/* arch-tag: 458e5939-3e2f-4398-83f5-3e6fc230e6e2 */

/*  eXperience GTK engine: fill.c
 *  
 *  Copyright (C) 2004-2005  Benjamin Berg <benjamin@sipsolutions.net>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "fill.h"

void
experience_fill_set_color (eXperienceFill * fill, eXperienceDynamicColor color)
{
	g_assert (fill != NULL);
	
	if (!fill->color_set) {
		fill->color_set = TRUE;
		fill->color = color;
	} else g_printerr ("Color set more than once in fill %i in group %s!\n", fill->drawable.number, fill->drawable.group_name);
}

/*#######*/
static eXperienceDrawable *
create (void)
{
	eXperienceFill * new_fill;
	new_fill = g_new0 (eXperienceFill, 1);
	
	experience_filter_init (&new_fill->drawable.filter, FILTER_SATURATION | FILTER_BRIGHTNESS);
	
	return (eXperienceDrawable*) new_fill;
}

static void
destroy (eXperienceDrawable * drawable)
{
	eXperienceFill * fill = (eXperienceFill* )drawable;
	
	g_assert (drawable != NULL);
	
	g_free (fill);
}

static gboolean
draw (eXperienceDrawable * drawable, GdkPixbuf * dest, GdkRectangle * dest_area, GtkStyle * style)
{
	eXperienceFill * fill = (eXperienceFill*) drawable;
	GdkPixbuf * sub_pixbuf;
	guint32 pixel;
	GdkColor color;
	GdkRectangle real_dest_area = {0,0,0,0};
	
	g_assert (drawable   != NULL);
	g_assert (dest_area  != NULL);
	g_assert (style != NULL);
	g_assert (drawable->class == experience_fill_class);
	
	if (!fill->color_set) return FALSE;
	
	real_dest_area.width  = gdk_pixbuf_get_width  (dest);
	real_dest_area.height = gdk_pixbuf_get_height (dest);
	
	gdk_rectangle_intersect (dest_area, &real_dest_area, &real_dest_area);
	
	if ((real_dest_area.width > 0) && (real_dest_area.height > 0)) {
		sub_pixbuf = gdk_pixbuf_new_subpixbuf (dest, real_dest_area.x, real_dest_area.y, real_dest_area.width, real_dest_area.height);
		
		experience_dynamic_color_update (&fill->color, style);
		
		color = fill->color.output_color;
		
		experience_apply_filter_to_color (&color, &drawable->filter);
		
		pixel = 0xFF;
		pixel += (color.red   / (GDK_COLOR_MAX / 255)) << 24;
		pixel += (color.green / (GDK_COLOR_MAX / 255)) << 16;
		pixel += (color.blue  / (GDK_COLOR_MAX / 255)) <<  8;
		
		gdk_pixbuf_fill (sub_pixbuf, pixel);
		
		g_object_unref ((GObject*) sub_pixbuf);
	}
	return TRUE;
}

static void
inherit_from_drawable (eXperienceDrawable * drawable, eXperienceDrawable * from)
{
	eXperienceFill * fill = (eXperienceFill*) drawable;
	eXperienceFill * fill_from = (eXperienceFill*) from;
	
	g_assert (drawable != NULL);
	g_assert (from != NULL);
	g_assert (drawable->class == experience_fill_class);
	g_assert (from->class == experience_fill_class);
	
	if (!fill->color_set) {
		fill->color_set = fill_from->color_set;
		fill->color = fill_from->color;
	}
}

static void
apply_group_settings (eXperienceDrawable * drawable, eXperienceGroup * group)
{
	return;
}

static eXperienceDrawableClass _experience_fill_class;

void
experience_fill_init_class (void)
{
	_experience_fill_class.object_type = "fill";
	_experience_fill_class.create  = create;
	_experience_fill_class.destroy = destroy;
	_experience_fill_class.draw    = draw;
	_experience_fill_class.inherit_from_drawable = inherit_from_drawable;
	_experience_fill_class.apply_group_settings  = apply_group_settings;
	
	experience_fill_class = &_experience_fill_class;
}

