=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsRangesApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_ranges_get_worksheet_cells_range_value
#
# Get cells list in a range by range name or row column indexes  
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param string $namerange range name, for example: &#39;A1:B2&#39; or &#39;range_name1&#39; (optional)
# @param int $first_row the first row of the range (optional)
# @param int $first_column the first column of the range (optional)
# @param int $row_count the count of rows in the range (optional)
# @param int $column_count the count of columns in the range (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'namerange' => {
        data_type => 'string',
        description => 'range name, for example: &#39;A1:B2&#39; or &#39;range_name1&#39;',
        required => '0',
    },
    'first_row' => {
        data_type => 'int',
        description => 'the first row of the range',
        required => '0',
    },
    'first_column' => {
        data_type => 'int',
        description => 'the first column of the range',
        required => '0',
    },
    'row_count' => {
        data_type => 'int',
        description => 'the count of rows in the range',
        required => '0',
    },
    'column_count' => {
        data_type => 'int',
        description => 'the count of columns in the range',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_get_worksheet_cells_range_value' } = { 
    	summary => 'Get cells list in a range by range name or row column indexes  ',
        params => $params,
        returns => 'RangeValueResponse',
        };
}
# @return RangeValueResponse
#
sub cells_ranges_get_worksheet_cells_range_value {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_get_worksheet_cells_range_value");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_get_worksheet_cells_range_value");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/value';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'namerange'}) {
        $query_params->{'namerange'} = $self->{api_client}->to_query_value($args{'namerange'});
    }

    # query params
    if ( exists $args{'first_row'}) {
        $query_params->{'firstRow'} = $self->{api_client}->to_query_value($args{'first_row'});
    }

    # query params
    if ( exists $args{'first_column'}) {
        $query_params->{'firstColumn'} = $self->{api_client}->to_query_value($args{'first_column'});
    }

    # query params
    if ( exists $args{'row_count'}) {
        $query_params->{'rowCount'} = $self->{api_client}->to_query_value($args{'row_count'});
    }

    # query params
    if ( exists $args{'column_count'}) {
        $query_params->{'columnCount'} = $self->{api_client}->to_query_value($args{'column_count'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RangeValueResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_column_width
#
# Set column width of range
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param double $value  (required)
# @param Range $range  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'value' => {
        data_type => 'double',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'Range',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_column_width' } = { 
    	summary => 'Set column width of range',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_ranges_post_worksheet_cells_range_column_width {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_column_width");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_column_width");
    }

    # verify the required parameter 'value' is set
    unless (exists $args{'value'}) {
      croak("Missing the required parameter 'value' when calling cells_ranges_post_worksheet_cells_range_column_width");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/columnWidth';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'value'}) {
        $query_params->{'value'} = $self->{api_client}->to_query_value($args{'value'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'range'}) {
        $_body_data = $args{'range'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_merge
#
# Combines a range of cells into a single cell.              
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param Range $range range in worksheet  (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'range' => {
        data_type => 'Range',
        description => 'range in worksheet ',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_merge' } = { 
    	summary => 'Combines a range of cells into a single cell.              ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_ranges_post_worksheet_cells_range_merge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_merge");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_merge");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/merge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'range'}) {
        $_body_data = $args{'range'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_move_to
#
# Move the current range to the dest range.             
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param int $dest_row The start row of the dest range. (required)
# @param int $dest_column The start column of the dest range. (required)
# @param Range $range range in worksheet  (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'dest_row' => {
        data_type => 'int',
        description => 'The start row of the dest range.',
        required => '1',
    },
    'dest_column' => {
        data_type => 'int',
        description => 'The start column of the dest range.',
        required => '1',
    },
    'range' => {
        data_type => 'Range',
        description => 'range in worksheet ',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_move_to' } = { 
    	summary => 'Move the current range to the dest range.             ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_ranges_post_worksheet_cells_range_move_to {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_move_to");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_move_to");
    }

    # verify the required parameter 'dest_row' is set
    unless (exists $args{'dest_row'}) {
      croak("Missing the required parameter 'dest_row' when calling cells_ranges_post_worksheet_cells_range_move_to");
    }

    # verify the required parameter 'dest_column' is set
    unless (exists $args{'dest_column'}) {
      croak("Missing the required parameter 'dest_column' when calling cells_ranges_post_worksheet_cells_range_move_to");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/moveto';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'dest_row'}) {
        $query_params->{'destRow'} = $self->{api_client}->to_query_value($args{'dest_row'});
    }

    # query params
    if ( exists $args{'dest_column'}) {
        $query_params->{'destColumn'} = $self->{api_client}->to_query_value($args{'dest_column'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'range'}) {
        $_body_data = $args{'range'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_outline_border
#
# Sets outline border around a range of cells.
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param RangeSetOutlineBorderRequest $range_operate Range Set OutlineBorder Request  (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'range_operate' => {
        data_type => 'RangeSetOutlineBorderRequest',
        description => 'Range Set OutlineBorder Request ',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_outline_border' } = { 
    	summary => 'Sets outline border around a range of cells.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_ranges_post_worksheet_cells_range_outline_border {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_outline_border");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_outline_border");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/outlineBorder';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'range_operate'}) {
        $_body_data = $args{'range_operate'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_row_height
#
# set row height of range
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param double $value  (required)
# @param Range $range  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'value' => {
        data_type => 'double',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'Range',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_row_height' } = { 
    	summary => 'set row height of range',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_ranges_post_worksheet_cells_range_row_height {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_row_height");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_row_height");
    }

    # verify the required parameter 'value' is set
    unless (exists $args{'value'}) {
      croak("Missing the required parameter 'value' when calling cells_ranges_post_worksheet_cells_range_row_height");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/rowHeight';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'value'}) {
        $query_params->{'value'} = $self->{api_client}->to_query_value($args{'value'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'range'}) {
        $_body_data = $args{'range'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_style
#
# Sets the style of the range.             
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param RangeSetStyleRequest $range_operate Range Set Style Request  (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'range_operate' => {
        data_type => 'RangeSetStyleRequest',
        description => 'Range Set Style Request ',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_style' } = { 
    	summary => 'Sets the style of the range.             ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_ranges_post_worksheet_cells_range_style {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_style");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_style");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/style';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'range_operate'}) {
        $_body_data = $args{'range_operate'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_unmerge
#
# Unmerges merged cells of this range.             
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param Range $range range in worksheet  (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'range' => {
        data_type => 'Range',
        description => 'range in worksheet ',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_unmerge' } = { 
    	summary => 'Unmerges merged cells of this range.             ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_ranges_post_worksheet_cells_range_unmerge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_unmerge");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_unmerge");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/unmerge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'range'}) {
        $_body_data = $args{'range'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_range_value
#
# Puts a value into the range, if appropriate the value will be converted to other data type and cell's number format will be reset.             
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param string $value Input value (required)
# @param Range $range range in worksheet  (optional)
# @param boolean $is_converted True: converted to other data type if appropriate. (optional, default to false)
# @param boolean $set_style True: set the number format to cell&#39;s style when converting to other data type (optional, default to false)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'value' => {
        data_type => 'string',
        description => 'Input value',
        required => '1',
    },
    'range' => {
        data_type => 'Range',
        description => 'range in worksheet ',
        required => '0',
    },
    'is_converted' => {
        data_type => 'boolean',
        description => 'True: converted to other data type if appropriate.',
        required => '0',
    },
    'set_style' => {
        data_type => 'boolean',
        description => 'True: set the number format to cell&#39;s style when converting to other data type',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_range_value' } = { 
    	summary => 'Puts a value into the range, if appropriate the value will be converted to other data type and cell&#39;s number format will be reset.             ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_ranges_post_worksheet_cells_range_value {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_range_value");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_range_value");
    }

    # verify the required parameter 'value' is set
    unless (exists $args{'value'}) {
      croak("Missing the required parameter 'value' when calling cells_ranges_post_worksheet_cells_range_value");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges/value';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'value'}) {
        $query_params->{'Value'} = $self->{api_client}->to_query_value($args{'value'});
    }

    # query params
    if ( exists $args{'is_converted'}) {
        $query_params->{'isConverted'} = $self->{api_client}->to_query_value($args{'is_converted'});
    }

    # query params
    if ( exists $args{'set_style'}) {
        $query_params->{'setStyle'} = $self->{api_client}->to_query_value($args{'set_style'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'range'}) {
        $_body_data = $args{'range'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_ranges_post_worksheet_cells_ranges
#
# copy range in the worksheet
# 
# @param string $name workbook name (required)
# @param string $sheet_name worksheet name (required)
# @param RangeCopyRequest $range_operate copydata,copystyle,copyto,copyvalue (optional)
# @param string $folder Workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'workbook name',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'worksheet name',
        required => '1',
    },
    'range_operate' => {
        data_type => 'RangeCopyRequest',
        description => 'copydata,copystyle,copyto,copyvalue',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_ranges_post_worksheet_cells_ranges' } = { 
    	summary => 'copy range in the worksheet',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_ranges_post_worksheet_cells_ranges {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_ranges_post_worksheet_cells_ranges");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_ranges_post_worksheet_cells_ranges");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/ranges';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'range_operate'}) {
        $_body_data = $args{'range_operate'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

1;
