=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsWorksheetsApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_worksheets_delete_unprotect_worksheet
#
# Unprotect worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param ProtectSheetParameter $protect_parameter with protection settings. Only password is used here. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'protect_parameter' => {
        data_type => 'ProtectSheetParameter',
        description => 'with protection settings. Only password is used here.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_delete_unprotect_worksheet' } = { 
    	summary => 'Unprotect worksheet.',
        params => $params,
        returns => 'WorksheetResponse',
        };
}
# @return WorksheetResponse
#
sub cells_worksheets_delete_unprotect_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_delete_unprotect_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_delete_unprotect_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/protection';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'protect_parameter'}) {
        $_body_data = $args{'protect_parameter'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_delete_worksheet
#
# Delete worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_delete_worksheet' } = { 
    	summary => 'Delete worksheet.',
        params => $params,
        returns => 'WorksheetsResponse',
        };
}
# @return WorksheetsResponse
#
sub cells_worksheets_delete_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_delete_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_delete_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_delete_worksheet_background
#
# Set worksheet background image.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_delete_worksheet_background' } = { 
    	summary => 'Set worksheet background image.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_delete_worksheet_background {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_delete_worksheet_background");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_delete_worksheet_background");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/background';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_delete_worksheet_comment
#
# Delete worksheet's cell comment.
# 
# @param string $name The document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $cell_name The cell name (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_delete_worksheet_comment' } = { 
    	summary => 'Delete worksheet&#39;s cell comment.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_delete_worksheet_comment {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_delete_worksheet_comment");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_delete_worksheet_comment");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_worksheets_delete_worksheet_comment");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/comments/{cellName}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_delete_worksheet_comments
#
# Delete all comments for worksheet.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_delete_worksheet_comments' } = { 
    	summary => 'Delete all comments for worksheet.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_delete_worksheet_comments {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_delete_worksheet_comments");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_delete_worksheet_comments");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/comments';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_delete_worksheet_freeze_panes
#
# Unfreeze panes
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $row  (required)
# @param int $column  (required)
# @param int $freezed_rows  (required)
# @param int $freezed_columns  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'row' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'freezed_rows' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'freezed_columns' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_delete_worksheet_freeze_panes' } = { 
    	summary => 'Unfreeze panes',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_delete_worksheet_freeze_panes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_delete_worksheet_freeze_panes");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_delete_worksheet_freeze_panes");
    }

    # verify the required parameter 'row' is set
    unless (exists $args{'row'}) {
      croak("Missing the required parameter 'row' when calling cells_worksheets_delete_worksheet_freeze_panes");
    }

    # verify the required parameter 'column' is set
    unless (exists $args{'column'}) {
      croak("Missing the required parameter 'column' when calling cells_worksheets_delete_worksheet_freeze_panes");
    }

    # verify the required parameter 'freezed_rows' is set
    unless (exists $args{'freezed_rows'}) {
      croak("Missing the required parameter 'freezed_rows' when calling cells_worksheets_delete_worksheet_freeze_panes");
    }

    # verify the required parameter 'freezed_columns' is set
    unless (exists $args{'freezed_columns'}) {
      croak("Missing the required parameter 'freezed_columns' when calling cells_worksheets_delete_worksheet_freeze_panes");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/freezepanes';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'row'}) {
        $query_params->{'row'} = $self->{api_client}->to_query_value($args{'row'});
    }

    # query params
    if ( exists $args{'column'}) {
        $query_params->{'column'} = $self->{api_client}->to_query_value($args{'column'});
    }

    # query params
    if ( exists $args{'freezed_rows'}) {
        $query_params->{'freezedRows'} = $self->{api_client}->to_query_value($args{'freezed_rows'});
    }

    # query params
    if ( exists $args{'freezed_columns'}) {
        $query_params->{'freezedColumns'} = $self->{api_client}->to_query_value($args{'freezed_columns'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_named_ranges
#
# Read worksheets ranges info.
# 
# @param string $name Document name. (required)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_named_ranges' } = { 
    	summary => 'Read worksheets ranges info.',
        params => $params,
        returns => 'RangesResponse',
        };
}
# @return RangesResponse
#
sub cells_worksheets_get_named_ranges {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_named_ranges");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/ranges';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('RangesResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet
#
# Read worksheet info or export.
# 
# @param string $name The document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $format The exported file format. (optional)
# @param int $vertical_resolution Image vertical resolution. (optional, default to 0)
# @param int $horizontal_resolution Image horizontal resolution. (optional, default to 0)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'The exported file format.',
        required => '0',
    },
    'vertical_resolution' => {
        data_type => 'int',
        description => 'Image vertical resolution.',
        required => '0',
    },
    'horizontal_resolution' => {
        data_type => 'int',
        description => 'Image horizontal resolution.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet' } = { 
    	summary => 'Read worksheet info or export.',
        params => $params,
        returns => 'string',
        };
}
# @return string
#
sub cells_worksheets_get_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    # query params
    if ( exists $args{'vertical_resolution'}) {
        $query_params->{'verticalResolution'} = $self->{api_client}->to_query_value($args{'vertical_resolution'});
    }

    # query params
    if ( exists $args{'horizontal_resolution'}) {
        $query_params->{'horizontalResolution'} = $self->{api_client}->to_query_value($args{'horizontal_resolution'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('string', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet_calculate_formula
#
# Calculate formula value.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $formula The formula. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'formula' => {
        data_type => 'string',
        description => 'The formula.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet_calculate_formula' } = { 
    	summary => 'Calculate formula value.',
        params => $params,
        returns => 'SingleValueResponse',
        };
}
# @return SingleValueResponse
#
sub cells_worksheets_get_worksheet_calculate_formula {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet_calculate_formula");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet_calculate_formula");
    }

    # verify the required parameter 'formula' is set
    unless (exists $args{'formula'}) {
      croak("Missing the required parameter 'formula' when calling cells_worksheets_get_worksheet_calculate_formula");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/formulaResult';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'formula'}) {
        $query_params->{'formula'} = $self->{api_client}->to_query_value($args{'formula'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SingleValueResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet_comment
#
# Get worksheet comment by cell name.
# 
# @param string $name The document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $cell_name The cell name (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet_comment' } = { 
    	summary => 'Get worksheet comment by cell name.',
        params => $params,
        returns => 'CommentResponse',
        };
}
# @return CommentResponse
#
sub cells_worksheets_get_worksheet_comment {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet_comment");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet_comment");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_worksheets_get_worksheet_comment");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/comments/{cellName}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CommentResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet_comments
#
# Get worksheet comments.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet_comments' } = { 
    	summary => 'Get worksheet comments.',
        params => $params,
        returns => 'CommentsResponse',
        };
}
# @return CommentsResponse
#
sub cells_worksheets_get_worksheet_comments {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet_comments");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet_comments");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/comments';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CommentsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet_merged_cell
#
# Get worksheet merged cell by its index.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param int $merged_cell_index Merged cell index. (required)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'merged_cell_index' => {
        data_type => 'int',
        description => 'Merged cell index.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet_merged_cell' } = { 
    	summary => 'Get worksheet merged cell by its index.',
        params => $params,
        returns => 'MergedCellResponse',
        };
}
# @return MergedCellResponse
#
sub cells_worksheets_get_worksheet_merged_cell {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet_merged_cell");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet_merged_cell");
    }

    # verify the required parameter 'merged_cell_index' is set
    unless (exists $args{'merged_cell_index'}) {
      croak("Missing the required parameter 'merged_cell_index' when calling cells_worksheets_get_worksheet_merged_cell");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/mergedCells/{mergedCellIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'merged_cell_index'}) {
        my $_base_variable = "{" . "mergedCellIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'merged_cell_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('MergedCellResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet_merged_cells
#
# Get worksheet merged cells.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The workseet name. (required)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The workseet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet_merged_cells' } = { 
    	summary => 'Get worksheet merged cells.',
        params => $params,
        returns => 'MergedCellsResponse',
        };
}
# @return MergedCellsResponse
#
sub cells_worksheets_get_worksheet_merged_cells {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet_merged_cells");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet_merged_cells");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/mergedCells';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('MergedCellsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheet_text_items
#
# Get worksheet text items.
# 
# @param string $name Workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $folder The workbook&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheet_text_items' } = { 
    	summary => 'Get worksheet text items.',
        params => $params,
        returns => 'TextItemsResponse',
        };
}
# @return TextItemsResponse
#
sub cells_worksheets_get_worksheet_text_items {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheet_text_items");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_get_worksheet_text_items");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/textItems';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextItemsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_get_worksheets
#
# Read worksheets info.
# 
# @param string $name Document name. (required)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_get_worksheets' } = { 
    	summary => 'Read worksheets info.',
        params => $params,
        returns => 'WorksheetsResponse',
        };
}
# @return WorksheetsResponse
#
sub cells_worksheets_get_worksheets {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_get_worksheets");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_autofit_worksheet_columns
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $first_column  (required)
# @param int $last_column  (required)
# @param AutoFitterOptions $auto_fitter_options  (optional)
# @param int $first_row  (optional)
# @param int $last_row  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'first_column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'last_column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'auto_fitter_options' => {
        data_type => 'AutoFitterOptions',
        description => '',
        required => '0',
    },
    'first_row' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'last_row' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_autofit_worksheet_columns' } = { 
    	summary => '',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_post_autofit_worksheet_columns {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_autofit_worksheet_columns");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_autofit_worksheet_columns");
    }

    # verify the required parameter 'first_column' is set
    unless (exists $args{'first_column'}) {
      croak("Missing the required parameter 'first_column' when calling cells_worksheets_post_autofit_worksheet_columns");
    }

    # verify the required parameter 'last_column' is set
    unless (exists $args{'last_column'}) {
      croak("Missing the required parameter 'last_column' when calling cells_worksheets_post_autofit_worksheet_columns");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autofitcolumns';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'first_column'}) {
        $query_params->{'firstColumn'} = $self->{api_client}->to_query_value($args{'first_column'});
    }

    # query params
    if ( exists $args{'last_column'}) {
        $query_params->{'lastColumn'} = $self->{api_client}->to_query_value($args{'last_column'});
    }

    # query params
    if ( exists $args{'first_row'}) {
        $query_params->{'firstRow'} = $self->{api_client}->to_query_value($args{'first_row'});
    }

    # query params
    if ( exists $args{'last_row'}) {
        $query_params->{'lastRow'} = $self->{api_client}->to_query_value($args{'last_row'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'auto_fitter_options'}) {
        $_body_data = $args{'auto_fitter_options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_autofit_worksheet_row
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $row_index  (required)
# @param int $first_column  (required)
# @param int $last_column  (required)
# @param AutoFitterOptions $auto_fitter_options  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'first_column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'last_column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'auto_fitter_options' => {
        data_type => 'AutoFitterOptions',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_autofit_worksheet_row' } = { 
    	summary => '',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_post_autofit_worksheet_row {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_autofit_worksheet_row");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_autofit_worksheet_row");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling cells_worksheets_post_autofit_worksheet_row");
    }

    # verify the required parameter 'first_column' is set
    unless (exists $args{'first_column'}) {
      croak("Missing the required parameter 'first_column' when calling cells_worksheets_post_autofit_worksheet_row");
    }

    # verify the required parameter 'last_column' is set
    unless (exists $args{'last_column'}) {
      croak("Missing the required parameter 'last_column' when calling cells_worksheets_post_autofit_worksheet_row");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autofitrow';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'row_index'}) {
        $query_params->{'rowIndex'} = $self->{api_client}->to_query_value($args{'row_index'});
    }

    # query params
    if ( exists $args{'first_column'}) {
        $query_params->{'firstColumn'} = $self->{api_client}->to_query_value($args{'first_column'});
    }

    # query params
    if ( exists $args{'last_column'}) {
        $query_params->{'lastColumn'} = $self->{api_client}->to_query_value($args{'last_column'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'auto_fitter_options'}) {
        $_body_data = $args{'auto_fitter_options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_autofit_worksheet_rows
#
# Autofit worksheet rows.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param AutoFitterOptions $auto_fitter_options Auto Fitter Options. (optional)
# @param int $start_row Start row. (optional)
# @param int $end_row End row. (optional)
# @param boolean $only_auto Only auto. (optional, default to false)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'auto_fitter_options' => {
        data_type => 'AutoFitterOptions',
        description => 'Auto Fitter Options.',
        required => '0',
    },
    'start_row' => {
        data_type => 'int',
        description => 'Start row.',
        required => '0',
    },
    'end_row' => {
        data_type => 'int',
        description => 'End row.',
        required => '0',
    },
    'only_auto' => {
        data_type => 'boolean',
        description => 'Only auto.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_autofit_worksheet_rows' } = { 
    	summary => 'Autofit worksheet rows.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_post_autofit_worksheet_rows {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_autofit_worksheet_rows");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_autofit_worksheet_rows");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autofitrows';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'end_row'}) {
        $query_params->{'endRow'} = $self->{api_client}->to_query_value($args{'end_row'});
    }

    # query params
    if ( exists $args{'only_auto'}) {
        $query_params->{'onlyAuto'} = $self->{api_client}->to_query_value($args{'only_auto'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'auto_fitter_options'}) {
        $_body_data = $args{'auto_fitter_options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_copy_worksheet
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $source_sheet  (required)
# @param CopyOptions $options  (optional)
# @param string $source_workbook  (optional)
# @param string $source_folder  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'source_sheet' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'options' => {
        data_type => 'CopyOptions',
        description => '',
        required => '0',
    },
    'source_workbook' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'source_folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_copy_worksheet' } = { 
    	summary => '',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_post_copy_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_copy_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_copy_worksheet");
    }

    # verify the required parameter 'source_sheet' is set
    unless (exists $args{'source_sheet'}) {
      croak("Missing the required parameter 'source_sheet' when calling cells_worksheets_post_copy_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/copy';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'source_sheet'}) {
        $query_params->{'sourceSheet'} = $self->{api_client}->to_query_value($args{'source_sheet'});
    }

    # query params
    if ( exists $args{'source_workbook'}) {
        $query_params->{'sourceWorkbook'} = $self->{api_client}->to_query_value($args{'source_workbook'});
    }

    # query params
    if ( exists $args{'source_folder'}) {
        $query_params->{'sourceFolder'} = $self->{api_client}->to_query_value($args{'source_folder'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_move_worksheet
#
# Move worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param WorksheetMovingRequest $moving with moving parameters. (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'moving' => {
        data_type => 'WorksheetMovingRequest',
        description => 'with moving parameters.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_move_worksheet' } = { 
    	summary => 'Move worksheet.',
        params => $params,
        returns => 'WorksheetsResponse',
        };
}
# @return WorksheetsResponse
#
sub cells_worksheets_post_move_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_move_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_move_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/position';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'moving'}) {
        $_body_data = $args{'moving'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_rename_worksheet
#
# Rename worksheet
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $newname  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'newname' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_rename_worksheet' } = { 
    	summary => 'Rename worksheet',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_post_rename_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_rename_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_rename_worksheet");
    }

    # verify the required parameter 'newname' is set
    unless (exists $args{'newname'}) {
      croak("Missing the required parameter 'newname' when calling cells_worksheets_post_rename_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/rename';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'newname'}) {
        $query_params->{'newname'} = $self->{api_client}->to_query_value($args{'newname'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_update_worksheet_property
#
# Update worksheet property
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param Worksheet $sheet  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet' => {
        data_type => 'Worksheet',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_update_worksheet_property' } = { 
    	summary => 'Update worksheet property',
        params => $params,
        returns => 'WorksheetResponse',
        };
}
# @return WorksheetResponse
#
sub cells_worksheets_post_update_worksheet_property {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_update_worksheet_property");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_update_worksheet_property");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'sheet'}) {
        $_body_data = $args{'sheet'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_update_worksheet_zoom
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $value  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'value' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_update_worksheet_zoom' } = { 
    	summary => '',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_post_update_worksheet_zoom {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_update_worksheet_zoom");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_update_worksheet_zoom");
    }

    # verify the required parameter 'value' is set
    unless (exists $args{'value'}) {
      croak("Missing the required parameter 'value' when calling cells_worksheets_post_update_worksheet_zoom");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/zoom';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'value'}) {
        $query_params->{'value'} = $self->{api_client}->to_query_value($args{'value'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_worksheet_comment
#
# Update worksheet's cell comment.
# 
# @param string $name The document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $cell_name The cell name (required)
# @param Comment $comment Comment object (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name',
        required => '1',
    },
    'comment' => {
        data_type => 'Comment',
        description => 'Comment object',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_worksheet_comment' } = { 
    	summary => 'Update worksheet&#39;s cell comment.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_post_worksheet_comment {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_worksheet_comment");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_worksheet_comment");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_worksheets_post_worksheet_comment");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/comments/{cellName}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'comment'}) {
        $_body_data = $args{'comment'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_worksheet_range_sort
#
# Sort worksheet range.
# 
# @param string $name The workbook name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $cell_area The range to sort. (required)
# @param DataSorter $data_sorter with sorting settings. (optional)
# @param string $folder The workbook folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The workbook name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'cell_area' => {
        data_type => 'string',
        description => 'The range to sort.',
        required => '1',
    },
    'data_sorter' => {
        data_type => 'DataSorter',
        description => 'with sorting settings.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The workbook folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_worksheet_range_sort' } = { 
    	summary => 'Sort worksheet range.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_post_worksheet_range_sort {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_worksheet_range_sort");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_worksheet_range_sort");
    }

    # verify the required parameter 'cell_area' is set
    unless (exists $args{'cell_area'}) {
      croak("Missing the required parameter 'cell_area' when calling cells_worksheets_post_worksheet_range_sort");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/sort';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'cell_area'}) {
        $query_params->{'cellArea'} = $self->{api_client}->to_query_value($args{'cell_area'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'data_sorter'}) {
        $_body_data = $args{'data_sorter'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_worksheet_text_search
#
# Search text.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $text Text to search. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'text' => {
        data_type => 'string',
        description => 'Text to search.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_worksheet_text_search' } = { 
    	summary => 'Search text.',
        params => $params,
        returns => 'TextItemsResponse',
        };
}
# @return TextItemsResponse
#
sub cells_worksheets_post_worksheet_text_search {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_worksheet_text_search");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_worksheet_text_search");
    }

    # verify the required parameter 'text' is set
    unless (exists $args{'text'}) {
      croak("Missing the required parameter 'text' when calling cells_worksheets_post_worksheet_text_search");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/findText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'text'}) {
        $query_params->{'text'} = $self->{api_client}->to_query_value($args{'text'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextItemsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_post_worsheet_text_replace
#
# Replace text.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param string $old_value The old text to replace. (required)
# @param string $new_value The new text to replace by. (required)
# @param string $folder Document&#39;s folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'The old text to replace.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'The new text to replace by.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document&#39;s folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_post_worsheet_text_replace' } = { 
    	summary => 'Replace text.',
        params => $params,
        returns => 'WorksheetReplaceResponse',
        };
}
# @return WorksheetReplaceResponse
#
sub cells_worksheets_post_worsheet_text_replace {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_post_worsheet_text_replace");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_post_worsheet_text_replace");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling cells_worksheets_post_worsheet_text_replace");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling cells_worksheets_post_worsheet_text_replace");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/replaceText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if ( exists $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetReplaceResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_put_add_new_worksheet
#
# Add new worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The new sheet name. (required)
# @param int $position The new sheet position. (optional)
# @param string $sheettype The new sheet type. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The new sheet name.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'The new sheet position.',
        required => '0',
    },
    'sheettype' => {
        data_type => 'string',
        description => 'The new sheet type.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_put_add_new_worksheet' } = { 
    	summary => 'Add new worksheet.',
        params => $params,
        returns => 'WorksheetsResponse',
        };
}
# @return WorksheetsResponse
#
sub cells_worksheets_put_add_new_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_put_add_new_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_put_add_new_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if ( exists $args{'sheettype'}) {
        $query_params->{'sheettype'} = $self->{api_client}->to_query_value($args{'sheettype'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetsResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_put_change_visibility_worksheet
#
# Change worksheet visibility.
# 
# @param string $name Document name. (required)
# @param string $sheet_name Worksheet name. (required)
# @param boolean $is_visible New worksheet visibility value. (required)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'Worksheet name.',
        required => '1',
    },
    'is_visible' => {
        data_type => 'boolean',
        description => 'New worksheet visibility value.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_put_change_visibility_worksheet' } = { 
    	summary => 'Change worksheet visibility.',
        params => $params,
        returns => 'WorksheetResponse',
        };
}
# @return WorksheetResponse
#
sub cells_worksheets_put_change_visibility_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_put_change_visibility_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_put_change_visibility_worksheet");
    }

    # verify the required parameter 'is_visible' is set
    unless (exists $args{'is_visible'}) {
      croak("Missing the required parameter 'is_visible' when calling cells_worksheets_put_change_visibility_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/visible';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'is_visible'}) {
        $query_params->{'isVisible'} = $self->{api_client}->to_query_value($args{'is_visible'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_put_protect_worksheet
#
# Protect worksheet.
# 
# @param string $name Document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param ProtectSheetParameter $protect_parameter with protection settings. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'protect_parameter' => {
        data_type => 'ProtectSheetParameter',
        description => 'with protection settings.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_put_protect_worksheet' } = { 
    	summary => 'Protect worksheet.',
        params => $params,
        returns => 'WorksheetResponse',
        };
}
# @return WorksheetResponse
#
sub cells_worksheets_put_protect_worksheet {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_put_protect_worksheet");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_put_protect_worksheet");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/protection';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'protect_parameter'}) {
        $_body_data = $args{'protect_parameter'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('WorksheetResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_put_worksheet_background
#
# Set worksheet background image.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $png  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'png' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_put_worksheet_background' } = { 
    	summary => 'Set worksheet background image.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_put_worksheet_background {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_put_worksheet_background");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_put_worksheet_background");
    }

    # verify the required parameter 'png' is set
    unless (exists $args{'png'}) {
      croak("Missing the required parameter 'png' when calling cells_worksheets_put_worksheet_background");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/background';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'png'}) {
        $_body_data = $args{'png'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_put_worksheet_comment
#
# Add worksheet's cell comment.
# 
# @param string $name The document name. (required)
# @param string $sheet_name The worksheet name. (required)
# @param string $cell_name The cell name (required)
# @param Comment $comment Comment object (optional)
# @param string $folder The document folder. (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The document name.',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => 'The worksheet name.',
        required => '1',
    },
    'cell_name' => {
        data_type => 'string',
        description => 'The cell name',
        required => '1',
    },
    'comment' => {
        data_type => 'Comment',
        description => 'Comment object',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_put_worksheet_comment' } = { 
    	summary => 'Add worksheet&#39;s cell comment.',
        params => $params,
        returns => 'CommentResponse',
        };
}
# @return CommentResponse
#
sub cells_worksheets_put_worksheet_comment {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_put_worksheet_comment");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_put_worksheet_comment");
    }

    # verify the required parameter 'cell_name' is set
    unless (exists $args{'cell_name'}) {
      croak("Missing the required parameter 'cell_name' when calling cells_worksheets_put_worksheet_comment");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/comments/{cellName}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_name'}) {
        my $_base_variable = "{" . "cellName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'comment'}) {
        $_body_data = $args{'comment'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CommentResponse', $response);
    return $_response_object;
}

#
# cells_worksheets_put_worksheet_freeze_panes
#
# Set freeze panes
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $row  (required)
# @param int $column  (required)
# @param int $freezed_rows  (required)
# @param int $freezed_columns  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'row' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'freezed_rows' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'freezed_columns' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_worksheets_put_worksheet_freeze_panes' } = { 
    	summary => 'Set freeze panes',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_worksheets_put_worksheet_freeze_panes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_worksheets_put_worksheet_freeze_panes");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_worksheets_put_worksheet_freeze_panes");
    }

    # verify the required parameter 'row' is set
    unless (exists $args{'row'}) {
      croak("Missing the required parameter 'row' when calling cells_worksheets_put_worksheet_freeze_panes");
    }

    # verify the required parameter 'column' is set
    unless (exists $args{'column'}) {
      croak("Missing the required parameter 'column' when calling cells_worksheets_put_worksheet_freeze_panes");
    }

    # verify the required parameter 'freezed_rows' is set
    unless (exists $args{'freezed_rows'}) {
      croak("Missing the required parameter 'freezed_rows' when calling cells_worksheets_put_worksheet_freeze_panes");
    }

    # verify the required parameter 'freezed_columns' is set
    unless (exists $args{'freezed_columns'}) {
      croak("Missing the required parameter 'freezed_columns' when calling cells_worksheets_put_worksheet_freeze_panes");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/freezepanes';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'row'}) {
        $query_params->{'row'} = $self->{api_client}->to_query_value($args{'row'});
    }

    # query params
    if ( exists $args{'column'}) {
        $query_params->{'column'} = $self->{api_client}->to_query_value($args{'column'});
    }

    # query params
    if ( exists $args{'freezed_rows'}) {
        $query_params->{'freezedRows'} = $self->{api_client}->to_query_value($args{'freezed_rows'});
    }

    # query params
    if ( exists $args{'freezed_columns'}) {
        $query_params->{'freezedColumns'} = $self->{api_client}->to_query_value($args{'freezed_columns'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

1;
