#! /usr/bin/env false

use v6.d;

unit class IRC::Client::Plugin::Reminders::Delay;

has Int $.minutes = 0;
has Int $.hours = 0;
has Int $.days = 0;
has Int $.weeks = 0;

submethod TWEAK
{
	if ($!weeks) { $!days += $!weeks × 7; }
}

submethod Str
{
	my $s;

	$s ~= $_ ~ 'd' with $!days;
	$s ~= $_ ~ 'h' with $!hours;
	$s ~= $_ ~ 'm' with $!minutes;

	$s;
}

method seconds (
	--> Int
) {
	my $seconds = 0;

	$seconds += $!minutes × 60;
	$seconds += $!hours × 60 × 60;
	$seconds += $!days × 24 × 60 × 60;

	$seconds;
}

method at (
	--> DateTime
) {
	DateTime
		.now
		.utc
		.later(seconds => self.seconds)
		.truncated-to('minute')
}

=begin pod

=NAME    IRC::Client::Plugin::Reminders::Delay
=VERSION 0.1.0
=AUTHOR  Patrick Spek <p.spek@tyil.nl>

=begin LICENSE
Copyright © 2020

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU Affero General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
details.

You should have received a copy of the GNU Affero General Public License along
with this program.  If not, see http://www.gnu.org/licenses/.
=end LICENSE

=end pod

# vim: ft=raku noet sw=8 ts=8
