=begin comment

Copyright (c) 2018 Aspose Pty Ltd. All Rights Reserved.

Licensed under the MIT (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

      https://github.com/aspose-omr-cloud/aspose-omr-cloud-perl/blob/master/LICENSE

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.



Aspose.OMR for Cloud API Reference

Aspose.OMR for Cloud helps performing optical mark recognition in the cloud

OpenAPI spec version: 1.1

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package asposeomrcloud::OmrApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use asposeomrcloud::ApiClient;

our $VERSION=19.7.0;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'asposeomrcloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = asposeomrcloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# post_run_omr_task
#
# Run specific OMR task
# 
# @param string $name Name of the file to recognize. (required)
# @param string $action_name Action name [&#39;CorrectTemplate&#39;, &#39;FinalizeTemplate&#39;, &#39;RecognizeImage&#39;] (required)
# @param OMRFunctionParam $param Function params, specific for each actionName (optional)
# @param string $storage Image&#39;s storage. (optional)
# @param string $folder Image&#39;s folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Name of the file to recognize.',
        required => '1',
    },
    'action_name' => {
        data_type => 'string',
        description => 'Action name [&#39;CorrectTemplate&#39;, &#39;FinalizeTemplate&#39;, &#39;RecognizeImage&#39;]',
        required => '1',
    },
    'param' => {
        data_type => 'OMRFunctionParam',
        description => 'Function params, specific for each actionName',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Image&#39;s storage.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Image&#39;s folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_run_omr_task' } = { 
    	summary => 'Run specific OMR task',
        params => $params,
        returns => 'OMRResponse',
        };
}
# @return OMRResponse
#
sub post_run_omr_task {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_run_omr_task");
    }

    # verify the required parameter 'action_name' is set
    unless (exists $args{'action_name'}) {
      croak("Missing the required parameter 'action_name' when calling post_run_omr_task");
    }

    # parse inputs
    my $_resource_path = '/omr/{name}/runOmrTask';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'action_name'}) {
        $query_params->{'actionName'} = $self->{api_client}->to_query_value($args{'action_name'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'param'}) {
        $_body_data = $args{'param'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('OMRResponse', $response);
    return $_response_object;
}

1;
