/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class SheetUtil {
    private static final char defaultChar = '0';
    private static final double fontHeightMultiple = 2.0;
    private static final FormulaEvaluator dummyEvaluator = new FormulaEvaluator(){

        public void clearAllCachedResultValues() {
        }

        public void notifySetFormula(Cell cell) {
        }

        public void notifyDeleteCell(Cell cell) {
        }

        public void notifyUpdateCell(Cell cell) {
        }

        public CellValue evaluate(Cell cell) {
            return null;
        }

        public Cell evaluateInCell(Cell cell) {
            return null;
        }

        public void evaluateAll() {
        }

        public int evaluateFormulaCell(Cell cell) {
            return cell.getCachedFormulaResultType();
        }
    };
    private static final FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);

    public static double getCellWidth(Cell cell, int defaultCharWidth, DataFormatter formatter, boolean useMergedCells) {
        Sheet sheet = cell.getSheet();
        Workbook wb = sheet.getWorkbook();
        Row row = cell.getRow();
        int column = cell.getColumnIndex();
        int colspan = 1;
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress region = sheet.getMergedRegion(i);
            if (!SheetUtil.containsCell(region, row.getRowNum(), column)) continue;
            if (!useMergedCells) {
                return -1.0;
            }
            cell = row.getCell(region.getFirstColumn());
            colspan = 1 + region.getLastColumn() - region.getFirstColumn();
        }
        CellStyle style = cell.getCellStyle();
        int cellType = cell.getCellType();
        if (cellType == 2) {
            cellType = cell.getCachedFormulaResultType();
        }
        Font font = wb.getFontAt(style.getFontIndex());
        double width = -1.0;
        if (cellType == 1) {
            RichTextString rt = cell.getRichStringCellValue();
            String[] lines = rt.getString().split("\\n");
            for (int i = 0; i < lines.length; ++i) {
                String txt = lines[i] + '0';
                AttributedString str = new AttributedString(txt);
                SheetUtil.copyAttributes(font, str, 0, txt.length());
                if (rt.numFormattingRuns() > 0) {
                    // empty if block
                }
                TextLayout layout = new TextLayout(str.getIterator(), fontRenderContext);
                if (style.getRotation() != 0) {
                    AffineTransform trans = new AffineTransform();
                    trans.concatenate(AffineTransform.getRotateInstance((double)style.getRotation() * 2.0 * Math.PI / 360.0));
                    trans.concatenate(AffineTransform.getScaleInstance(1.0, 2.0));
                    width = Math.max(width, layout.getOutline(trans).getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                    continue;
                }
                width = Math.max(width, layout.getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
            }
        } else {
            String sval = null;
            if (cellType == 0) {
                try {
                    sval = formatter.formatCellValue(cell, dummyEvaluator);
                }
                catch (Exception e) {
                    sval = String.valueOf(cell.getNumericCellValue());
                }
            } else if (cellType == 4) {
                sval = String.valueOf(cell.getBooleanCellValue()).toUpperCase();
            }
            if (sval != null) {
                String txt = sval + '0';
                AttributedString str = new AttributedString(txt);
                SheetUtil.copyAttributes(font, str, 0, txt.length());
                TextLayout layout = new TextLayout(str.getIterator(), fontRenderContext);
                if (style.getRotation() != 0) {
                    AffineTransform trans = new AffineTransform();
                    trans.concatenate(AffineTransform.getRotateInstance((double)style.getRotation() * 2.0 * Math.PI / 360.0));
                    trans.concatenate(AffineTransform.getScaleInstance(1.0, 2.0));
                    width = Math.max(width, layout.getOutline(trans).getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                } else {
                    width = Math.max(width, layout.getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                }
            }
        }
        return width;
    }

    public static double getColumnWidth(Sheet sheet, int column, boolean useMergedCells) {
        Workbook wb = sheet.getWorkbook();
        DataFormatter formatter = new DataFormatter();
        Font defaultFont = wb.getFontAt((short)0);
        AttributedString str = new AttributedString(String.valueOf('0'));
        SheetUtil.copyAttributes(defaultFont, str, 0, 1);
        TextLayout layout = new TextLayout(str.getIterator(), fontRenderContext);
        int defaultCharWidth = (int)layout.getAdvance();
        double width = -1.0;
        for (Row row : sheet) {
            Cell cell = row.getCell(column);
            if (cell == null) continue;
            double cellWidth = SheetUtil.getCellWidth(cell, defaultCharWidth, formatter, useMergedCells);
            width = Math.max(width, cellWidth);
        }
        return width;
    }

    public static double getColumnWidth(Sheet sheet, int column, boolean useMergedCells, int firstRow, int lastRow) {
        Workbook wb = sheet.getWorkbook();
        DataFormatter formatter = new DataFormatter();
        Font defaultFont = wb.getFontAt((short)0);
        AttributedString str = new AttributedString(String.valueOf('0'));
        SheetUtil.copyAttributes(defaultFont, str, 0, 1);
        TextLayout layout = new TextLayout(str.getIterator(), fontRenderContext);
        int defaultCharWidth = (int)layout.getAdvance();
        double width = -1.0;
        for (int rowIdx = firstRow; rowIdx <= lastRow; ++rowIdx) {
            Cell cell;
            Row row = sheet.getRow(rowIdx);
            if (row == null || (cell = row.getCell(column)) == null) continue;
            double cellWidth = SheetUtil.getCellWidth(cell, defaultCharWidth, formatter, useMergedCells);
            width = Math.max(width, cellWidth);
        }
        return width;
    }

    private static void copyAttributes(Font font, AttributedString str, int startIdx, int endIdx) {
        str.addAttribute(TextAttribute.FAMILY, font.getFontName(), startIdx, endIdx);
        str.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getFontHeightInPoints()));
        if (font.getBoldweight() == 700) {
            str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, startIdx, endIdx);
        }
        if (font.getItalic()) {
            str.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, startIdx, endIdx);
        }
        if (font.getUnderline() == 1) {
            str.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, startIdx, endIdx);
        }
    }

    public static boolean containsCell(CellRangeAddress cr, int rowIx, int colIx) {
        return cr.getFirstRow() <= rowIx && cr.getLastRow() >= rowIx && cr.getFirstColumn() <= colIx && cr.getLastColumn() >= colIx;
    }
}

