/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.filter;

import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;

public class LastModifiedLimit
implements MFileFilter {
    private long lastModifiedLimitInMillis;

    public LastModifiedLimit(long lastModifiedLimitInMillis) {
        this.lastModifiedLimitInMillis = lastModifiedLimitInMillis;
    }

    public boolean accept(MFile dataset) {
        long lastModified = dataset.getLastModified();
        if (lastModified < 0L) {
            return true;
        }
        long now = System.currentTimeMillis();
        return now - lastModified > this.lastModifiedLimitInMillis;
    }

    public long getLastModifiedLimitInMillis() {
        return this.lastModifiedLimitInMillis;
    }
}

