/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.syntax;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageDescriptor {
    private final Set<String> type = new TreeSet<String>();
    private final Set<String> keyword = new TreeSet<String>();
    private final Set<String> preproc = new TreeSet<String>();

    public LanguageDescriptor() {
        this.type.add("actor");
        this.type.add("participant");
        this.type.add("usecase");
        this.type.add("class");
        this.type.add("interface");
        this.type.add("abstract");
        this.type.add("enum");
        this.type.add("component");
        this.type.add("state");
        this.type.add("object");
        this.type.add("artifact");
        this.type.add("folder");
        this.type.add("rect");
        this.type.add("node");
        this.type.add("frame");
        this.type.add("cloud");
        this.type.add("database");
        this.type.add("storage");
        this.type.add("agent");
        this.type.add("boundary");
        this.type.add("control");
        this.type.add("entity");
        this.type.add("card");
        this.keyword.add("@startuml");
        this.keyword.add("@enduml");
        this.keyword.add("as");
        this.keyword.add("also");
        this.keyword.add("autonumber");
        this.keyword.add("title");
        this.keyword.add("newpage");
        this.keyword.add("box");
        this.keyword.add("alt");
        this.keyword.add("else");
        this.keyword.add("opt");
        this.keyword.add("loop");
        this.keyword.add("par");
        this.keyword.add("break");
        this.keyword.add("critical");
        this.keyword.add("note");
        this.keyword.add("group");
        this.keyword.add("left");
        this.keyword.add("right");
        this.keyword.add("of");
        this.keyword.add("on");
        this.keyword.add("link");
        this.keyword.add("over");
        this.keyword.add("end");
        this.keyword.add("activate");
        this.keyword.add("deactivate");
        this.keyword.add("destroy");
        this.keyword.add("create");
        this.keyword.add("footbox");
        this.keyword.add("hide");
        this.keyword.add("show");
        this.keyword.add("skinparam");
        this.keyword.add("skin");
        this.keyword.add("top");
        this.keyword.add("bottom");
        this.keyword.add("top to bottom direction");
        this.keyword.add("package");
        this.keyword.add("namespace");
        this.keyword.add("page");
        this.keyword.add("up");
        this.keyword.add("down");
        this.keyword.add("if");
        this.keyword.add("else");
        this.keyword.add("endif");
        this.keyword.add("partition");
        this.keyword.add("footer");
        this.keyword.add("header");
        this.keyword.add("center");
        this.keyword.add("rotate");
        this.keyword.add("ref");
        this.keyword.add("return");
        this.keyword.add("is");
        this.keyword.add("repeat");
        this.keyword.add("start");
        this.keyword.add("stop");
        this.keyword.add("while");
        this.keyword.add("endwhile");
        this.keyword.add("fork");
        this.keyword.add("again");
        this.preproc.add("!include");
        this.preproc.add("!define");
        this.preproc.add("!undef");
        this.preproc.add("!ifdef");
        this.preproc.add("!endif");
        this.preproc.add("!ifndef");
    }

    public void print(PrintStream printStream) {
        LanguageDescriptor.print(printStream, "type", this.type);
        LanguageDescriptor.print(printStream, "keyword", this.keyword);
        LanguageDescriptor.print(printStream, "preprocessor", this.preproc);
        LanguageDescriptor.print(printStream, "skinparameter", SkinParam.getPossibleValues());
        LanguageDescriptor.print(printStream, "color", HtmlColorUtils.names());
        printStream.println(";EOF");
    }

    private static void print(PrintStream printStream, String string, Collection<String> collection) {
        printStream.println(";" + string);
        printStream.println(";" + collection.size());
        for (String string2 : collection) {
            printStream.println(string2);
        }
        printStream.println();
    }
}

