#!/usr/bin/perl

=head1 ABOUT

This is a sample program to generate an HTML document using XML::LibXML's
DOM routines. It was written to resolve
L<https://rt.cpan.org/Ticket/Display.html?id=117923> . Thanks to Dan Jacobson.

=cut

use strict;
use warnings;

use XML::LibXML;

{
    my $doc = XML::LibXML->createDocument;

    # A small Domain-Specific-Language for generating DOM:
    my $_text = sub {
        my ($content) = @_;

        return $doc->createTextNode($content);
    };

    # Short for element.
    my $_el = sub {
        my $name = shift;
        my $param = shift;
        my $attrs = {};
        if (ref($param) eq 'HASH')
        {
            $attrs = $param;
            $param = shift;
        }
        my $childs = $param;

        my $elem = $doc->createElementNS("", $name);

        while (my ($k, $v) = each %$attrs)
        {
            $elem->setAttribute($k, $v);
        }

        foreach my $child (@$childs)
        {
            $elem->appendChild($child);
        }

        return $elem;
    };

    my $html = $_el->(
        'html',
        [
            $_el->(
                'head',
                [
                    $_el->(
                        'title',
                        [
                            $_text->("Sample HTML document as generated by XML::LibXML"),
                        ],
                    ),
                    $_el->(
                        'meta',
                        { 'http-equiv' => 'Content-Type',
                            'content' => 'text/html; charset=utf-8'
                        },
                        [],
                    ),
                ],
            ),
            $_el->(
                'body',
                [
                    $_el->(
                        'p',
                        [
                            $_text->("Introducing a link - "),
                            $_el->(
                                'a',
                                { 'href' => 'http://www.wikipedia.org/', },
                                [
                                    $_text->("Link to Wikipedia"),
                                ],
                            ),
                            $_text->(". We hope you enjoyed it."),
                        ],
                    ),
                    $_el->(
                        'p',
                        [
                            $_el->(
                                'img',
                                { 'src' => 'http://example.com/non-exist.png',
                                    'alt' => 'non-existing image',
                                },
                                [],
                            ),
                        ],
                    ),
                    $_el->(
                        'ol',
                        [
                            $_el->(
                                'li',
                                [
                                    $_el->(
                                        'p',
                                        [
                                            $_text->("First item."),
                                        ],
                                    ),
                                ],
                            ),
                            $_el->(
                                'li',
                                [
                                    $_el->(
                                        'p',
                                        [
                                            $_text->("Second item."),
                                        ],
                                    ),
                                ],
                            ),
                        ],
                    ),
                ],
            ),
        ],
    );
    $doc->setDocumentElement( $html );

    print $doc->toStringHTML();
}

=head1 COPYRIGHT & LICENSE

Copyright 2016 by Shlomi Fish

This program is distributed under the MIT (X11) License:
L<http://www.opensource.org/licenses/mit-license.php>

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

=cut
