# Do not remove the following line; MakeMaker relies on it to identify
# this file as a template for defsubs.h
# Extracting defsubs.h (with variable substitutions)
#!perl -w
use File::Spec;
my (undef, $headerpath) = @ARGV;
my ($out) = __FILE__ =~ /(^.*)\.PL/i;
$out =~ s/_h$/.h/;
unlink $out if -l $out;
open(OUT,">$out") || die "Cannot open $file:$!";
print "Extracting $out...\n";
print OUT <<"END";
/*
 !!! Don't modify this file - it's autogenerated from $0 !!!
 */
END

foreach my $const (qw(
		      CVf_ANON
		      CVf_CLONE
		      CVf_CLONED
		      CVf_CONST
		      CVf_LOCKED
		      CVf_LVALUE
		      CVf_METHOD
		      CVf_NODEBUG
		      CVf_UNIQUE
		      CVf_WEAKOUTSIDE
		      GVf_IMPORTED_AV
		      GVf_IMPORTED_CV
		      GVf_IMPORTED_HV
		      GVf_IMPORTED_SV
		      HEf_SVKEY
		      SVTYPEMASK
		      SVf_FAKE
		      SVf_IOK
		      SVf_IVisUV
		      SVf_NOK
		      SVf_POK
		      SVf_READONLY
		      SVf_ROK
		      SVp_IOK
		      SVp_NOK
		      SVp_POK
		      SVpad_OUR
		      SVs_RMG
		      SVs_SMG
		      SVt_PVGV
		      SVt_PVHV
		      PAD_FAKELEX_ANON
		      PAD_FAKELEX_MULTI
		      ))
 {
  doconst($const);
 }

if ($] < 5.009) {
    # This is only present in 5.10, but it's useful to B::Deparse to be able
    # to import a dummy value from B
    doconst(OPpPAD_STATE);
}

if ($] >= 5.009) {
    # Constant not present in 5.8.x
    doconst(CVf_ISXSUB);
} else {
    # Constant not present after 5.8.x
    doconst(AVf_REAL);
}  

foreach my $tuple (['op.h'],['cop.h'],['regexp.h','RXf_'])
 {
  my $file = $tuple->[0];
  my $pfx = $tuple->[1] || '';
  my $path = File::Spec->catfile($headerpath, $file);
  open(OPH,"$path") || die "Cannot open $path:$!";
  while (<OPH>)
   {  
    doconst($1) if (/#define\s+($pfx\w+)\s+([\(\)\|\dx]+)\s*(?:$|\/\*)/);
   }  
  close(OPH);
 }
close(OUT);
               
sub doconst
{
 my $sym = shift;
 my $l = length($sym);
 print OUT <<"END";
 newCONSTSUB(stash,"$sym",newSViv($sym)); 
 av_push(export_ok,newSVpvn("$sym",$l));
END
}
