package Google::Ads::AdWords::v201109_1::TemplateAd;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201109_1' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201109_1::Ad);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %id_of :ATTR(:get<id>);
my %url_of :ATTR(:get<url>);
my %displayUrl_of :ATTR(:get<displayUrl>);
my %approvalStatus_of :ATTR(:get<approvalStatus>);
my %disapprovalReasons_of :ATTR(:get<disapprovalReasons>);
my %trademarkDisapproved_of :ATTR(:get<trademarkDisapproved>);
my %Ad__Type_of :ATTR(:get<Ad__Type>);
my %templateId_of :ATTR(:get<templateId>);
my %adUnionId_of :ATTR(:get<adUnionId>);
my %templateElements_of :ATTR(:get<templateElements>);
my %dimensions_of :ATTR(:get<dimensions>);
my %name_of :ATTR(:get<name>);
my %duration_of :ATTR(:get<duration>);

__PACKAGE__->_factory(
    [ qw(        id
        url
        displayUrl
        approvalStatus
        disapprovalReasons
        trademarkDisapproved
        Ad__Type
        templateId
        adUnionId
        templateElements
        dimensions
        name
        duration

    ) ],
    {
        'id' => \%id_of,
        'url' => \%url_of,
        'displayUrl' => \%displayUrl_of,
        'approvalStatus' => \%approvalStatus_of,
        'disapprovalReasons' => \%disapprovalReasons_of,
        'trademarkDisapproved' => \%trademarkDisapproved_of,
        'Ad__Type' => \%Ad__Type_of,
        'templateId' => \%templateId_of,
        'adUnionId' => \%adUnionId_of,
        'templateElements' => \%templateElements_of,
        'dimensions' => \%dimensions_of,
        'name' => \%name_of,
        'duration' => \%duration_of,
    },
    {
        'id' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'url' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'displayUrl' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'approvalStatus' => 'Google::Ads::AdWords::v201109_1::Ad::ApprovalStatus',
        'disapprovalReasons' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'trademarkDisapproved' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'Ad__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'templateId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'adUnionId' => 'Google::Ads::AdWords::v201109_1::AdUnionId',
        'templateElements' => 'Google::Ads::AdWords::v201109_1::TemplateElement',
        'dimensions' => 'Google::Ads::AdWords::v201109_1::Dimensions',
        'name' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'duration' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'id' => 'id',
        'url' => 'url',
        'displayUrl' => 'displayUrl',
        'approvalStatus' => 'approvalStatus',
        'disapprovalReasons' => 'disapprovalReasons',
        'trademarkDisapproved' => 'trademarkDisapproved',
        'Ad__Type' => 'Ad.Type',
        'templateId' => 'templateId',
        'adUnionId' => 'adUnionId',
        'templateElements' => 'templateElements',
        'dimensions' => 'dimensions',
        'name' => 'name',
        'duration' => 'duration',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109_1::TemplateAd

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TemplateAd from the namespace https://adwords.google.com/api/adwords/cm/v201109_1.

Represents a <a href= "http://www.google.com/adwords/displaynetwork/plan-creative-campaigns/display-ad-builder.html" >Display Ad Builder</a> template ad. A template ad is composed of a template (specified by its ID) and the data that populates the template's fields. For a list of available templates and their required fields, see the <a href= "/apis/adwords/docs/appendix/templateads.html">Template Ads appendix</a>. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * templateId


=item * adUnionId


=item * templateElements


=item * dimensions


=item * name


=item * duration




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109_1::TemplateAd
   templateId =>  $some_value, # long
   adUnionId =>  $a_reference_to, # see Google::Ads::AdWords::v201109_1::AdUnionId
   templateElements =>  $a_reference_to, # see Google::Ads::AdWords::v201109_1::TemplateElement
   dimensions =>  $a_reference_to, # see Google::Ads::AdWords::v201109_1::Dimensions
   name =>  $some_value, # string
   duration =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

