# Generated by default/object.tt
package Paws::LookoutEquipment::ModelSummary;
  use Moose;
  has CreatedAt => (is => 'ro', isa => 'Str');
  has DatasetArn => (is => 'ro', isa => 'Str');
  has DatasetName => (is => 'ro', isa => 'Str');
  has ModelArn => (is => 'ro', isa => 'Str');
  has ModelName => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutEquipment::ModelSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutEquipment::ModelSummary object:

  $service_obj->Method(Att1 => { CreatedAt => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutEquipment::ModelSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedAt

=head1 DESCRIPTION

Provides information about the specified ML model, including dataset
and model names and ARNs, as well as status.

=head1 ATTRIBUTES


=head2 CreatedAt => Str

The time at which the specific model was created.


=head2 DatasetArn => Str

The Amazon Resource Name (ARN) of the dataset used to create the model.


=head2 DatasetName => Str

The name of the dataset being used for the ML model.


=head2 ModelArn => Str

The Amazon Resource Name (ARN) of the ML model.


=head2 ModelName => Str

The name of the ML model.


=head2 Status => Str

Indicates the status of the ML model.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutEquipment>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

