# Generated by default/object.tt
package Paws::Quicksight::Theme;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has CreatedTime => (is => 'ro', isa => 'Str');
  has LastUpdatedTime => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has ThemeId => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str');
  has Version => (is => 'ro', isa => 'Paws::Quicksight::ThemeVersion');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::Theme

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::Theme object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::Theme object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Summary information about a theme.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the theme.


=head2 CreatedTime => Str

The date and time that the theme was created.


=head2 LastUpdatedTime => Str

The date and time that the theme was last updated.


=head2 Name => Str

The name that the user gives to the theme.


=head2 ThemeId => Str

The identifier that the user gives to the theme.


=head2 Type => Str

The type of theme, based on how it was created. Valid values include:
C<QUICKSIGHT> and C<CUSTOM>.


=head2 Version => L<Paws::Quicksight::ThemeVersion>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

