package HTTP::MobileAgent::DoCoMoDisplayMap;
# This file is autogenerated by makedocomomap
# in HTTP-MobileAgent distribution

use strict;
require Exporter;
use base qw(Exporter);

use vars qw(@EXPORT_OK $DisplayMap);
@EXPORT_OK = qw($DisplayMap);

BEGIN {
    if ($ENV{DOCOMO_MAP}) {
        eval q{
            require XML::Simple;
            my $xml = XML::Simple->new;
            my $map = $xml->XMLin($ENV{DOCOMO_MAP});
            if ($map->{terminal}) {
                # new layout
                for my $terminal (@{$map->{terminal}}) {
                    my $model = delete $terminal->{model};
                    $DisplayMap->{$model} = $terminal;
                }
            }
            else {
                # old layout
                $DisplayMap = $map;
            }
        };
        warn "using normal hash map: $@" if $@;
    }
}

$DisplayMap ||= {
  'CA01C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '650',
    'width' => '480'
  },
  'D2101V' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '130',
    'width' => '120'
  },
  'D701I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '240',
    'width' => '230'
  },
  'D701IWM' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '240',
    'width' => '230'
  },
  'D702I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'D702IBCL' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'D702IF' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'D703I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'D704I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'D705I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'D705IMYU' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '240'
  },
  'D800IDS' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'D851IWM' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '230'
  },
  'D900I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'D901I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'D901IS' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'D902I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '230'
  },
  'D902IS' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '230'
  },
  'D903I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '230'
  },
  'D903ITV' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '230'
  },
  'D904I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'D905I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '352',
    'width' => '240'
  },
  'F01A' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '352',
    'width' => '240'
  },
  'F01B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '648',
    'width' => '480'
  },
  'F01C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'F02A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '352',
    'width' => '240'
  },
  'F02B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '648',
    'width' => '480'
  },
  'F02C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'F02D' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'F03A' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '352',
    'width' => '240'
  },
  'F03B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '648',
    'width' => '480'
  },
  'F03C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'F04A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '352',
    'width' => '240'
  },
  'F04B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '648',
    'width' => '480'
  },
  'F04C' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '648',
    'width' => '480'
  },
  'F04D' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'F05A' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '352',
    'width' => '240'
  },
  'F05C' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '648',
    'width' => '480'
  },
  'F06A' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '352',
    'width' => '240'
  },
  'F06B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'F06D' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'F07A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '256',
    'width' => '240'
  },
  'F07B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '648',
    'width' => '480'
  },
  'F07C' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '630',
    'width' => '480'
  },
  'F08A3' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '648',
    'width' => '480'
  },
  'F08B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '648',
    'width' => '480'
  },
  'F08C' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '330',
    'width' => '240'
  },
  'F09A3' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '648',
    'width' => '480'
  },
  'F09B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '330',
    'width' => '240'
  },
  'F09C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'F10A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '330',
    'width' => '240'
  },
  'F10B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '648',
    'width' => '480'
  },
  'F10C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'F11C' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '648',
    'width' => '480'
  },
  'F2051' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '182',
    'width' => '176'
  },
  'F2102V' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '182',
    'width' => '176'
  },
  'F700I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F700IS' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F702ID' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F703I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F704I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F705I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '352',
    'width' => '240'
  },
  'F706I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '352',
    'width' => '240'
  },
  'F801I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '352',
    'width' => '240'
  },
  'F880IES' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '256',
    'width' => '240'
  },
  'F881IES' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '256',
    'width' => '240'
  },
  'F882IES' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '256',
    'width' => '240'
  },
  'F883I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '256',
    'width' => '240'
  },
  'F883IES' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '256',
    'width' => '240'
  },
  'F883IESS' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '256',
    'width' => '240'
  },
  'F883IS' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '256',
    'width' => '240'
  },
  'F884I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '364',
    'width' => '240'
  },
  'F884IES' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '282',
    'width' => '240'
  },
  'F900I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F900IC' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F900IT' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F901IC' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F901IS' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F902I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F902IS' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F903I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F903IBSC' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F903IX' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '230'
  },
  'F904I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '352',
    'width' => '240'
  },
  'F905I' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '352',
    'width' => '240'
  },
  'F905IBIZ' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '352',
    'width' => '240'
  },
  'F906I' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '352',
    'width' => '240'
  },
  'L01B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '660',
    'width' => '480'
  },
  'L01C' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '330',
    'width' => '240'
  },
  'L03C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '320',
    'width' => '240'
  },
  'L10C' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '330',
    'width' => '240'
  },
  'L600I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '189',
    'width' => '170'
  },
  'L601I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '189',
    'width' => '170'
  },
  'L602I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '189',
    'width' => '170'
  },
  'L704I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '280',
    'width' => '240'
  },
  'L705I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '280',
    'width' => '240'
  },
  'L705IX' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '280',
    'width' => '240'
  },
  'L706IE' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '280',
    'width' => '240'
  },
  'L852I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '298',
    'width' => '240'
  },
  'M702IG' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '267',
    'width' => '240'
  },
  'M702IS' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '267',
    'width' => '240'
  },
  'N01A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N01B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '640',
    'width' => '480'
  },
  'N01C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '650',
    'width' => '480'
  },
  'N02A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N02B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '640',
    'width' => '480'
  },
  'N02C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '650',
    'width' => '480'
  },
  'N02D' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '650',
    'width' => '480'
  },
  'N03A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N03B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '640',
    'width' => '480'
  },
  'N03C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '650',
    'width' => '480'
  },
  'N03D' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '650',
    'width' => '480'
  },
  'N04A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N04B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '640',
    'width' => '480'
  },
  'N05A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N05B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '640',
    'width' => '480'
  },
  'N05C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '650',
    'width' => '480'
  },
  'N06A3' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '640',
    'width' => '480'
  },
  'N06B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N07A3' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '640',
    'width' => '480'
  },
  'N07B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '640',
    'width' => '480'
  },
  'N08A3' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '640',
    'width' => '480'
  },
  'N08B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '480',
    'width' => '480'
  },
  'N09A3' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '640',
    'width' => '480'
  },
  'N2001' => {
    'color' => 1,
    'depth' => '4096',
    'height' => '128',
    'width' => '118'
  },
  'N2002' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '128',
    'width' => '118'
  },
  'N2051' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '198',
    'width' => '176'
  },
  'N2102V' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '198',
    'width' => '176'
  },
  'N2701' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '198',
    'width' => '176'
  },
  'N600I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '180',
    'width' => '176'
  },
  'N601I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'N700I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'N701I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'N701IECO' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'N702ID' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'N702IS' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'N703ID' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'N703IMYU' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'N704IMYU' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'N705I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N705IMYU' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N706I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N706IE' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N706III' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N900I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '269',
    'width' => '240'
  },
  'N900IG' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '269',
    'width' => '240'
  },
  'N900IL' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '269',
    'width' => '240'
  },
  'N900IS' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '269',
    'width' => '240'
  },
  'N901IC' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'N901IS' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'N902I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'N902IL' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'N902IS' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'N902IX' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'N903I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'N904I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '352',
    'width' => '240'
  },
  'N905I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N905IBIZ' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N905IMYU' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N906I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N906IL' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'N906IMYU' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'NM705I' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '235',
    'width' => '231'
  },
  'NM706I' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '235',
    'width' => '231'
  },
  'NM850IG' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '144',
    'width' => '176'
  },
  'P01A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P01B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '662',
    'width' => '480'
  },
  'P01C' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '331',
    'width' => '240'
  },
  'P02A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P02B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '662',
    'width' => '480'
  },
  'P02C' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '662',
    'width' => '480'
  },
  'P03A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P03B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '331',
    'width' => '240'
  },
  'P03C' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '650',
    'width' => '480'
  },
  'P03D' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '650',
    'width' => '480'
  },
  'P04A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P04B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '662',
    'width' => '480'
  },
  'P04C' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '650',
    'width' => '480'
  },
  'P05A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P05B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '331',
    'width' => '240'
  },
  'P05C' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '650',
    'width' => '480'
  },
  'P06A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P06B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '650',
    'width' => '480'
  },
  'P06C' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '650',
    'width' => '480'
  },
  'P07A3' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '662',
    'width' => '480'
  },
  'P07B' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '331',
    'width' => '240'
  },
  'P08A3' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '662',
    'width' => '480'
  },
  'P09A3' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '662',
    'width' => '480'
  },
  'P10A' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P2002' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '128',
    'width' => '118'
  },
  'P2101V' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '182',
    'width' => '163'
  },
  'P2102V' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '198',
    'width' => '176'
  },
  'P700I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'P701ID' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'P702I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'P702ID' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'P703I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'P703IMYU' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'P704I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'P704IMYU' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'P705I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P705ICL' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P705IMYU' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P706IE' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P706IMYU' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P851I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'P900I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '266',
    'width' => '240'
  },
  'P900IV' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '266',
    'width' => '240'
  },
  'P901I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'P901IS' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'P901ITV' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '270',
    'width' => '240'
  },
  'P902I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'P902IS' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'P903I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'P903ITV' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P903IX' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '270',
    'width' => '240'
  },
  'P904I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P905I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P905ITV' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'P906I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '350',
    'width' => '240'
  },
  'SA700IS' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '252',
    'width' => '240'
  },
  'SA702I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '252',
    'width' => '240'
  },
  'SA800I' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '252',
    'width' => '240'
  },
  'SH01A' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '320',
    'width' => '240'
  },
  'SH01B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '646',
    'width' => '480'
  },
  'SH01C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'SH02A' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '320',
    'width' => '240'
  },
  'SH02B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '646',
    'width' => '480'
  },
  'SH02C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'SH03A' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '320',
    'width' => '240'
  },
  'SH03B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '592',
    'width' => '480'
  },
  'SH03D' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'SH04A' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '320',
    'width' => '240'
  },
  'SH04B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '592',
    'width' => '480'
  },
  'SH04C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'SH05A3' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '592',
    'width' => '480'
  },
  'SH05B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '646',
    'width' => '480'
  },
  'SH05C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '592',
    'width' => '480'
  },
  'SH05D' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'SH06A3' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '592',
    'width' => '480'
  },
  'SH06B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '646',
    'width' => '480'
  },
  'SH06C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '592',
    'width' => '480'
  },
  'SH07A3' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '592',
    'width' => '480'
  },
  'SH07B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'SH08A' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '592',
    'width' => '480'
  },
  'SH08B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '646',
    'width' => '480'
  },
  'SH08C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '592',
    'width' => '480'
  },
  'SH09B' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '646',
    'width' => '480'
  },
  'SH09C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'SH10C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'SH11C' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '656',
    'width' => '480'
  },
  'SH2101V' => {
    'color' => 1,
    'depth' => '65536',
    'height' => '600',
    'width' => '800'
  },
  'SH700I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '252',
    'width' => '240'
  },
  'SH700IS' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '252',
    'width' => '240'
  },
  'SH702ID' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '240'
  },
  'SH702IS' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '240'
  },
  'SH703I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '240'
  },
  'SH704I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'SH705I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'SH705III' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'SH706I' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '320',
    'width' => '240'
  },
  'SH706IE' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'SH706IW' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '320',
    'width' => '240'
  },
  'SH851I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '252',
    'width' => '240'
  },
  'SH900I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '252',
    'width' => '240'
  },
  'SH901IC' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '252',
    'width' => '240'
  },
  'SH901IS' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '252',
    'width' => '240'
  },
  'SH902I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '240'
  },
  'SH902IS' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '240'
  },
  'SH902ISL' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '240',
    'width' => '240'
  },
  'SH903I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'SH903ITV' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'SH904I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'SH905I' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '320',
    'width' => '240'
  },
  'SH905ITV' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '320',
    'width' => '240'
  },
  'SH906I' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '320',
    'width' => '240'
  },
  'SH906ITV' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '320',
    'width' => '240'
  },
  'SO702I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '256',
    'width' => '240'
  },
  'SO703I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '368',
    'width' => '240'
  },
  'SO704I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '368',
    'width' => '240'
  },
  'SO705I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'SO706I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '320',
    'width' => '240'
  },
  'SO902I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '256',
    'width' => '240'
  },
  'SO902IWP+' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '256',
    'width' => '240'
  },
  'SO903I' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '368',
    'width' => '240'
  },
  'SO903ITV' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '368',
    'width' => '240'
  },
  'SO905I' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '368',
    'width' => '240'
  },
  'SO905ICS' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '368',
    'width' => '240'
  },
  'SO906I' => {
    'color' => 1,
    'depth' => '16777216',
    'height' => '368',
    'width' => '240'
  },
  'T2101V' => {
    'color' => 1,
    'depth' => '262144',
    'height' => '144',
    'width' => '176'
  }
}
;

1;
