# Generated by default/object.tt
package Paws::GlueDataBrew::DatabaseInputDefinition;
  use Moose;
  has DatabaseTableName => (is => 'ro', isa => 'Str', required => 1);
  has GlueConnectionName => (is => 'ro', isa => 'Str', required => 1);
  has TempDirectory => (is => 'ro', isa => 'Paws::GlueDataBrew::S3Location');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::DatabaseInputDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::DatabaseInputDefinition object:

  $service_obj->Method(Att1 => { DatabaseTableName => $value, ..., TempDirectory => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::DatabaseInputDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->DatabaseTableName

=head1 DESCRIPTION

Connection information for dataset input files stored in a database.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DatabaseTableName => Str

The table within the target database.


=head2 B<REQUIRED> GlueConnectionName => Str

The Glue Connection that stores the connection information for the
target database.


=head2 TempDirectory => L<Paws::GlueDataBrew::S3Location>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

