# Generated by default/object.tt
package Paws::HealthLake::ImportJobProperties;
  use Moose;
  has DataAccessRoleArn => (is => 'ro', isa => 'Str');
  has DatastoreId => (is => 'ro', isa => 'Str', required => 1);
  has EndTime => (is => 'ro', isa => 'Str');
  has InputDataConfig => (is => 'ro', isa => 'Paws::HealthLake::InputDataConfig', required => 1);
  has JobId => (is => 'ro', isa => 'Str', required => 1);
  has JobName => (is => 'ro', isa => 'Str');
  has JobStatus => (is => 'ro', isa => 'Str', required => 1);
  has Message => (is => 'ro', isa => 'Str');
  has SubmitTime => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::HealthLake::ImportJobProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::HealthLake::ImportJobProperties object:

  $service_obj->Method(Att1 => { DataAccessRoleArn => $value, ..., SubmitTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::HealthLake::ImportJobProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->DataAccessRoleArn

=head1 DESCRIPTION

Displays the properties of the import job, including the ID, Arn, Name,
and the status of the Data Store.

=head1 ATTRIBUTES


=head2 DataAccessRoleArn => Str

The Amazon Resource Name (ARN) that gives Amazon HealthLake access to
your input data.


=head2 B<REQUIRED> DatastoreId => Str

The datastore id used when the Import job was created.


=head2 EndTime => Str

The time that the Import job was completed.


=head2 B<REQUIRED> InputDataConfig => L<Paws::HealthLake::InputDataConfig>

The input data configuration that was supplied when the Import job was
created.


=head2 B<REQUIRED> JobId => Str

The AWS-generated id number for the Import job.


=head2 JobName => Str

The user-generated name for an Import job.


=head2 B<REQUIRED> JobStatus => Str

The job status for an Import job. Possible statuses are SUBMITTED,
IN_PROGRESS, COMPLETED, FAILED.


=head2 Message => Str

An explanation of any errors that may have occurred during the FHIR
import job.


=head2 B<REQUIRED> SubmitTime => Str

The time that the Import job was submitted for processing.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::HealthLake>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

