# Generated by default/object.tt
package Paws::MediaLive::VideoBlackFailoverSettings;
  use Moose;
  has BlackDetectThreshold => (is => 'ro', isa => 'Num', request_name => 'blackDetectThreshold', traits => ['NameInRequest']);
  has VideoBlackThresholdMsec => (is => 'ro', isa => 'Int', request_name => 'videoBlackThresholdMsec', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::VideoBlackFailoverSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::VideoBlackFailoverSettings object:

  $service_obj->Method(Att1 => { BlackDetectThreshold => $value, ..., VideoBlackThresholdMsec => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::VideoBlackFailoverSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->BlackDetectThreshold

=head1 DESCRIPTION

Placeholder documentation for VideoBlackFailoverSettings

=head1 ATTRIBUTES


=head2 BlackDetectThreshold => Num

A value used in calculating the threshold below which MediaLive
considers a pixel to be 'black'. For the input to be considered black,
every pixel in a frame must be below this threshold. The threshold is
calculated as a percentage (expressed as a decimal) of white. Therefore
.1 means 10% white (or 90% black). Note how the formula works for any
color depth. For example, if you set this field to 0.1 in 10-bit color
depth: (1023*0.1=102.3), which means a pixel value of 102 or less is
'black'. If you set this field to .1 in an 8-bit color depth:
(255*0.1=25.5), which means a pixel value of 25 or less is 'black'. The
range is 0.0 to 1.0, with any number of decimal places.


=head2 VideoBlackThresholdMsec => Int

The amount of time (in milliseconds) that the active input must be
black before automatic input failover occurs.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

