# Generated by default/object.tt
package Paws::Translate::ParallelDataProperties;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has CreatedAt => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has EncryptionKey => (is => 'ro', isa => 'Paws::Translate::EncryptionKey');
  has FailedRecordCount => (is => 'ro', isa => 'Int');
  has ImportedDataSize => (is => 'ro', isa => 'Int');
  has ImportedRecordCount => (is => 'ro', isa => 'Int');
  has LastUpdatedAt => (is => 'ro', isa => 'Str');
  has LatestUpdateAttemptAt => (is => 'ro', isa => 'Str');
  has LatestUpdateAttemptStatus => (is => 'ro', isa => 'Str');
  has Message => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has ParallelDataConfig => (is => 'ro', isa => 'Paws::Translate::ParallelDataConfig');
  has SkippedRecordCount => (is => 'ro', isa => 'Int');
  has SourceLanguageCode => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has TargetLanguageCodes => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Translate::ParallelDataProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Translate::ParallelDataProperties object:

  $service_obj->Method(Att1 => { Arn => $value, ..., TargetLanguageCodes => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Translate::ParallelDataProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

The properties of a parallel data resource.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the parallel data resource.


=head2 CreatedAt => Str

The time at which the parallel data resource was created.


=head2 Description => Str

The description assigned to the parallel data resource.


=head2 EncryptionKey => L<Paws::Translate::EncryptionKey>




=head2 FailedRecordCount => Int

The number of records unsuccessfully imported from the parallel data
input file.


=head2 ImportedDataSize => Int

The number of UTF-8 characters that Amazon Translate imported from the
parallel data input file. This number includes only the characters in
your translation examples. It does not include characters that are used
to format your file. For example, if you provided a Translation Memory
Exchange (.tmx) file, this number does not include the tags.


=head2 ImportedRecordCount => Int

The number of records successfully imported from the parallel data
input file.


=head2 LastUpdatedAt => Str

The time at which the parallel data resource was last updated.


=head2 LatestUpdateAttemptAt => Str

The time that the most recent update was attempted.


=head2 LatestUpdateAttemptStatus => Str

The status of the most recent update attempt for the parallel data
resource.


=head2 Message => Str

Additional information from Amazon Translate about the parallel data
resource.


=head2 Name => Str

The custom name assigned to the parallel data resource.


=head2 ParallelDataConfig => L<Paws::Translate::ParallelDataConfig>

Specifies the format and S3 location of the parallel data input file.


=head2 SkippedRecordCount => Int

The number of items in the input file that Amazon Translate skipped
when you created or updated the parallel data resource. For example,
Amazon Translate skips empty records, empty target texts, and empty
lines.


=head2 SourceLanguageCode => Str

The source language of the translations in the parallel data file.


=head2 Status => Str

The status of the parallel data resource. When the parallel data is
ready for you to use, the status is C<ACTIVE>.


=head2 TargetLanguageCodes => ArrayRef[Str|Undef]

The language codes for the target languages available in the parallel
data file. All possible target languages are returned as an array.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Translate>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

