# Generated by default/object.tt
package Paws::SageMaker::ArtifactSourceType;
  use Moose;
  has SourceIdType => (is => 'ro', isa => 'Str', required => 1);
  has Value => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ArtifactSourceType

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ArtifactSourceType object:

  $service_obj->Method(Att1 => { SourceIdType => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ArtifactSourceType object:

  $result = $service_obj->Method(...);
  $result->Att1->SourceIdType

=head1 DESCRIPTION

The ID and ID type of an artifact source.

=head1 ATTRIBUTES


=head2 B<REQUIRED> SourceIdType => Str

The type of ID.


=head2 B<REQUIRED> Value => Str

The ID.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

