use strict;
use warnings;
use Test::More tests => 68;
use Digest::Hamsi qw(hamsi_384 hamsi_384_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Hamsi->new(384)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            hamsi_384_hex($data), $digest,
            "hamsi_384_hex: $len bits of $msg"
        );
        ok(
            hamsi_384($data) eq pack('H*', $digest),
            "hamsi_384: $len bits of $msg"
        );
    }

    my $md = Digest::Hamsi->new(384)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|3943CD34E3B96B197A8BF4BAC7AA982D18530DD12F41136B26D7E88759255F21153F4A4BD02E523612B8427F9DD96C8D
00|FE01E43FD1B6D68E14C626FB0BEF2536196D34FDF269E158EC3EFB4698A38076F1E9461143B20ED57458CBD0B4BEDBC1
C0|5A98A212919F11A7033B38DE92D2D26DFA984535203B5875E2F433E033EA710C4521F6D1EAFAAAD72FA9F5842CD1E2DC
C0|27E79763A466D497886C058939C282DA6CCCACAAA6B06D9456CE31DC43341CD115F9DD67F70DC9061D8ABEF133703D95
80|3C346F258ABDA2CD4E99C5F3F2D0BF99CDFEEF3EBBD60B141C851DF0DDF55E19A590F906D992461025E9649CBF3A4BBF
48|7E0AE580FF083259C1FA76BD074AAE0EF56E7E2DFFC4D856F8FAB24DE26A9F47B1A8E0A8A8DD0AFB8995C5BBA499A148
50|5EE13848ED59A93E36426D7B508E2CE28B9020D526522464755845B9CCD30DAB01A368058FEC177AEDC579BBB5E81966
98|93337A356B0A92004E74B04941C18E2E9493676E734DC54E12716F54244ABC6740B181752FE0D24EDEE0037728968D88
CC|9B299C0B4A6838B5B0F53B0F9C0AEA98BBC9C4C9481EC0EC68F344E696F8787DE2E08A1404A038C83AC9E121136E8BB8
9800|18FC42D482EB5038DEB333FEE4228FE4602E45B66023458689F14457ACEEC848E9C94AA3809443276BB8D2521371F8EE
9D40|E726BCF73A2B4FD1440290758BE0945E1BBCD717BAD1187B7D47226EF78CF2CF17709DE0D670594F25D37A2E08B15B9A
AA80|12CC12699D1B5B6B9C4BADAC3A50FA8BBCF42234323A01932D449FC65542206C1912291FC9D497EF756794EC4D33B963
9830|9B7DC0D0DB34EA325C453A2BA4D338A623D06587FBCED3041C104F15B6B7A7E618ED4BAE7F2933FB9D255A5DC479567E
5030|25300536DF6DB151548BA430A7C1D79DF57E23B5C5C194BB6008CF667FFD1300D0AC864138A9DBA7170C89151B7BB511
4D24|990EE4DC8D1CCC4D27D76A6DB12F4AC7007987EF540F342764A284A6F17FFDF8634D17A4F3A216A29CAC5519D7CE60D8
CBDE|7937062C4B2E933248A8799482393E8BD302E41EE0BB0B1DA55A64A80D3B7973E1C40033FE79C73B3535089AB520E595
41FB|E7394C52238CA2251E51714E790B0EE64A27EBD669CD88F2D564BF17FF704D710BA5F4419DD106A027B16D3DECFB3A9A
4FF400|28072DAA55DBA3473E2C832400FEFFB0142E9525626C32AD758BC97F877C8E88AD63E89714DF61D190316EB87C2DABB4
FD0440|EDAD0FDE2BCB8037057354B5282D35DCCEE046E58F53C3D6F5BF32882795E8A51672AF62640FB5F056530B48E989D1BE
424D00|A6282CEB076DB8AE54CFAB24069AF617A6CC0E7ACB4C7DEDC06A099F51C5951DF0C94AC24BB238DAE4BCB6C4DBDE099A
3FDEE0|87EE5B6E7F21ECAD310E8408669412C4EA3BE5D6F3B7B351A5821B90313454D62DCC7C86FC7A81064CD83D5012D2374A
335768|877E4D19A58D9ACB09DB3A00150E2C838B0F4254AAF8F0D683B630409E18F83E0E0BB155795162C2179F1B0EBBC2A00E
051E7C|08A3877BF4B50080F1AB04BB682F2BD41851C4F686B3A6B05E890C8F52D973DAE11DD6F2764B272C017DCDEFA1354E3A
717F8C|B76D04858D9C32716ACE909F328F9FDA9DE68F835434F2238C80899E438A2F8B9505415D4EA43D3A5E3CAE89908A11ED
1F877C|D8C34C26E4147F706B94923073EE272AEF4D024E75CB622288016E38175AF79C405CEC671F426DC2ABEF6E4381886E69
EB35CF80|46F967CA54CF7B8D4C8963D25C164F81DAE913194514FC136AB65E40C3A2DF21C8430143EB77E0B7ED018EE6418699E0
B406C480|61B566348E86469BCDF854801A9DE0CD584684EF0F2924C9E5C58803AECC02DBB9E2212058B9B532A1377012C32DAB10
CEE88040|5587E4A6FE05751A7F7BC52AA289FA8F98743BA7B59A165A662A12799720C367D8D787216D8612EE17053FF7936BF6D3
C584DB70|23698678EA2DB0EB7CAB521F13CE38EAAE258979B178B9D7DF5DFF36ABEF8F26DEE681C8E90E7BC4CB27B484070ADF33
53587BC8|4FE20A44FC9FFED715BDCB44DC9D0F95A70FD3B05906B0FAEFA9DF0253E6B1653AC5F05DD8D621C1B95C3F36166CCD7A
69A305B0|D4C331C978B7EDA164CB1C571DF1070932A6A1B2DCB47A1909063D259A19C02B99CD7FB6B940842F1EF86D42ACDC25AE
C9375ECE|36E37B5E3B1AC82047964C1D04684872A0958445184C204356A4308D2B960F2F9E27AEE94A9558AC5C45D1E368C09D76
C1ECFDFC|CE995F5DDAA1EFCA93F01E88CD419A4B7858B6A1624753E3D86998F7A1731DBC1FB9E1461F967D11702F83C5B412C52E
8D73E8A280|3DB8BA87A3DAB9FDBFD515B42386522BB2EDC8E0943D3F5B0E78683884345033B33A16DDA42F5C44C68D1914431262E5
06F2522080|AA89620DA992BFEFD72CBB4CE06C0448410C5B1080225B617C82769CE9343AE2F7051DC64392BAA9C75E64CAD86FAC07
3EF6C36F20|9FB16B8FAEBCB09C2ADB79790DE507B1D5595C5AEE0B9A2C690388116C2A25A14A9C6438973B4B4ED9E1E6C712038B79
0127A1D340|7E5050B4BCF19618E430D0D9BBFF766FB128F0941209AD02236F444B5A627B51B03AC74EC031081F2DF442EE8EFAE32A
6A6AB6C210|CCDC8EBE0FA6676A42DF3C9D364E9FFBBC1868E1BE3B28C5E85F65637DE2A454CF859E4880D93EA2EEA5FB00C0F09BF3
AF3175E160|AFFDBBEEE59B9852C1F5BEA751F2B8821D2B8AC408011CAA1263D19244E65EACF9AC30856794B3E57EA37DE20B33129B
B66609ED86|03CA19F1498FC3C166BC893C90A5A02665EA26A82118960D89D9184B98E0653DCDC5E847C2EE2544B66968B7625AC43C
21F134AC57|729FE312BA82B1BA5A3123D8267D9A4CB4022C86FECAD9BEBF11565589B828346306F9E0A21FDF2C124F163F777340C5
3DC2AADFFC80|A4EAB9FCC00C1B2F606EEF71E5F9AEB713E36FBDD01347A7E74A3AFA8AC6C887B9E8771E3D4228A38431302BCDCF1924
9202736D2240|37CEE47C7FF2B01B78419B2E81623EC493E7A32E85B6A78DB25B144B8D5482934FFF6EA4FC0B072C54A48F50B1B29662
F219BD629820|A6B9ABD938FADFD8D3043049D54C722144C0D72E6CAB303DC60EB036E5DB3BD99673287B6E6EFB865FA70734875311E5
F3511EE2C4B0|42D41651CD10036B39BAA3F847ACED92D46647E2D9B51B1572EE7F941A60B604B406DB2FCBA9F2748C825F64D5138DB0
3ECAB6BF7720|A69C9F54BD705A79438D29A43369DF23B8E8FB70121B1AD3DC68B9DC061E0B63BF8740FDB95EAF399DB951F069D25D36
CD62F688F498|92097817BDE5C9C9B31BF5ED0C9BA29A0CAA254CCF0359324970C25C6F4E68002CD3C5CB87FBE4643C4847C992AC5343
C2CBAA33A9F8|044A59C2414F79BCDA6E683280066ED05E68066D0EDE2B761A3C85A25AE434F7544CBD47F9A6ABDFD93368CDB21D5353
C6F50BB74E29|A86EA34B1C88DD353D8CFAEA2683A852933FD38EC2F730296B1371A72E75FFD72AFDC785B9DDF7545BF92EF42727F27D
79F1B4CCC62A00|79D6450FD47C3D36A67C1A6B19229608A910EAD67D046438F34F84AA048CA6CB0481CB3A7F82135F635FA1EA134D4B53
