/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineOpImage;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AffineGeneralOpImage
extends AffineOpImage {
    private int subsampleBits;
    private int shiftvalue;
    private int interp_width;
    private int interp_height;
    private int interp_left;
    private int interp_top;
    private int interp_right;
    private int interp_bottom;

    public AffineGeneralOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, map, imageLayout, affineTransform, interpolation, dArray);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.shiftvalue = 1 << this.subsampleBits;
        this.interp_width = interpolation.getWidth();
        this.interp_height = interpolation.getHeight();
        this.interp_left = interpolation.getLeftPadding();
        this.interp_top = interpolation.getTopPadding();
        this.interp_right = this.interp_width - this.interp_left - 1;
        this.interp_bottom = this.interp_height - this.interp_top - 1;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int[][] nArray = new int[this.interp_height][this.interp_width];
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        byte[] byArray3 = new byte[n8];
        int n13 = 0;
        while (n13 < n8) {
            byArray3[n13] = (byte)this.backgroundValues[n13];
            ++n13;
        }
        int n14 = n10;
        while (n14 < n12) {
            int n15 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n14 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n16 = (int)Math.floor(f5);
            int n17 = (int)Math.floor(f6);
            float f7 = f5 - (float)n16;
            float f8 = f6 - (float)n17;
            int n18 = (n16 - n) * n6;
            int n19 = (n17 - n2) * n7;
            int n20 = n9;
            while (n20 < n11) {
                int n21;
                if ((float)n16 >= f + (float)this.interp_left && (float)n16 < f3 - (float)this.interp_right && (float)n17 >= f2 + (float)this.interp_top && (float)n17 < f4 - (float)this.interp_bottom) {
                    n21 = 0;
                    while (n21 < n8) {
                        byte[] byArray4 = byArray2[n21];
                        int n22 = nArray3[n21];
                        int n23 = this.interp_left * n6 + this.interp_top * n7;
                        n23 = n18 + n19 - n23;
                        int n24 = 0;
                        int n25 = 0;
                        int n26 = 0;
                        while (n26 < this.interp_height) {
                            int n27 = n23;
                            int n28 = 0;
                            while (n28 < this.interp_width) {
                                nArray[n25][n24++] = byArray4[n23 + n22] & 0xFF;
                                n23 += n6;
                                ++n28;
                            }
                            ++n25;
                            n24 = 0;
                            n23 = n27 + n7;
                            ++n26;
                        }
                        int n29 = (int)(f7 * (float)this.shiftvalue);
                        int n30 = (int)(f8 * (float)this.shiftvalue);
                        int n31 = this.interp.interpolate(nArray, n29, n30);
                        int n32 = n31 < 0 ? 0 : (n31 > 255 ? 255 : n31);
                        byArray[n21][n15 + nArray2[n21]] = (byte)(n32 & 0xFF);
                        ++n21;
                    }
                } else if (this.setBackground) {
                    n21 = 0;
                    while (n21 < n8) {
                        byArray[n21][n15 + nArray2[n21]] = byArray3[n21];
                        ++n21;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n16 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n16 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n17 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n17 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n18 = (n16 - n) * n6;
                n19 = (n17 - n2) * n7;
                n15 += n4;
                ++n20;
            }
            n3 += n5;
            ++n14;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        int[][] nArray = new int[this.interp_height][this.interp_width];
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int[] nArray5 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int[] nArray6 = new int[n8];
        int n13 = 0;
        while (n13 < n8) {
            nArray6[n13] = (int)this.backgroundValues[n13];
            ++n13;
        }
        int n14 = n10;
        while (n14 < n12) {
            int n15 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n14 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n16 = (int)Math.floor(f5);
            int n17 = (int)Math.floor(f6);
            float f7 = f5 - (float)n16;
            float f8 = f6 - (float)n17;
            int n18 = (n16 - n) * n6;
            int n19 = (n17 - n2) * n7;
            int n20 = n9;
            while (n20 < n11) {
                int n21;
                if ((float)n16 >= f + (float)this.interp_left && (float)n16 < f3 - (float)this.interp_right && (float)n17 >= f2 + (float)this.interp_top && (float)n17 < f4 - (float)this.interp_bottom) {
                    n21 = 0;
                    while (n21 < n8) {
                        int[] nArray7 = nArray4[n21];
                        int n22 = nArray5[n21];
                        int n23 = this.interp_left * n6 + this.interp_top * n7;
                        n23 = n18 + n19 - n23;
                        int n24 = 0;
                        int n25 = 0;
                        int n26 = 0;
                        while (n26 < this.interp_height) {
                            int n27 = n23;
                            int n28 = 0;
                            while (n28 < this.interp_width) {
                                nArray[n25][n24++] = nArray7[n23 + n22];
                                n23 += n6;
                                ++n28;
                            }
                            ++n25;
                            n24 = 0;
                            n23 = n27 + n7;
                            ++n26;
                        }
                        int n29 = (int)(f7 * (float)this.shiftvalue);
                        int n30 = (int)(f8 * (float)this.shiftvalue);
                        int n31 = this.interp.interpolate(nArray, n29, n30);
                        int n32 = n31 < Integer.MIN_VALUE ? Integer.MIN_VALUE : (n31 > Integer.MAX_VALUE ? Integer.MAX_VALUE : n31);
                        nArray2[n21][n15 + nArray3[n21]] = n32;
                        ++n21;
                    }
                } else if (this.setBackground) {
                    n21 = 0;
                    while (n21 < n8) {
                        nArray2[n21][n15 + nArray3[n21]] = nArray6[n21];
                        ++n21;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n16 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n16 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n17 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n17 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n18 = (n16 - n) * n6;
                n19 = (n17 - n2) * n7;
                n15 += n4;
                ++n20;
            }
            n3 += n5;
            ++n14;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int[][] nArray = new int[this.interp_height][this.interp_width];
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n8];
        int n13 = 0;
        while (n13 < n8) {
            sArray3[n13] = (short)this.backgroundValues[n13];
            ++n13;
        }
        int n14 = n10;
        while (n14 < n12) {
            int n15 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n14 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n16 = (int)Math.floor(f5);
            int n17 = (int)Math.floor(f6);
            float f7 = f5 - (float)n16;
            float f8 = f6 - (float)n17;
            int n18 = (n16 - n) * n6;
            int n19 = (n17 - n2) * n7;
            int n20 = n9;
            while (n20 < n11) {
                int n21;
                if ((float)n16 >= f + (float)this.interp_left && (float)n16 < f3 - (float)this.interp_right && (float)n17 >= f2 + (float)this.interp_top && (float)n17 < f4 - (float)this.interp_bottom) {
                    n21 = 0;
                    while (n21 < n8) {
                        short[] sArray4 = sArray2[n21];
                        int n22 = nArray3[n21];
                        int n23 = this.interp_left * n6 + this.interp_top * n7;
                        n23 = n18 + n19 - n23;
                        int n24 = 0;
                        int n25 = 0;
                        int n26 = 0;
                        while (n26 < this.interp_height) {
                            int n27 = n23;
                            int n28 = 0;
                            while (n28 < this.interp_width) {
                                nArray[n25][n24++] = sArray4[n23 + n22];
                                n23 += n6;
                                ++n28;
                            }
                            ++n25;
                            n24 = 0;
                            n23 = n27 + n7;
                            ++n26;
                        }
                        int n29 = (int)(f7 * (float)this.shiftvalue);
                        int n30 = (int)(f8 * (float)this.shiftvalue);
                        int n31 = this.interp.interpolate(nArray, n29, n30);
                        int n32 = n31 < Short.MIN_VALUE ? Short.MIN_VALUE : (n31 > Short.MAX_VALUE ? Short.MAX_VALUE : (int)((short)n31));
                        sArray[n21][n15 + nArray2[n21]] = n32;
                        ++n21;
                    }
                } else if (this.setBackground) {
                    n21 = 0;
                    while (n21 < n8) {
                        sArray[n21][n15 + nArray2[n21]] = sArray3[n21];
                        ++n21;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n16 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n16 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n17 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n17 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n18 = (n16 - n) * n6;
                n19 = (n17 - n2) * n7;
                n15 += n4;
                ++n20;
            }
            n3 += n5;
            ++n14;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int[][] nArray = new int[this.interp_height][this.interp_width];
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n8];
        int n13 = 0;
        while (n13 < n8) {
            sArray3[n13] = (short)this.backgroundValues[n13];
            ++n13;
        }
        int n14 = n10;
        while (n14 < n12) {
            int n15 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n14 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n16 = (int)Math.floor(f5);
            int n17 = (int)Math.floor(f6);
            float f7 = f5 - (float)n16;
            float f8 = f6 - (float)n17;
            int n18 = (n16 - n) * n6;
            int n19 = (n17 - n2) * n7;
            int n20 = n9;
            while (n20 < n11) {
                int n21;
                if ((float)n16 >= f + (float)this.interp_left && (float)n16 < f3 - (float)this.interp_right && (float)n17 >= f2 + (float)this.interp_top && (float)n17 < f4 - (float)this.interp_bottom) {
                    n21 = 0;
                    while (n21 < n8) {
                        short[] sArray4 = sArray2[n21];
                        int n22 = nArray3[n21];
                        int n23 = this.interp_left * n6 + this.interp_top * n7;
                        n23 = n18 + n19 - n23;
                        int n24 = 0;
                        int n25 = 0;
                        int n26 = 0;
                        while (n26 < this.interp_height) {
                            int n27 = n23;
                            int n28 = 0;
                            while (n28 < this.interp_width) {
                                nArray[n25][n24++] = sArray4[n23 + n22] & 0xFFFF;
                                n23 += n6;
                                ++n28;
                            }
                            ++n25;
                            n24 = 0;
                            n23 = n27 + n7;
                            ++n26;
                        }
                        int n29 = (int)(f7 * (float)this.shiftvalue);
                        int n30 = (int)(f8 * (float)this.shiftvalue);
                        int n31 = this.interp.interpolate(nArray, n29, n30);
                        int n32 = n31 < 0 ? 0 : (n31 > 65535 ? 65535 : n31);
                        sArray[n21][n15 + nArray2[n21]] = (short)(n32 & 0xFFFF);
                        ++n21;
                    }
                } else if (this.setBackground) {
                    n21 = 0;
                    while (n21 < n8) {
                        sArray[n21][n15 + nArray2[n21]] = sArray3[n21];
                        ++n21;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n16 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n16 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n17 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n17 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n18 = (n16 - n) * n6;
                n19 = (n17 - n2) * n7;
                n15 += n4;
                ++n20;
            }
            n3 += n5;
            ++n14;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        float[][] fArray = new float[this.interp_height][this.interp_width];
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray3 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        float[] fArray4 = new float[n8];
        int n13 = 0;
        while (n13 < n8) {
            fArray4[n13] = (float)this.backgroundValues[n13];
            ++n13;
        }
        int n14 = n10;
        while (n14 < n12) {
            int n15 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n14 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n16 = (int)Math.floor(f5);
            int n17 = (int)Math.floor(f6);
            float f7 = f5 - (float)n16;
            float f8 = f6 - (float)n17;
            int n18 = (n16 - n) * n6;
            int n19 = (n17 - n2) * n7;
            int n20 = n9;
            while (n20 < n11) {
                int n21;
                if ((float)n16 >= f + (float)this.interp_left && (float)n16 < f3 - (float)this.interp_right && (float)n17 >= f2 + (float)this.interp_top && (float)n17 < f4 - (float)this.interp_bottom) {
                    n21 = 0;
                    while (n21 < n8) {
                        float f9;
                        float[] fArray5 = fArray3[n21];
                        int n22 = nArray2[n21];
                        int n23 = this.interp_left * n6 + this.interp_top * n7;
                        n23 = n18 + n19 - n23;
                        int n24 = 0;
                        int n25 = 0;
                        int n26 = 0;
                        while (n26 < this.interp_height) {
                            int n27 = n23;
                            int n28 = 0;
                            while (n28 < this.interp_width) {
                                fArray[n25][n24++] = fArray5[n23 + n22];
                                n23 += n6;
                                ++n28;
                            }
                            ++n25;
                            n24 = 0;
                            n23 = n27 + n7;
                            ++n26;
                        }
                        fArray2[n21][n15 + nArray[n21]] = f9 = this.interp.interpolate(fArray, f7, f8);
                        ++n21;
                    }
                } else if (this.setBackground) {
                    n21 = 0;
                    while (n21 < n8) {
                        fArray2[n21][n15 + nArray[n21]] = fArray4[n21];
                        ++n21;
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n16 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n16 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n17 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n17 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n18 = (n16 - n) * n6;
                n19 = (n17 - n2) * n7;
                n15 += n4;
                ++n20;
            }
            n3 += n5;
            ++n14;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        double[][] dArray = new double[this.interp_height][this.interp_width];
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray3 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        int n13 = n10;
        while (n13 < n12) {
            int n14 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)n13 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            double d = ((Point2D)float_2).getX();
            double d2 = ((Point2D)float_2).getY();
            int n15 = (int)Math.floor(d -= 0.5);
            int n16 = (int)Math.floor(d2 -= 0.5);
            double d3 = d - (double)n15;
            double d4 = d2 - (double)n16;
            int n17 = (n15 - n) * n6;
            int n18 = (n16 - n2) * n7;
            int n19 = n9;
            while (n19 < n11) {
                int n20;
                if ((float)n15 >= f + (float)this.interp_left && (float)n15 < f3 - (float)this.interp_right && (float)n16 >= f2 + (float)this.interp_top && (float)n16 < f4 - (float)this.interp_bottom) {
                    n20 = 0;
                    while (n20 < n8) {
                        double d5;
                        double[] dArray4 = dArray3[n20];
                        int n21 = nArray2[n20];
                        int n22 = this.interp_left * n6 + this.interp_top * n7;
                        n22 = n17 + n18 - n22;
                        int n23 = 0;
                        int n24 = 0;
                        int n25 = 0;
                        while (n25 < this.interp_height) {
                            int n26 = n22;
                            int n27 = 0;
                            while (n27 < this.interp_width) {
                                dArray[n24][n23++] = dArray4[n22 + n21];
                                n22 += n6;
                                ++n27;
                            }
                            ++n24;
                            n23 = 0;
                            n22 = n26 + n7;
                            ++n25;
                        }
                        dArray2[n20][n14 + nArray[n20]] = d5 = this.interp.interpolate(dArray, (float)d3, (float)d4);
                        ++n20;
                    }
                } else if (this.setBackground) {
                    n20 = 0;
                    while (n20 < n8) {
                        dArray2[n20][n14 + nArray[n20]] = this.backgroundValues[n20];
                        ++n20;
                    }
                }
                if (d3 < this.fracdx1) {
                    n15 += this.incx;
                    d3 += this.fracdx;
                } else {
                    n15 += this.incx1;
                    d3 -= this.fracdx1;
                }
                if (d4 < this.fracdy1) {
                    n16 += this.incy;
                    d4 += this.fracdy;
                } else {
                    n16 += this.incy1;
                    d4 -= this.fracdy1;
                }
                n17 = (n15 - n) * n6;
                n18 = (n16 - n2) * n7;
                n14 += n4;
                ++n19;
            }
            n3 += n5;
            ++n13;
        }
    }
}

