START_HELP(aed767)
"1 aed767",
"?commands set terminal aed767",
"?set terminal aed767",
"?set term aed767",
"?terminal aed767",
"?term aed767",
"?aed767",
"?commands set terminal aed512",
"?set terminal aed512",
"?set term aed512",
"?terminal aed512",
"?term aed512",
"?aed512",
" The `aed512` and `aed767` terminal drivers support AED graphics terminals.",
" The two drivers differ only in their horizontal ranges, which are 512 and",
" 768 pixels, respectively.  Their vertical range is 575 pixels.  There are",
" no options for these drivers."
END_HELP(aed767)
START_HELP(aifm)
"1 aifm",
"?commands set terminal aifm",
"?set terminal aifm",
"?set term aifm",
"?terminal aifm",
"?term aifm",
"?aifm",
" Several options may be set in `aifm`---the Adobe Illustrator 3.0+ driver.",
"",
" Syntax:",
"       set terminal aifm {<color>} {\"<fontname>\"} {<fontsize>}",
"",
" <color> is either `color` or `monochrome`; \"<fontname>\" is the name of a",
" valid PostScript font; <fontsize> is the size of the font in PostScript",
" points, before scaling by the `set size` command.  Selecting `default` sets",
" all options to their default values: `monochrome`, \"Times-Roman\", and 14pt.",
"",
" Since AI does not really support multiple pages, multiple graphs will be",
" drawn directly on top of one another.  However, each graph will be grouped",
" individually, making it easy to separate them inside AI (just pick them up",
" and move them).",
"",
" Examples:",
"       set term aifm",
"       set term aifm 22",
"       set size 0.7,1.4; set term aifm color \"Times-Roman\" 14"
END_HELP(ai)
START_HELP(amiga)
"1 amiga",
"?commands set terminal amiga",
"?set terminal amiga",
"?set term amiga",
"?terminal amiga",
"?term amiga",
"?amiga",
" The `amiga` terminal, for Commodore Amiga computers, allows the user to",
" plot either to a screen (default), or, if Kickstart 3.0 or higher is",
" installed, to a window on the current public screen. The font and its size",
" can also be selected.",
"",
" Syntax:",
"       set terminal amiga {screen | window} {\"<fontname>\"} {<fontsize>}",
"",
" The default font is 8-point \"topaz\".",
"",
" The screen option uses a virtual screen, so it is possible that the graph",
" will be larger than the screen."
END_HELP(amiga)
START_HELP(apollo)
"1 apollo",
"?commands set terminal apollo",
"?set terminal apollo",
"?set term apollo",
"?terminal apollo",
"?term apollo",
"?apollo",
" The `apollo` terminal driver supports the Apollo Graphics Primitive Resource",
" with rescaling after window resizing.  It has no options.",
"",
" If a fixed-size window is desired, the `gpr` terminal may be used instead."
END_HELP(apollo)
START_HELP(aqua)
"1 aqua",
"?commands set terminal aqua",
"?set terminal aqua",
"?set term aqua",
"?terminal aqua",
"?term aqua",
"?aqua",
"?Aqua",
" This terminal relies on AquaTerm.app for display on Mac OS X.",
"",
" Syntax:",
"       set terminal aqua {<n>} {title \"<wintitle>\"} {size <x> <y>}",
"                         {fname \"<fontface>\"} {fsize <fontsize>}",
"",
" where <n> is the number of the window to draw in (default is 0),",
" <wintitle> is the name shown in the title bar (default \"Figure <n>\"),",
" <x> <y> is the size of the plot (default is 846x594 pt = 11.75x8.25 in).",
"",
" Use <fontface> to specify the font to use (default is \"Times-Roman\"),",
" <fontzise> sets the font size (default is 14.0 pt)."
END_HELP(aqua)
START_HELP(atari)
"1 atari ST (via AES)",
"?commands set terminal atari",
"?set terminal atari",
"?set term atari",
"?terminal atari",
"?term atari",
"?atari",
" The `atari` terminal has options to set the character size and the screen",
" colors.",
"",
" Syntax:",
"       set terminal atari {<fontsize>} {<col0> <col1> ... <col15>}",
"",
" The character size must appear if any colors are to be specified.  Each of",
" the (up to 16) colors is given as a three-digit hex number, where the digits",
" represent RED, GREEN and BLUE (in that order).  The range of 0--15 is scaled",
" to whatever color range the screen actually has.  On a normal ST screen, odd",
" and even intensities are the same.",
"",
" Examples:",
"       set terminal atari 4    # use small (6x6) font",
"       set terminal atari 6 0  # set monochrome screen to white on black",
"       set terminal atari 13 0 fff f00 f0 f ff f0f",
"                  # set first seven colors to black, white, red, green,",
"                  # blue, cyan, and purple and use large font (8x16).",
"",
" Additionally, if an environment variable GNUCOLORS exists, its contents are",
" interpreted as an options string, but an explicit terminal option takes",
" precedence."
END_HELP(atari)
START_HELP(vdi)
"1 atari ST (via VDI)",
"?commands set terminal vdi",
"?set terminal vdi",
"?set term vdi",
"?terminal vdi",
"?term vdi",
"?vdi",
" The `vdi` terminal is the same as the `atari` terminal, except that it sends",
" output to the screen via the VDI and not into AES-Windows.",
"",
" The `vdi` terminal has options to set the character size and the screen",
" colors.",
"",
" Syntax:",
"       set terminal vdi {<fontsize>} {<col0> <col1> ... <col15>}",
"",
" The character size must appear if any colors are to be specified.  Each of",
" the (up to 16) colors is given as a three-digit hex number, where the digits",
" represent RED, GREEN and BLUE (in that order).  The range of 0--15 is scaled",
" to whatever color range the screen actually has.  On a normal ST screen, odd",
" and even intensities are the same.",
"",
" Examples:",
"       set terminal vdi 4    # use small (6x6) font",
"       set terminal vdi 6 0  # set monochrome screen to white on black",
"       set terminal vdi 13 0 fff f00 f0 f ff f0f",
"                  # set first seven colors to black, white, red, green,",
"                  # blue, cyan, and purple and use large font (8x16).",
"",
" Additionally, if an environment variable GNUCOLORS exists, its contents are",
" interpreted as an options string, but an explicit terminal option takes",
" precedence."
END_HELP(vdi)
START_HELP(be)
"1 be",
"?commands set terminal be",
"?set terminal be",
"?set term be",
"?terminal be",
"?term be",
"?be",
"?BE",
" `gnuplot` provides the `be` terminal type for use with X servers.  This",
" terminal type is set automatically at startup if the `DISPLAY` environment",
" variable is set, if the `TERM` environment variable is set to `xterm`, or",
" if the `-display` command line option is used.",
"",
" Syntax:",
"           set terminal be {reset} {<n>}",
"",
" Multiple plot windows are supported: `set terminal be <n>` directs the",
" output to plot window number n.  If n>0, the terminal number will be",
" appended to the window title and the icon will be labeled `gplt <n>`.",
" The active window may distinguished by a change in cursor (from default",
" to crosshair.)",
"",
" Plot windows remain open even when the `gnuplot` driver is changed to a",
" different device.  A plot window can be closed by pressing the letter q",
" while that window has input focus, or by choosing `close` from a window",
" manager menu.  All plot windows can be closed by specifying `reset`, which",
" actually terminates the subprocess which maintains the windows (unless",
" `-persist` was specified).",
"",
" Plot windows will automatically be closed at the end of the session",
" unless the `-persist` option was given.",
"",
" The size or aspect ratio of a plot may be changed by resizing the `gnuplot`",
" window.",
"",
" Linewidths and pointsizes may be changed from within `gnuplot` with",
" `set linestyle`.",
"",
" For terminal type `be`, `gnuplot` accepts (when initialized) the standard",
" X Toolkit options and resources such as geometry, font, and name from the",
" command line arguments or a configuration file.  See the X(1) man page",
" (or its equivalent) for a description of such options.",
"",
" A number of other `gnuplot` options are available for the `be` terminal.",
" These may be specified either as command-line options when `gnuplot` is",
" invoked or as resources in the configuration file \".Xdefaults\".  They are",
" set upon initialization and cannot be altered during a `gnuplot` session.",
"2 command-line_options",
"?commands set terminal be command-line-options",
"?set terminal be command-line-options",
"?set term be command-line-options",
"?be command-line-options",
" In addition to the X Toolkit options, the following options may be specified",
" on the command line when starting `gnuplot` or as resources in your",
" \".Xdefaults\" file:",
"@start table - first is interactive cleartext form",
"  `-mono`        forces monochrome rendering on color displays.",
"  `-gray`        requests grayscale rendering on grayscale or color displays.",
"                         (Grayscale displays receive monochrome rendering by default.)",
"  `-clear`   requests that the window be cleared momentarily before a",
"                         new plot is displayed.",
"  `-raise`   raises plot window after each plot",
"  `-noraise` does not raise plot window after each plot",
"  `-persist` plots windows survive after main gnuplot program exits",
"#\\begin{tabular}{|cl|} \\hline",
"#`-mono`  & forces monochrome rendering on color displays.\\\\",
"#`-gray`  & requests grayscale rendering on grayscale or color displays.\\\\",
"#                 & (Grayscale displays receive monochrome rendering by default.) \\\\",
"#`-clear` & requests that the window be cleared momentarily before a\\\\",
"#                 & new plot is displayed. \\\\",
"#`-raise` & raises plot window after each plot. \\\\",
"#`-noraise` & does not raise plot window after each plot. \\\\",
"#`-persist`&plots windows survive after main gnuplot program exits. \\\\",
"%c l .",
"%`-mono`@forces monochrome rendering on color displays.",
"%`-gray`@requests grayscale rendering on grayscale or color displays.",
"%           @(Grayscale displays receive monochrome rendering by default.)",
"%`-clear`@requests that the window be cleared momentarily before a",
"%                @new plot is displayed.",
"%`-raise`@raises plot window after each plot",
"%`-noraise`@does not raise plot window after each plot",
"%`-persist`@plots windows survive after main gnuplot program exits",
"@end table",
" The options are shown above in their command-line syntax.  When entered as",
" resources in \".Xdefaults\", they require a different syntax.",
"",
" Example:",
"           gnuplot*gray: on",
"",
" `gnuplot` also provides a command line option (`-pointsize <v>`) and a",
" resource, `gnuplot*pointsize: <v>`, to control the size of points plotted",
" with the `points` plotting style.  The value `v` is a real number (greater",
" than 0 and less than or equal to ten) used as a scaling factor for point",
" sizes.  For example, `-pointsize 2` uses points twice the default size, and",
" `-pointsize 0.5` uses points half the normal size.",
"2 monochrome_options",
"?commands set terminal be monochrome_options",
"?set terminal be monochrome_options",
"?set term be monochrome_options",
"?be monochrome_options",
" For monochrome displays, `gnuplot` does not honor foreground or background",
" colors.  The default is black-on-white.  `-rv` or `gnuplot*reverseVideo: on`",
" requests white-on-black.",
"",
"2 color_resources",
"?commands set terminal be color_resources",
"?set terminal be color_resources",
"?set term be color_resources",
"?be color_resources",
" For color displays, `gnuplot` honors the following resources (shown here",
" with their default values) or the greyscale resources.  The values may be",
" color names as listed in the BE rgb.txt file on your system, hexadecimal",
" RGB color specifications (see BE documentation), or a color name followed",
" by a comma and an `intensity` value from 0 to 1.  For example, `blue, 0.5`",
" means a half intensity blue.",
"@start table - first is interactive cleartext form",
"  gnuplot*background:  white",
"  gnuplot*textColor:   black",
"  gnuplot*borderColor: black",
"  gnuplot*axisColor:   black",
"  gnuplot*line1Color:  red",
"  gnuplot*line2Color:  green",
"  gnuplot*line3Color:  blue",
"  gnuplot*line4Color:  magenta",
"  gnuplot*line5Color:  cyan",
"  gnuplot*line6Color:  sienna",
"  gnuplot*line7Color:  orange",
"  gnuplot*line8Color:  coral",
"#\\begin{tabular}{|cl|} \\hline",
"#&gnuplot*background: white\\\\",
"#&gnuplot*textColor: black\\\\",
"#&gnuplot*borderColor: black\\\\",
"#&gnuplot*axisColor: black\\\\",
"#&gnuplot*line1Color: red\\\\",
"#&gnuplot*line2Color: green\\\\",
"#&gnuplot*line3Color: blue\\\\",
"#&gnuplot*line4Color: magenta\\\\",
"#&gnuplot*line5Color: cyan\\\\",
"#&gnuplot*line6Color: sienna\\\\",
"#&gnuplot*line7Color: orange\\\\",
"#&gnuplot*line8Color: coral\\\\",
"%c l .",
"%@gnuplot*background: white",
"%@gnuplot*textColor: black",
"%@gnuplot*borderColor: black",
"%@gnuplot*axisColor: black",
"%@gnuplot*line1Color: red",
"%@gnuplot*line2Color: green",
"%@gnuplot*line3Color: blue",
"%@gnuplot*line4Color: magenta",
"%@gnuplot*line5Color: cyan",
"%@gnuplot*line6Color: sienna",
"%@gnuplot*line7Color: orange",
"%@gnuplot*line8Color: coral",
"@end table",
"",
" The command-line syntax for these is, for example,",
"",
" Example:",
"           gnuplot -background coral",
"",
"2 grayscale_resources",
"?commands set terminal be grayscale_resources",
"?set terminal be grayscale_resources",
"?set term be grayscale_resources",
"?be grayscale_resources",
" When `-gray` is selected, `gnuplot` honors the following resources for",
" grayscale or color displays (shown here with their default values).  Note",
" that the default background is black.",
"@start table - first is interactive cleartext form",
"  gnuplot*background: black",
"  gnuplot*textGray:   white",
"  gnuplot*borderGray: gray50",
"  gnuplot*axisGray:   gray50",
"  gnuplot*line1Gray:  gray100",
"  gnuplot*line2Gray:  gray60",
"  gnuplot*line3Gray:  gray80",
"  gnuplot*line4Gray:  gray40",
"  gnuplot*line5Gray:  gray90",
"  gnuplot*line6Gray:  gray50",
"  gnuplot*line7Gray:  gray70",
"  gnuplot*line8Gray:  gray30",
"#\\begin{tabular}{|cl|} \\hline",
"#&gnuplot*background: black\\\\",
"#&gnuplot*textGray: white\\\\",
"#&gnuplot*borderGray: gray50\\\\",
"#&gnuplot*axisGray: gray50\\\\",
"#&gnuplot*line1Gray: gray100\\\\",
"#&gnuplot*line2Gray: gray60\\\\",
"#&gnuplot*line3Gray: gray80\\\\",
"#&gnuplot*line4Gray: gray40\\\\",
"#&gnuplot*line5Gray: gray90\\\\",
"#&gnuplot*line6Gray: gray50\\\\",
"#&gnuplot*line7Gray: gray70\\\\",
"#&gnuplot*line8Gray: gray30\\\\",
"%c l .",
"%@gnuplot*background: black",
"%@gnuplot*textGray: white",
"%@gnuplot*borderGray: gray50",
"%@gnuplot*axisGray: gray50",
"%@gnuplot*line1Gray: gray100",
"%@gnuplot*line2Gray: gray60",
"%@gnuplot*line3Gray: gray80",
"%@gnuplot*line4Gray: gray40",
"%@gnuplot*line5Gray: gray90",
"%@gnuplot*line6Gray: gray50",
"%@gnuplot*line7Gray: gray70",
"%@gnuplot*line8Gray: gray30",
"@end table",
"",
"2 line_resources",
"?commands set terminal be line_resources",
"?set terminal be line_resources",
"?set term be line_resources",
"?be line_resources",
" `gnuplot` honors the following resources for setting the width (in pixels) of",
" plot lines (shown here with their default values.)  0 or 1 means a minimal",
" width line of 1 pixel width.  A value of 2 or 3 may improve the appearance of",
" some plots.",
"@start table - first is interactive cleartext form",
"  gnuplot*borderWidth: 2",
"  gnuplot*axisWidth:   0",
"  gnuplot*line1Width:  0",
"  gnuplot*line2Width:  0",
"  gnuplot*line3Width:  0",
"  gnuplot*line4Width:  0",
"  gnuplot*line5Width:  0",
"  gnuplot*line6Width:  0",
"  gnuplot*line7Width:  0",
"  gnuplot*line8Width:  0",
"#\\begin{tabular}{|cl|} \\hline",
"#&gnuplot*borderWidth: 2\\\\",
"#&gnuplot*axisWidth: 0\\\\",
"#&gnuplot*line1Width: 0\\\\",
"#&gnuplot*line2Width: 0\\\\",
"#&gnuplot*line3Width: 0\\\\",
"#&gnuplot*line4Width: 0\\\\",
"#&gnuplot*line5Width: 0\\\\",
"#&gnuplot*line6Width: 0\\\\",
"#&gnuplot*line7Width: 0\\\\",
"#&gnuplot*line8Width: 0\\\\",
"%c l .",
"%@gnuplot*borderWidth: 2",
"%@gnuplot*axisWidth: 0",
"%@gnuplot*line1Width: 0",
"%@gnuplot*line2Width: 0",
"%@gnuplot*line3Width: 0",
"%@gnuplot*line4Width: 0",
"%@gnuplot*line5Width: 0",
"%@gnuplot*line6Width: 0",
"%@gnuplot*line7Width: 0",
"%@gnuplot*line8Width: 0",
"@end table",
"",
" `gnuplot` honors the following resources for setting the dash style used for",
" plotting lines.  0 means a solid line.  A two-digit number `jk` (`j` and `k`",
" are >= 1  and <= 9) means a dashed line with a repeated pattern of `j` pixels",
" on followed by `k` pixels off.  For example, '16' is a \"dotted\" line with one",
" pixel on followed by six pixels off.  More elaborate on/off patterns can be",
" specified with a four-digit value.  For example, '4441' is four on, four off,",
" four on, one off.  The default values shown below are for monochrome displays",
" or monochrome rendering on color or grayscale displays.  For color displays,",
" the default for each is 0 (solid line) except for `axisDashes` which defaults",
" to a '16' dotted line.",
"@start table - first is interactive cleartext form",
"  gnuplot*borderDashes:   0",
"  gnuplot*axisDashes:        16",
"  gnuplot*line1Dashes:        0",
"  gnuplot*line2Dashes:   42",
"  gnuplot*line3Dashes:   13",
"  gnuplot*line4Dashes:   44",
"  gnuplot*line5Dashes:   15",
"  gnuplot*line6Dashes: 4441",
"  gnuplot*line7Dashes:   42",
"  gnuplot*line8Dashes:   13",
"#\\begin{tabular}{|cl|} \\hline",
"#&gnuplot*borderDashes: 0\\\\",
"#&gnuplot*axisDashes: 16\\\\",
"#&gnuplot*line1Dashes: 0\\\\",
"#&gnuplot*line2Dashes: 42\\\\",
"#&gnuplot*line3Dashes: 13\\\\",
"#&gnuplot*line4Dashes: 44\\\\",
"#&gnuplot*line5Dashes: 15\\\\",
"#&gnuplot*line6Dashes: 4441\\\\",
"#&gnuplot*line7Dashes: 42\\\\",
"#&gnuplot*line8Dashes: 13\\\\",
"%c l .",
"%@gnuplot*borderDashes: 0",
"%@gnuplot*axisDashes: 16",
"%@gnuplot*line1Dashes: 0",
"%@gnuplot*line2Dashes: 42",
"%@gnuplot*line3Dashes: 13",
"%@gnuplot*line4Dashes: 44",
"%@gnuplot*line5Dashes: 15",
"%@gnuplot*line6Dashes: 4441",
"%@gnuplot*line7Dashes: 42",
"%@gnuplot*line8Dashes: 13",
"@end table"
END_HELP(be)
START_HELP(cgi)
"1 cgi",
"?commands set terminal cgi",
"?set terminal cgi",
"?set term cgi",
"?terminal cgi",
"?term cgi",
"?cgi",
"?commands set terminal hcgi",
"?set terminal hcgi",
"?set term hcgi",
"?terminal hcgi",
"?term hcgi",
"?hcgi",
" The `cgi` and `hcgi` terminal drivers support SCO CGI drivers.  `hcgi` is for",
" printers; the environment variable CGIPRNT must be set.  `cgi` may be used",
" for either a display or hardcopy; if the environment variable CGIDISP is set,",
" then that display is used.  Otherwise CGIPRNT is used.",
"",
" These terminals have no options."
END_HELP(cgi)
START_HELP(cgm)
"1 cgm",
"?commands set terminal cgm",
"?set terminal cgm",
"?set term cgm",
"?terminal cgm",
"?term cgm",
"?cgm",
" The `cgm` terminal generates a Computer Graphics Metafile, Version 1. ",
" This file format is a subset of the ANSI X3.122-1986 standard entitled",
" \"Computer Graphics - Metafile for the Storage and Transfer of Picture",
" Description Information\".",
" Several options may be set in `cgm`.",
"",
" Syntax:",
"       set terminal cgm {<mode>} {<color>} {<rotation>} {solid | dashed}",
"                        {width <plot_width>} {linewidth <line_width>}",
"                        {\"<font>\"} {<fontsize>}",
"                        {<color0> <color1> <color2> ...}",
"",
" where <mode> is `landscape`, `portrait`, or `default`;",
" <color> is either `color` or `monochrome`; ",
" <rotation> is either `rotate` or `norotate`;",
" `solid` draws all curves with solid lines, overriding any dashed patterns;",
" <plot_width> is the assumed width of the plot in points; ",
" <line_width> is the line width in points (default 1); ",
" <font> is the name of a font; and ",
" <fontsize> is the size of the font in points (default 12).",
"",
" By default, `cgm` uses rotated text for the Y axis label.",
"",
" The first six options can be in any order.  Selecting `default` sets all",
" options to their default values.",
"",
" Each color must be of the form 'xrrggbb', where x is the literal",
" character 'x' and 'rrggbb' are the red, green and blue components in",
" hex.  For example, 'x00ff00' is green.  The background color is set",
" first, then the plotting colors."
"",
" Examples:",
"       set terminal cgm landscape color rotate dashed width 432 \\",
"                      linewidth 1  'Helvetica Bold' 12       # defaults",
"       set terminal cgm linewidth 2  14  # wider lines & larger font",
"       set terminal cgm portrait \"Times Italic\" 12",
"       set terminal cgm color solid      # no pesky dashes!",
"2 font",
"?commands set terminal cgm font",
"?set terminal cgm font",
"?set term cgm font",
"?cgm font",
" The first part of a Computer Graphics Metafile, the metafile description,",
" includes a font table.  In the picture body, a font is designated by an",
" index into this table.  By default, this terminal generates a table with",
" the following 35 fonts, plus six more with `italic` replaced by",
" `oblique`, or vice-versa (since at least the Microsoft Office and Corel",
" Draw CGM import filters treat `italic` and `oblique` as equivalent):",
"@start table - first is interactive cleartext form",
"       Helvetica",
"       Helvetica Bold",
"       Helvetica Oblique",
"       Helvetica Bold Oblique",
"       Times Roman",
"       Times Bold",
"       Times Italic",
"       Times Bold Italic",
"       Courier",
"       Courier Bold",
"       Courier Oblique",
"       Courier Bold Oblique",
"       Symbol",
"       Hershey/Cartographic_Roman",
"       Hershey/Cartographic_Greek",
"       Hershey/Simplex_Roman",
"       Hershey/Simplex_Greek",
"       Hershey/Simplex_Script",
"       Hershey/Complex_Roman",
"       Hershey/Complex_Greek",
"       Hershey/Complex_Script",
"       Hershey/Complex_Italic",
"       Hershey/Complex_Cyrillic",
"       Hershey/Duplex_Roman",
"       Hershey/Triplex_Roman",
"       Hershey/Triplex_Italic",
"       Hershey/Gothic_German",
"       Hershey/Gothic_English",
"       Hershey/Gothic_Italian",
"       Hershey/Symbol_Set_1",
"       Hershey/Symbol_Set_2",
"       Hershey/Symbol_Math",
"       ZapfDingbats",
"       Script",
"       15",
"#\\begin{tabular}{|ccl|} \\hline",
"#\\multicolumn{3}{|c|}{CGM fonts}\\\\",
"#&Helvetica&\\\\",
"#&Helvetica Bold&\\\\",
"#&Helvetica Oblique&\\\\",
"#&Helvetica Bold Oblique&\\\\",
"#&Times Roman&\\\\",
"#&Times Bold&\\\\",
"#&Times Italic&\\\\",
"#&Times Bold Italic&\\\\",
"#&Courier&\\\\",
"#&Courier Bold&\\\\",
"#&Courier Oblique&\\\\",
"#&Courier Bold Oblique&\\\\",
"#&Symbol&\\\\",
"#&Hershey/Cartographic\\_Roman&\\\\",
"#&Hershey/Cartographic\\_Greek&\\\\",
"#&Hershey/Simplex\\_Roman&\\\\",
"#&Hershey/Simplex\\_Greek&\\\\",
"#&Hershey/Simplex\\_Script&\\\\",
"#&Hershey/Complex\\_Roman&\\\\",
"#&Hershey/Complex\\_Greek&\\\\",
"#&Hershey/Complex\\_Script&\\\\",
"#&Hershey/Complex\\_Italic&\\\\",
"#&Hershey/Complex\\_Cyrillic&\\\\",
"#&Hershey/Duplex\\_Roman&\\\\",
"#&Hershey/Triplex\\_Roman&\\\\",
"#&Hershey/Triplex\\_Italic&\\\\",
"#&Hershey/Gothic\\_German&\\\\",
"#&Hershey/Gothic\\_English&\\\\",
"#&Hershey/Gothic\\_Italian&\\\\",
"#&Hershey/Symbol\\_Set\\_1&\\\\",
"#&Hershey/Symbol\\_Set\\_2&\\\\",
"#&Hershey/Symbol\\_Math&\\\\",
"#&ZapfDingbats&\\\\",
"#&Script&\\\\",
"#&15&\\\\",
"%c c l .",
"%@@CGM fonts",
"%_",
"%@@Helvetica",
"%@@Helvetica Bold",
"%@@Helvetica Oblique",
"%@@Helvetica Bold Oblique",
"%@@Times Roman",
"%@@Times Bold",
"%@@Times Italic",
"%@@Times Bold Italic",
"%@@Courier",
"%@@Courier Bold",
"%@@Courier Oblique",
"%@@Courier Bold Oblique",
"%@@Symbol",
"%@@Hershey/Cartographic_Roman",
"%@@Hershey/Cartographic_Greek",
"%@@Hershey/Simplex_Roman",
"%@@Hershey/Simplex_Greek",
"%@@Hershey/Simplex_Script",
"%@@Hershey/Complex_Roman",
"%@@Hershey/Complex_Greek",
"%@@Hershey/Complex_Script",
"%@@Hershey/Complex_Italic",
"%@@Hershey/Complex_Cyrillic",
"%@@Hershey/Duplex_Roman",
"%@@Hershey/Triplex_Roman",
"%@@Hershey/Triplex_Italic",
"%@@Hershey/Gothic_German",
"%@@Hershey/Gothic_English",
"%@@Hershey/Gothic_Italian",
"%@@Hershey/Symbol_Set_1",
"%@@Hershey/Symbol_Set_2",
"%@@Hershey/Symbol_Math",
"%@@ZapfDingbats",
"%@@Script",
"%@@15",
"@end table",
" The first thirteen of these fonts are required for WebCGM.  The",
" Microsoft Office CGM import filter implements the 13 standard fonts",
" listed above, and also 'ZapfDingbats' and 'Script'.  However, the",
" script font may only be accessed under the name '15'.  For more on",
" Microsoft import filter font substitutions, check its help file which",
" you may find here:",
"   C:\\Program Files\\Microsoft Office\\Office\\Cgmimp32.hlp",
" and/or its configuration file, which you may find here:",
"   C:\\Program Files\\Common Files\\Microsoft Shared\\Grphflt\\Cgmimp32.cfg",
"",
" In the `set term` command, you may specify a font name which does not",
" appear in the default font table.  In that case, a new font table is",
" constructed with the specified font as its first entry. You must ensure",
" that the spelling, capitalization, and spacing of the name are",
" appropriate for the application that will read the CGM file.  (Gnuplot",
" and any MIL-D-28003A compliant application ignore case in font names.)",
" If you need to add several new fonts, use several `set term` commands.",
"",
" Example:",
"       set terminal cgm 'Old English'",
"       set terminal cgm 'Tengwar'",
"       set terminal cgm 'Arabic'",
"       set output 'myfile.cgm'",
"       plot ...",
"       set output",
"",
" You cannot introduce a new font in a `set label` command."
"2 fontsize",
"?commands set terminal cgm fontsize",
"?set terminal cgm fontsize",
"?set term cgm fontsize",
"?cgm fontsize",
" Fonts are scaled assuming the page is 6 inches wide.  If the `size`",
" command is used to change the aspect ratio of the page or the CGM file",
" is converted to a different width, the resulting font sizes will be",
" scaled up or down accordingly.  To change the assumed width, use the",
" `width` option.",
"2 linewidth",
"?commands set terminal cgm linewidth",
"?set terminal cgm linewidth",
"?set term cgm linewidth",
"?cgm linewidth",
" The `linewidth` option sets the width of lines in pt.  The default width",
" is 1 pt.  Scaling is affected by the actual width of the page, as",
" discussed under the `fontsize` and `width` options.",
"2 rotate",
"?commands set terminal cgm rotate",
"?set terminal cgm rotate",
"?set term cgm rotate",
"?cgm rotate",
" The `norotate` option may be used to disable text rotation.  For",
" example, the CGM input filter for Word for Windows 6.0c can accept",
" rotated text, but the DRAW editor within Word cannot.  If you edit a",
" graph (for example, to label a curve), all rotated text is restored to",
" horizontal.  The Y axis label will then extend beyond the clip boundary.",
" With `norotate`, the Y axis label starts in a less attractive location,",
" but the page can be edited without damage.  The `rotate` option confirms",
" the default behavior.",
"2 solid",
"?set terminal cgm solid",
"?set term cgm solid",
"?cgm solid",
" The `solid` option may be used to disable dashed line styles in the",
" plots.  This is useful when color is enabled and the dashing of the",
" lines detracts from the appearance of the plot. The `dashed` option",
" confirms the default behavior, which gives a different dash pattern to",
" each curve.",
"2 size",
"?commands set terminal cgm size",
"?set terminal cgm size",
"?set term cgm size",
"?cgm size",
" Default size of a CGM plot is 32599 units wide and 23457 units high for",
" landscape, or 23457 units wide by 32599 units high for portrait.",
"2 width",
"?commands set terminal cgm width",
"?set terminal cgm width",
"?set term cgm width",
"?cgm width",
" All distances in the CGM file are in abstract units.  The application",
" that reads the file determines the size of the final plot.  By default,",
" the width of the final plot is assumed to be 6 inches (15.24 cm).  This",
" distance is used to calculate the correct font size, and may be changed",
" with the `width` option.  The keyword should be followed by the width in",
" points.  (Here, a point is 1/72 inch, as in PostScript.  This unit is",
" known as a \"big point\" in TeX.)  Gnuplot `expressions` can be used to",
" convert from other units.",
"",
" Example:",
"       set terminal cgm width 432            # default",
"       set terminal cgm width 6*72           # same as above",
"       set terminal cgm width 10/2.54*72     # 10 cm wide",
"2 nofontlist",
"?commands set terminal cgm nofontlist",
"?set terminal cgm nofontlist",
"?set term cgm nofontlist",
"?cgm nofontlist",
"?commands set terminal cgm winword6",
"?set terminal cgm winword6",
"?set term cgm winword6",
"?cgm winword6",
" The default font table includes the fonts recommended for WebCGM, which",
" are compatible with the Computer Graphics Metafile input filter for",
" Microsoft Office and Corel Draw.  Another application might use",
" different fonts and/or different font names, which may not be",
" documented.  As a workaround, the `nofontlist` option deletes the font",
" table from the CGM file.  In this case, the reading application should",
" use a default table.  Gnuplot will still use its own default font table",
" to select font indices.  Thus, 'Helvetica' will give you an index of 1,",
" which should get you the first entry in your application's default font",
" table. 'Helvetica Bold' will give you its second entry, etc.",
"",
" The former `winword6` option is now a deprecated synonym for",
" `nofontlist`.  The problems involving the color and font tables that",
" the `winword6` option was intended to work around turned out to be",
" gnuplot bugs which have now been fixed."
END_HELP(cgm)
START_HELP(corel)
"1 corel",
"?commands set terminal corel",
"?set terminal corel",
"?set term corel",
"?terminal corel",
"?term corel",
"?corel",
" The `corel` terminal driver supports CorelDraw.",
"",
" Syntax:",
"       set terminal corel {  default",
"                           | {monochrome | color",
"                                {\"<font>\" {<fontsize> ",
"                                   {<xsize> <ysize> {<linewidth> }}}}}",
"",
" where the fontsize and linewidth are specified in points and the sizes in",
" inches.  The defaults are monochrome, \"SwitzerlandLight\", 22, 8.2, 10 and 1.2."
END_HELP(corel)
START_HELP(debug)
"1 debug",
"?commands set terminal debug",
"?set terminal debug",
"?set term debug",
"?terminal debug",
"?term debug",
"?debug",
" This terminal is provided to allow for the debugging of `gnuplot`.  It is",
" likely to be of use only for users who are modifying the source code."
END_HELP(debug)
START_HELP(svga)
"1 svga",
"?commands set terminal svga",
"?set terminal svga",
"?set term svga",
"?terminal svga",
"?term svga",
"?svga",
" The `svga` terminal driver supports PCs with SVGA graphics.  It can only be",
" used if it is compiled with DJGPP.  Its only option is the font.",
"",
" Syntax:",
"       set terminal svga {\"<fontname>\"}"
END_HELP(svga)
START_HELP(dumb)
"1 dumb",
"?commands set terminal dumb",
"?set terminal dumb",
"?set term dumb",
"?terminal dumb",
"?term dumb",
"?dumb",
" The `dumb` terminal driver has an optional size specification and trailing",
" linefeed control.",
"",
" Syntax:",
"       set terminal dumb {[no]feed} {<xsize> <ysize>}",
"                         {[no]enhanced}",
"",
" where <xsize> and <ysize> set the size of the dumb terminals. Default is",
" 79 by 24. The last newline is printed only if `feed` is enabled.",
"",
" Examples:",
"       set term dumb nofeed",
"       set term dumb 79 49 # VGA screen---why would anyone do that?"
END_HELP(dumb)
START_HELP(dxf)
"1 dxf",
"?commands set terminal dxf",
"?set terminal dxf",
"?set term dxf",
"?terminal dxf",
"?term dxf",
"?dxf",
" The `dxf` terminal driver creates pictures that can be imported into AutoCad",
" (Release 10.x).  It has no options of its own, but some features of its plots",
" may be modified by other means.  The default size is 120x80 AutoCad units,",
" which can be changed by `set size`.  `dxf` uses seven colors (white, red,",
" yellow, green, cyan, blue and magenta), which can be changed only by",
" modifying the source file.  If a black-and-white plotting device is used, the",
" colors are mapped to differing line thicknesses.  See the description of the",
" AutoCad print/plot command."
END_HELP(dxf)
START_HELP(dxy800a)
"1 dxy800a",
"?commands set terminal dxy800a",
"?set terminal dxy800a",
"?set term dxy800a",
"?terminal dxy800a",
"?term dxy800a",
"?dxy800a",
" This terminal driver supports the Roland DXY800A plotter.  It has no options."
END_HELP(dxy800a)
START_HELP(eepic)
"1 eepic",
"?commands set terminal eepic",
"?set terminal eepic",
"?set term eepic",
"?terminal eepic",
"?term eepic",
"?eepic",
" The `eepic` terminal driver supports the extended LaTeX picture environment.",
" It is an alternative to the `latex` driver.",
"",
" The output of this terminal is intended for use with the \"eepic.sty\" macro",
" package for LaTeX.  To use it, you need \"eepic.sty\", \"epic.sty\" and a",
" printer driver that supports the \"tpic\" \\specials.  If your printer driver",
" doesn't support those \\specials, \"eepicemu.sty\" will enable you to use some",
" of them.",
" dvips and dvipdfm do support the \"tpic\" \\specials.",
"",
" Syntax:",
"    set terminal eepic {color, dashed, rotate, small, tiny, default, <fontsize>}",
"",
" Options:",
" You can give options in any order you wish.",
" 'color' causes gnuplot to produce \\color{...} commands so that the graphs are",
" colored. Using this option, you must include \\usepackage{color} in the preambel",
" of your latex document.",
" 'dashed' will allow dashed line types; without this option, only solid lines",
" with varying thickness will be used.",
" 'dashed' and 'color' are mutually exclusive; if 'color' is specified, then 'dashed'",
" will be ignored.",
" 'rotate' will enable true rotated text (by 90 degrees). Otherwise, rotated text",
" will be typeset with letters stacked above each other. If you use this option",
" you must include \\usepackage{graphicx} in the preamble.",
" 'small' will use \\scriptsize symbols as point markers (Probably does not work",
" with TeX, only LaTeX2e). Default is to use the default math size.",
" 'tiny' uses \\scriptscriptstyle symbols.",
" 'default' resets all options to their defaults = no color, no dashed lines,",
" pseudo-rotated (stacked) text, large point symbols.",
" <fontsize> is a number which specifies the font size inside the picture",
" environment; the unit is pt (points), i.e., 10 pt equals approx. 3.5 mm.",
" If fontsize is not specified, then all text inside the picture will be set",
" in \\footnotesize.",
"",
" Notes:",
" Remember to escape the # character (or other chars meaningful to (La-)TeX)",
" by \\\\ (2 backslashes).",
" It seems that dashed lines become solid lines when the vertices of a plot",
" are too close. (I do not know if that is a general problem with the tpic specials,",
" or if it is caused by a bug in eepic.sty or dvips/dvipdfm.)",
" The default size of an eepic plot is 5x3 inches, which can be scaled ",
" by 'set size a,b'.",
" Points, among other things, are drawn using the LaTeX commands \"\\Diamond\",",
" \"\\Box\", etc.  These commands no longer belong to the LaTeX2e core; they are",
" included in the latexsym package, which is part of the base distribution and",
" thus part of any LaTeX implementation. Please do not forget to use this package.",
" Instead of latexsym, you can also include the amssymb package."
" All drivers for LaTeX offer a special way of controlling text positioning:",
" If any text string begins with '{', you also need to include a '}' at the",
" end of the text, and the whole text will be centered both horizontally and",
" vertically.  If the text string begins with '[', you need to follow this with",
" a position specification (up to two out of t,b,l,r), ']{', the text itself,",
" and finally '}'.  The text itself may be anything LaTeX can typeset as an",
" LR-box.  '\\rule{}{}'s may help for best positioning.",
"",
" Examples:",
" set term eepic",
"   output graphs as eepic macros inside a picture environment;",
"   \\input the resulting file in your LaTeX document.",
" set term eepic color tiny rotate 8",
"   eepic macros with \\color macros, \\scripscriptsize point markers,",
"   true rotated text, and all text set with 8pt.",
"",
" About label positioning:",
" Use gnuplot defaults (mostly sensible, but sometimes not really best):",
"        set title '\\LaTeX\\ -- $ \\gamma $'",
" Force centering both horizontally and vertically:",
"        set label '{\\LaTeX\\ -- $ \\gamma $}' at 0,0",
" Specify own positioning (top here):",
"        set xlabel '[t]{\\LaTeX\\ -- $ \\gamma $}'",
" The other label -- account for long ticlabels:",
"        set ylabel '[r]{\\LaTeX\\ -- $ \\gamma $\\rule{7mm}{0pt}}'"
END_HELP(eepic)
START_HELP(emf)
"1 emf",
"?commands set terminal emf",
"?set terminal emf",
"?set term emf",
"?terminal emf",
"?term emf",
"?emf",
" The `emf` terminal generates an Enhanced Metafile Format file.  This file",
" format is the metafile standard on MS Win32 Systems"
"",
" Syntax:",
"       set terminal emf {<color>} {solid | dashed}",
"                        {\"<font>\"} {<fontsize>}",
"",
" <color> is either `color` or `monochrome`; ",
" `solid` draws all curves with solid lines, overriding any dashed patterns;",
" <font> is the name of a font; and ",
" `<fontsize>` is the size of the font in points.",
"",
" The first two options can be in any order.  Selecting `default` sets all",
" options to their default values.",
"",
" Examples:",
"       set terminal emf 'Times Roman Italic' 12",
"       set terminal emf color solid    # no pesky dashes!"
END_HELP(emf)
START_HELP(emxvga)
"1 emxvga",
"?commands set terminal emxvga",
"?set terminal emxvga",
"?set term emxvga",
"?terminal emxvga",
"?term emxvga",
"?emxvga",
"?commands set terminal emxvesa",
"?set terminal emxvesa",
"?set term emxvesa",
"?terminal emxvesa",
"?term emxvesa",
"?emxvesa",
"?commands set terminal vgal",
"?set terminal vgal",
"?set term vgal",
"?terminal vgal",
"?term vgal",
"?vgal",
" The `emxvga`, `emxvesa` and `vgal` terminal drivers support PCs with SVGA,",
" vesa SVGA and VGA graphics boards, respectively.  They are intended to be",
" compiled with \"emx-gcc\" under either DOS or OS/2.  They also need VESA and",
" SVGAKIT maintained by Johannes Martin (JMARTIN@GOOFY.ZDV.UNI-MAINZ.DE) with",
" additions by David J. Liu (liu@phri.nyu.edu).",
"",
" Syntax:",
"       set terminal emxvga",
"       set terminal emxvesa {vesa-mode}",
"       set terminal vgal",
"",
" The only option is the vesa mode for `emxvesa`, which defaults to G640x480x256."
END_HELP(emxvga)
START_HELP(epslatex)
"1 epslatex",
"?commands set terminal epslatex",
"?set terminal epslatex",
"?set term epslatex",
"?terminal epslatex",
"?term epslatex",
"?epslatex",
" The `epslatex` driver generates output for further processing by LaTeX."
"",
" Syntax:",
"       set terminal epslatex {default}",
"                               {color | monochrome} {solid | dashed}",
"                               {\"<fontname>\"} {<fontsize>}",
"",
" `default` mode sets all options to their defaults: `monochrome`, `dashed`,",
" \"default\" and 11pt.",
" Default size of a plot is 5 inches wide and 3 inches high.",
"",
" `solid` draws all plots with solid lines, overriding any dashed patterns;",
" `\"<fontname>\"` is the name of font; and `<fontsize>` is",
" the size of the font in PostScript points. Font selection isn't supported yet.",
" Font size selection is supported only for the calculation of proper spacing.",
" The actual LaTeX font at the point of inclusion is taken, so use LaTeX commands",
" for changing fonts. If you use e.g. 12pt as font size for your LaTeX documents, ",
" use '\"default\" 12' as options.",
"",
" All drivers for LaTeX offer a special way of controlling text positioning: ",
" (a) If any text string begins with '{', you also need to include a '}' at the",
" end of the text, and the whole text will be centered both horizontally",
" and vertically by LaTeX.  (b) If the text string begins with '[', you need",
" to continue it with: a position specification (up to two out of t,b,l,r),",
" ']{', the text itself, and finally, '}'. The text itself may be anything",
" LaTeX can typeset as an LR-box. \\rule{}{}'s may help for best positioning.",
" See also the documentation for the `pslatex` terminal driver.",
" To create multiline labels, use \\shortstack, for example",
"    set ylabel '[r]{\\shortstack{first line \\\\ second line}}' ",
"",
" The driver produces two different files, one for the eps part of the figure",
" and one for the LaTeX part. The name of the eps file is taken from the",
" `set output` command. The name of the LaTeX file is derived by replacing",
" the file extension (normally `.eps`) with `.tex` instead.",
" There is no LaTeX output if no output file is given!",
" Remember to close the `output file` before leaving `gnuplot`.",
"",
" In your LaTeX documents use '\\input{filename}' to include the figure.",
" The `.eps` file is included by the command \\includegraphics{...}, so you",
" must also include \\usepackage{graphicx} in the LaTeX preamble.",
"",
" Pdf files can be made from the eps file using 'epstopdf'. If the graphics",
" package is properly configured, the LaTeX files can also be processed by",
" pdflatex without changes, using the pdf files instead of the eps files."
END_HELP(epslatex)
START_HELP(epson_180dpi)
"1 epson-180dpi",
"?commands set terminal epson-180dpi",
"?set terminal epson-180dpi",
"?set term epson-180dpi",
"?terminal epson-180dpi",
"?term epson-180dpi",
"?epson-180dpi",
"?commands set terminal epson-60dpi",
"?set terminal epson-60dpi",
"?set term epson-60dpi",
"?terminal epson-60dpi",
"?term epson-60dpi",
"?epson-60dpi",
"?commands set terminal epson-lx800",
"?set terminal epson-lx800",
"?set term epson-lx800",
"?terminal epson-lx800",
"?term epson-lx800",
"?epson-lx800",
"?commands set terminal nec-cp6",
"?set terminal nec-cp6",
"?set term nec-cp6",
"?terminal nec-cp6",
"?term nec-cp6",
"?nec-cp6",
"?commands set terminal okidata",
"?set terminal okidata",
"?set term okidata",
"?terminal okidata",
"?term okidata",
"?okidata",
"?commands set terminal starc",
"?set terminal starc",
"?set term starc",
"?terminal starc",
"?term starc",
"?starc",
"?commands set terminal tandy-60dpi",
"?set terminal tandy-60dpi",
"?set term tandy-60dpi",
"?terminal tandy-60dpi",
"?term tandy-60dpi",
"?tandy-60dpi",
" This driver supports a family of Epson printers and derivatives.",
"",
" `epson-180dpi` and `epson-60dpi` are drivers for Epson LQ-style 24-pin",
" printers with resolutions of 180 and 60 dots per inch, respectively.",
"",
" `epson-lx800` is a generic 9-pin driver appropriate for printers like the",
" Epson LX-800, the Star NL-10 and NX-1000, the PROPRINTER, and so forth.",
"",
" `nec-cp6` is generic 24-pin driver that can be used for printers like the",
" NEC CP6 and the Epson LQ-800.",
"",
" The `okidata` driver supports the 9-pin OKIDATA 320/321 Standard printers.",
"",
" The `starc` driver is for the Star Color Printer.",
"",
" The `tandy-60dpi` driver is for the Tandy DMP-130 series of 9-pin, 60-dpi",
" printers.",
"",
" Only `nec-cp6` has any options.",
"",
" Syntax:",
"       set terminal nec-cp6 {monochrome | colour | draft}",
"",
" which defaults to monochrome.",
"",
" With each of these drivers, a binary copy is required on a PC to print.  Do",
" not use `print`---use instead `copy file /b lpt1:`."
END_HELP(epson_180dpi)
START_HELP(excl)
"1 excl",
"?commands set terminal excl",
"?set terminal excl",
"?set term excl",
"?terminal excl",
"?term excl",
"?excl",
" The `excl` terminal driver supports Talaris printers such as the EXCL Laser",
" printer and the 1590.  It has no options."
END_HELP(excl)
START_HELP(hercules)
"1 hercules",
"?commands set terminal hercules",
"?set terminal hercules",
"?set term hercules",
"?terminal hercules",
"?term hercules",
"?hercules",
"?commands set terminal egalib",
"?set terminal egalib",
"?set term egalib",
"?terminal egalib",
"?term egalib",
"?egalib",
"?commands set terminal egamono",
"?set terminal egamono",
"?set term egamono",
"?terminal egamono",
"?term egamono",
"?egamono",
"?commands set terminal vgalib",
"?set terminal vgalib",
"?set term vgalib",
"?terminal vgalib",
"?term vgalib",
"?vgalib",
"?commands set terminal vgamono",
"?set terminal vgamono",
"?set term vgamono",
"?terminal vgamono",
"?term vgamono",
"?vgamono",
"?commands set terminal svgalib",
"?set terminal svgalib",
"?set term svgalib",
"?terminal svgalib",
"?term svgalib",
"?svgalib",
"?commands set terminal ssvgalib",
"?set terminal ssvgalib",
"?set term ssvgalib",
"?terminal ssvgalib",
"?term ssvgalib",
"?ssvgalib",
" These drivers supports PC monitors with autodetected graphics boards.  They",
" can be used only when compiled with Zortech C/C++.  None have options."
END_HELP(hercules)
START_HELP(fig)
"1 fig",
"?commands set terminal fig",
"?set terminal fig",
"?set term fig",
"?terminal fig",
"?term fig",
"?fig",
"?xfig",
" The `fig` terminal device generates output in the Fig graphics language.",
"",
" Syntax:",
"       set terminal fig {monochrome | color}",
"                        {landscape | portrait}",
"                        {small | big | size <xsize> <ysize>}",
"                        {metric | inches}",
"                        {pointsmax <max_points>}",
"                        {solid | dashed}",
"                        {fontsize <fsize>}",
"                        {textnormal | {textspecial texthidden textrigid}}",
"                        {thickness <units>}",
"                        {depth <layer>}",
"                        {version <number>}",
"",
" `monochrome` and `color` determine whether the picture is black-and-white or",
" `color`.  `small` and `big` produce a 5x3 or 8x5 inch graph in the default",
" `landscape` mode and 3x5 or 5x8 inches in `portrait` mode.",
" `size` sets (overrides) the size of the drawing",
" area to <xsize>*<ysize> in units of inches or centimeters depending on the",
" `inches` or `metric` setting in effect.",
" The latter settings is also used as default units for editing with \"xfig\".",
"",
" `pointsmax <max_points>` sets the maximum number of points per polyline.",
"",
" `solid` inhibits automatic usage of `dash`ed lines when solid linestyles are",
" used up, which otherwise occurs.",
"",
" `fontsize` sets the size of the text font to <fsize> points.  `textnormal`",
" resets the text flags and selects postscript fonts, `textspecial` sets the",
" text flags for LaTeX specials, `texthidden` sets the hidden flag and",
" `textrigid` the rigid flag. ",
"",
" `depth` sets the default depth layer for all lines and text.  The default",
" depth is 10 to leave room for adding material with \"xfig\" on top of the",
" plot.",
"",
" `version` sets the format version of the generated fig output. Currently",
" only versions 3.1 and 3.2 are supported.",
"",
" `thickness` sets the default line thickness, which is 1 if not specified.",
" Overriding the thickness can be achieved by adding a multiple of 100 to the",
" `linetype` value for a `plot` command.  In a similar way the `depth`",
" of plot elements (with respect to the default depth) can be controlled by",
" adding a multiple of 1000 to <linetype>.  The depth is then <layer> +",
" <linetype>/1000 and the thickness is (<linetype>%1000)/100 or, if that is",
" zero, the default line thickness.",
"",
" Additional point-plot symbols are also available with the `fig` driver. The",
" symbols can be used through `pointtype` values % 100 above 50, with different",
" fill intensities controlled by <pointtype> % 5 and outlines in black (for",
" <pointtype> % 10 < 5) or in the current color.  Available symbols are",
"         50 - 59:  circles",
"         60 - 69:  squares",
"         70 - 79:  diamonds",
"         80 - 89:  upwards triangles",
"         90 - 99:  downwards triangles",
" The size of these symbols is linked to the font size.  The depth of symbols",
" is by default one less than the depth for lines to achieve nice error bars.",
" If <pointtype> is above 1000, the depth is <layer> + <pointtype>/1000-1.  If",
" <pointtype>%1000 is above 100, the fill color is (<pointtype>%1000)/100-1.",
"",
" Available fill colors are (from 1 to 9): black, blue, green, cyan, red,",
" magenta, yellow, white and dark blue (in monochrome mode: black for 1 to 6",
" and white for 7 to 9).",
"",
" See `plot with` for details of <linetype> and <pointtype>.",
"",
" The `big` option is a substitute for the `bfig` terminal in earlier versions,",
" which is no longer supported.",
"",
" Examples:",
"       set terminal fig monochrome small pointsmax 1000  # defaults",
"",
"       plot 'file.dat' with points linetype 102 pointtype 759",
" would produce circles with a blue outline of width 1 and yellow fill color.",
"",
"       plot 'file.dat' using 1:2:3 with err linetype 1 pointtype 554",
" would produce errorbars with black lines and circles filled red.  These",
" circles are one layer above the lines (at depth 9 by default).",
"",
" To plot the error bars on top of the circles use",
"       plot 'file.dat' using 1:2:3 with err linetype 1 pointtype 2554"
END_HELP(fig)
START_HELP(png)
"1 png (NEW)",
"?commands set terminal png",
"?set terminal png",
"?set term png",
"?terminal png",
"?term png",
"?png",
" Syntax:",
"       set terminal png ",
"              {{no}transparent} {{no}interlace}",
"              {tiny | small | medium | large | giant}",
"              {font <face> {<pointsize>}}",
"              {size <x>,<y>} {{no}crop}",
"              {{no}enhanced}",
"              {<color0> <color1> <color2> ...}",
"",
" PNG images are created using libgd, with optional support for TrueType",
" and Adobe Type 1 fonts via libfreetype. Version 1.8 or greater of libgd",
" is required.",
"",
" `transparent` instructs the driver to generate transparent PNGs.  The first",
" color will be the transparent one. Default is `notransparent`.",
"",
" `interlace` instructs the driver to generate interlaced PNGs.",
" Default is `nointerlace`.",
"",
" Five basic fonts are supported directly by the gd library. These are",
" `tiny` (5x8 pixels), `small` (6x12 pixels), `medium`, (7x13 Bold), ",
" `large` (8x16) or `giant` (9x15 pixels). These fonts cannot be scaled",
" or rotated (pure horizontal or vertical text only).",
"",
" If gnuplot was built with support for TrueType (*.ttf) or Adobe Type 1 ",
" (*.pfa) fonts, they may be selected using the 'font <face> {<pointsize>}' ",
" option. <face> is either the full pathname to the font file, or a font ",
" face name that is assumed to be the first part of a filename in one of the ",
" directories listed in the GDFONTPATH environmental variable. That is, ",
" 'set term png font \"Face\"' will look for a font file named either ",
" <somedirectory>/Face.ttf or <somedirectory>/Face.pfa. Both TrueType and ",
" Adobe Type 1 fonts are fully scalable and may be rotated through any angle.",
" If no font is specified, gnuplot checks the environmental variable ",
" GNUPLOT_DEFAULT_GDFONT to see if there is a preferred default font. ",
"",
" `enhanced` enables the enhanced text processing features, (subscripts, ",
" superscripts and mixed fonts). See `enhanced` for more information. ",
" The full enhanced mode syntax is supported by the PNG/JPEG driver itself,",
" but some of these features are dependent on which version of the ",
" underlying libgd library is present, and which fonts are available.",
"",
" The size <x,y> is given in pixels---it defaults to 640x480.  The number of",
" pixels can be also modified by scaling with the `set size` command.",
" `crop` trims blank space from the edges of the completed plot, resulting",
" in a smaller final image size. Default is `nocrop`.",
"",
" Each color must be of the form 'xrrggbb', where x is the literal character",
" 'x' and 'rrggbb' are the red, green and blue components in hex.  For example,",
" 'x00ff00' is green.  The background color is set first, then the border",
" colors, then the X & Y axis colors, then the plotting colors.  The maximum",
" number of colors that can be set is 256.",
"",
" Examples:",
"       set terminal png medium size 640,480 \\",
"                        xffffff x000000 x404040 \\",
"                        xff0000 xffa500 x66cdaa xcdb5cd \\",
"                        xadd8e6 x0000ff xdda0dd x9500d3    # defaults",
"",
" which uses white for the non-transparent background, black for borders, gray",
" for the axes, and red, orange, medium aquamarine, thistle 3, light blue, blue,",
" plum and dark violet for eight plotting colors.",
"",
"       set terminal png font arial 14 size 800,600",
"",
" which searches for a TrueType font with face name 'arial' in the directory",
" specified by the environment variable GDFONTPATH and 14pt font size.",
"",
"       set terminal png transparent xffffff \\",
"                        x000000 x202020 x404040 x606060 \\",
"                        x808080 xA0A0A0 xC0C0C0 xE0E0E0",
"",
" which uses white for the transparent background, black for borders, dark",
" gray for axes, and a gray-scale for the six plotting colors.",
""
END_HELP(png)
START_HELP(jpeg)
"1 jpeg",
"?commands set terminal jpeg",
"?set terminal jpeg",
"?set term jpeg",
"?terminal jpeg",
"?term jpeg",
"?jpeg",
"",
" Syntax:",
"       set terminal jpeg ",
"                        {{no}interlace}",
"                        {tiny | small | medium | large | giant}",
"                        {font <face> {<pointsize>}}",
"                        {size <x>,<y>} {{no}crop}",
"                        {{no}enhanced}",
"                        {<color0> <color1> <color2> ...}",
"",
" JPEG images are created using libgd, with optional support for TrueType",
" fonts via libfreetype.",
"",
" The `interlace` option creates a progressive JPEG image.",
" Default is `nointerlace`.",
"",
" Five basic fonts are supported directly by the gd library. These are",
" `tiny` (5x8 pixels), `small` (6x12 pixels), `medium`, (7x13 Bold), ",
" `large` (8x16) or `giant` (9x15 pixels). These fonts cannot be scaled",
" or rotated (pure horizontal or vertical text only).",
"",
" If gnuplot was built with support for TrueType (*.ttf) or Adobe Type 1 ",
" (*.pfa) fonts, they may be selected using the 'font <face> {<pointsize>}' ",
" option. <face> is either the full pathname to the font file, or a font ",
" face name that is assumed to be the first part of a filename in one of the ",
" directories listed in the GDFONTPATH environmental variable. That is, ",
" 'set term jpeg font \"Face\"' will look for a font file named either ",
" <somedirectory>/Face.ttf or <somedirectory>/Face.pfa. Both TrueType and ",
" Adobe Type 1 fonts are fully scalable and may be rotated through any angle.",
" If no font is specified, gnuplot checks the environmental variable ",
" GNUPLOT_DEFAULT_GDFONT to see if there is a preferred default font. ",
"",
" `enhanced` enables the enhanced text processing features, (subscripts, ",
" superscripts and mixed fonts). See `enhanced` for more information. ",
" The full enhanced mode syntax is supported by the PNG/JPEG driver itself,",
" but some of these features are dependent on which version of the ",
" underlying libgd library is present, and which fonts are available.",
"",
" The size <x,y> is given in pixels---it defaults to 640x480.  The number of",
" pixels can be also modified by scaling with the `set size` command.",
" `crop` trims blank space from the edges of the completed plot, resulting",
" in a smaller final image size. Default is `nocrop`.",
"",
" Each color must be of the form 'xrrggbb', where x is the literal character",
" 'x' and 'rrggbb' are the red, green and blue components in hex.  For example,",
" 'x00ff00' is green.  The background color is set first, then the border",
" colors, then the X & Y axis colors, then the plotting colors.  The maximum",
" number of colors that can be set is 256.",
"",
" Examples:",
"       set terminal jpeg medium size 640,480 \\",
"                        xffffff x000000 x404040 \\",
"                        xff0000 xffa500 x66cdaa xcdb5cd \\",
"                        xadd8e6 x0000ff xdda0dd x9500d3    # defaults",
"",
" which uses white for the non-transparent background, black for borders, gray",
" for the axes, and red, orange, medium aquamarine, thistle 3, light blue, blue,",
" plum and dark violet for eight plotting colors.",
"",
"       set terminal jpeg large font arial size 800,600",
"",
" which searches for a TrueType font with face name 'arial' in the directory",
" specified by the environment variable GDFONTPATH and large (14pt) font size.",
""
END_HELP(jpeg)
START_HELP(ggi)
"1 ggi",
"?commands set terminal ggi",
"?set terminal ggi",
"?set term ggi",
"?terminal ggi",
"?term ggi",
"?ggi",
" The `ggi` driver can run on different targets as X or svgalib.",
"",
" Syntax:",
"    set terminal ggi [acceleration <integer>] [[mode] {mode}]",
"",
" In X the window cannot be resized using window manager handles, but the",
" mode can be given with the mode option, e.g.:",
"  - V1024x768",
"  - V800x600",
"  - V640x480",
"  - V320x200",
" Please refer to the ggi documentation for other modes. The 'mode' keyword",
" is optional. It is recommended to select the target by environment variables",
" as explained in the libggi manual page. To get DGA on X, you should for",
" example",
"    bash> export GGI_DISPLAY=DGA",
"    csh>  setenv GGI_DISPLAY DGA",
"",
" 'acceleration' is only used for targets which report relative pointer",
" motion events (e.g. DGA) and is a strictly positive integer multiplication",
" factor for the relative distances.  The default for acceleration is 7.",
"",
" Examples:",
"    set term ggi acc 10",
"    set term ggi acc 1 mode V1024x768",
"    set term ggi V1024x768"
END_HELP(ggi)
START_HELP(gif)
"1 gif",
"?commands set terminal gif",
"?set terminal gif",
"?set term gif",
"?terminal gif",
"?term gif",
"?gif",
" The `gif` terminal driver generates output in GIF format.  It uses Thomas",
" Boutell's gd library, which is available from http://www.boutell.com/gd/",
" Support for GIF output was removed from the gd library beginning with ",
" version 1.6; newer versions support PNG output instead.",
"",
" Syntax:",
"       set terminal gif {transparent} {interlace}",
"                        {tiny | small | medium | large | giant}",
"                        {size <x>,<y>}",
"                        {<color0> <color1> <color2> ...}",
"",
" `transparent` instructs the driver to generate transparent GIFs.  The first",
" color will be the transparent one.",
"",
" `interlace` instructs the driver to generate interlaced GIFs.",
"",
" The choice of fonts is `tiny` (5x8 pixels), `small` (6x12 pixels), `medium`",
" (7x13 Bold), `large` (8x16) or `giant` (9x15 pixels)",
"",
" The size <x,y> is given in pixels---it defaults to 640x480.  The number of",
" pixels can be also modified by scaling with the `set size` command.",
"",
" Each color must be of the form 'xrrggbb', where x is the literal character",
" 'x' and 'rrggbb' are the red, green and blue components in hex.  For example,",
" 'x00ff00' is green.  The background color is set first, then the border",
" colors, then the X & Y axis colors, then the plotting colors.  The maximum",
" number of colors that can be set is 256.",
"",
" Examples:",
"       set terminal gif small size 640,480 \\",
"                        xffffff x000000 x404040 \\",
"                        xff0000 xffa500 x66cdaa xcdb5cd \\",
"                        xadd8e6 x0000ff xdda0dd x9500d3    # defaults",
"",
" which uses white for the non-transparent background, black for borders, gray",
" for the axes, and red, orange, medium aquamarine, thistle 3, light blue, blue,",
" plum and dark violet for eight plotting colors.",
"",
"       set terminal gif transparent xffffff \\",
"                        x000000 x202020 x404040 x606060 \\",
"                        x808080 xA0A0A0 xC0C0C0 xE0E0E0",
"",
" which uses white for the transparent background, black for borders, dark",
" gray for axes, and a gray-scale for the six plotting colors.",
"",
" The page size is 640x480 pixels.  The `gif` driver can create either color",
" or monochromatic output, but you have no control over which is produced.",
"",
" The current version of the `gif` driver does not support animated GIFs."
END_HELP(gif)
START_HELP(gnugraph)
"1 Gnugraph(GNU plotutils)",
"?commands set terminal gnugraph",
"?set terminal gnugraph",
"?set term gnugraph",
"?terminal gnugraph",
"?term gnugraph",
"?gnugraph",
" The `gnugraph` driver produces device-independent output in the GNU plot",
" graphics language.  The default size of the PostScript results generated by",
" \"plot2ps\" is 5 x 3 inches; this can be increased up to about 8.25 x 8.25 by",
" `set size`.",
"",
" Syntax:",
"       set terminal gnugraph {\"<fontname>\"} {<fontsize>}",
"                             {type <pt>} {size \"<size>\"}",
"",
" which defaults to 10-point \"Courier\".",
"",
" For `type`, the following options are accepted: `X`, `pnm`, `gif`, `ai`,",
" `ps`, `cgm`, `fig`, `pcl5`, `hpgl`, `tek`, and `meta` (default). The",
" `size` option (default is a4) is passed straight through to plotutils, it's",
" the user's responsibility to provide correct values. Details can be found",
" in the plotutils documentation.",
"",
" Examples:",
"       set terminal gnugraph type hpgl size \"a4\"",
"       set terminal gnugraph size \"a4,xoffset=-5mm,yoffset=2.0cm\" type pnm",
"",
" There is a non-GNU version of the `gnugraph` driver which cannot be compiled",
" unless this version is left out."
END_HELP(gnugraph)
START_HELP(gpic)
"1 gpic",
"?commands set terminal gpic",
"?set terminal gpic",
"?set term gpic",
"?terminal gpic",
"?term gpic",
"?gpic",
" The `gpic` terminal driver generates GPIC graphs in the Free Software",
" Foundations's \"groff\" package.  The default size is 5 x 3 inches.  The only",
" option is the origin, which defaults to (0,0).",
"",
" Syntax:",
"       set terminal gpic {<x> <y>}",
"",
" where `x` and `y` are in inches.",
"",
" A simple graph can be formatted using",
"",
"       groff -p -mpic -Tps file.pic > file.ps.",
"",
" The output from pic can be pipe-lined into eqn, so it is possible to put",
" complex functions in a graph with the `set label` and `set {x/y}label`",
" commands.  For instance,",
"",
"       set ylab '@space 0 int from 0 to x alpha ( t ) roman d t@'",
"",
" will label the y axis with a nice integral if formatted with the command:",
"",
"       gpic filename.pic | geqn -d@@ -Tps | groff -m[macro-package] -Tps",
"           > filename.ps",
"",
" Figures made this way can be scaled to fit into a document.  The pic language",
" is easy to understand, so the graphs can be edited by hand if need be.  All",
" co-ordinates in the pic-file produced by `gnuplot` are given as x+gnuplotx",
" and y+gnuploty.  By default x and y are given the value 0.  If this line is",
" removed with an editor in a number of files, one can put several graphs in",
" one figure like this (default size is 5.0x3.0 inches):",
"",
"       .PS 8.0",
"       x=0;y=3",
"       copy \"figa.pic\"",
"       x=5;y=3",
"       copy \"figb.pic\"",
"       x=0;y=0",
"       copy \"figc.pic\"",
"       x=5;y=0",
"       copy \"figd.pic\"",
"       .PE",
"",
" This will produce an 8-inch-wide figure with four graphs in two rows on top",
" of each other.",
"",
" One can also achieve the same thing by the command",
"",
"       set terminal gpic x y",
"",
" for example, using",
"",
"       .PS 6.0",
"       copy \"trig.pic\"",
"       .PE"
END_HELP(gpic)
START_HELP(gpr)
"1 gpr",
"?commands set terminal gpr",
"?set terminal gpr",
"?set term gpr",
"?terminal gpr",
"?term gpr",
"?gpr",
" The `gpr` terminal driver supports the Apollo Graphics Primitive Resource",
" for a fixed-size window.  It has no options.",
"",
" If a variable window size is desired, use the `apollo` terminal instead."
END_HELP(gpr)
START_HELP(grass)
"1 grass",
"?commands set terminal grass",
"?set terminal grass",
"?set term grass",
"?terminal grass",
"?term grass",
"?grass",
" The `grass` terminal driver gives `gnuplot` capabilities to users of the ",
" GRASS geographic information system.  Contact grassp-list@moon.cecer.army.mil",
" for more information.  Pages are written to the current frame of the GRASS",
" Graphics Window.  There are no options."
END_HELP(grass)
START_HELP(hp2623a)
"1 hp2623a",
"?commands set terminal hp2623a",
"?set terminal hp2623a",
"?set term hp2623a",
"?terminal hp2623a",
"?term hp2623a",
"?hp2623a",
" The `hp2623a` terminal driver supports the Hewlett Packard HP2623A.  It has",
" no options."
END_HELP(hp2623a)
START_HELP(hp2648)
"1 hp2648",
"?commands set terminal hp2648",
"?set terminal hp2648",
"?set term hp2648",
"?terminal hp2648",
"?term hp2648",
"?hp2648",
" The `hp2648` terminal driver supports the Hewlett Packard HP2647 and HP2648.",
" It has no options."
END_HELP(hp2648)
START_HELP(hp500c)
"1 hp500c",
"?commands set terminal hp500c",
"?set terminal hp500c",
"?set term hp500c",
"?terminal hp500c",
"?term hp500c",
"?hp500c",
" The `hp500c` terminal driver supports the Hewlett Packard HP DeskJet 500c.",
" It has options for resolution and compression.",
"",
" Syntax:",
"       set terminal hp500c {<res>} {<comp>}",
"",
" where `res` can be 75, 100, 150 or 300 dots per inch and `comp` can be \"rle\",",
" or \"tiff\".  Any other inputs are replaced by the defaults, which are 75 dpi",
" and no compression.  Rasterization at the higher resolutions may require a",
" large amount of memory."
END_HELP(hp500c)
START_HELP(hpgl)
"1 hpgl",
"?commands set terminal hpgl",
"?set terminal hpgl",
"?set term hpgl",
"?terminal hpgl",
"?term hpgl",
"?hpgl",
"?commands set terminal pcl5",
"?set terminal pcl5",
"?set term pcl5",
"?terminal pcl5",
"?term pcl5",
"?pcl5",
" The `hpgl` driver produces HPGL output for devices like the HP7475A plotter.",
" There are two options which can be set: the number of pens and `eject`,",
" which tells the plotter to eject a page when done.  The default is to use 6",
" pens and not to eject the page when done.",
"",
" The international character sets ISO-8859-1 and CP850 are recognized via",
" `set encoding iso_8859_1` or `set encoding cp850` (see `set encoding` for",
" details).",
"",
" Syntax:",
"       set terminal hpgl {<number_of_pens>} {eject}",
"",
" The selection",
"",
"       set terminal hpgl 8 eject",
"",
" is equivalent to the previous `hp7550` terminal, and the selection",
"",
"       set terminal hpgl 4",
"",
" is equivalent to the previous `hp7580b` terminal.",
"",
" The `pcl5` driver supports plotters such as the Hewlett-Packard Designjet",
" 750C, the Hewlett-Packard Laserjet III, and the Hewlett-Packard Laserjet IV.",
" It actually uses HPGL-2, but there is a name conflict among the terminal",
" devices.  It has several options which must be specified in the order",
" indicated below:",
"",
" Syntax:",
"       set terminal pcl5 {mode <mode>} {<plotsize>}",
"           {{color {<number_of_pens>}} | monochrome} {solid | dashed}",
"           {font <font>} {size <fontsize>} {pspoints | nopspoints}",
"",
" <mode> is `landscape` or `portrait`. <plotsize> is the physical",
" plotting size of the plot, which is one of the following: `letter` for",
" standard (8 1/2\" X 11\") displays, `legal` for (8 1/2\" X 14\") displays,",
" `noextended` for (36\" X 48\") displays (a letter size ratio) or,",
" `extended` for (36\" X 55\") displays (almost a legal size ratio).",
" `color` is for multi-pen (i.e. color) plots, and <number_of_pens> is",
" the number of pens (i.e. colors) used in color plots. `monochrome` is for",
" one (e.g. black) pen plots. `solid` draws all lines as solid lines, or",
" `dashed` will draw lines with different dashed and dotted line patterns.",
" <font> is `stick`, `univers`, `cg_times`, `zapf_dingbats`, `antique_olive`,",
" `arial`, `courier`, `garamond_antigua`, `letter_gothic`, `cg_omega`,",
" `albertus`, `times_new_roman`, `clarendon`, `coronet`, `marigold`,",
" `truetype_symbols`, or `wingdings`. <fontsize> is the font size in points.",
" The point type selection can be the standard default set by specifying",
" `nopspoints`, or the same set of point types found in the postscript terminal",
" by specifying `pspoints`.",
"",
" Note that built-in support of some of these options is printer device",
" dependent. For instance, all the fonts are supposedly supported by the HP",
" Laserjet IV, but only a few (e.g. univers, stick) may be supported by the HP",
" Laserjet III and the Designjet 750C. Also, color obviously won't work on the",
" the laserjets since they are monochrome devices.",
"",
" Defaults: landscape, noextended, color (6 pens), solid, univers, 12 point,",
"           and nopspoints.",
"",
" With `pcl5` international characters are handled by the printer; you just put",
" the appropriate 8-bit character codes into the text strings.  You don't need",
" to bother with `set encoding`.",
"",
" HPGL graphics can be imported by many software packages."
END_HELP(hpgl)
START_HELP(hpljii)
"1 hpljii",
"?commands set terminal hpljii",
"?set terminal hpljii",
"?set term hpljii",
"?terminal hpljii",
"?term hpljii",
"?hpljii",
"?commands set terminal hpdj",
"?set terminal hpdj",
"?set term hpdj",
"?terminal hpdj",
"?term hpdj",
"?hpdj",
" The `hpljii` terminal driver supports the HP Laserjet Series II printer.  The",
" `hpdj` driver supports the HP DeskJet 500 printer.  These drivers allow a",
" choice of resolutions.",
"",
" Syntax:",
"       set terminal hpljii | hpdj {<res>}",
"",
" where `res` may be 75, 100, 150 or 300 dots per inch; the default is 75.",
" Rasterization at the higher resolutions may require a large amount of memory.",
"",
" The `hp500c` terminal is similar to `hpdj`; `hp500c` additionally supports",
" color and compression."
END_HELP(hpljii)
START_HELP(hppj)
"1 hppj",
"?commands set terminal hppj",
"?set terminal hppj",
"?set term hppj",
"?terminal hppj",
"?term hppj",
"?hppj",
" The `hppj` terminal driver supports the HP PaintJet and HP3630 printers.  The",
" only option is the choice of font.",
"",
" Syntax:",
"       set terminal hppj {FNT5X9 | FNT9X17 | FNT13X25}",
"",
" with the middle-sized font (FNT9X17) being the default."
END_HELP(hppj)
START_HELP(imagen)
"1 imagen",
"?commands set terminal imagen",
"?set terminal imagen",
"?set term imagen",
"?terminal imagen",
"?term imagen",
"?imagen",
" The `imagen` terminal driver supports Imagen laser printers.  It is capable",
" of placing multiple graphs on a single page.",
"",
" Syntax:",
"       set terminal imagen {<fontsize>} {portrait | landscape}",
"                           {[<horiz>,<vert>]}",
"",
" where `fontsize` defaults to 12 points and the layout defaults to `landscape`.",
" `<horiz>` and `<vert>` are the number of graphs in the horizontal and",
" vertical directions; these default to unity.",
"",
" Example:",
"       set terminal imagen portrait [2,3]",
"",
" puts six graphs on the page in three rows of two in portrait orientation."
END_HELP(imagen)
START_HELP(iris4d)
"1 iris4d",
"?commands set terminal iris4d",
"?set terminal iris4d",
"?set term iris4d",
"?terminal iris4d",
"?term iris4d",
"?iris4d",
" The `iris4d` terminal driver supports Silicon Graphics IRIS 4D computers.",
" Its only option is 8- or 24-bit color depth.  The default is 8.",
"",
" Syntax:",
"       set terminal iris4d {8 | 24}",
"",
" The color depth is not really a choice -- the value appropriate for the",
" hardware should be selected.",
"",
" When using 24-bit mode, the colors can be directly specified via the file",
" .gnuplot_iris4d that is searched in the current directory and then in the",
" home directory specified by the HOME environment variable.  This file holds",
" RGB values for the background, border, labels and nine plotting colors, in",
" that order.  For example, here is a file containing the default colors:",
"",
"       85   85   85     Background   (dark gray)",
"       0    0    0      Boundary     (black)",
"       170  0    170    Labeling     (magenta)",
"       85   255  255    Plot Color 1 (light cyan)",
"       170  0    0      Plot Color 2 (red)",
"       0    170  0      Plot Color 3 (green)",
"       255  85   255    Plot Color 4 (light magenta)",
"       255  255  85     Plot Color 5 (yellow)",
"       255  85   85     Plot Color 6 (light red)",
"       85   255  85     Plot Color 7 (light green)",
"       0    170  170    Plot Color 8 (cyan)",
"       170  170  0      Plot Color 9 (brown)",
"",
" This file must have exactly 12 lines of RGB triples.  No empty lines are",
" allowed, and anything after the third number on a line is ignored."
END_HELP(iris4d)
START_HELP(kyo)
"1 kyo",
"?commands set terminal kyo",
"?set terminal kyo",
"?set term kyo",
"?terminal kyo",
"?term kyo",
"?kyo",
"?commands set terminal prescribe",
"?set terminal prescribe",
"?set term prescribe",
"?terminal prescribe",
"?term prescribe",
"?prescribe",
" The `kyo` and `prescribe` terminal drivers support the Kyocera laser printer.",
" The only difference between the two is that `kyo` uses \"Helvetica\" whereas",
" `prescribe` uses \"Courier\".  There are no options."
END_HELP(kyo)
START_HELP(latex)
"1 latex",
"?commands set terminal emtex",
"?set terminal emtex",
"?set term emtex",
"?terminal emtex",
"?term emtex",
"?latex",
"?commands set terminal latex",
"?set terminal latex",
"?set term latex",
"?terminal latex",
"?term latex",
"?emtex",
" The `latex` and `emtex` drivers allow two options.",
"",
" Syntax:",
"       set terminal latex | emtex {courier | roman | default} {<fontsize>}",
"",
" `fontsize` may be any size you specify.  The default is for the plot to",
" inherit its font setting from the embedding document.",
"",
" Unless your driver is capable of building fonts at any size (e.g. dvips),",
" stick to the standard 10, 11 and 12 point sizes.",
"",
" METAFONT users beware: METAFONT does not like odd sizes.",
"",
" All drivers for LaTeX offer a special way of controlling text positioning:",
" If any text string begins with '{', you also need to include a '}' at the",
" end of the text, and the whole text will be centered both horizontally and",
" vertically.  If the text string begins with '[', you need to follow this with",
" a position specification (up to two out of t,b,l,r), ']{', the text itself,",
" and finally '}'.  The text itself may be anything LaTeX can typeset as an",
" LR-box.  '\\rule{}{}'s may help for best positioning.",
"",
" Points, among other things, are drawn using the LaTeX commands \"\\Diamond\" and",
" \"\\Box\".  These commands no longer belong to the LaTeX2e core; they are included",
" in the latexsym package, which is part of the base distribution and thus part",
" of any LaTeX implementation.  Please do not forget to use this package.",
"",
" Examples:",
" About label positioning:",
" Use gnuplot defaults (mostly sensible, but sometimes not really best):",
"        set title '\\LaTeX\\ -- $ \\gamma $'",
" Force centering both horizontally and vertically:",
"        set label '{\\LaTeX\\ -- $ \\gamma $}' at 0,0",
" Specify own positioning (top here):",
"        set xlabel '[t]{\\LaTeX\\ -- $ \\gamma $}'",
" The other label -- account for long ticlabels:",
"        set ylabel '[r]{\\LaTeX\\ -- $ \\gamma $\\rule{7mm}{0pt}}'"
END_HELP(latex)
START_HELP(1)
"1 linux",
"?commands set terminal linux",
"?set terminal linux",
"?set term linux",
"?terminal linux",
"?term linux",
"?linux",
" The `linux` driver has no additional options to specify.  It looks at the",
" environment variable GSVGAMODE for the default mode; if not set, it uses",
" 1024x768x256 as default mode or, if that is not possible, 640x480x16",
" (standard VGA)."
END_HELP(1)
START_HELP(mac)
"1 macintosh",
"?set terminal macintosh",
"?set term macintosh",
"?terminal macintosh",
"?term macintosh",
"?macintosh",
" Several options may be set in the 'macintosh' driver.",
"",
" Syntax:",
"      set terminal macintosh {singlewin | multiwin} {vertical | novertical}",
"                             {size <width>, <height> | default}",
"",
" 'singlewin' limits the output to a single window and is useful for animations.",
" 'multiwin' allows multiple windows.",
" 'vertical' is only valid under the gx option. With this option, rotated text",
"     be drawn vertically. novertical turns this option off.",
"  size <width>, <height> overrides the graph size set in the preferences",
"     dialog until it is cleared with either 'set term mac size default'",
"     or 'set term mac default'.",
"",
"  'set term mac size default' sets the window size settings to those set in",
"     the preferences dialog.",
"",
"  'set term mac default' sets all options to their default values.",
"     Default values: nogx, multiwin, novertical.",
"",
"  If you generate graphs under the multiwin option and then switch to singlewin,",
"  the next plot command will cause one more window to be created. This new",
"  window will be reused as long as singlewin is in effect. If you switch back",
"  to multiwin, generate some graphs, and then switch to singlewin again, the",
"  orginal 'singlewin' window will be resused if it is still open. Otherwise",
"  a new 'singlewin' window will be created. The 'singlewin' window is not numbered."
END_HELP(mac)
START_HELP(mf)
"1 mf",
"?commands set terminal mf",
"?set terminal mf",
"?set term mf",
"?terminal mf",
"?term mf",
"?mf",
"?metafont",
" The `mf` terminal driver creates an input file to the METAFONT program.  Thus a",
" figure may be used in the TeX document in the same way as is a character.",
"",
" To use a picture in a document, the METAFONT program must be run with the",
" output file from `gnuplot` as input.  Thus, the user needs a basic knowledge",
" of the font creating process and the procedure for including a new font in a",
" document.  However, if the METAFONT program is set up properly at the local",
" site, an unexperienced user could perform the operation without much trouble.",
"",
" The text support is based on a METAFONT character set.  Currently the",
" Computer Modern Roman font set is input, but the user is in principal free to",
" choose whatever fonts he or she needs.  The METAFONT source files for the",
" chosen font must be available.  Each character is stored in a separate",
" picture variable in METAFONT.  These variables may be manipulated (rotated,",
" scaled etc.) when characters are needed.  The drawback is the interpretation",
" time in the METAFONT program.  On some machines (i.e. PC) the limited amount",
" of memory available may also cause problems if too many pictures are stored.",
"",
" The `mf` terminal has no options.",
"2 METAFONT Instructions",
"?commands set terminal mf detailed",
"?set terminal mf detailed",
"?set term mf detailed",
"?mf detailed",
"?metafont detailed",
"",
" - Set your terminal to METAFONT:",
"   set terminal mf",
" - Select an output-file, e.g.:",
"   set output \"myfigures.mf\"",
" - Create your pictures. Each picture will generate a separate character. Its",
" default size will be 5*3 inches. You can change the size by saying `set size",
" 0.5,0.5` or whatever fraction of the default size you want to have.",
"",
" - Quit `gnuplot`.",
"",
" - Generate a TFM and GF file by running METAFONT on the output of `gnuplot`.",
" Since the picture is quite large (5*3 in), you will have to use a version of",
" METAFONT that has a value of at least 150000 for memmax.  On Unix systems",
" these are conventionally installed under the name bigmf.  For the following",
" assume that the command virmf stands for a big version of METAFONT.  For",
" example:",
"",
" - Invoke METAFONT:",
"     virmf '&plain'",
" - Select the output device: At the METAFONT prompt ('*') type:",
"     \\mode:=CanonCX;     % or whatever printer you use",
" - Optionally select a magnification:",
"     mag:=1;             % or whatever you wish",
" - Input the `gnuplot`-file:",
"     input myfigures.mf",
" On a typical Unix machine there will usually be a script called \"mf\" that",
" executes virmf '&plain', so you probably can substitute mf for virmf &plain.",
" This will generate two files: mfput.tfm and mfput.$$$gf (where $$$ indicates",
" the resolution of your device).  The above can be conveniently achieved by",
" typing everything on the command line, e.g.:",
" virmf '&plain' '\\mode:=CanonCX; mag:=1; input myfigures.mf'",
" In this case the output files will be named myfigures.tfm and",
" myfigures.300gf.",
"",
" - Generate a PK file from the GF file using gftopk:",
"   gftopk myfigures.300gf myfigures.300pk",
" The name of the output file for gftopk depends on the DVI driver you use.",
" Ask your local TeX administrator about the naming conventions.  Next, either",
" install the TFM and PK files in the appropriate directories, or set your",
" environment variables properly.  Usually this involves setting TEXFONTS to",
" include the current directory and doing the same thing for the environment",
" variable that your DVI driver uses (no standard name here...).  This step is",
" necessary so that TeX will find the font metric file and your DVI driver will",
" find the PK file.",
"",
" - To include your pictures in your document you have to tell TeX the font:",
"   \\font\\gnufigs=myfigures",
" Each picture you made is stored in a single character.  The first picture is",
" character 0, the second is character 1, and so on...  After doing the above",
" step, you can use the pictures just like any other characters.  Therefore, to",
" place pictures 1 and 2 centered in your document, all you have to do is:",
"   \\centerline{\\gnufigs\\char0}",
"   \\centerline{\\gnufigs\\char1}",
" in plain TeX.  For LaTeX you can, of course, use the picture environment and",
" place the picture wherever you wish by using the \\makebox and \\put macros.",
"",
" This conversion saves you a lot of time once you have generated the font;",
" TeX handles the pictures as characters and uses minimal time to place them,",
" and the documents you make change more often than the pictures do.  It also",
" saves a lot of TeX memory.  One last advantage of using the METAFONT driver",
" is that the DVI file really remains device independent, because no \\special",
" commands are used as in the eepic and tpic drivers."
END_HELP(mf)
START_HELP(mp)
"1 mp",
"?commands set terminal mpost",
"?set terminal mp",
"?set term mp",
"?terminal mp",
"?term mp",
"?mp",
"?metapost",
"",
" The `mp` driver produces output intended to be input to the Metapost program.",
" Running Metapost on the file creates EPS files containing the plots. By",
" default, Metapost passes all text through TeX.  This has the advantage of",
" allowing essentially  any TeX symbols in titles and labels.",
"",
" Syntax:",
"    set term mp {color | colour | monochrome}",
"                {solid | dashed}",
"                {notex | tex | latex}",
"                {magnification <magsize>}",
"                {psnfss | psnfss-version7 | nopsnfss}",
"                {prologues <value>}",
"                {a4paper}",
"                {amstex}",
"                {\"<fontname>\"} {<fontsize>}",
"",
" The option `color` causes lines to be drawn in color (on a printer or display",
" that supports it), `monochrome` (or nothing) selects black lines.  The option",
" `solid` draws solid lines, while `dashed` (or nothing) selects lines with",
" different patterns of dashes.  If `solid` is selected but `color` is not,",
" nearly all lines will be identical.  This may occasionally be useful, so it is",
" allowed.",
"",
" The option `notex` bypasses TeX entirely, therefore no TeX code can be used in",
" labels under this option.  This is intended for use on old plot files or files",
" that make frequent use of common characters like `$` and `%` that require",
" special handling in TeX.",
"",
" The option `tex` sets the terminal to output its text for TeX to process.",
"",
" The option `latex` sets the terminal to output its text for processing by",
" LaTeX. This allows things like \\frac for fractions which LaTeX knows about",
" but TeX does not.  Note that you must set the environment variable TEX to the",
" name of your LaTeX executable (normally latex) if you use this option or use",
" `mpost --tex=<name of LaTeX executable> ...`. Otherwise metapost will try and",
" use TeX to process the text and it won't work.",
"",
" Changing font sizes in TeX has no effect on the size of mathematics, and there",
" is no foolproof way to make such a change, except by globally  setting a",
" magnification factor. This is the purpose of the `magnification` option. It",
" must be followed by a scaling factor. All text (NOT the graphs) will be scaled",
" by this factor. Use this if you have math that you want at some size other",
" than the default 10pt. Unfortunately, all math will be the same size, but see",
" the discussion below on editing the MP output. `mag` will also work under",
" `notex` but there seems no point in using it as the font size option (below)",
" works as well.",
"",
" The option `psnfss` uses postscript fonts in combination with LaTeX. Since",
" this option only makes sense, if LaTeX is being used, the `latex` option is selected",
" automatically. This option includes the following packages for LaTeX:",
" inputenc(latin1), fontenc(T1), mathptmx, helvet(scaled=09.2), courier, latexsym ",
" and textcomp.",
"",
" The option `psnfss-version7` uses also postscript fonts in LaTeX (option `latex`",
" is also automatically selected), but uses the following packages with LaTeX:",
" inputenc(latin1), fontenc(T1), times, mathptmx, helvet and courier.",
"",
" The option `nopsnfss` is the default and uses the standard font (cmr10 if not",
" otherwise specified).",
"",
" The option `prologues` takes a value as an additional argument and adds the line",
" `prologues:=<value>` to the metapost file. If a value of `2` is specified metapost",
" uses postscript fonts to generate the eps-file, so that the result can be viewed",
" using e.g. ghostscript. Normally the output of metapost uses TeX fonts and therefore",
" has to be included in a (La)TeX file before you can look at it.",
"",
" The option `noprologues` is the default. No additional line specifying the prologue",
" will be added.",
"",
" The option `a4paper` adds a `[a4paper]` to the documentclass. Normally letter paper",
" is used (default). Since this option is only used in case of LaTeX, the `latex` option",
" is selected automatically.",
"",
" The option `amstex` automatically selects the `latex` option and includes the following",
" LaTeX packages: amsfonts, amsmath(intlimits). By default these packages are not",
" included.",
"",
" A name in quotes selects the font that will be used when no explicit font is",
" given in a `set label` or `set title`.  A name recognized by TeX (a TFM file",
" exists) must be used.  The default is \"cmr10\" unless `notex` is selected,",
" then it is \"pcrr8r\" (Courier).  Even under `notex`, a TFM file is needed by",
" Metapost. The file `pcrr8r.tfm` is the name given to Courier in LaTeX's psnfss",
" package.  If you change the font from the `notex` default, choose a font that",
" matches the ASCII encoding at least in the range 32-126.  `cmtt10` almost",
" works, but it has a nonblank character in position 32 (space).",
"",
" The size can be any number between 5.0 and 99.99.  If it is omitted, 10.0 is",
" used.  It is advisable to use `magstep` sizes: 10 times an integer or",
" half-integer power of 1.2, rounded to two decimals, because those are the most",
" available sizes of fonts in TeX systems.",
"",
" All the options are optional.  If font information is given, it must be at the",
" end, with size (if present) last.  The size is needed to select a size for the",
" font, even if the font name includes size information.  For example,",
" `set term mp \"cmtt12\"` selects cmtt12 shrunk to the default size 10.  This",
" is probably not what you want or you would have used cmtt10.",
"",
" The following common ascii characters need special treatment in TeX:",
"    $, &, #, %, _;  |, <, >;  ^, ~,  \\, {, and }",
" The five characters $, #, &, _, and % can simply be escaped, e.g., `\\$`.",
" The three characters <, >, and | can be wrapped in math mode, e.g., `$<$`.",
" The remainder require some TeX work-arounds.  Any good book on TeX will give",
" some guidance.",
"",
" If you type your labels inside double quotes, backslashes in TeX code need to",
" be escaped (doubled). Using single quotes will avoid having to do this, but",
" then you cannot use `\\n` for line breaks.  As of this writing, version 3.7 of",
" gnuplot processes titles given in a `plot` command differently than in other",
" places, and backslashes in TeX commands need to be doubled regardless of the",
" style of quotes.",
"",
" Metapost pictures are typically used in TeX documents.  Metapost deals with",
" fonts pretty much the same way TeX does, which is different from most other",
" document preparation programs.  If the picture is included in a LaTeX document",
" using the graphics package, or in a plainTeX document via epsf.tex, and then",
" converted to PostScript with dvips (or other dvi-to-ps converter), the text in",
" the plot will usually be handled correctly.  However, the text may not appear",
" if you send the Metapost output as-is to a PostScript interpreter.",
"",
"2 Metapost Instructions",
"?commands set terminal mp detailed",
"?set terminal mp detailed",
"?set term mp detailed",
"?mp detailed",
"?metapost detailed",
"",
" - Set your terminal to Metapost, e.g.:",
"    set terminal mp mono \"cmtt12\" 12",
"",
" - Select an output-file, e.g.:",
"    set output \"figure.mp\"",
"",
" - Create your pictures.  Each plot (or multiplot group) will generate a",
" separate Metapost beginfig...endfig group.  Its default size will be 5 by 3",
" inches.  You can change the size by saying `set size 0.5,0.5` or whatever",
" fraction of the default size you want to have.",
"",
" - Quit gnuplot.",
"",
" - Generate EPS files by running Metapost on the output of gnuplot:",
"    mpost figure.mp  OR  mp figure.mp",
" The name of the Metapost program depends on the system, typically `mpost` for",
" a Unix machine and `mp` on many others.  Metapost will generate one EPS file",
" for each picture.",
"",
" - To include your pictures in your document you can use the graphics package",
" in LaTeX or epsf.tex in plainTeX:",
"    \\usepackage{graphics} % LaTeX",
"    \\input epsf.tex       % plainTeX",
" If you use a driver other than dvips for converting TeX DVI output to PS, you",
" may need to add the following line in your LaTeX document:",
"    \\DeclareGraphicsRule{*}{eps}{*}{}",
" Each picture you made is in a separate file.  The first picture is in, e.g.,",
" figure.0, the second in figure.1, and so on....  To place the third picture in",
" your document, for example, all you have to do is:",
"    \\includegraphics{figure.2} % LaTeX",
"    \\epsfbox{figure.2}         % plainTeX",
"",
" The advantage, if any, of the mp terminal over a postscript terminal is",
" editable output.  Considerable effort went into making this output as clean as",
" possible.  For those knowledgeable in the Metapost language, the default line",
" types and colors can be changed by editing the arrays `lt[]` and `col[]`.",
" The choice of solid vs dashed lines, and color vs black lines can be change by",
" changing the values assigned to the booleans `dashedlines` and `colorlines`.",
" If the default `tex` option was in effect, global changes to the text of",
" labels can be achieved by editing the `vebatimtex...etex` block.  In",
" particular, a LaTeX preamble can be added if desired, and then LaTeX's",
" built-in size changing commands can be used for maximum flexibility. Be sure",
" to set the appropriate MP configuration variable to force Metapost to run",
" LaTeX instead of plainTeX."
END_HELP(mp)
START_HELP(mgr)
"1 mgr",
"?commands set terminal mgr",
"?set terminal mgr",
"?set term mgr",
"?terminal mgr",
"?term mgr",
"?mgr",
" The `mgr` terminal driver supports the Mgr Window system.  It has no options."
END_HELP(mgr)
START_HELP(mif)
"1 mif",
"?commands set terminal mif",
"?set terminal mif",
"?set term mif",
"?terminal mif",
"?term mif",
"?mif",
" The `mif` terminal driver produces Frame Maker MIF format version 3.00.  It",
" plots in MIF Frames with the size 15*10 cm, and plot primitives with the same",
" pen will be grouped in the same MIF group.  Plot primitives in a `gnuplot`",
" page will be plotted in a MIF Frame, and several MIF Frames are collected in",
" one large MIF Frame.  The MIF font used for text is \"Times\".",
"",
" Several options may be set in the MIF 3.00 driver.",
"",
" Syntax:",
"       set terminal mif {color | colour | monochrome} {polyline | vectors}",
"                        {help | ?}",
"",
" `colour` plots lines with line types >= 0 in colour (MIF sep. 2--7) and",
" `monochrome` plots all line types in black (MIF sep. 0).",
" `polyline` plots curves as continuous curves and `vectors` plots curves as",
" collections of vectors.",
" `help` and `?` print online help on standard error output---both print a",
" short description of the usage; `help` also lists the options.",
"",
" Examples:",
"       set term mif colour polylines    # defaults",
"       set term mif                     # defaults",
"       set term mif vectors",
"       set term mif help"
END_HELP(mif)
START_HELP(mtos)
"1 mtos",
"?commands set terminal mtos",
"?set terminal mtos",
"?set term mtos",
"?terminal mtos",
"?term mtos",
"?mtos",
" The `mtos` terminal has no options.  It sends data via a pipe to an external",
" program called GPCLIENT.  It runs under MULTITOS, Magic 3.x, MagicMAC. and",
" MiNT.  If you cannot find GPCLIENT, than mail to dirk@lstm.uni-erlangen.de."
END_HELP(mtos)
START_HELP(next)
"1 next",
"?commands set terminal next",
"?set terminal next",
"?set term next",
"?terminal next",
"?term next",
"?next",
"?NeXT",
" Several options may be set in the next driver.",
"",
" Syntax:",
"       set terminal next {<mode>} {<type> } {<color>} {<dashed>}",
"                  {\"<fontname>\"} {<fontsize>} title {\"<newtitle>\"}",
"",
" where <mode> is  `default`, which sets all options to their defaults;",
" <type> is either `new` or `old`, where `old` invokes the old single window;",
" <color> is either `color` or `monochrome`;",
" <dashed> is either `solid` or `dashed`;",
" \"<fontname>\" is the name of a valid PostScript font;",
" <fontsize> is the size of the font in PostScript points; and",
" <title> is the title for the GnuTerm window.",
" Defaults are  `new`, `monochrome`, `dashed`, \"Helvetica\", 14pt.",
"",
" Examples:",
"       set term next default",
"       set term next 22",
"       set term next color \"Times-Roman\" 14",
"       set term next color \"Helvetica\" 12 title \"MyPlot\"",
"       set term next old",
"",
" Pointsizes may be changed with `set linestyle`."
END_HELP(next)
START_HELP(openstep)
"1 Openstep (next)",
"?commands set terminal openstep",
"?set terminal openstep",
"?set term openstep",
"?terminal openstep",
"?term openstep",
"?openstep",
"?OpenStep",
"?Openstep",
" Several options may be set in the openstep (next) driver.",
"",
" Syntax:",
"       set terminal openstep {<mode>} {<type> } {<color>} {<dashed>}",
"                  {\"<fontname>\"} {<fontsize>} title {\"<newtitle>\"}",
"",
" where <mode> is  `default`, which sets all options to their defaults;",
" <type> is either `new` or `old`, where `old` invokes the old single window;",
" <color> is either `color` or `monochrome`;",
" <dashed> is either `solid` or `dashed`;",
" \"<fontname>\" is the name of a valid PostScript font;",
" <fontsize> is the size of the font in PostScript points; and",
" <title> is the title for the GnuTerm window.",
" Defaults are  `new`, `monochrome`, `dashed`, \"Helvetica\", 14pt.",
"",
" Examples:",
"       set term openstep default",
"       set term openstep 22",
"       set term openstep color \"Times-Roman\" 14",
"       set term openstep color \"Helvetica\" 12 title \"MyPlot\"",
"       set term openstep old",
"",
" Pointsizes may be changed with `set linestyle`."
END_HELP(openstep)
START_HELP(pbm)
"1 pbm",
"?commands set terminal pbm",
"?set terminal pbm",
"?set term pbm",
"?terminal pbm",
"?term pbm",
"?pbm",
" Several options may be set in the `pbm` terminal---the driver for PBMplus.",
"",
" Syntax:",
"       set terminal pbm {<fontsize>} {<mode>}",
"",
" where <fontsize> is `small`, `medium`, or `large` and <mode> is `monochrome`,",
" `gray` or `color`.  The default plot size is 640 pixels wide and 480 pixels",
" high; this may be changed by `set size`.",
"",
" The output of the `pbm` driver depends upon <mode>: `monochrome` produces a",
" portable bitmap (one bit per pixel), `gray` a portable graymap (three bits",
" per pixel) and `color` a portable pixmap (color, four bits per pixel).",
"",
" The output of this driver can be used with Jef Poskanzer's excellent PBMPLUS",
" package, which provides programs to convert the above PBMPLUS formats to GIF,",
" TIFF, MacPaint, Macintosh PICT, PCX, X11 bitmap and many others.  PBMPLUS may",
" be obtained from ftp.x.org.  The relevant files have names that begin with",
" \"netpbm-1mar1994.p1\"; they reside in /contrib/utilities.  The package can",
" probably also be obtained from one of the many sites that mirrors ftp.x.org.",
"",
" Examples:",
"       set terminal pbm small monochrome             # defaults",
"       set size 2,2; set terminal pbm color medium"
END_HELP(pbm)
START_HELP(dospc)
"1 dospc",
"?commands set terminal dospc",
"?set terminal dospc",
"?set term dospc",
"?terminal dospc",
"?term dospc",
"?dospc",
" The `dospc` terminal driver supports PCs with arbitrary graphics boards,",
" which will be automatically detected.  It should be used only if you are",
" not using the gcc or Zortec C/C++ compilers."
END_HELP(dospc)
START_HELP(pdf)
"1 pdf",
"?commands set terminal pdf",
"?set terminal pdf",
"?set term pdf",
"?terminal pdf",
"?term pdf",
"?pdf",
" This terminal produces files in the Adobe Portable Document Format",
" (PDF), useable for printing or display with tools like Acrobat Reader",
"",
" Syntax:",
"       set terminal pdf {fname \"<font>\"} {fsize <fontsize>}",
"                        {{no}enhanced}",
"",
" where <font> is the name of the default font to use (default Helvetica)",
" and <fontsize> is the font size (in points, default 12).",
"",
" The `enhanced` option enables enhanced text processing features",
" (subscripts, superscripts and mixed fonts). See `enhanced` for more",
" information. Only the core PDF fonts are supported."
END_HELP(pdf)
START_HELP(pm)
"1 pm",
"?commands set terminal pm",
"?set terminal pm",
"?set term pm",
"?terminal pm",
"?term pm",
"?pm",
" The `pm` terminal driver provides an OS/2 Presentation Manager window in",
" which the graph is plotted.  The window is opened when the first graph is",
" plotted.  This window has its own online help as well as facilities for",
" printing, copying to the clipboard and some line type and color adjustments.",
" The `multiplot` option is supported.",
"",
" Syntax:",
"       set terminal pm {server {n}} {persist} {widelines} {enhanced} {\"title\"}",
"",
" If `persist` is specified, each graph appears in its own window and all",
" windows remain open after `gnuplot` exits.  If `server` is specified, all",
" graphs appear in the same window, which remains open when `gnuplot` exits.",
" This option takes an optional numerical argument which specifies an instance",
" of the server process.  Thus multiple server windows can be in use at the",
" same time.",
"",
" If `widelines` is specified, all plots will be drawn with wide lines.  If",
" `enhanced` is specified, sub- and superscripts and multiple fonts are",
" enabled using the same syntax as the `enhanced postscript` option (see",
" `set terminal postscript enhanced` for details).  Font names for the basic",
" PostScript fonts may be abbreviated to single letters.",
"",
" If `title` is specified, it will be used as the title of the plot window.",
" It will also be used as the name of the server instance, and will override",
" the optional numerical argument.",
"",
" Linewidths may be changed with `set linestyle`."
END_HELP(pm)
START_HELP(png_old)
"1 png (OLD)",
"?commands set terminal png (old)",
"?set terminal png (old)",
"?set term png (old)",
"?terminal png (old)",
"?term png (old)",
" The `png` terminal driver supports Portable Network Graphics.  This old ",
" version of the png driver requires the third-party libraries \"libpng\" ",
" and \"zlib\".  There is a newer png driver, with many more features, that",
" is preferred if you have libgd version 1.8 or newer.",
"",
" Syntax:",
"       set terminal png {small | medium | large}",
"                        {transparent|notransparent}",
"                        {picsize <xsize> <ysize>}",
"                        {monochrome | gray | color}",
"                        {<color0> <color1> <color2> ...}",
"",
" `transparent` instructs the driver to generate transparent PNGs.  The first",
" color will be the transparent one.",
    "",
" The defaults are `small` (fontsize) and `color`.  Default size of the output",
" is 640*480 pixel. This can be changed by the option `picsize`.",
"",
" Each <color> must be of the form 'xrrggbb', where x is the literal character",
" 'x' and 'rrggbb' are the red, green and blue components in hex.  For example,",
" 'x00ff00' is green.  The background color is set first, then the border",
" color, then the X & Y axis color, then the plotting colors.  The maximum",
" number of colors that can be set is currently 99."
END_HELP(png_old)
START_HELP(post)
"1 postscript",
"?commands set terminal postscript",
"?set terminal postscript",
"?set term postscript",
"?terminal postscript",
"?term postscript",
"?postscript",
" Several options may be set in the `postscript` driver.",
"",
" Syntax:",
"       set terminal postscript {<mode>} {enhanced | noenhanced}",
"                               {color | colour | monochrome}",
"                               {blacktext | colortext | colourtext}",
"                               {solid | dashed} {dashlength | dl <DL>}",
"                               {linewidth | lw <LW>}",
"                               {<duplexing>}",
"                               {rounded | butt}",
"                               {fontfile [add | delete] \"<filename>\"}",
"                               {palfuncparam <samples>{,<maxdeviation>}}",
"                               {\"<fontname>\"} {<fontsize>}",
"",
" where <mode> is `landscape`, `portrait`, `eps` or `default`;",
" `enhanced` enables enhanced text mode features (subscripts,",
" superscripts and mixed fonts). See `enhanced` for more information.",
" Option `color` enables color;",
" `blacktext` forces all text to be written in black even in color mode;",
" `solid` draws all plots with solid lines, overriding any dashed patterns;",
" `dashlength` or `dl` scales the length of the dashed-line segments by <DL>",
" (which is a floating-point number greater than zero);",
" `linewidth` or `lw` scales all linewidths by <LW>;",
" <duplexing> is `defaultplex`, `simplex` or `duplex` (\"duplexing\" in",
" PostScript is the ability of the printer to print on both sides of the same",
" page---don't set this if your printer can't do it);",
" `rounded` sets line caps and line joins to be rounded; `butt` is the",
" default, butt caps and mitered joins;",
" `\"<fontname>\"` is the name of a valid PostScript font; and `<fontsize>` is",
" the size of the font in PostScript points.",
" In addition to the standard postscript fonts, an oblique version of the",
" Symbol font, useful for mathematics, is defined. It is called"
" \"Symbol-Oblique\".",
"",
" `default` mode sets all options to their defaults: `landscape`, `monochrome`,",
" `dashed`, `dl 1.0`, `lw 1.0`, `defaultplex`, `noenhanced`, \"Helvetica\" and",
" 14pt.  Default size of a PostScript plot is 10 inches wide and 7 inches high.",
"",
" `palfuncparam` is only available if compiled with `pm3d` support.  It controls",
" how `set palette functions` are encoded as gradients in the output.",
" Analytic color component functions (set via `set palette functions`) are",
" encoded as linear interpolated gradients in the postscript output:  The color",
" component functions are sampled at <samples> points and all points are",
" removed from this gradient which can be removed without changing the",
" resulting colors by more than <maxdeviation>.  For almost every useful",
" palette you may savely leave the defaults of <samples>=2000 and",
" <maxdeviation>=0.003 untouched.",
"",
" `eps` mode generates EPS (Encapsulated PostScript) output, which is just",
" regular PostScript with some additional lines that allow the file to be",
" imported into a variety of other applications.  (The added lines are",
" PostScript comment lines, so the file may still be printed by itself.)  To",
" get EPS output, use the `eps` mode and make only one plot per file.  In `eps`",
" mode the whole plot, including the fonts, is reduced to half of the default",
" size.",
"",
" Fonts listed by `fontfile` or `fontfile add` encapsulate the font",
" definitions of the listed font from a postscript Type 1 or TrueType font",
" file directly into the gnuplot output postscript file. Thus, the enclosed",
" font can be used in labels, titles, etc. See the section",
" `postscript fontfile` for more details.",
" With `fontfile delete` a fontfile is deleted from the list of embedded",
" files.",
"",
" Examples:",
"       set terminal postscript default       # old postscript",
"       set terminal postscript enhanced      # old enhpost",
"       set terminal postscript landscape 22  # old psbig",
"       set terminal postscript eps 14        # old epsf1",
"       set terminal postscript eps 22        # old epsf2",
"       set size 0.7,1.4; set term post portrait color \"Times-Roman\" 14",
"       set term post \"VAGRoundedBT_Regular\" 14 fontfile \"bvrr8a.pfa\"",
"",
" Linewidths and pointsizes may be changed with `set style line`.",
"",
" The `postscript` driver supports about 70 distinct pointtypes, selectable",
" through the `pointtype` option on `plot` and `set style line`.",
"",
" Several possibly useful files about `gnuplot`'s PostScript are included",
" in the /docs/psdoc subdirectory of the `gnuplot` distribution and at the",
" distribution sites.  These are \"ps_symbols.gpi\" (a `gnuplot` command file",
" that, when executed, creates the file \"ps_symbols.ps\" which shows all the",
" symbols available through the `postscript` terminal), \"ps_guide.ps\" (a",
" PostScript file that contains a summary of the enhanced syntax and a page",
" showing what the octal codes produce with text and symbol fonts),",
" \"ps_file.doc\" (a text file that contains a discussion of the organization",
" of a PostScript file written by `gnuplot`), and \"ps_fontfile_doc.tex\"",
" (a LaTeX file which contains a short documentation concerning the",
" encapsulation of LaTeX fonts with a glyph table of the math fonts).",
"",
" A PostScript file is editable, so once `gnuplot` has created one, you are",
" free to modify it to your heart's desire.  See the `editing postscript`",
" section for some hints.",
"2 enhanced postscript",
"?commands set terminal postscript enhanced",
"?set terminal postscript enhanced",
"?set term postscript enhanced",
"?terminal postscript enhanced",
"?term postscript enhanced",
"?enhanced_postscript",
"?enhanced postscript",
"?Enhanced postscript",
"?enhanced text",
"?Enhanced text",
"?enhanced",
" Several terminal types support an enhanced text mode in which ",
" additional formatting information is embedded in the text string.",
"",
"@start table - first is interactive cleartext form",
"  Control      Examples        Explanation",
"   ^           a^x             superscript",
"   _           a_x             subscript",
"   @           @x or a@^b_c    phantom box (occupies no width)",
"   &           &{space}        inserts space of specified length",
"   ~           ~a{.8-}         overprints '-' on 'a', raised by .8",
"                               times the current fontsize",
"#\\begin{tabular}{|ccl|} \\hline",
"#\\multicolumn{3}{|c|}{Enhanced Text Control Codes} \\\\ \\hline",
"#Control & Examples & Explanation \\\\ \\hline",
"#\\verb~^~ & \\verb~a^x~ & superscript\\\\",
"#\\verb~_~ & \\verb~a_x~ & subscript\\\\",
"#\\verb~@~ & \\verb~@x or a@^b_c~ & phantom box (occupies no width)\\\\",
"#\\verb~&~ & \\verb~&{space}~ & inserts space of specified length\\\\",
"#\\verb|~| & \\verb|~a{.8-}| & overprints '-' on 'a', raised by .8\\\\",
"#\\verb~ ~ & \\verb~ ~ & times the current fontsize\\\\",
"%c c l .",
"%.TE",
"%.TS",
"%center box tab ($) ;",
"%c c l .",
"%Control$Examples$Explanation",
"%_",
"%^$a^x$superscript",
"%\\&_$a\\&_x$subscript",
"% @ $ @x or a\\&@^b\\&_c$phantom box (occupies no width)",
"% & $ &{space}$inserts space of specified length",
"% ~ $ ~a{.8-}$overprints '-' on 'a', raised by .8",
"%   $   $times the current fontsize",
"@end table",
"",
" Braces can be used to place multiple-character text where a single character",
" is expected (e.g., 2^{10}).  To change the font and/or size, use the full",
" form:  {/[fontname][=fontsize | *fontscale] text}.  Thus {/Symbol=20 G} is a",
" 20-point GAMMA and {/*0.75 K} is a K at three-quarters of whatever fontsize",
" is currently in effect.  (The '/' character MUST be the first character after",
" the '{'.)",
"",
" If the encoding vector has been changed by `set encoding`, the default",
" encoding vector can be used instead by following the slash with a dash.  This",
" is unnecessary if you use the Symbol font, however---since /Symbol uses its",
" own encoding vector, `gnuplot` will not apply any other encoding vector to",
" it.",
"",
" The phantom box is useful for a@^b_c to align superscripts and subscripts",
" but does not work well for overwriting an accent on a letter.  (To do the",
" latter, it is much better to use 'set encoding iso_8859_1' to change to the",
" ISO Latin-1 encoding vector, which contains a large variety of letters with",
" accents or other diacritical marks.)  Since the box is non-spacing, it is",
" sensible to put the shorter of the subscript or superscript in the box (that",
" is, after the @).",
"",
" Space equal in length to a string can be inserted using the '&' character.",
" Thus",
"         'abc&{def}ghi'",
" would produce",
"         'abc   ghi'.",
"",
" The '~' character causes the next character or bracketed text to be",
" overprinted by the following character or bracketed text.  The second text",
" will be horizontally centered on the first.  Thus '~a/' will result in an 'a'",
" with a slash through it.  You can also shift the second text vertically by",
" preceding the second text with a number, which will define the fraction of the",
" current fontsize by which the text will be raised or lowered.  In this case",
" the number and text must be enclosed in brackets because more than one",
" character is necessary.  If the overprinted text begins with a number, put a",
" space between the vertical offset and the text ('~{abc}{.5 000}'); otherwise",
" no space is needed ('~{abc}{.5---}').  You can change the font for one or",
" both strings ('~a{.5 /*.2 o}'---an 'a' with a one-fifth-size 'o' on top---and",
" the space between the number and the slash is necessary), but you can't",
" change it after the beginning of the string.  Neither can you use any other",
" special syntax within either string.  You can, of course, use control",
" characters by escaping them (see below), such as '~a{\\^}'",
"",
" You can access special symbols numerically by specifying \\character-code (in",
" octal), e.g., {/Symbol \\245} is the symbol for infinity.",
"",
" You can escape control characters using \\, e.g.,  \\\\, \\{, and so on.",
"",
" But be aware that strings in double-quotes are parsed differently than those",
" enclosed in single-quotes.  The major difference is that backslashes may need",
" to be doubled when in double-quoted strings.",
"",
" Examples (these are hard to describe in words---try them!):",
"       set xlabel 'Time (10^6 {/Symbol m}s)'",
"       set title '{/Symbol=18 \\362@_{/=9.6 0}^{/=12 x}} \\",
"                  {/Helvetica e^{-{/Symbol m}^2/2} d}{/Symbol m}'",
"",
" The file \"ps_guide.ps\" in the /docs/psdoc subdirectory of the `gnuplot` source",
" distribution contains more examples of the enhanced syntax.",
"2 editing postscript",
"?commands set terminal postscript editing",
"?set terminal postscript editing",
"?set term postscript editing",
"?terminal postscript editing",
"?term postscript editing",
"?editing_postscript",
"?editing postscript",
" The PostScript language is a very complex language---far too complex to",
" describe in any detail in this document.  Nevertheless there are some things",
" in a PostScript file written by `gnuplot` that can be changed without risk of",
" introducing fatal errors into the file.",
"",
" For example, the PostScript statement \"/Color true def\" (written into the",
" file in response to the command `set terminal postscript color`), may be",
" altered in an obvious way to generate a black-and-white version of a plot.",
" Similarly line colors, text colors, line weights and symbol sizes can also be",
" altered in straight-forward ways.  Text (titles and labels) can be edited to",
" correct misspellings or to change fonts.  Anything can be repositioned, and",
" of course anything can be added or deleted, but modifications such as these",
" may require deeper knowledge of the PostScript language.",
"",
" The organization of a PostScript file written by `gnuplot` is discussed in",
" the text file \"ps_file.doc\" in the docs/ps subdirectory of the gnuplot",
" source distribution.",
"2 postscript fontfile",
"?commands set terminal postscript fontfile",
"?set terminal postscript fontfile",
"?set term postscript fontfile",
"?terminal postscript fontfile",
"?term postscript fontfile",
"?postscript fontfile",
"?fontfile",
" The `fontfile` or `fontfile add` option takes one file name as argument",
" and encapsulates this file into the postscript output in order to make",
" this font available for text elements (labels, tic marks, titles, etc.).",
" The `fontfile delete` option also takes one file name as argument. It",
" deletes this file name from the list of encapsulated files.",
"",
" The postscript terminal understands some",
" font file formats: Type 1 fonts in ASCII file format (extension \".pfa\"),",
" Type 1 fonts in binary file format (extension \".pfb\"), and TrueType",
" fonts (extension \".ttf\"). Pfa files are understood directly, pfb and ttf",
" files are converted on the fly if appropriate conversion tools are",
" installed (see below). You have to specify the full filename with the",
" extension. Each `fontfile` option takes exact one font file name. This",
" option can be used multiple times in order to include more than one font",
" file.",
"",
" The font file is searched in the working directory and in all directories",
" listed in the fontpath which is determined by `set fontpath`.",
" In addition, the fontpath can be set using the environment variable",
" GNUPLOT_FONTPATH. If this is not set a system dependent default search",
" list is used. See `set fontpath` for more details.",
"",
" For using the encapsulated font file you have to specify the font name",
" (which normally is not the same as the file name). When embedding a",
" font file by using the `fontfile` option in interactive mode, the ",
" font name is printed on the screen. E.g.",
"    Font file 'p052004l.pfb' contains the font 'URWPalladioL-Bold'. Location:",
"    /usr/lib/X11/fonts/URW/p052004l.pfb",
"",
" When using pfa or pfb fonts, you can also find it out by looking into the",
" font file. There is a line similar to \"/FontName /URWPalladioL-Bold def\".",
" The middle string without the slash is the fontname, here",
" \"URWPalladioL-Bold\".",
" For TrueType fonts, this is not so easy since the font name is stored in a",
" binary format. In addition, they often have spaces in the font names which",
" is not supported by Type 1 fonts (in which a TrueType is converted on the",
" fly). The font names are changed in order to eliminate the spaces in the",
" fontnames. The easiest way to find out which font name is generated for",
" use with gnuplot, start gnuplot in interactive mode and type in",
" \"set terminal postscript fontfile '<filename.ttf>'\".",
"",
" For converting font files to pfa format the conversion tool has to read",
" the font from a file and write it to standard output.",
" For pfb files \"pfbtops\" is a tool which can do this. If this program",
" is installed on your system the on the fly conversion should work.",
" Just try to encapsulate a pfb file. If the compiled in program call does",
" not work correctly you can specify how this program is called by",
" defining the environment variable GNUPLOT_PFBTOPFA e.g. to",
" \"pfbtops %s\". The `%s` will be repeated by the font file name and thus",
" has to exist in the string.",
" If you don't want to do the conversion on the fly but get a pfa file of",
" the font you can use the tool \"pfb2pfa\" which is written in simple c",
" and should compile with any c compiler.",
" It is available from many ftp servers, e.g.",
"^ <a href=\"ftp://ftp.dante.de/tex-archive/fonts/utilities/ps2mf/\">",
"           ftp://ftp.dante.de/tex-archive/fonts/utilities/ps2mf/",
"^ </a>",
" In fact, \"pfbtopfa\" and \"pfb2ps\" do the same job. \"pfbtopfa\" puts",
" the resulting pfa code into a file, whereas \"pfbtops\" writes it to",
" standard output.",
"",
" TrueType fonts are converted into Type 1 pfa format, e.g.",
" by using the tool \"ttf2pt1\" which is available from",
"^ <a href=\"http://ttf2pt1.sourceforge.net/\">",
"           http://ttf2pt1.sourceforge.net/",
"^ </a>",
" If the builtin conversion does not",
" work, the conversion command can be changed by the environment variable",
" GNUPLOT_TTFTOPFA. For usage with ttf2pt1 it may be set to",
" \"ttf2pt1 -a -e -W 0 %s - \". Here again, `%s` stands for the",
" file name.",
"",
" For special purposes you also can use a pipe (if available for your",
" operating system). Therefore you start the file name definition with ",
" the character \"<\" and append a program call. This program has ",
" to write pfa data to standard output. Thus, a pfa file may be accessed",
" by `set fontfile \"< cat garamond.pfa\"`.",
"",
" For example, including Type 1 font files can be used for including the",
" postscript output in LaTeX documents. The \"european computer modern\"",
" font (which is a variant of the \"computer modern\" font) is available",
" in pfb format from any CTAN server, e.g.",
"^ <a href=\"ftp://ftp.dante.de/tex-archive/fonts/ps-type1/cm-super/\">",
"           ftp://ftp.dante.de/tex-archive/fonts/ps-type1/cm-super/",
"^ </a>",
" For example, the file \"sfrm1000.pfb\" contains the normal upright fonts",
" with serifs in the design size 10pt (font name \"SFRM1000\").",
" The computer modern fonts, which are still necessary for mathematics,",
" are available from",
"^ <a href=\"ftp://ftp.dante.de/tex-archive/fonts/cm/ps-type1/bluesky\">",
"           ftp://ftp.dante.de/tex-archive/fonts/cm/ps-type1/bluesky",
"^ </a>",
" With these you can use any character available in TeX. However, the",
" computer modern fonts have a strange encoding. (This is why you should not",
" use cmr10.pfb for text, but sfrm1000.pfb instead.)",
" The usage of TeX fonts is shown in one of the demos.",
" The file \"ps_fontfile_doc.tex\" in the /docs/psdoc subdirectory of the",
" `gnuplot` source distribution contains a table with glyphs of the TeX",
" mathfonts.",
"",
" If the font \"CMEX10\" is embedded (file \"cmex10.pfb\") gnuplot defines",
" the additional font \"CMEX10-Baseline\". It is shifted vertically in order",
" to fit better to the other glyphs (CMEX10 has its baseline at the top of",
" the symbols)."
END_HELP(post)
START_HELP(pslatex)
"1 pslatex and pstex",
"?commands set terminal pslatex",
"?set terminal pslatex",
"?set term pslatex",
"?terminal pslatex",
"?term pslatex",
"?pslatex",
"?commands set terminal pstex",
"?set terminal pstex",
"?set term pstex",
"?terminal pstex",
"?term pstex",
"?pstex",
" The `pslatex` and `pstex` drivers generate output for further processing by",
" LaTeX and TeX, respectively.  Figures generated by `pstex` can be included",
" in any plain-based format (including LaTeX).",
"",
" Syntax:",
"       set terminal [pslatex | pstex] {<color>} {<dashed>} {<rotate>}",
"                                      {auxfile} {<font_size>}",
"",
" <color> is either `color` or `monochrome`.  <dashed> is either `dashed`",
" or `solid`.  <rotate> is either `rotate` or `norotate` and determines",
" if the y-axis label is rotated.  <font_size> is the size (in pts) of the",
" desired font.",
"",
" If `auxfile` is specified, it directs the driver to put the PostScript",
" commands into an auxiliary file instead of directly into the LaTeX file.",
" This is useful if your pictures are large enough that dvips cannot handle",
" them.  The name of the auxiliary PostScript file is derived from the name of",
" the TeX file given on the `set output` command; it is determined by replacing",
" the trailing `.tex` (actually just the final extent in the file name) with",
" `.ps` in the output file name, or, if the TeX file has no extension, `.ps`",
" is appended.  Remember to close the `output file` before leaving `gnuplot`.",
" The `.ps` is included into the `.tex` file by a \\special{psfile=...} command.",
" If you would rather prefer \\includegraphics{...}, then use the `epslatex`",
" terminal.",
"",
" All drivers for LaTeX offer a special way of controlling text positioning: ",
" (a) If any text string begins with '{', you also need to include a '}' at the",
" end of the text, and the whole text will be centered both horizontally",
" and vertically by LaTeX.  (b) If the text string begins with '[', you need",
" to continue it with: a position specification (up to two out of t,b,l,r),",
" ']{', the text itself, and finally, '}'. The text itself may be anything",
" LaTeX can typeset as an LR-box. \\rule{}{}'s may help for best positioning.",
"",
" Examples:",
"       set term pslatex monochrome dashed rotate       # set to defaults",
" To write the PostScript commands into the file \"foo.ps\":",
"       set term pslatex auxfile",
"       set output \"foo.tex\"; plot ...; set output",
" About label positioning:",
" Use gnuplot defaults (mostly sensible, but sometimes not really best):",
"        set title '\\LaTeX\\ -- $ \\gamma $'",
" Force centering both horizontally and vertically:",
"        set label '{\\LaTeX\\ -- $ \\gamma $}' at 0,0",
" Specify own positioning (top here):",
"        set xlabel '[t]{\\LaTeX\\ -- $ \\gamma $}'",
" The other label -- account for long ticlabels:",
"        set ylabel '[r]{\\LaTeX\\ -- $ \\gamma $\\rule{7mm}{0pt}}'",
"",
" Linewidths and pointsizes may be changed with `set style line`."
END_HELP(pslatex)
START_HELP(pstricks)
"1 pstricks",
"?commands set terminal pstricks",
"?set terminal pstricks",
"?set term pstricks",
"?terminal pstricks",
"?term pstricks",
"?pstricks",
" The `pstricks` driver is intended for use with the \"pstricks.sty\" macro",
" package for LaTeX.  It is an alternative to the `eepic` and `latex` drivers.",
" You need \"pstricks.sty\", and, of course, a printer that understands",
" PostScript, or a converter such as Ghostscript.",
"",
" PSTricks is available via anonymous ftp from the /pub directory at",
" Princeton.edu.  This driver definitely does not come close to using the full",
" capability of the PSTricks package.",
"",
" Syntax:",
"       set terminal pstricks {hacktext | nohacktext} {unit | nounit}",
"",
" The first option invokes an ugly hack that gives nicer numbers; the second",
" has to do with plot scaling.  The defaults are `hacktext` and `nounit`."
END_HELP(pstricks)
START_HELP(qms)
"1 qms",
"?commands set terminal qms",
"?set terminal qms",
"?set term qms",
"?terminal qms",
"?term qms",
"?qms",
" The `qms` terminal driver supports the QMS/QUIC Laser printer, the Talaris",
" 1200 and others.  It has no options."
END_HELP(qms)
START_HELP(regis)
"1 regis",
"?commands set terminal regis",
"?set terminal regis",
"?set term regis",
"?terminal regis",
"?term regis",
"?regis",
" The `regis` terminal device generates output in the REGIS graphics language.",
" It has the option of using 4 (the default) or 16 colors.",
"",
" Syntax:",
"       set terminal regis {4 | 16}"
END_HELP(regis)
START_HELP(rgip)
"1 rgip",
"?commands set terminal rgip",
"?set terminal rgip",
"?set term rgip",
"?terminal rgip",
"?term rgip",
"?rgip",
"?commands set terminal uniplex",
"?set terminal uniplex",
"?set term uniplex",
"?terminal uniplex",
"?term uniplex",
"?uniplex",
" The `rgip` and `uniplex` terminal drivers support RGIP metafiles.  They can",
" combine several graphs on a single page, but only one page is allowed in a",
" given output file.",
"",
" Syntax:",
"       set terminal rgip | uniplex {portrait | landscape}",
"                                   {[<horiz>,<vert>]} {<fontsize>}",
"",
" permissible values for the font size are in the range 1--8, with the default",
" being 1.  The default layout is landscape.  Graphs are placed on the page in",
" a `horiz`x`vert` grid, which defaults to [1,1].",
"",
" Example:",
"       set terminal uniplex portrait [2,3]",
"",
" puts six graphs on a page in three rows of two in portrait orientation."
END_HELP(rgip)
START_HELP(sun)
"1 sun",
"?commands set terminal sun",
"?set terminal sun",
"?set term sun",
"?terminal sun",
"?term sun",
"?sun",
" The `sun` terminal driver supports the SunView window system.  It has no",
" options."
END_HELP(sun)
START_HELP(svg)
"1 svg",
"?commands set terminal svg",
"?set terminal svg",
"?set term svg",
"?terminal svg",
"?term svg",
"?svg",
" This terminal produces files in the W3C Scalable Vector Graphics format.",
"",
" Syntax:",
"       set terminal svg {size <x> <y> {|fixed|dynamic}}",
"                        {fname \"<font>\"} {fsize <fontsize>}",
"                        {{no}enhanced} {fontfile <filename>}",
"",
" where <x> and <y> are the size of the SVG plot to generate,",
" `dynamic` allows a svg-Viewer to resize plot, whereas the default",
" setting, `fixed`, will request an absolute size.",
"",
" <font> is the name of the default font to use (default Arial) and",
" <fontsize> is the font size (in points, default 12). Gnuplot does not",
" currently provide a mechanism for embedding fonts in the output file,",
" so svg viewing programs may substitute other fonts when the file is",
" displayed.",
"",
" The svg terminal supports an enhanced text mode, which allows font",
" and other formatting commands to be embedded in labels and other text",
" strings. The enhanced text mode syntax is shared with other gnuplot",
" terminal types. See `enhanced` for more details.",
"",
" SVG allows you to embed fonts directly into an SVG document, or to",
" provide a hypertext link to the desired font. The `fontfile` option",
" specifies a local file which is copied into the <defs> section of the",
" resulting SVG output file.  This file may either itself contain a font,",
" or may contain the records necessary to create a hypertext reference to",
" the desired font. Gnuplot will look for the requested file using the",
" directory list in the GNUPLOT_FONTPATH environmental variable."
END_HELP(svg)
START_HELP(tek410x)
"1 tek410x",
"?commands set terminal tek410x",
"?set terminal tek410x",
"?set term tek410x",
"?terminal tek410x",
"?term tek410x",
"?tek410x",
" The `tek410x` terminal driver supports the 410x and 420x family of Tektronix",
" terminals.  It has no options."
END_HELP(tek410x)
START_HELP(table)
"1 table",
"?commands set terminal table",
"?set terminal table",
"?set term table",
"?terminal table",
"?term table",
"?table",
" Instead of producing a graph, the `table` terminal prints out the points on",
" which a graph would be based, i.e., the results of processing the `plot` or",
" `splot` command, in a multicolumn ASCII table of X Y {Z} R values.  The",
" character R takes on one of three values: \"i\" if the point is in the active",
" range, \"o\" if it is out-of-range, or \"u\" if it is undefined.  The data",
" format is determined by the format of the axis labels (see `set format`),",
" and the columns are separated by single spaces.",
"",
" For those times when you want the numbers, you can display them on the",
" screen or save them to a file.  This can be useful if you want to generate",
" contours and then save them for further use, perhaps for plotting with",
" `plot`;  see `set contour` for an example.  The same method can be used to",
" save interpolated data (see `set samples` and `set dgrid3d`)."
END_HELP(table)
START_HELP(tek40)
"1 tek40",
"?commands set terminal tek40xx",
"?set terminal tek40xx",
"?set term tek40xx",
"?terminal tek40xx",
"?term tek40xx",
"?tek40",
"?commands set terminal vttek",
"?set terminal vttek",
"?set term vttek",
"?terminal vttek",
"?term vttek",
"?vttek",
"?commands set terminal kc-tek40xx",
"?set terminal kc-tek40xx",
"?set term kc-tek40xx",
"?terminal kc-tek40xx",
"?term kc-tek40xx",
"?kc-tek40xx",
"?commands set terminal km-tek40xx",
"?set terminal km-tek40xx",
"?set term km-tek40xx",
"?terminal km-tek40xx",
"?term km-tek40xx",
"?km-tek40xx",
"?commands set terminal selanar",
"?set terminal selanar",
"?set term selanar",
"?terminal selanar",
"?term selanar",
"?selanar",
"?commands set terminal bitgraph",
"?set terminal bitgraph",
"?set term bitgraph",
"?terminal bitgraph",
"?term bitgraph",
"?bitgraph",
" This family of terminal drivers supports a variety of VT-like terminals.",
" `tek40xx` supports Tektronix 4010 and others as well as most TEK emulators;",
" `vttek` supports VT-like tek40xx terminal emulators; `kc-tek40xx` supports",
" MS-DOS Kermit Tek4010 terminal emulators in color: `km-tek40xx` supports them",
" in monochrome; `selanar` supports Selanar graphics; and `bitgraph` supports",
" BBN Bitgraph terminals.  None have any options."
END_HELP(tek40)
START_HELP(texdraw)
"1 texdraw",
"?commands set terminal texdraw",
"?set terminal texdraw",
"?set term texdraw",
"?terminal texdraw",
"?term texdraw",
"?texdraw",
" The `texdraw` terminal driver supports the LaTeX texdraw environment.  It is",
" intended for use with \"texdraw.sty\" and \"texdraw.tex\" in the texdraw package.",
"",
" Points, among other things, are drawn using the LaTeX commands \"\\Diamond\" and",
" \"\\Box\".  These commands no longer belong to the LaTeX2e core; they are included",
" in the latexsym package, which is part of the base distribution and thus part",
" of any LaTeX implementation.  Please do not forget to use this package.",
"",
" It has no options."
END_HELP(texdraw)
START_HELP(tgif)
"1 tgif",
"?commands set terminal tgif",
"?set terminal tgif",
"?set term tgif",
"?terminal tgif",
"?term tgif",
"?tgif",
" Tgif is an X11-based drawing tool---it has nothing to do with GIF.",
"",
" The `tgif` driver supports different pointsizes (with `set pointsize`),",
" different label fonts and font sizes (e.g. `set label \"Hallo\" at x,y font",
" \"Helvetica,34\"`) and multiple graphs on the page.  The proportions of the",
" axes are not changed.",
"",
" Syntax:",
"       set terminal tgif {portrait | landscape} {<[x,y]>}",
"                         {solid | dashed}",
"                         {\"<fontname>\"} {<fontsize>}",
"",
" where <[x,y]> specifies the number of graphs in the x and y directions on the",
" page, \"<fontname>\" is the name of a valid PostScript font, and <fontsize>",
" specifies the size of the PostScript font.  Defaults are `portrait`, `[1,1]`,",
" `dashed`, `\"Helvetica\"`, and `18`.",
"",
" The `solid` option is usually prefered if lines are colored, as they often",
" are in the editor.  Hardcopy will be black-and-white, so `dashed` should be",
" chosen for that.",
"",
" Multiplot is implemented in two different ways.",
"",
" The first multiplot implementation is the standard gnuplot multiplot feature:",
"",
"       set terminal tgif",
"       set output \"file.obj\"",
"       set multiplot",
"       set origin x01,y01",
"       set size  xs,ys",
"       plot ...",
"            ...",
"       set origin x02,y02",
"       plot ...",
"       set nomultiplot",
"",
" See `set multiplot` for further information.",
"",
" The second version is the [x,y] option for the driver itself.  The advantage",
" of this implementation is that everything is scaled and placed automatically",
" without the need for setting origins and sizes; the graphs keep their natural",
" x/y proportions of 3/2 (or whatever is fixed by `set size`).",
"",
" If both multiplot methods are selected, the standard method is chosen and a",
" warning message is given.",
"",
" Examples of single plots (or standard multiplot):",
"       set terminal tgif                  # defaults",
"       set terminal tgif \"Times-Roman\" 24",
"       set terminal tgif landscape",
"       set terminal tgif landscape solid",
"",
" Examples using the built-in multiplot mechanism:",
"       set terminal tgif portrait [2,4]  # portrait; 2 plots in the x-",
"                                         # and 4 in the y-direction",
"       set terminal tgif [1,2]           # portrait; 1 plot in the x-",
"                                         # and 2 in the y-direction",
"       set terminal tgif landscape [3,3] # landscape; 3 plots in both",
"                                         # directions"
END_HELP(tgif)
START_HELP(tkcanvas)
"1 tkcanvas",
"?commands set terminal tkcanvas",
"?set terminal tkcanvas",
"?set term tkcanvas",
"?terminal tkcanvas",
"?term tkcanvas",
"?tkcanvas",
" This terminal driver generates Tk canvas widget commands based on Tcl/Tk",
" (default) or Perl.  To use it, rebuild `gnuplot` (after uncommenting or",
" inserting the appropriate line in \"term.h\"), then",
"",
"  gnuplot> set term tkcanvas {perltk} {interactive}",
"  gnuplot> set output 'plot.file'",
"",
" After invoking \"wish\", execute the following sequence of Tcl/Tk commands:",
"",
"  % source plot.file",
"  % canvas .c",
"  % pack .c",
"  % gnuplot .c",
"",
" Or, for Perl/Tk use a program like this:",
"",
"  use Tk;",
"  my $top = MainWindow->new;",
"  my $c = $top->Canvas->pack;",
"  my $gnuplot = do \"plot.pl\";",
"  $gnuplot->($c);",
"  MainLoop;",
"",
" The code generated by `gnuplot` creates a procedure called \"gnuplot\"",
" that takes the name of a canvas as its argument.  When the procedure is",
" called, it clears the canvas, finds the size of the canvas and draws the plot",
" in it, scaled to fit.",
"",
" For 2-dimensional plotting (`plot`) two additional procedures are defined:",
" \"gnuplot_plotarea\" will return a list containing the borders of the plotting",
" area \"xleft, xright, ytop, ybot\" in canvas screen coordinates, while the ranges",
" of the two axes \"x1min, x1max, y1min, y1max, x2min, x2max, y2min, y2max\" in plot",
" coordinates can be obtained calling \"gnuplot_axisranges\".",
" If the \"interactive\" option is specified, mouse clicking on a line segment",
" will print the coordinates of its midpoint to stdout. Advanced actions",
" can happen instead if the user supplies a procedure named",
" \"user_gnuplot_coordinates\", which takes the following arguments:",
" \"win id x1s y1s x2s y2s x1e y1e x2e y2e x1m y1m x2m y2m\",",
" the name of the canvas and the id of the line segment followed by the",
" coordinates of its start and end point in the two possible axis ranges; the",
" coordinates of the midpoint are only filled for logarithmic axes.",
"",
" The current version of `tkcanvas` supports neither `multiplot` nor `replot`."
END_HELP(tkcanvas)
START_HELP(tpic)
"1 tpic",
"?commands set terminal tpic",
"?set terminal tpic",
"?set term tpic",
"?terminal tpic",
"?term tpic",
"?tpic",
" The `tpic` terminal driver supports the LaTeX picture environment with tpic",
" \\specials.  It is an alternative to the `latex` and `eepic` terminal drivers.",
" Options are the point size, line width, and dot-dash interval.",
"",
" Syntax:",
"       set terminal tpic <pointsize> <linewidth> <interval>",
"",
" where `pointsize` and `linewidth` are integers in milli-inches and `interval`",
" is a float in inches.  If a non-positive value is specified, the default is",
" chosen: pointsize = 40, linewidth = 6, interval = 0.1.",
"",
" All drivers for LaTeX offer a special way of controlling text positioning:",
" If any text string begins with '{', you also need to include a '}' at the",
" end of the text, and the whole text will be centered both horizontally",
" and vertically by LaTeX. --- If the text string begins with '[', you need",
" to continue it with: a position specification (up to two out of t,b,l,r),",
" ']{', the text itself, and finally, '}'. The text itself may be anything",
" LaTeX can typeset as an LR-box. \\rule{}{}'s may help for best positioning.",
"",
" Examples:",
" About label positioning:",
" Use gnuplot defaults (mostly sensible, but sometimes not really best):",
"        set title '\\LaTeX\\ -- $ \\gamma $'",
" Force centering both horizontally and vertically:",
"        set label '{\\LaTeX\\ -- $ \\gamma $}' at 0,0",
" Specify own positioning (top here):",
"        set xlabel '[t]{\\LaTeX\\ -- $ \\gamma $}'",
" The other label -- account for long ticlabels:",
"        set ylabel '[r]{\\LaTeX\\ -- $ \\gamma $\\rule{7mm}{0pt}}'"
END_HELP(tpic)
START_HELP(unixpc)
"1 unixpc",
"?commands set terminal unixpc",
"?set terminal unixpc",
"?set term unixpc",
"?terminal unixpc",
"?term unixpc",
"?unixpc",
" The `unixpc` terminal driver supports AT&T 3b1 and AT&T 7300 Unix PC.  It has",
" no options."
END_HELP(unixpc)
START_HELP(vx384)
"1 vx384",
"?commands set terminal vx384",
"?set terminal vx384",
"?set term vx384",
"?terminal vx384",
"?term vx384",
"?vx384",
" The `vx384` terminal driver supports the Vectrix 384 and Tandy color",
" printers.  It has no options."
END_HELP(vx384)
START_HELP(vgagl)
"1 vgagl",
"?commands set terminal vgagl",
"?set terminal vgagl",
"?set term vgagl",
"?terminal vgagl",
"?term vgagl",
"?vgagl",
" The `vgagl` driver is a fast linux console driver with full mouse and pm3d",
" support.  It looks at the environment variable SVGALIB_DEFAULT_MODE for the",
" default mode; if not set, it uses a 256 color mode with the highest",
" available resolution.",
"",
" Syntax:",
"    set terminal vgagl \\",
"                 background [red] [[green] [blue]] \\",
"                 [uniform | interpolate] \\",
"                 [mode]",
"",
" The color mode can also be given with the mode option. Both Symbolic",
" names as G1024x768x256 and integers are allowed. The `background` option",
" takes either one or three integers in the range [0, 255]. If only one",
" integers is supplied, it is taken as gray value for the background.",
" If three integers are present, the background gets the corresponding",
" color.",
" The (mutually exclusive) options `interpolate` and `uniform` control",
" if color interpolation is done while drawing triangles (on by default).",
"",
" To get high resolution modes, you will probably have to modify the",
" configuration file of libvga, usually /etc/vga/libvga.conf.  Using",
" the VESA fb is a good choice, but this needs to be compiled in the",
" kernel.",
"",
" The vgagl driver uses the first *available* vga mode from the following list:",
"  - the driver which was supplied when setting vgagl, e.g. `set term vgagl",
"    G1024x768x256` would first check, if the G1024x768x256 mode is available.",
"  - the environment variable SVGALIB_DEFAULT_MODE",
"  - G1024x768x256",
"  - G800x600x256",
"  - G640x480x256",
"  - G320x200x256",
"  - G1280x1024x256",
"  - G1152x864x256",
"  - G1360x768x256",
"  - G1600x1200x256",
""
END_HELP(vgagl)
START_HELP(VWS)
"1 VWS",
"?commands set terminal VWS",
"?set terminal VWS",
"?set term VWS",
"?terminal VWS",
"?term VWS",
"?VWS",
" The `VWS` terminal driver supports the VAX Windowing System.  It has",
" no options.  It will sense the display type (monochrome, gray scale,",
" or color.)  All line styles are plotted as solid lines."
END_HELP(VWS)
START_HELP(windows)
"1 windows",
"?commands set terminal windows",
"?set terminal windows",
"?set term windows",
"?terminal windows",
"?term windows",
"?windows",
" Three options may be set in the `windows` terminal driver.",
"",
" Syntax:",
"       set terminal windows {<color>} {\"<fontname>\"} {<fontsize>}",
"",
" where `<color>` is either `color` or `monochrome`, `\"<fontname>\"` is the",
" name of a valid Windows font, and `<fontsize>` is the size of the font in",
" points.",
"",
" Other options may be set with the graph-menu, the initialization file,",
" and `set linestyle`.  Note that there is one restriction imposed by",
" the classic Windows GDI interface: modifiable linewidth only works with",
" solid lines, not with dotted or dashed ones.",
"",
" The Windows version normally terminates immediately as soon as the end of",
" any files given as command line arguments is reached (i.e. in non-interactive",
" mode), unless you specify `-` as the last command line option.",
" It will also not show the text-window at all, in this mode, only the plot.",
" By giving the optional argument `-persist` (same as for gnuplot under x11;",
" former Windows-only options `/noend` or `-noend` are still accepted as well),",
" will not close gnuplot. Contrary to gnuplot on other operating systems,",
" gnuplot's interactive command line is accessible after the -persist option.",
"2 graph-menu",
"?commands set terminal windows graph-menu",
"?set terminal windows graph-menu",
"?set term windows graph-menu",
"?windows graph-menu",
"?graph-menu",
" The `gnuplot graph` window has the following options on a pop-up menu",
" accessed by pressing the right mouse button or selecting `Options` from the",
" system menu:",
"",
" `Bring to Top` when checked brings the graph window to the top after every",
" plot.",
"",
" `Color` when checked enables color linestyles.  When unchecked it forces",
" monochrome linestyles.",
"",
" `Copy to Clipboard` copies a bitmap and a Metafile picture.",
"",
" `Background...` sets the window background color.",
"",
" `Choose Font...` selects the font used in the graphics window.",
"",
" `Line Styles...` allows customization of the line colors and styles.",
"",
" `Print...` prints the graphics windows using a Windows printer driver and",
" allows selection of the printer and scaling of the output.  The output",
" produced by `Print` is not as good as that from `gnuplot`'s own printer",
" drivers.",
"",
" `Update wgnuplot.ini` saves the current window locations, window sizes, text",
" window font, text window font size, graph window font, graph window font",
" size, background color and linestyles to the initialization file",
" `WGNUPLOT.INI`.",
"2 printing",
"?commands set terminal windows printing",
"?set terminal windows printing",
"?set term windows printing",
"?windows printing",
"?printing",
" In order of preference, graphs may be be printed in the following ways.",
"",
" `1.` Use the `gnuplot` command `set terminal` to select a printer and `set",
" output` to redirect output to a file.",
"",
" `2.` Select the `Print...` command from the `gnuplot graph` window.  An extra",
" command `screendump` does this from the text window.",
"",
" `3.` If `set output \"PRN\"` is used, output will go to a temporary file.  When",
" you exit from `gnuplot` or when you change the output with another `set",
" output` command, a dialog box will appear for you to select a printer port.",
" If you choose OK, the output will be printed on the selected port, passing",
" unmodified through the print manager.  It is possible to accidentally (or",
" deliberately) send printer output meant for one printer to an incompatible",
" printer.",
"2 text-menu",
"?commands set terminal windows text-menu",
"?set terminal windows text-menu",
"?set term windows text-menu",
"?windows text-menu",
"?text-menu",
" The `gnuplot text` window has the following options on a pop-up menu accessed",
" by pressing the right mouse button or selecting `Options` from the system",
" menu:",
"",
" `Copy to Clipboard` copies marked text to the clipboard.",
"",
" `Paste` copies text from the clipboard as if typed by the user.",
"",
" `Choose Font...` selects the font used in the text window.",
"",
" `System Colors` when selected makes the text window honor the System Colors",
" set using the Control Panel.  When unselected, text is black or blue on a",
" white background.",
"",
" `Update wgnuplot.ini` saves the current text window location, text window",
" size, text window font and text window font size to the initialisation file",
" `WGNUPLOT.INI`.",
"",
" `MENU BAR`",
"",
" If the menu file `WGNUPLOT.MNU` is found in the same directory as",
" WGNUPLOT.EXE, then the menu specified in `WGNUPLOT.MNU` will be loaded.",
" Menu commands:",
"",
" [Menu] starts a new menu with the name on the following line.",
"",
" [EndMenu] ends the current menu.",
"",
" [--] inserts a horizontal menu separator.",
"",
" [|] inserts a vertical menu separator.",
"",
" [Button] puts the next macro on a push button instead of a menu.",
"",
" Macros take two lines with the macro name (menu entry) on the first line and",
" the macro on the second line.  Leading spaces are ignored.  Macro commands:",
"",
" [INPUT] --- Input string with prompt terminated by [EOS] or {ENTER}",
"",
" [EOS] --- End Of String terminator.  Generates no output.",
"",
" [OPEN] --- Get name of file to open from list box, with title of list box",
" terminated by [EOS], followed by default filename terminated by [EOS] or",
" {ENTER}.  This uses COMMDLG.DLL from Windows 3.1.",
"",
" [SAVE] --- Get name of file to save.  Similar to [OPEN]",
"",
" Macro character substitutions:",
"",
" {ENTER} --- Carriage Return '\\r'",
"",
" {TAB} --- Tab '\\011'",
"",
" {ESC} --- Escape '\\033'",
"",
" {^A} --- '\\001'",
"",
" ...",
"",
" {^_} --- '\\031'",
"",
" Macros are limited to 256 characters after expansion.",
"2 wgnuplot.ini",
"?commands set terminal windows wgnuplot.ini",
"?set terminal windows wgnuplot.ini",
"?set term windows wgnuplot.ini",
"?windows wgnuplot.ini",
"?wgnuplot.ini",
" Windows `gnuplot` will read some of its options from the `[WGNUPLOT]` section",
" of `WGNUPLOT.INI` in the Windows directory.  A sample `WGNUPLOT.INI` file:",
"",
"       [WGNUPLOT]",
"       TextOrigin=0 0",
"       TextSize=640 150",
"       TextFont=Terminal,9",
"       GraphOrigin=0 150",
"       GraphSize=640 330",
"       GraphFont=Arial,10",
"       GraphColor=1",
"       GraphToTop=1",
"       GraphBackground=255 255 255",
"       Border=0 0 0 0 0",
"       Axis=192 192 192 2 2",
"       Line1=0 0 255 0 0",
"       Line2=0 255 0 0 1",
"       Line3=255 0 0 0 2",
"       Line4=255 0 255 0 3",
"       Line5=0 0 128 0 4",
"",
" The `GraphFont` entry specifies the font name and size in points.  The five",
" numbers given in the `Border`, `Axis` and `Line` entries are the `Red`",
" intensity (0--255), `Green` intensity, `Blue` intensity, `Color Linestyle`",
" and `Mono Linestyle`.  `Linestyles` are 0=SOLID, 1=DASH, 2=DOT, 3=DASHDOT,",
" 4=DASHDOTDOT.  In the sample `WGNUPLOT.INI` file above, Line 2 is a green",
" solid line in color mode, or a dashed line in monochrome mode.  The default",
" line width is 1 pixel.  If `Linestyle` is negative, it specifies the width of",
" a SOLID line in pixels.  Line1 and any linestyle used with the `points` style",
" must be SOLID with unit width.",
"2 windows3.0",
"?commands set terminal windows windows3.0",
"?set terminal windows windows3.0",
"?set term windows windows3.0",
"?windows windows3.0",
"?windows3.0",
" Windows 3.1 is preferred, but WGNUPLOT will run under Windows 3.0 with the",
" following restrictions:",
" `1.` COMMDLG.DLL and SHELL.DLL (available with Windows 3.1 or Borland C++",
" 3.1) must be in the windows directory.",
"",
" `2.` WGNUPLOT.HLP produced by Borland C++ 3.1 is in Windows 3.1 format.",
" You need to use the WINHELP.EXE supplied with Borland C++ 3.1.",
"",
" `3.` It will not run in real mode due to lack of memory.",
"",
" `4.` TrueType fonts are not available in the graph window.",
"",
" `5.` Drag-drop does not work."
END_HELP(windows)
START_HELP(x11)
"1 x11",
"?commands set terminal x11",
"?set terminal x11",
"?set term x11",
"?terminal x11",
"?term x11",
"?x11",
"?X11",
" `gnuplot` provides the `x11` terminal type for use with X servers.  This",
" terminal type is set automatically at startup if the `DISPLAY` environment",
" variable is set, if the `TERM` environment variable is set to `xterm`, or",
" if the `-display` command line option is used.",
"",
" Syntax:",
"    set terminal x11 [reset] <n> [[no]enhanced] [font <fontspec>]",
"                     [title \"<string>\"] [[no]persist] [[no]raise] [close]",
"",
" Multiple plot windows are supported: `set terminal x11 <n>` directs the",
" output to plot window number n.  If n>0, the terminal number will be",
" appended to the window title (unless a title has been supplied manually)",
" and the icon will be labeled `gplt <n>`.  The active window may be",
" distinguished by a change in cursor (from default to crosshair.)",
"",
" The x11 terminal support enhanced text mode (see `enhanced`), subject",
" to the available fonts. In order for font size commands embedded in text",
" to have any effect, the default x11 font must be scalable. Thus the first",
" example below will work as expected, but the second will not.",
"",
"    set term x11 enhanced font \"arial,15\" ",
"    set title '{\\=20 Big} Medium {\\=5 Small}' ",
"",
"    set term x11 enhanced font \"terminal-14\" ",
"    set title '{\\=20 Big} Medium {\\=5 Small}' ",
"",
" Plot windows remain open even when the `gnuplot` driver is changed to a",
" different device.  A plot window can be closed by pressing the letter q",
" while that window has input focus, or by choosing `close` from a window",
" manager menu.  All plot windows can be closed by specifying `reset`, which",
" actually terminates the subprocess which maintains the windows (unless",
" `-persist` was specified).  The `close` command can be used to close",
" individual plot windows by number.  However, after a `reset`, those plot",
" windows left due to persist cannot be closed with the command `close`.",
" A `close` without a number closes the current active plot window.",
"",
" The gnuplot outboard driver, gnuplot_x11, is searched in a default place",
" chosen when the program is compiled.  You can override that by defining",
" the environment variable GNUPLOT_DRIVER_DIR to point to a different",
" location.",
"",
" Plot windows will automatically be closed at the end of the session",
" unless the `-persist` option was given.",
"",
" The options `persist` and `raise` are unset by default, which means that",
" the defaults (persist == no and raise == yes) or the command line options",
" -persist / -raise or the Xresources are taken.  If [no]persist or",
" [no]raise are specified, they will override command line options and",
" Xresources.  Setting one of these options takes place immediately, so",
" the behaviour of an already running driver can be modified.",
"",
" The option `title \"<title name>\"` will supply the title name of the window",
" for the current plot window or plot window <n> if a number is given.",
" Where (or if) this title is shown depends on your X window manager.",
"",
" The size or aspect ratio of a plot may be changed by resizing the `gnuplot`",
" window.",
"",
" Linewidths and pointsizes may be changed from within `gnuplot` with",
" `set linestyle`.",
"",
" For terminal type `x11`, `gnuplot` accepts (when initialized) the standard",
" X Toolkit options and resources such as geometry, font, and name from the",
" command line arguments or a configuration file.  See the X(1) man page",
" (or its equivalent) for a description of such options.",
"",
" A number of other `gnuplot` options are available for the `x11` terminal.",
" These may be specified either as command-line options when `gnuplot` is",
" invoked or as resources in the configuration file \".Xdefaults\".  They are",
" set upon initialization and cannot be altered during a `gnuplot` session.",
" (except `persist` and `raise`)",
"2 x11_fonts",
"?commands set terminal x11 x11_fonts",
"?set terminal x11 x11_fonts",
"?set term x11 x11_fonts",
"?x11 x11_fonts",
"?x11_fonts",
" Upon initial startup, the default font is taken from the X11 resources",
" as set in the system or user .Xdefaults file or on the command line.",
"",
" Example:",
"       gnuplot*font: lucidasans-bold-12",
" A new default font may be specified to the x11 driver from inside",
" gnuplot using",
"      `set term x11 font \"<fontspec>\"`",
" The driver first queries the X-server for a font of the exact name given,",
" for example `set term x11 font \"lucidasans-10\"`. If this query fails, then",
" it tries to interpret <fontspec> as \"<font>,<size>,<slant>,<weight>\" ",
" and to construct a full X11 font name of the form",
"       -*-<font>-<weight>-<s>-*-*-<size>-*-*-*-*-*-<encoding>",
"",
"  <font> is the base name of the font (e.g. Times or Symbol)",
"  <size> is the point size (defaults to 12 if not specified)",
"  <s> is `i` if <slant>==\"italic\" `o` if <slant>==\"oblique\" `r` otherwise",
"  <weight> is `medium` or `bold` if explicitly requested, otherwise `*`",
"  <encoding> is set based on the current character set (see help for `set encoding`).",
" So `set term x11 font \"arial,15,italic\"` will be translated to",
" -*-arial-*-i-*-*-15-*-*-*-*-*-iso8859-1 (assuming default encoding).",
" The <size>, <slant>, and <weight> specifications are all optional.",
" If you do not specify <slant> or <weight> then you will get whatever font ",
" variant the font server offers first.",
" The driver also recognizes some common PostScript font names and",
" replaces them with possible X11 or TrueType equivalents.",
" This same sequence is used to process font requests from `set label`.",
"2 command-line_options",
"?commands set terminal x11 command-line-options",
"?set terminal x11 command-line-options",
"?set term x11 command-line-options",
"?x11 command-line-options",
"?command-line-options",
" In addition to the X Toolkit options, the following options may be specified",
" on the command line when starting `gnuplot` or as resources in your",
" \".Xdefaults\" file (note that `raise` and `persist` can be overridden",
" later by `set term x11 [no]raise [no]persist)`:",
"@start table - first is interactive cleartext form",
"  `-mono`     forces monochrome rendering on color displays.",
"  `-gray`     requests grayscale rendering on grayscale or color displays.",
"              (Grayscale displays receive monochrome rendering by default.)",
"  `-clear`    requests that the window be cleared momentarily before a",
"              new plot is displayed.",
"  `-tvtwm`    requests that geometry specifications for position of the",
"              window be made relative to the currently displayed portion",
"              of the virtual root.",
"  `-raise`    raises plot window after each plot",
"  `-noraise`  does not raise plot window after each plot",
"  `-noevents` does not process mouse and key events",
"  `-persist`  plot windows survive after main gnuplot program exits",
"#\\begin{tabular}{|cl|} \\hline",
"#`-mono`     & forces monochrome rendering on color displays.\\\\",
"#`-gray`     & requests grayscale rendering on grayscale or color displays.\\\\",
"#            & (Grayscale displays receive monochrome rendering by default.) \\\\",
"#`-clear`    & requests that the window be cleared momentarily before a\\\\",
"#            & new plot is displayed. \\\\",
"#`-tvtwm`    & requests that geometry specifications for position of the\\\\",
"#            & window be made relative to the currently displayed portion\\\\",
"#            & of the virtual root. \\\\",
"#`-raise`    & raises plot window after each plot. \\\\",
"#`-noraise`  & does not raise plot window after each plot. \\\\",
"#`-noevents` & does not process mouse and key events. \\\\",
"#`-persist`  & plot windows survive after main gnuplot program exits. \\\\",
"%c l .",
"%`-mono`@forces monochrome rendering on color displays.",
"%`-gray`@requests grayscale rendering on grayscale or color displays.",
"%       @(Grayscale displays receive monochrome rendering by default.)",
"%`-clear`@requests that the window be cleared momentarily before a",
"%        @new plot is displayed.",
"%`-tvtwm`@requests that geometry specifications for position of the",
"%        @window be made relative to the currently displayed portion",
"%        @of the virtual root.",
"%`-raise`@raises plot window after each plot",
"%`-noraise`@does not raise plot window after each plot",
"%`-novevents`@does not process mouse and key events",
"%`-persist`@plot windows survive after main gnuplot program exits",
"@end table",
" The options are shown above in their command-line syntax.  When entered as",
" resources in \".Xdefaults\", they require a different syntax.",
"",
" Example:",
"       gnuplot*gray: on",
"",
" `gnuplot` also provides a command line option (`-pointsize <v>`) and a",
" resource, `gnuplot*pointsize: <v>`, to control the size of points plotted",
" with the `points` plotting style.  The value `v` is a real number (greater",
" than 0 and less than or equal to ten) used as a scaling factor for point",
" sizes.  For example, `-pointsize 2` uses points twice the default size, and",
" `-pointsize 0.5` uses points half the normal size.",
"",
" The `-noevents` switch disables all mouse and key event processing (except",
" for `q` and `<space>` for closing the window). This is useful for programs",
" which use the x11 driver independent of the gnuplot main program.",
"2 monochrome_options",
"?commands set terminal x11 monochrome_options",
"?set terminal x11 monochrome_options",
"?set term x11 monochrome_options",
"?x11 monochrome_options",
"?monochrome_options",
" For monochrome displays, `gnuplot` does not honor foreground or background",
" colors.  The default is black-on-white.  `-rv` or `gnuplot*reverseVideo: on`",
" requests white-on-black.",
"",
"2 color_resources",
"?commands set terminal x11 color_resources",
"?set terminal x11 color_resources",
"?set term x11 color_resources",
"?x11 color_resources",
"?color_resources",
" For color displays, `gnuplot` honors the following resources (shown here",
" with their default values) or the greyscale resources.  The values may be",
" color names as listed in the X11 rgb.txt file on your system, hexadecimal",
" RGB color specifications (see X11 documentation), or a color name followed",
" by a comma and an `intensity` value from 0 to 1.  For example, `blue, 0.5`",
" means a half intensity blue.",
"@start table - first is interactive cleartext form",
"  gnuplot*background:  white",
"  gnuplot*textColor:   black",
"  gnuplot*borderColor: black",
"  gnuplot*axisColor:   black",
"  gnuplot*line1Color:  red",
"  gnuplot*line2Color:  green",
"  gnuplot*line3Color:  blue",
"  gnuplot*line4Color:  magenta",
"  gnuplot*line5Color:  cyan",
"  gnuplot*line6Color:  sienna",
"  gnuplot*line7Color:  orange",
"  gnuplot*line8Color:  coral",
"#\\begin{tabular}{|cl|} \\hline",
"#&gnuplot*background: white\\\\",
"#&gnuplot*textColor: black\\\\",
"#&gnuplot*borderColor: black\\\\",
"#&gnuplot*axisColor: black\\\\",
"#&gnuplot*line1Color: red\\\\",
"#&gnuplot*line2Color: green\\\\",
"#&gnuplot*line3Color: blue\\\\",
"#&gnuplot*line4Color: magenta\\\\",
"#&gnuplot*line5Color: cyan\\\\",
"#&gnuplot*line6Color: sienna\\\\",
"#&gnuplot*line7Color: orange\\\\",
"#&gnuplot*line8Color: coral\\\\",
"%c l .",
"%@gnuplot*background: white",
"%@gnuplot*textColor: black",
"%@gnuplot*borderColor: black",
"%@gnuplot*axisColor: black",
"%@gnuplot*line1Color: red",
"%@gnuplot*line2Color: green",
"%@gnuplot*line3Color: blue",
"%@gnuplot*line4Color: magenta",
"%@gnuplot*line5Color: cyan",
"%@gnuplot*line6Color: sienna",
"%@gnuplot*line7Color: orange",
"%@gnuplot*line8Color: coral",
"@end table",
"",
" The command-line syntax for these is simple only for background,",
" which maps directly to the usual X11 toolkit option \"-bg\".  All",
" others can only be set on the command line by use of the generic",
" \"-xrm\" resource override option",
"",
" Examples:",
"",
"       gnuplot -background coral",
" to change the background color.",
"",
"       gnuplot -xrm 'gnuplot*line1Color:blue'",
" to override the first linetype color.",
"",
"2 grayscale_resources",
"?commands set terminal x11 grayscale_resources",
"?set terminal x11 grayscale_resources",
"?set term x11 grayscale_resources",
"?x11 grayscale_resources",
"?grayscale_resources",
" When `-gray` is selected, `gnuplot` honors the following resources for",
" grayscale or color displays (shown here with their default values).  Note",
" that the default background is black.",
"@start table - first is interactive cleartext form",
"  gnuplot*background: black",
"  gnuplot*textGray:   white",
"  gnuplot*borderGray: gray50",
"  gnuplot*axisGray:   gray50",
"  gnuplot*line1Gray:  gray100",
"  gnuplot*line2Gray:  gray60",
"  gnuplot*line3Gray:  gray80",
"  gnuplot*line4Gray:  gray40",
"  gnuplot*line5Gray:  gray90",
"  gnuplot*line6Gray:  gray50",
"  gnuplot*line7Gray:  gray70",
"  gnuplot*line8Gray:  gray30",
"#\\begin{tabular}{|cl|} \\hline",
"#&gnuplot*background: black\\\\",
"#&gnuplot*textGray: white\\\\",
"#&gnuplot*borderGray: gray50\\\\",
"#&gnuplot*axisGray: gray50\\\\",
"#&gnuplot*line1Gray: gray100\\\\",
"#&gnuplot*line2Gray: gray60\\\\",
"#&gnuplot*line3Gray: gray80\\\\",
"#&gnuplot*line4Gray: gray40\\\\",
"#&gnuplot*line5Gray: gray90\\\\",
"#&gnuplot*line6Gray: gray50\\\\",
"#&gnuplot*line7Gray: gray70\\\\",
"#&gnuplot*line8Gray: gray30\\\\",
"%c l .",
"%@gnuplot*background: black",
"%@gnuplot*textGray: white",
"%@gnuplot*borderGray: gray50",
"%@gnuplot*axisGray: gray50",
"%@gnuplot*line1Gray: gray100",
"%@gnuplot*line2Gray: gray60",
"%@gnuplot*line3Gray: gray80",
"%@gnuplot*line4Gray: gray40",
"%@gnuplot*line5Gray: gray90",
"%@gnuplot*line6Gray: gray50",
"%@gnuplot*line7Gray: gray70",
"%@gnuplot*line8Gray: gray30",
"@end table",
"",
"2 line_resources",
"?commands set terminal x11 line_resources",
"?set terminal x11 line_resources",
"?set term x11 line_resources",
"?x11 line_resources",
"?line_resources",
" `gnuplot` honors the following resources for setting the width (in pixels) of",
" plot lines (shown here with their default values.)  0 or 1 means a minimal",
" width line of 1 pixel width.  A value of 2 or 3 may improve the appearance of",
" some plots.",
"@start table - first is interactive cleartext form",
"  gnuplot*borderWidth: 2",
"  gnuplot*axisWidth:   0",
"  gnuplot*line1Width:  0",
"  gnuplot*line2Width:  0",
"  gnuplot*line3Width:  0",
"  gnuplot*line4Width:  0",
"  gnuplot*line5Width:  0",
"  gnuplot*line6Width:  0",
"  gnuplot*line7Width:  0",
"  gnuplot*line8Width:  0",
"#\\begin{tabular}{|cl|} \\hline",
"#&gnuplot*borderWidth: 2\\\\",
"#&gnuplot*axisWidth: 0\\\\",
"#&gnuplot*line1Width: 0\\\\",
"#&gnuplot*line2Width: 0\\\\",
"#&gnuplot*line3Width: 0\\\\",
"#&gnuplot*line4Width: 0\\\\",
"#&gnuplot*line5Width: 0\\\\",
"#&gnuplot*line6Width: 0\\\\",
"#&gnuplot*line7Width: 0\\\\",
"#&gnuplot*line8Width: 0\\\\",
"%c l .",
"%@gnuplot*borderWidth: 2",
"%@gnuplot*axisWidth: 0",
"%@gnuplot*line1Width: 0",
"%@gnuplot*line2Width: 0",
"%@gnuplot*line3Width: 0",
"%@gnuplot*line4Width: 0",
"%@gnuplot*line5Width: 0",
"%@gnuplot*line6Width: 0",
"%@gnuplot*line7Width: 0",
"%@gnuplot*line8Width: 0",
"@end table",
"",
" `gnuplot` honors the following resources for setting the dash style used for",
" plotting lines.  0 means a solid line.  A two-digit number `jk` (`j` and `k`",
" are >= 1  and <= 9) means a dashed line with a repeated pattern of `j` pixels",
" on followed by `k` pixels off.  For example, '16' is a \"dotted\" line with one",
" pixel on followed by six pixels off.  More elaborate on/off patterns can be",
" specified with a four-digit value.  For example, '4441' is four on, four off,",
" four on, one off.  The default values shown below are for monochrome displays",
" or monochrome rendering on color or grayscale displays.  For color displays,",
" the default for each is 0 (solid line) except for `axisDashes` which defaults",
" to a '16' dotted line.",
"@start table - first is interactive cleartext form",
"  gnuplot*borderDashes:   0",
"  gnuplot*axisDashes:    16",
"  gnuplot*line1Dashes:    0",
"  gnuplot*line2Dashes:   42",
"  gnuplot*line3Dashes:   13",
"  gnuplot*line4Dashes:   44",
"  gnuplot*line5Dashes:   15",
"  gnuplot*line6Dashes: 4441",
"  gnuplot*line7Dashes:   42",
"  gnuplot*line8Dashes:   13",
"#\\begin{tabular}{|cl|} \\hline",
"#&gnuplot*borderDashes: 0\\\\",
"#&gnuplot*axisDashes: 16\\\\",
"#&gnuplot*line1Dashes: 0\\\\",
"#&gnuplot*line2Dashes: 42\\\\",
"#&gnuplot*line3Dashes: 13\\\\",
"#&gnuplot*line4Dashes: 44\\\\",
"#&gnuplot*line5Dashes: 15\\\\",
"#&gnuplot*line6Dashes: 4441\\\\",
"#&gnuplot*line7Dashes: 42\\\\",
"#&gnuplot*line8Dashes: 13\\\\",
"%c l .",
"%@gnuplot*borderDashes: 0",
"%@gnuplot*axisDashes: 16",
"%@gnuplot*line1Dashes: 0",
"%@gnuplot*line2Dashes: 42",
"%@gnuplot*line3Dashes: 13",
"%@gnuplot*line4Dashes: 44",
"%@gnuplot*line5Dashes: 15",
"%@gnuplot*line6Dashes: 4441",
"%@gnuplot*line7Dashes: 42",
"%@gnuplot*line8Dashes: 13",
"@end table"
, "",
"2 x11 pm3d_resources",
"?commands set terminal x11 pm3d_resources",
"?set terminal x11 pm3d_resources",
"?set term x11 pm3d_resources",
"?x11 pm3d_resources",
"?pm3d_resources",
"?x11 pm3d",
" Choosing the appropriate visual class and number of colors is a crucial",
" point in X11 applications and a bit awkward, since X11 supports six visual",
" types in different depths.",
"",
" By default `gnuplot` uses the default visual of the screen. The number of",
" colors which can be allocated depends on the visual class chosen. On a",
" visual class with a depth > 12bit, gnuplot starts with a maximal number",
" of 0x200 colors.  On a visual class with a depth > 8bit (but <= 12 bit)",
" the maximal number of colors is 0x100, on <= 8bit displays the maximum",
" number of colors is 240 (16 are left for line colors).",
"",
" Gnuplot first starts to allocate the maximal number of colors as stated",
" above.  If this fails, the number of colors is reduced by the factor 2",
" until gnuplot gets all colors which are requested. If dividing `maxcolors`",
" by 2 repeatedly results in a number which is smaller than `mincolors`",
" `gnuplot` tries to install a private colormap. In this case the window",
" manager is responsible for swapping colormaps when the pointer is moved",
" in and out the x11 driver's window.",
"",
" The default for `mincolors` is maxcolors / (num_colormaps > 1 ? 2 : 8),",
" where num_colormaps is the number of colormaps which are currently used",
" by gnuplot (usually 1, if only one x11 window is open).",
"",
" Some systems support multiple (different) visual classes together on one",
" screen. On these systems it might be necessary to force gnuplot to use a",
" specific visual class, e.g. the default visual might be 8bit PseudoColor",
" but the screen would also support 24bit TrueColor which would be the",
" preferred choice.",
"",
" The information about an Xserver's capabilities can be obtained with the",
" program `xdpyinfo`.  For the visual names below you can choose one of",
" StaticGray, GrayScale, StaticColor, PseudoColor, TrueColor, DirectColor.",
" If an Xserver supports a requested visual type at different depths,",
" `gnuplot` chooses the visual class with the highest depth (deepest).",
" If the requested visual class matches the default visual and multiple",
" classes of this type are supported, the default visual is preferred.",
"",
" Example: on an 8bit PseudoColor visual you can force a private color map",
" by specifying `gnuplot*maxcolors: 240` and `gnuplot*mincolors: 240`.",
"",
"@start table - first is interactive cleartext form",
"  gnuplot*maxcolors:  <integer number>",
"  gnuplot*mincolors:  <integer number>",
"  gnuplot*visual:     <visual name>",
"#\\begin{tabular}{|cl|} \\hline",
"#&gnuplot*maxcolors:  <integer number>\\\\",
"#&gnuplot*mincolors:  <integer number>\\\\",
"#&gnuplot*visual:     <visual name>\\\\",
"%c l .",
"%@gnuplot*maxcolors:  <integer number>",
"%@gnuplot*mincolors:  <integer number>",
"%@gnuplot*visual:     <visual name>",
"@end table"
END_HELP(x11)
START_HELP(xlib)
"1 xlib",
"?commands set terminal xlib",
"?set terminal xlib",
"?set term xlib",
"?terminal xlib",
"?term xlib",
"?xlib",
" The `xlib` terminal driver supports the X11 Windows System.  It generates",
" gnuplot_x11 commands, but sends them to the output file specified by",
" `set output '<filename>'`. `set term x11` is equivalent to",
" `set terminal xlib; set output \"|gnuplot_x11 -noevents\"`.",
" `xlib` takes the same set of options as `x11`."
END_HELP(xlib)
