/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import gnu.java.awt.java2d.PolyEdge;

final class ActiveEdges {
    private PolyEdge[] activeEdges = new PolyEdge[8];
    private int numActiveEdges = 0;

    ActiveEdges() {
    }

    void clear() {
        this.numActiveEdges = 0;
    }

    void add(PolyEdge edge) {
        int oldSize = this.activeEdges.length;
        if (this.numActiveEdges >= oldSize) {
            int newSize = oldSize + oldSize / 4 + 1;
            PolyEdge[] newEdges = new PolyEdge[newSize];
            System.arraycopy(this.activeEdges, 0, newEdges, 0, oldSize);
            this.activeEdges = newEdges;
        }
        this.activeEdges[this.numActiveEdges] = edge;
        ++this.numActiveEdges;
    }

    void intersectSortAndPack(int n, int y) {
        int last = 0;
        int i = 0;
        while (i < this.numActiveEdges) {
            PolyEdge edge = this.activeEdges[i];
            if (edge != null && edge.y1 >= y) {
                assert (edge.y1 >= y && edge.y0 <= y) : "edge must cross scanline";
                edge.intersect(n, y);
                this.activeEdges[last] = edge;
                int j = ++last - 1;
                while (j > 0) {
                    if (this.activeEdges[j].xIntersection >= this.activeEdges[j - 1].xIntersection) break;
                    PolyEdge tmp = this.activeEdges[j];
                    this.activeEdges[j] = this.activeEdges[j - 1];
                    this.activeEdges[j - 1] = tmp;
                    --j;
                }
            }
            ++i;
        }
        this.numActiveEdges = last;
    }

    int getNumActiveEdges() {
        return this.numActiveEdges;
    }

    PolyEdge getActiveEdge(int i) {
        return this.activeEdges[i];
    }

    void remove(int y) {
        int i = 0;
        while (i < this.numActiveEdges) {
            PolyEdge edge = this.activeEdges[i];
            if (edge != null && edge.y1 < y) {
                this.activeEdges[i] = null;
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[ActiveEdges] ");
        int i = 0;
        while (i < this.numActiveEdges) {
            s.append(this.activeEdges[i]);
            s.append(',');
            ++i;
        }
        return s.toString();
    }
}

