/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class ZoneInfo
extends TimeZone {
    private static final int SECS_SHIFT = 22;
    private static final long OFFSET_MASK = 0x1FFFFFL;
    private static final int OFFSET_SHIFT = 43;
    private static final long IS_DST = 0x200000L;
    private int rawOffset;
    private int dstSavings;
    private boolean useDaylight;
    private long[] transitions;
    private SimpleTimeZone lastRule;
    private static SimpleTimeZone gmtZone = null;
    static final long serialVersionUID = -3740626706860383657L;

    public ZoneInfo(int rawOffset, String id, long[] transitions, SimpleTimeZone lastRule) {
        if (transitions == null || transitions.length < 1) {
            throw new IllegalArgumentException("transitions must not be null");
        }
        if (lastRule == null) {
            throw new IllegalArgumentException("lastRule must not be null");
        }
        this.rawOffset = rawOffset;
        this.transitions = transitions;
        this.lastRule = lastRule;
        this.setID(id);
        this.computeDSTSavings();
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        if (gmtZone == null) {
            gmtZone = new SimpleTimeZone(0, "GMT");
        }
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException("dayOfWeek out of range");
        }
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("month out of range:" + month);
        }
        if (era != 1) {
            return (int)((this.transitions[0] << 43 >> 43) * 1000L);
        }
        GregorianCalendar cal = new GregorianCalendar(gmtZone);
        cal.set(year, month, day, 0, 0, 0);
        if (cal.get(5) != day) {
            throw new IllegalArgumentException("day out of range");
        }
        return this.getOffset(cal.getTimeInMillis() - (long)this.rawOffset + (long)millis);
    }

    private long findTransition(long secs) {
        if (secs < this.transitions[0] >> 22) {
            return this.transitions[0];
        }
        if (secs >= this.transitions[this.transitions.length - 1] >> 22) {
            return Long.MAX_VALUE;
        }
        long val = secs + 1L << 22;
        int lo = 1;
        int hi = this.transitions.length;
        int mid = 1;
        while (lo < hi) {
            mid = (lo + hi) / 2;
            if (val <= this.transitions[mid - 1]) {
                hi = mid;
                continue;
            }
            if (val <= this.transitions[mid]) break;
            lo = mid + 1;
        }
        return this.transitions[mid];
    }

    public int getOffset(long date) {
        long d = date >= 0L ? date / 1000L : (date + 1L) / 1000L - 1L;
        long transition = this.findTransition(d);
        if (transition == Long.MAX_VALUE) {
            return this.lastRule.getOffset(date);
        }
        return (int)((transition << 43 >> 43) * 1000L);
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int rawOffset) {
        this.rawOffset = rawOffset;
        this.lastRule.setRawOffset(rawOffset);
    }

    private void computeDSTSavings() {
        if (this.lastRule.useDaylightTime()) {
            this.dstSavings = this.lastRule.getDSTSavings();
            this.useDaylight = true;
        } else {
            this.dstSavings = 0;
            this.useDaylight = false;
            long currentSecs = System.currentTimeMillis() / 1000L;
            int i = this.transitions.length - 1;
            while (i >= 0 && currentSecs < this.transitions[i] >> 22) {
                if ((this.transitions[i] & 0x200000L) != 0L) {
                    this.dstSavings = (int)((this.transitions[i] << 43 >> 43) * 1000L) - this.rawOffset;
                    this.useDaylight = true;
                    break;
                }
                --i;
            }
        }
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    public boolean inDaylightTime(Date date) {
        long d = date.getTime();
        d = d >= 0L ? d / 1000L : (d + 1L) / 1000L - 1L;
        long transition = this.findTransition(d);
        if (transition == Long.MAX_VALUE) {
            return this.lastRule.inDaylightTime(date);
        }
        return (transition & 0x200000L) != 0L;
    }

    public synchronized int hashCode() {
        int hash = this.lastRule.hashCode();
        return hash;
    }

    public synchronized boolean equals(Object o) {
        if (!this.hasSameRules((TimeZone)o)) {
            return false;
        }
        ZoneInfo zone = (ZoneInfo)o;
        return this.getID().equals(zone.getID());
    }

    public boolean hasSameRules(TimeZone o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo zone = (ZoneInfo)o;
        if (zone.hashCode() != this.hashCode() || this.rawOffset != zone.rawOffset) {
            return false;
        }
        return this.lastRule.equals(zone.lastRule);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + "id=" + this.getID() + ",offset=" + this.rawOffset + ",transitions=" + this.transitions.length + ",useDaylight=" + this.useDaylight + (this.useDaylight ? ",dstSavings=" + this.dstSavings : "") + ",lastRule=" + this.lastRule.toString() + "]";
    }

    /*
     * Unable to fully structure code
     */
    public static TimeZone readTZFile(String id, String file) {
        block88: {
            block89: {
                block87: {
                    dis = null;
                    fis = new FileInputStream(file);
                    bis = new BufferedInputStream(fis);
                    dis = new DataInputStream(bis);
                    tzif = new byte[5];
                    dis.readFully(tzif);
                    tzif2 = 4;
                    if (tzif[0] == 84 && tzif[1] == 90 && tzif[2] == 105 && tzif[3] == 102) {
                        if (tzif[4] >= 50) {
                            tzif2 = 8;
                        }
                        ZoneInfo.skipFully(dis, 15L);
                    } else {
                        ZoneInfo.skipFully(dis, 11L);
                    }
                    ttisgmtcnt = dis.readInt();
                    ttisstdcnt = dis.readInt();
                    leapcnt = dis.readInt();
                    timecnt = dis.readInt();
                    typecnt = dis.readInt();
                    charcnt = dis.readInt();
                    if (tzif2 != 8) ** GOTO lbl41
                    ZoneInfo.skipFully(dis, timecnt * 5 + typecnt * 6 + charcnt + leapcnt * 8 + ttisgmtcnt + ttisstdcnt);
                    dis.readFully(tzif);
                    if (tzif[0] == 84 && tzif[1] == 90 && tzif[2] == 105 && tzif[3] == 102 && tzif[4] >= 50) break block87;
lbl25:
                    // 8 sources

                    while (true) {
                        try {
                            if (dis != null) {
                                dis.close();
                            }
                        }
                        catch (IOException v0) {}
                        return null;
                    }
                }
                ZoneInfo.skipFully(dis, 15L);
                ttisgmtcnt = dis.readInt();
                ttisstdcnt = dis.readInt();
                leapcnt = dis.readInt();
                timecnt = dis.readInt();
                typecnt = dis.readInt();
                charcnt = dis.readInt();
lbl41:
                // 2 sources

                if (typecnt <= 0 || timecnt < 0 || charcnt < 0 || leapcnt < 0 || ttisgmtcnt < 0 || ttisstdcnt < 0 || ttisgmtcnt > typecnt || ttisstdcnt > typecnt) ** GOTO lbl25
                times = new long[timecnt];
                i = 0;
                while (i < timecnt) {
                    times[i] = tzif2 == 8 ? dis.readLong() : (long)dis.readInt();
                    ++i;
                }
                types = new int[timecnt];
                i = 0;
                while (i < timecnt) {
                    types[i] = dis.readByte();
                    if (types[i] < 0) {
                        v1 = i;
                        types[v1] = types[v1] + 256;
                    }
                    if (types[i] >= typecnt) ** GOTO lbl25
                    ++i;
                }
                offsets = new int[typecnt];
                typeflags = new int[typecnt];
                i = 0;
                while (i < typecnt) {
                    offsets[i] = dis.readInt();
                    if ((long)offsets[i] >= 0x100000L || (long)offsets[i] <= -1048576L) ** GOTO lbl25
                    dst = dis.readByte();
                    abbrind = dis.readByte();
                    if (abbrind < 0) {
                        abbrind += 256;
                    }
                    if (abbrind >= charcnt) ** GOTO lbl25
                    typeflags[i] = (dst != 0 ? 256 : 0) + abbrind;
                    ++i;
                }
                names = new byte[charcnt];
                dis.readFully(names);
                ZoneInfo.skipFully(dis, leapcnt * (tzif2 + 4) + ttisstdcnt + ttisgmtcnt);
                tzstr = null;
                if (tzif2 == 8 && dis.readByte() == 10 && (tzstr = dis.readLine()).length() <= 0) {
                    tzstr = null;
                }
                std_ind = -1;
                dst_ind = -1;
                if (timecnt == 0) {
                    std_ind = 0;
                } else {
                    i = timecnt - 1;
                    while (i >= 0) {
                        if (std_ind == -1 && (typeflags[types[i]] & 256) == 0) {
                            std_ind = types[i];
                        } else if (dst_ind == -1 && (typeflags[types[i]] & 256) != 0) {
                            dst_ind = types[i];
                        }
                        if (dst_ind != -1 && std_ind != -1) break;
                        --i;
                    }
                }
                if (std_ind == -1) ** GOTO lbl25
                j = typeflags[std_ind] & 255;
                while (j < charcnt && names[j] != 0) {
                    ++j;
                }
                std_zonename = new String(names, typeflags[std_ind] & 255, j - (typeflags[std_ind] & 255), "ASCII");
                dst_zonename = "";
                if (dst_ind != -1) {
                    j = typeflags[dst_ind] & 255;
                    while (j < charcnt && names[j] != 0) {
                        ++j;
                    }
                    dst_zonename = new String(names, typeflags[dst_ind] & 255, j - (typeflags[dst_ind] & 255), "ASCII");
                }
                std_offset_string = "";
                dst_offset_string = "";
                if (tzstr == null && (dst_ind != -1 || offsets[std_ind] != 0 && !std_zonename.startsWith("GMT+") && !std_zonename.startsWith("GMT-"))) {
                    std_offset_string = Integer.toString(-offsets[std_ind] / 3600);
                    seconds = -offsets[std_ind] % 3600;
                    if (seconds != 0) {
                        if (seconds < 0) {
                            seconds *= -1;
                        }
                        std_offset_string = seconds < 600 ? String.valueOf(std_offset_string) + ":0" + Integer.toString(seconds / 60) : String.valueOf(std_offset_string) + ":" + Integer.toString(seconds / 60);
                        if ((seconds %= 60) >= 10) {
                            std_offset_string = String.valueOf(std_offset_string) + ":" + Integer.toString(seconds);
                        } else if (seconds > 0) {
                            std_offset_string = String.valueOf(std_offset_string) + ":0" + Integer.toString(seconds);
                        }
                    }
                    if (dst_ind != -1 && offsets[dst_ind] != offsets[std_ind] + 3600) {
                        dst_offset_string = Integer.toString(-offsets[dst_ind] / 3600);
                        seconds = -offsets[dst_ind] % 3600;
                        if (seconds != 0) {
                            if (seconds < 0) {
                                seconds *= -1;
                            }
                            dst_offset_string = seconds < 600 ? String.valueOf(dst_offset_string) + ":0" + Integer.toString(seconds / 60) : String.valueOf(dst_offset_string) + ":" + Integer.toString(seconds / 60);
                            if ((seconds %= 60) >= 10) {
                                dst_offset_string = String.valueOf(dst_offset_string) + ":" + Integer.toString(seconds);
                            } else if (seconds > 0) {
                                dst_offset_string = String.valueOf(dst_offset_string) + ":0" + Integer.toString(seconds);
                            }
                        }
                    }
                }
                change_spec = new String[2];
                if (tzstr != null || dst_ind == -1 || timecnt <= 10) break block89;
                nowPlus5y = System.currentTimeMillis() / 1000L + 157680000L;
                first = timecnt - 1;
                while (first >= 0) {
                    if (times[first] < nowPlus5y || types[first] != std_ind && types[first] != dst_ind || types[first] != types[timecnt - 2 + ((first ^ timecnt) & 1)]) break;
                    --first;
                }
                if (timecnt - ++first < 10 || types[timecnt - 1] == types[timecnt - 2]) break block89;
                cal = new GregorianCalendar(new SimpleTimeZone(0, "GMT"));
                values = new int[22];
                i = timecnt - 1;
                while (i >= first) {
                    base = i % 2 * 11;
                    offset = offsets[types[i > first ? i - 1 : i + 1]];
                    cal.setTimeInMillis((times[i] + (long)offset) * 1000L);
                    if (i >= timecnt - 2) {
                        values[base + 0] = cal.get(1);
                        values[base + 1] = cal.get(2);
                        values[base + 2] = cal.get(5);
                        values[base + 3] = cal.getActualMaximum(5);
                        values[base + 4] = cal.get(7);
                        values[base + 5] = cal.get(11);
                        values[base + 6] = cal.get(12);
                        values[base + 7] = cal.get(13);
                        values[base + 8] = values[base + 2];
                        values[base + 9] = values[base + 2];
                        values[base + 10] = 0;
                    } else {
                        year = cal.get(1);
                        month = cal.get(2);
                        day_of_month = cal.get(5);
                        month_days = cal.getActualMaximum(5);
                        day_of_week = cal.get(7);
                        hour = cal.get(11);
                        minute = cal.get(12);
                        second = cal.get(13);
                        if (year != values[base + 0] - 1 || month != values[base + 1] || hour != values[base + 5] || minute != values[base + 6] || second != values[base + 7]) break;
                        if (day_of_week == values[base + 4]) {
                            if (day_of_month < values[base + 8]) {
                                values[base + 8] = day_of_month;
                            }
                            if (day_of_month > values[base + 9]) {
                                values[base + 9] = day_of_month;
                            }
                            if (values[base + 10] < 0) break;
                            if (values[base + 10] == 0) {
                                values[base + 10] = 1;
                                if (values[base + 2] > 28) {
                                    values[base + 2] = 3;
                                } else if (values[base + 2] <= values[base + 3] - 7) {
                                    values[base + 3] = 2;
                                }
                            }
                            if (values[base + 10] == 1) {
                                if (day_of_month > 28) {
                                    values[base + 10] = 3;
                                } else if (day_of_month <= month_days - 7) {
                                    values[base + 10] = 2;
                                }
                            } else if (values[base + 10] == 2 && day_of_month > 28 || values[base + 10] == 3 && day_of_month <= month_days - 7) {
                                break;
                            }
                        } else {
                            if (day_of_month != values[base + 2] || values[base + 10] > 0) break;
                            values[base + 4] = day_of_week;
                            values[base + 10] = -1;
                        }
                        v2 = base + 0;
                        values[v2] = values[v2] - 1;
                    }
                    --i;
                }
                if (i >= first) break block89;
                i = 0;
                while (i < 2) {
                    block90: {
                        block92: {
                            block93: {
                                block91: {
                                    base = 11 * i;
                                    if (values[base + 10] == 0) break block90;
                                    if (values[base + 10] != -1) break block91;
                                    v3 = new int[12];
                                    v3[1] = 31;
                                    v3[2] = 59;
                                    v3[3] = 90;
                                    v3[4] = 120;
                                    v3[5] = 151;
                                    v3[6] = 181;
                                    v3[7] = 212;
                                    v3[8] = 243;
                                    v3[9] = 273;
                                    v3[10] = 304;
                                    v3[11] = 334;
                                    dayCount = v3;
                                    d = dayCount[values[base + 1] - 0];
                                    change_spec[i] = ",J" + Integer.toString(d += values[base + 2]);
                                    break block92;
                                }
                                if (values[base + 10] != 2) break block93;
                                if (values[base + 8] + 6 != values[base + 9]) break block90;
                                d = values[base + 1] - 0 + 1;
                                if (values[base + 8] % 7 == 1) {
                                    change_spec[i] = ",M" + Integer.toString(d);
                                    d = (values[base + 8] + 6) / 7;
                                } else {
                                    change_spec[i] = ",A" + Integer.toString(d);
                                    d = values[base + 8];
                                }
                                v4 = i;
                                change_spec[v4] = String.valueOf(change_spec[v4]) + "." + Integer.toString(d);
                                d = values[base + 4] - 1;
                                v5 = i;
                                change_spec[v5] = String.valueOf(change_spec[v5]) + "." + Integer.toString(d);
                                break block92;
                            }
                            if (values[base + 10] == 1 && values[base + 1] != 1) break block90;
                            d = values[base + 1] - 0 + 1;
                            change_spec[i] = ",M" + Integer.toString(d);
                            d = values[base + 4] - 1;
                            v6 = i;
                            change_spec[v6] = String.valueOf(change_spec[v6]) + ".5." + Integer.toString(d);
                        }
                        if (values[base + 5] != 2 || values[base + 6] != 0 || values[base + 7] != 0) {
                            d = values[base + 5];
                            v7 = i;
                            change_spec[v7] = String.valueOf(change_spec[v7]) + "/" + Integer.toString(d);
                            if (values[base + 6] != 0 || values[base + 7] != 0) {
                                d = values[base + 6];
                                if (d < 10) {
                                    v8 = i;
                                    change_spec[v8] = String.valueOf(change_spec[v8]) + ":0" + Integer.toString(d);
                                } else {
                                    v9 = i;
                                    change_spec[v9] = String.valueOf(change_spec[v9]) + ":" + Integer.toString(d);
                                }
                                d = values[base + 7];
                                if (d >= 10) {
                                    v10 = i;
                                    change_spec[v10] = String.valueOf(change_spec[v10]) + ":" + Integer.toString(d);
                                } else if (d > 0) {
                                    v11 = i;
                                    change_spec[v11] = String.valueOf(change_spec[v11]) + ":0" + Integer.toString(d);
                                }
                            }
                        }
                    }
                    ++i;
                }
                if (types[timecnt - 1 & -2] == std_ind) {
                    tmp = change_spec[0];
                    change_spec[0] = change_spec[1];
                    change_spec[1] = tmp;
                }
            }
            if (tzstr == null) {
                tzstr = String.valueOf(std_zonename) + std_offset_string;
                if (change_spec[0] != null && change_spec[1] != null) {
                    tzstr = String.valueOf(tzstr) + dst_zonename + dst_offset_string + change_spec[0] + change_spec[1];
                }
            }
            if (timecnt != 0) break block88;
            var44_51 = new SimpleTimeZone(offsets[std_ind] * 1000, id != null ? id : tzstr);
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException v12) {}
            return var44_51;
        }
        endRule = ZoneInfo.createLastRule(tzstr);
        if (endRule == null) ** GOTO lbl25
        i = 0;
        while (i < typecnt) {
            if ((typeflags[i] & 256) == 0) {
                times[0] = times[0] << 22 | (long)offsets[i] & 0x1FFFFFL;
                break;
            }
            ++i;
        }
        i = 1;
        while (i < timecnt) {
            times[i] = times[i] << 22 | (long)offsets[types[i - 1]] & 0x1FFFFFL | ((typeflags[types[i - 1]] & 256) != 0 ? 0x200000L : 0L);
            ++i;
        }
        var44_52 = new ZoneInfo(offsets[std_ind] * 1000, id != null ? id : tzstr, times, endRule);
        try {
            if (dis != null) {
                dis.close();
            }
        }
        catch (IOException v13) {}
        return var44_52;
        catch (IOException v14) {
            try {
                ** continue;
            }
            catch (Throwable var43_54) {
                try {
                    if (dis != null) {
                        dis.close();
                    }
                }
                catch (IOException v15) {}
                throw var43_54;
            }
        }
    }

    private static void skipFully(InputStream is, long l) throws IOException {
        while (l > 0L) {
            long k = is.skip(l);
            if (k <= 0L) {
                throw new EOFException();
            }
            l -= k;
        }
    }

    private static SimpleTimeZone createLastRule(String tzstr) {
        String stdName = null;
        try {
            int dstOffs;
            char c;
            int idLength = tzstr.length();
            int index = 0;
            while ((c = tzstr.charAt(index)) != '+' && c != '-' && c != ',' && c != ':' && !Character.isDigit(c) && c != '\u0000' && ++index < idLength) {
            }
            if (index >= idLength) {
                return new SimpleTimeZone(0, tzstr);
            }
            stdName = tzstr.substring(0, index);
            int prevIndex = index;
            while (((c = tzstr.charAt(index++)) == '-' || c == '+' || c == ':' || Character.isDigit(c)) && index < idLength) {
            }
            if (index < idLength) {
                --index;
            }
            String offset = tzstr.substring(prevIndex, index);
            prevIndex = index;
            int stdOffs = offset.charAt(0) == '+' || offset.charAt(0) == '-' ? ZoneInfo.parseTime(offset.substring(1)) : ZoneInfo.parseTime(offset);
            if (offset.charAt(0) == '-') {
                stdOffs = -stdOffs;
            }
            stdOffs = -stdOffs;
            if (index >= idLength) {
                return new SimpleTimeZone(stdOffs, stdName);
            }
            while ((c = tzstr.charAt(index)) != '+' && c != '-' && c != ',' && c != ':' && !Character.isDigit(c) && c != '\u0000' && ++index < idLength) {
            }
            if (index >= idLength) {
                return new SimpleTimeZone(stdOffs, stdName);
            }
            prevIndex = index;
            while (((c = tzstr.charAt(index++)) == '-' || c == '+' || c == ':' || Character.isDigit(c)) && index < idLength) {
            }
            if (index < idLength) {
                --index;
            }
            if (index == prevIndex && (c == ',' || c == ';')) {
                dstOffs = stdOffs + 3600000;
            } else {
                offset = tzstr.substring(prevIndex, index);
                prevIndex = index;
                dstOffs = offset.charAt(0) == '+' || offset.charAt(0) == '-' ? ZoneInfo.parseTime(offset.substring(1)) : ZoneInfo.parseTime(offset);
                if (offset.charAt(0) == '-') {
                    dstOffs = -dstOffs;
                }
                dstOffs = -dstOffs;
            }
            if (index >= idLength) {
                return new SimpleTimeZone(stdOffs, stdName);
            }
            if (tzstr.charAt(index) == ',' || tzstr.charAt(index) == ';') {
                int endMillis;
                String endDate;
                int startMillis;
                String startDate;
                int offs = ++index;
                while (tzstr.charAt(index) != ',' && tzstr.charAt(index) != ';') {
                    ++index;
                }
                String startTime = tzstr.substring(offs, index);
                String endTime = tzstr.substring(++index);
                index = startTime.indexOf(47);
                if (index != -1) {
                    startDate = startTime.substring(0, index);
                    startMillis = ZoneInfo.parseTime(startTime.substring(index + 1));
                } else {
                    startDate = startTime;
                    startMillis = 0x6DDD00;
                }
                index = endTime.indexOf(47);
                if (index != -1) {
                    endDate = endTime.substring(0, index);
                    endMillis = ZoneInfo.parseTime(endTime.substring(index + 1));
                } else {
                    endDate = endTime;
                    endMillis = 0x6DDD00;
                }
                int[] start = ZoneInfo.getDateParams(startDate);
                int[] end = ZoneInfo.getDateParams(endDate);
                return new SimpleTimeZone(stdOffs, tzstr, start[0], start[1], start[2], startMillis, end[0], end[1], end[2], endMillis, dstOffs - stdOffs);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    private static int[] getDateParams(String date) {
        int julianDay;
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        int[] dayCount = nArray;
        int type = 0;
        if (date.charAt(0) == 'M' || date.charAt(0) == 'm') {
            type = 1;
        } else if (date.charAt(0) == 'A' || date.charAt(0) == 'a') {
            type = 2;
        }
        if (type > 0) {
            int day;
            int month = Integer.parseInt(date.substring(1, date.indexOf(46)));
            int week = Integer.parseInt(date.substring(date.indexOf(46) + 1, date.lastIndexOf(46)));
            int dayOfWeek = Integer.parseInt(date.substring(date.lastIndexOf(46) + 1));
            ++dayOfWeek;
            if (type == 2) {
                day = week;
                dayOfWeek = -dayOfWeek;
            } else if (week == 5) {
                day = -1;
            } else {
                day = (week - 1) * 7 + 1;
                dayOfWeek = -dayOfWeek;
            }
            return new int[]{--month, day, dayOfWeek};
        }
        if (date.charAt(0) != 'J' || date.charAt(0) != 'j') {
            julianDay = Integer.parseInt(date.substring(1));
            ++julianDay;
            int[] nArray2 = new int[12];
            nArray2[1] = 31;
            nArray2[2] = 60;
            nArray2[3] = 91;
            nArray2[4] = 121;
            nArray2[5] = 152;
            nArray2[6] = 182;
            nArray2[7] = 213;
            nArray2[8] = 244;
            nArray2[9] = 274;
            nArray2[10] = 305;
            nArray2[11] = 335;
            dayCount = nArray2;
        } else {
            julianDay = Integer.parseInt(date);
        }
        int i = 11;
        while (i > 0) {
            if (dayCount[i] < julianDay) break;
            --i;
        }
        int month = i;
        int[] nArray3 = new int[3];
        nArray3[0] = month;
        nArray3[1] = julianDay -= dayCount[i];
        return nArray3;
    }

    private static int parseTime(String time) {
        int millis = 0;
        int i = 0;
        while (i < time.length()) {
            if (time.charAt(i) == ':') break;
            ++i;
        }
        millis = 3600000 * Integer.parseInt(time.substring(0, i));
        if (i >= time.length()) {
            return millis;
        }
        int iprev = ++i;
        while (i < time.length()) {
            if (time.charAt(i) == ':') break;
            ++i;
        }
        millis += 60000 * Integer.parseInt(time.substring(iprev, i));
        if (i >= time.length()) {
            return millis;
        }
        return millis += 1000 * Integer.parseInt(time.substring(++i));
    }
}

