/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key;

import gnu.java.security.key.dss.DSSKey;
import gnu.java.security.key.rsa.GnuRSAKey;
import gnu.java.security.util.FormatUtil;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.dh.GnuDHKey;
import gnu.javax.crypto.key.srp6.SRPKey;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;

public class OutgoingMessage {
    private ByteArrayOutputStream out = new ByteArrayOutputStream();

    public byte[] toByteArray() throws KeyAgreementException {
        byte[] buffer = this.wrap();
        int length = buffer.length;
        byte[] result = new byte[length + 4];
        result[0] = (byte)(length >>> 24);
        result[1] = (byte)(length >>> 16);
        result[2] = (byte)(length >>> 8);
        result[3] = (byte)length;
        System.arraycopy(buffer, 0, result, 4, length);
        return result;
    }

    public byte[] wrap() throws KeyAgreementException {
        int length = this.out.size();
        if (length > 0x7FFFFFFB || length < 0) {
            throw new KeyAgreementException("message content is too long");
        }
        return this.out.toByteArray();
    }

    public void writePublicKey(PublicKey k) throws KeyAgreementException {
        this.writeKey(k);
    }

    public void writePrivateKey(PrivateKey k) throws KeyAgreementException {
        this.writeKey(k);
    }

    public void writeMPI(BigInteger val) throws KeyAgreementException {
        byte[] b = val.toByteArray();
        int length = b.length;
        if (length > 65535) {
            throw new KeyAgreementException("MPI is too long");
        }
        byte[] lengthBytes = new byte[]{(byte)(length >>> 8), (byte)length};
        this.out.write(lengthBytes, 0, 2);
        this.out.write(b, 0, b.length);
    }

    public void writeString(String s) throws KeyAgreementException {
        byte[] b = null;
        try {
            b = s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException x) {
            throw new KeyAgreementException("unxupported UTF8 encoding", x);
        }
        int length = b.length;
        if (length > 65535) {
            throw new KeyAgreementException("text too long");
        }
        byte[] lengthBytes = new byte[]{(byte)(length >>> 8), (byte)length};
        this.out.write(lengthBytes, 0, 2);
        this.out.write(b, 0, b.length);
    }

    private void writeKey(Key k) throws KeyAgreementException {
        byte[] b = k.getEncoded();
        int keyType = this.getKeyType(k);
        int formatID = FormatUtil.getFormatID(k.getFormat());
        int length = b.length + 1;
        if (length > 0x7FFFFEF7) {
            throw new KeyAgreementException("Encoded key is too long");
        }
        byte[] lengthBytes = new byte[]{(byte)(length >>> 24), (byte)(length >>> 16), (byte)(length >>> 8), (byte)length};
        this.out.write(lengthBytes, 0, 4);
        this.out.write((keyType & 0xF) << 4 | formatID & 0xF);
        this.out.write(b, 0, b.length);
    }

    private int getKeyType(Key k) throws KeyAgreementException {
        if (k instanceof DSSKey) {
            return 0;
        }
        if (k instanceof GnuRSAKey) {
            return 1;
        }
        if (k instanceof GnuDHKey) {
            return 2;
        }
        if (k instanceof SRPKey) {
            return 3;
        }
        throw new KeyAgreementException("Unknown or unsupported key type: " + k.getClass().getName());
    }
}

