/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class AttributeNode
extends TemplateNode {
    final TemplateNode name;
    final TemplateNode namespace;
    final Node source;

    AttributeNode(TemplateNode name, TemplateNode namespace, Node source) {
        this.name = name;
        this.namespace = namespace;
        this.source = source;
    }

    TemplateNode clone(Stylesheet stylesheet) {
        AttributeNode ret = new AttributeNode(this.name.clone(stylesheet), this.namespace == null ? null : this.namespace.clone(stylesheet), this.source);
        if (this.children != null) {
            ret.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            ret.next = this.next.clone(stylesheet);
        }
        return ret;
    }

    void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        String ns2;
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        DocumentFragment fragment = doc.createDocumentFragment();
        this.name.apply(stylesheet, mode, context, pos, len, fragment, null);
        String nameValue = Expr.stringValue(fragment);
        String namespaceValue = null;
        if (this.namespace != null) {
            fragment = doc.createDocumentFragment();
            this.namespace.apply(stylesheet, mode, context, pos, len, fragment, null);
            namespaceValue = Expr.stringValue(fragment);
            if (namespaceValue.length() == 0) {
                namespaceValue = null;
            }
        }
        String prefix = this.getPrefix(nameValue);
        if (namespaceValue == null) {
            if (prefix != null) {
                namespaceValue = "xml".equals(prefix) ? "http://www.w3.org/XML/1998/namespace" : this.source.lookupNamespaceURI(prefix);
            }
        } else if (prefix != null && (ns2 = this.source.lookupNamespaceURI(prefix)) != null && !ns2.equals(namespaceValue)) {
            prefix = null;
            int ci = nameValue.indexOf(58);
            nameValue = nameValue.substring(ci + 1);
        }
        if (prefix == null) {
            prefix = this.source.lookupPrefix(namespaceValue);
            if (prefix != null) {
                nameValue = String.valueOf(prefix) + ":" + nameValue;
            } else if (namespaceValue != null) {
                prefix = this.inventPrefix(parent);
                nameValue = String.valueOf(prefix) + ":" + nameValue;
            }
        }
        NamedNodeMap attrs = parent.getAttributes();
        boolean insert = true;
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceValue) || "xmlns".equals(nameValue) || nameValue.startsWith("xmlns:")) {
            insert = false;
        }
        if (prefix != null && namespaceValue == null) {
            insert = false;
        }
        if (parent.getNodeType() == 1 && parent.getFirstChild() != null) {
            insert = false;
        }
        if (insert) {
            Attr attr;
            Attr attr2 = attr = namespaceValue != null ? doc.createAttributeNS(namespaceValue, nameValue) : doc.createAttribute(nameValue);
            if (attrs != null) {
                if (this.namespace != null) {
                    attrs.setNamedItemNS(attr);
                } else {
                    attrs.setNamedItem(attr);
                }
            }
            if (this.children != null) {
                this.children.apply(stylesheet, mode, context, pos, len, attr, null);
            }
        }
        if (this.next != null) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    final String getPrefix(String name) {
        int ci = name.indexOf(58);
        return ci == -1 ? null : name.substring(0, ci);
    }

    final String inventPrefix(Node parent) {
        String base = "ns";
        int count = 0;
        String ret = String.valueOf(base) + Integer.toString(count);
        while (parent.lookupNamespaceURI(ret) != null) {
            ret = String.valueOf(base) + Integer.toString(++count);
        }
        return ret;
    }

    public boolean references(QName var) {
        if (this.name != null && this.name.references(var)) {
            return true;
        }
        if (this.namespace != null && this.namespace.references(var)) {
            return true;
        }
        return super.references(var);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("attribute");
        buf.append('[');
        buf.append("name=");
        buf.append(this.name);
        buf.append(']');
        return buf.toString();
    }
}

