/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Window;
import java.awt.event.ComponentEvent;

public class WindowEvent
extends ComponentEvent {
    private static final long serialVersionUID = -1567959133147912127L;
    public static final int WINDOW_FIRST = 200;
    public static final int WINDOW_OPENED = 200;
    public static final int WINDOW_CLOSING = 201;
    public static final int WINDOW_CLOSED = 202;
    public static final int WINDOW_ICONIFIED = 203;
    public static final int WINDOW_DEICONIFIED = 204;
    public static final int WINDOW_ACTIVATED = 205;
    public static final int WINDOW_DEACTIVATED = 206;
    public static final int WINDOW_GAINED_FOCUS = 207;
    public static final int WINDOW_LOST_FOCUS = 208;
    public static final int WINDOW_STATE_CHANGED = 209;
    public static final int WINDOW_LAST = 209;
    private final Window opposite;
    private final int oldState;
    private final int newState;

    public WindowEvent(Window source, int id, Window opposite, int oldState, int newState) {
        super(source, id);
        this.opposite = opposite;
        this.oldState = oldState;
        this.newState = newState;
    }

    public WindowEvent(Window source, int id, Window opposite) {
        this(source, id, opposite, 0, 0);
    }

    public WindowEvent(Window source, int id, int oldState, int newState) {
        this(source, id, null, oldState, newState);
    }

    public WindowEvent(Window source, int id) {
        this(source, id, null, 0, 0);
    }

    public Window getWindow() {
        return this.source instanceof Window ? (Window)this.source : null;
    }

    public Window getOppositeWindow() {
        return this.opposite;
    }

    public int getOldState() {
        return this.oldState;
    }

    public int getNewState() {
        return this.newState;
    }

    public String paramString() {
        StringBuffer s = new StringBuffer();
        switch (this.id) {
            case 200: {
                s.append("WINDOW_OPENED,opposite=");
                break;
            }
            case 201: {
                s.append("WINDOW_CLOSING,opposite=");
                break;
            }
            case 202: {
                s.append("WINDOW_CLOSED,opposite=");
                break;
            }
            case 203: {
                s.append("WINDOW_ICONIFIED,opposite=");
                break;
            }
            case 204: {
                s.append("WINDOW_DEICONIFIED,opposite=");
                break;
            }
            case 205: {
                s.append("WINDOW_ACTIVATED,opposite=");
                break;
            }
            case 206: {
                s.append("WINDOW_DEACTIVATED,opposite=");
                break;
            }
            case 207: {
                s.append("WINDOW_GAINED_FOCUS,opposite=");
                break;
            }
            case 208: {
                s.append("WINDOW_LOST_FOCUS,opposite=");
                break;
            }
            case 209: {
                s.append("WINDOW_STATE_CHANGED,opposite=");
                break;
            }
            default: {
                s.append("unknown type,opposite=");
            }
        }
        return s.append(this.opposite).append(",oldState=").append(this.oldState).append(",newState=").append(this.newState).toString();
    }
}

