/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Byte
extends Number
implements Comparable<Byte> {
    private static final long serialVersionUID = -7183698231559129828L;
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class<Byte> TYPE = VMClassLoader.getPrimitiveClass('B');
    public static final int SIZE = 8;
    private static Byte[] byteCache = new Byte[256];
    private final byte value;

    public Byte(byte value) {
        this.value = value;
    }

    public Byte(String s) {
        this.value = Byte.parseByte(s, 10);
    }

    public static String toString(byte b) {
        return String.valueOf(b);
    }

    public static byte parseByte(String s) {
        return Byte.parseByte(s, 10);
    }

    public static byte parseByte(String s, int radix) {
        int i = Integer.parseInt(s, radix, false);
        if ((byte)i != i) {
            throw new NumberFormatException();
        }
        return (byte)i;
    }

    public static Byte valueOf(String s, int radix) {
        return new Byte(Byte.parseByte(s, radix));
    }

    public static Byte valueOf(String s) {
        return new Byte(Byte.parseByte(s, 10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Byte valueOf(byte val) {
        Byte[] byteArray = byteCache;
        synchronized (byteCache) {
            if (byteCache[val - -128] == null) {
                Byte.byteCache[val - -128] = new Byte(val);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return byteCache[val - -128];
        }
    }

    public static Byte decode(String s) {
        int i = Integer.parseInt(s, 10, true);
        if ((byte)i != i) {
            throw new NumberFormatException();
        }
        return new Byte((byte)i);
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Byte && this.value == ((Byte)obj).value;
    }

    @Override
    public int compareTo(Byte b) {
        return this.value - b.value;
    }
}

