/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private static final long serialVersionUID = -6849794470754667710L;
    private Object data;
    private int boffset;
    int count;
    private int cachedHashCode;
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();

    public String() {
        this.data = "".data;
        this.boffset = 0;
        this.count = 0;
    }

    public String(String str) {
        this.data = str.data;
        this.boffset = str.boffset;
        this.count = str.count;
        this.cachedHashCode = str.cachedHashCode;
    }

    public String(char[] data) {
        this.init(data, 0, data.length, false);
    }

    public String(char[] data, int offset, int count) {
        this.init(data, offset, count, false);
    }

    public String(byte[] ascii, int hibyte, int offset, int count) {
        this.init(ascii, hibyte, offset, count);
    }

    public String(byte[] ascii, int hibyte) {
        this.init(ascii, hibyte, 0, ascii.length);
    }

    public String(byte[] data, int offset, int count, String encoding) throws UnsupportedEncodingException {
        this.init(data, offset, count, encoding);
    }

    public String(byte[] data, String encoding) throws UnsupportedEncodingException {
        this(data, 0, data.length, encoding);
    }

    public String(byte[] data, int offset, int count) {
        try {
            this.init(data, offset, count, System.getProperty("file.encoding", "8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                this.init(data, offset, count, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {}
        }
    }

    public String(byte[] data) {
        this(data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer buffer) {
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            boolean should_copy;
            boolean bl = should_copy = buffer.count << 2 < buffer.value.length;
            if (!should_copy) {
                buffer.shared = true;
            }
            this.init(buffer.value, 0, buffer.count, !should_copy);
        }
    }

    public String(StringBuilder buffer) {
        this(buffer.value, 0, buffer.count);
    }

    String(char[] data, int offset, int count, boolean dont_copy) {
        this.init(data, offset, count, dont_copy);
    }

    String(gnu.gcj.runtime.StringBuffer buffer) {
        this.init(buffer);
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public native char charAt(int var1);

    public synchronized int codePointAt(int index) {
        return Character.codePointAt(this, index);
    }

    public synchronized int codePointBefore(int index) {
        return Character.codePointBefore(this, index);
    }

    public native void getChars(int var1, int var2, char[] var3, int var4);

    public native void getBytes(int var1, int var2, byte[] var3, int var4);

    public native byte[] getBytes(String var1) throws UnsupportedEncodingException;

    public byte[] getBytes() {
        try {
            return this.getBytes(System.getProperty("file.encoding", "8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                return this.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                throw new InternalError("couldn't find 8859_1 encoder");
            }
        }
    }

    public native boolean equals(Object var1);

    public native boolean contentEquals(StringBuffer var1);

    public native boolean contentEquals(CharSequence var1);

    public native boolean equalsIgnoreCase(String var1);

    @Override
    public int compareTo(String anotherString) {
        return this.nativeCompareTo(anotherString);
    }

    private native int nativeCompareTo(String var1);

    public int compareToIgnoreCase(String str) {
        return this.toUpperCase().toLowerCase().compareTo(str.toUpperCase().toLowerCase());
    }

    public native boolean regionMatches(int var1, String var2, int var3, int var4);

    public native boolean regionMatches(boolean var1, int var2, String var3, int var4, int var5);

    public native boolean startsWith(String var1, int var2);

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(String suffix) {
        return this.regionMatches(this.count - suffix.count, suffix, 0, suffix.count);
    }

    public native int hashCode();

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public native int indexOf(int var1, int var2);

    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.count - 1);
    }

    public native int lastIndexOf(int var1, int var2);

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public native int indexOf(String var1, int var2);

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count - str.count);
    }

    public int lastIndexOf(String str, int fromIndex) {
        if (fromIndex >= this.count) {
            fromIndex = this.count - str.count;
        }
        while (fromIndex >= 0) {
            if (this.startsWith(str, fromIndex)) {
                return fromIndex;
            }
            --fromIndex;
        }
        return -1;
    }

    public String substring(int begin) {
        return this.substring(begin, this.count);
    }

    public native String substring(int var1, int var2);

    @Override
    public CharSequence subSequence(int begin, int end) {
        return this.substring(begin, end);
    }

    public native String concat(String var1);

    public native String replace(char var1, char var2);

    public boolean matches(String regex) {
        return Pattern.matches(regex, this);
    }

    public String replaceFirst(String regex, String replacement) {
        return Pattern.compile(regex).matcher(this).replaceFirst(replacement);
    }

    public String replaceAll(String regex, String replacement) {
        return Pattern.compile(regex).matcher(this).replaceAll(replacement);
    }

    public String[] split(String regex, int limit) {
        return Pattern.compile(regex).split(this, limit);
    }

    public String[] split(String regex) {
        return Pattern.compile(regex).split(this, 0);
    }

    public native String toLowerCase(Locale var1);

    public String toLowerCase() {
        return this.toLowerCase(null);
    }

    public native String toUpperCase(Locale var1);

    public String toUpperCase() {
        return this.toUpperCase(null);
    }

    public native String trim();

    @Override
    public String toString() {
        return this;
    }

    public native char[] toCharArray();

    public static String valueOf(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public static String valueOf(char[] data) {
        return String.valueOf(data, 0, data.length);
    }

    public static native String valueOf(char[] var0, int var1, int var2);

    public static String copyValueOf(char[] data, int offset, int count) {
        String r = new String();
        r.init(data, offset, count, false);
        return r;
    }

    public static String copyValueOf(char[] data) {
        return String.copyValueOf(data, 0, data.length);
    }

    public static String valueOf(boolean b) {
        return b ? "true" : "false";
    }

    public static native String valueOf(char var0);

    public static native String valueOf(int var0);

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public static String format(Locale locale, String format, Object ... args) {
        Formatter f = new Formatter(locale);
        return f.format(format, args).toString();
    }

    public static String format(String format, Object ... args) {
        return String.format(Locale.getDefault(), format, args);
    }

    public native String intern();

    public synchronized int codePointCount(int start, int end) {
        if (start < 0 || end > this.count || start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int count = 0;
        while (start < end) {
            char base = this.charAt(start);
            if (base >= '\ud800' && base <= '\udbff' && start != end && start != count && this.charAt(start + 1) >= '\udc00' && this.charAt(start + 1) <= '\udfff') {
                ++start;
            }
            ++start;
            ++count;
        }
        return count;
    }

    public boolean contains(CharSequence s) {
        return this.indexOf(s.toString()) != -1;
    }

    public String replace(CharSequence target, CharSequence replacement) {
        String targetString = target.toString();
        String replaceString = replacement.toString();
        int targetLength = target.length();
        int replaceLength = replacement.length();
        int startPos = this.indexOf(targetString);
        StringBuilder result = new StringBuilder(this);
        while (startPos != -1) {
            result.replace(startPos, startPos + targetLength, replaceString);
            startPos = result.indexOf(targetString, startPos + replaceLength);
        }
        return result.toString();
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        if (index < 0 || index > this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePoints(this, index, codePointOffset);
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    private native void init(char[] var1, int var2, int var3, boolean var4);

    private native void init(byte[] var1, int var2, int var3, int var4);

    private native void init(byte[] var1, int var2, int var3, String var4) throws UnsupportedEncodingException;

    private native void init(gnu.gcj.runtime.StringBuffer var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

