/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.VMDirectByteBuffer;

class CharViewBufferImpl
extends CharBuffer {
    private int offset;
    private ByteBuffer bb;
    private boolean readOnly;
    private ByteOrder endian;

    CharViewBufferImpl(ByteBuffer bb, int capacity) {
        super(capacity, capacity, 0, -1);
        this.bb = bb;
        this.offset = bb.position();
        this.readOnly = bb.isReadOnly();
        this.endian = bb.order();
        if (bb.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(bb.address, this.offset);
        }
    }

    public CharViewBufferImpl(ByteBuffer bb, int offset, int capacity, int limit, int position, int mark, boolean readOnly, ByteOrder endian) {
        super(capacity, limit, position, mark);
        this.bb = bb;
        this.offset = offset;
        this.readOnly = readOnly;
        this.endian = endian;
        if (bb.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(bb.address, offset);
        }
    }

    public char get() {
        int p = this.position();
        char result = ByteBufferHelper.getChar(this.bb, (p << 1) + this.offset, this.endian);
        this.position(p + 1);
        return result;
    }

    public char get(int index) {
        return ByteBufferHelper.getChar(this.bb, (index << 1) + this.offset, this.endian);
    }

    public CharBuffer put(char value) {
        int p = this.position();
        ByteBufferHelper.putChar(this.bb, (p << 1) + this.offset, value, this.endian);
        this.position(p + 1);
        return this;
    }

    public CharBuffer put(int index, char value) {
        ByteBufferHelper.putChar(this.bb, (index << 1) + this.offset, value, this.endian);
        return this;
    }

    public CharBuffer compact() {
        if (this.position() > 0) {
            int count = this.limit() - this.position();
            this.bb.shiftDown(this.offset, this.offset + 2 * this.position(), 2 * count);
            this.position(count);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public CharBuffer slice() {
        return new CharViewBufferImpl(this.bb, (this.position() << 1) + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.endian);
    }

    CharBuffer duplicate(boolean readOnly) {
        int pos = this.position();
        this.reset();
        int mark = this.position();
        this.position(pos);
        return new CharViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), pos, mark, readOnly, this.endian);
    }

    public CharBuffer duplicate() {
        return this.duplicate(this.readOnly);
    }

    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end < start || end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return new CharViewBufferImpl(this.bb, this.array_offset, this.capacity(), this.position() + end, this.position() + start, -1, this.isReadOnly(), this.endian);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public ByteOrder order() {
        return this.endian;
    }
}

