/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.VMDirectByteBuffer;

final class FloatViewBufferImpl
extends FloatBuffer {
    private int offset;
    private ByteBuffer bb;
    private boolean readOnly;
    private ByteOrder endian;

    FloatViewBufferImpl(ByteBuffer bb, int capacity) {
        super(capacity, capacity, 0, -1);
        this.bb = bb;
        this.offset = bb.position();
        this.readOnly = bb.isReadOnly();
        this.endian = bb.order();
        if (bb.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(bb.address, this.offset);
        }
    }

    public FloatViewBufferImpl(ByteBuffer bb, int offset, int capacity, int limit, int position, int mark, boolean readOnly, ByteOrder endian) {
        super(capacity, limit, position, mark);
        this.bb = bb;
        this.offset = offset;
        this.readOnly = readOnly;
        this.endian = endian;
        if (bb.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(bb.address, offset);
        }
    }

    public float get() {
        int p = this.position();
        float result = ByteBufferHelper.getFloat(this.bb, (p << 2) + this.offset, this.endian);
        this.position(p + 1);
        return result;
    }

    public float get(int index) {
        return ByteBufferHelper.getFloat(this.bb, (index << 2) + this.offset, this.endian);
    }

    public FloatBuffer put(float value) {
        int p = this.position();
        ByteBufferHelper.putFloat(this.bb, (p << 2) + this.offset, value, this.endian);
        this.position(p + 1);
        return this;
    }

    public FloatBuffer put(int index, float value) {
        ByteBufferHelper.putFloat(this.bb, (index << 2) + this.offset, value, this.endian);
        return this;
    }

    public FloatBuffer compact() {
        if (this.position() > 0) {
            int count = this.limit() - this.position();
            this.bb.shiftDown(this.offset, this.offset + 4 * this.position(), 4 * count);
            this.position(count);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public FloatBuffer slice() {
        return new FloatViewBufferImpl(this.bb, (this.position() << 2) + this.offset, this.remaining(), this.remaining(), 0, -1, this.readOnly, this.endian);
    }

    FloatBuffer duplicate(boolean readOnly) {
        int pos = this.position();
        this.reset();
        int mark = this.position();
        this.position(pos);
        return new FloatViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), pos, mark, readOnly, this.endian);
    }

    public FloatBuffer duplicate() {
        return this.duplicate(this.readOnly);
    }

    public FloatBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public ByteOrder order() {
        return this.endian;
    }
}

