/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.locale.LocaleHelper;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.spi.NumberFormatProvider;
import java.util.Currency;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.ServiceLoader;

public abstract class NumberFormat
extends Format
implements Cloneable {
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    boolean groupingUsed;
    int maximumFractionDigits;
    private byte maxFractionDigits;
    int maximumIntegerDigits;
    private byte maxIntegerDigits;
    int minimumFractionDigits;
    private byte minFractionDigits;
    int minimumIntegerDigits;
    private byte minIntegerDigits;
    boolean parseIntegerOnly;
    private int serialVersionOnStream;
    private static final long serialVersionUID = -2308460125733713944L;

    public final String format(long number) {
        StringBuffer sbuf = new StringBuffer(50);
        this.format(number, sbuf, new FieldPosition(0));
        return sbuf.toString();
    }

    public StringBuffer format(Object obj, StringBuffer sbuf, FieldPosition pos) {
        if (obj instanceof Number) {
            return this.format(((Number)obj).doubleValue(), sbuf, pos);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public boolean equals(Object obj) {
        if (!(obj instanceof NumberFormat)) {
            return false;
        }
        NumberFormat nf = (NumberFormat)obj;
        return this.groupingUsed == nf.groupingUsed && this.maximumFractionDigits == nf.maximumFractionDigits && this.maximumIntegerDigits == nf.maximumIntegerDigits && this.minimumFractionDigits == nf.minimumFractionDigits && this.minimumIntegerDigits == nf.minimumIntegerDigits && this.parseIntegerOnly == nf.parseIntegerOnly;
    }

    public static Locale[] getAvailableLocales() {
        Locale[] list2 = new Locale[]{Locale.US};
        return list2;
    }

    private static NumberFormat computeInstance(Locale loc, String resource, String def) throws MissingResourceException {
        String fmt;
        if (loc.equals(Locale.ROOT)) {
            return new DecimalFormat(def, DecimalFormatSymbols.getInstance(loc));
        }
        ResourceBundle res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", loc, ClassLoader.getSystemClassLoader());
        try {
            fmt = res == null ? def : res.getString(resource);
        }
        catch (MissingResourceException missingResourceException) {
            fmt = def;
        }
        DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(loc);
        return new DecimalFormat(fmt, dfs);
    }

    public static final NumberFormat getCurrencyInstance() {
        return NumberFormat.getCurrencyInstance(Locale.getDefault());
    }

    /*
     * Unable to fully structure code
     */
    public static NumberFormat getCurrencyInstance(Locale loc) {
        try {
            format = NumberFormat.computeInstance(loc, "currencyFormat", "\u00a4#,##0.00;(\u00a4#,##0.00)");
            format.setMaximumFractionDigits(format.getCurrency().getDefaultFractionDigits());
            return format;
        }
        catch (MissingResourceException v0) {
            ** for (p : ServiceLoader.load(NumberFormatProvider.class))
        }
lbl-1000:
        // 1 sources

        {
            var6_7 = p.getAvailableLocales();
            var5_6 = var6_7.length;
            var4_5 = 0;
            while (var4_5 < var5_6) {
                l = var6_7[var4_5];
                if (l.equals(loc)) {
                    nf = p.getCurrencyInstance(loc);
                    if (nf == null) continue block2;
                    return nf;
                }
                ++var4_5;
            }
            continue;
        }
lbl19:
        // 1 sources

        return NumberFormat.getCurrencyInstance(LocaleHelper.getFallbackLocale(loc));
    }

    public static final NumberFormat getInstance() {
        return NumberFormat.getInstance(Locale.getDefault());
    }

    public static NumberFormat getInstance(Locale loc) {
        return NumberFormat.getNumberInstance(loc);
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    public static final NumberFormat getNumberInstance() {
        return NumberFormat.getNumberInstance(Locale.getDefault());
    }

    /*
     * Unable to fully structure code
     */
    public static NumberFormat getNumberInstance(Locale loc) {
        try {
            return NumberFormat.computeInstance(loc, "numberFormat", "#,##0.###");
        }
        catch (MissingResourceException v0) {
            ** for (p : ServiceLoader.load(NumberFormatProvider.class))
        }
lbl-1000:
        // 1 sources

        {
            var6_6 = p.getAvailableLocales();
            var5_5 = var6_6.length;
            var4_4 = 0;
            while (var4_4 < var5_5) {
                l = var6_6[var4_4];
                if (l.equals(loc)) {
                    nf = p.getNumberInstance(loc);
                    if (nf == null) continue block2;
                    return nf;
                }
                ++var4_4;
            }
            continue;
        }
lbl17:
        // 1 sources

        return NumberFormat.getNumberInstance(LocaleHelper.getFallbackLocale(loc));
    }

    public static final NumberFormat getIntegerInstance() {
        return NumberFormat.getIntegerInstance(Locale.getDefault());
    }

    /*
     * Unable to fully structure code
     */
    public static NumberFormat getIntegerInstance(Locale locale) {
        try {
            format = NumberFormat.computeInstance(locale, "integerFormat", "#,##0");
            format.setMaximumFractionDigits(0);
            format.setParseIntegerOnly(true);
            return format;
        }
        catch (MissingResourceException v0) {
            ** for (p : ServiceLoader.load(NumberFormatProvider.class))
        }
lbl-1000:
        // 1 sources

        {
            var6_7 = p.getAvailableLocales();
            var5_6 = var6_7.length;
            var4_5 = 0;
            while (var4_5 < var5_6) {
                l = var6_7[var4_5];
                if (l.equals(locale)) {
                    nf = p.getIntegerInstance(locale);
                    if (nf == null) continue block2;
                    return nf;
                }
                ++var4_5;
            }
            continue;
        }
lbl20:
        // 1 sources

        return NumberFormat.getIntegerInstance(LocaleHelper.getFallbackLocale(locale));
    }

    public static final NumberFormat getPercentInstance() {
        return NumberFormat.getPercentInstance(Locale.getDefault());
    }

    /*
     * Unable to fully structure code
     */
    public static NumberFormat getPercentInstance(Locale loc) {
        try {
            return NumberFormat.computeInstance(loc, "percentFormat", "#,##0%");
        }
        catch (MissingResourceException v0) {
            ** for (p : ServiceLoader.load(NumberFormatProvider.class))
        }
lbl-1000:
        // 1 sources

        {
            var6_6 = p.getAvailableLocales();
            var5_5 = var6_6.length;
            var4_4 = 0;
            while (var4_4 < var5_5) {
                l = var6_6[var4_4];
                if (l.equals(loc)) {
                    nf = p.getPercentInstance(loc);
                    if (nf == null) continue block2;
                    return nf;
                }
                ++var4_4;
            }
            continue;
        }
lbl17:
        // 1 sources

        return NumberFormat.getPercentInstance(LocaleHelper.getFallbackLocale(loc));
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash ^= this.maximumFractionDigits + this.maximumIntegerDigits + this.minimumFractionDigits + this.minimumIntegerDigits;
        if (this.groupingUsed) {
            hash ^= 0xF0F0;
        }
        if (this.parseIntegerOnly) {
            hash ^= 0xF0F;
        }
        return hash;
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public boolean isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    public abstract Number parse(String var1, ParsePosition var2);

    public Number parse(String sourceStr) throws ParseException {
        ParsePosition pp = new ParsePosition(0);
        Number r = this.parse(sourceStr, pp);
        if (r == null) {
            int index = pp.getErrorIndex();
            if (index < 0) {
                index = pp.getIndex();
            }
            throw new ParseException("couldn't parse number", index);
        }
        return r;
    }

    public final Object parseObject(String sourceStr, ParsePosition pos) {
        return this.parse(sourceStr, pos);
    }

    public void setGroupingUsed(boolean newValue) {
        this.groupingUsed = newValue;
    }

    public void setMaximumFractionDigits(int digits) {
        this.maximumFractionDigits = digits;
        if (this.getMinimumFractionDigits() > this.maximumFractionDigits) {
            this.setMinimumFractionDigits(this.maximumFractionDigits);
        }
    }

    public void setMaximumIntegerDigits(int digits) {
        this.maximumIntegerDigits = digits;
        if (this.getMinimumIntegerDigits() > this.maximumIntegerDigits) {
            this.setMinimumIntegerDigits(this.maximumIntegerDigits);
        }
    }

    public void setMinimumFractionDigits(int digits) {
        this.minimumFractionDigits = digits;
        if (this.getMaximumFractionDigits() < this.minimumFractionDigits) {
            this.setMaximumFractionDigits(this.minimumFractionDigits);
        }
    }

    public void setMinimumIntegerDigits(int digits) {
        this.minimumIntegerDigits = digits;
        if (this.getMaximumIntegerDigits() < this.minimumIntegerDigits) {
            this.setMaximumIntegerDigits(this.minimumIntegerDigits);
        }
    }

    public void setParseIntegerOnly(boolean value) {
        this.parseIntegerOnly = value;
    }

    public final String format(double number) {
        StringBuffer sbuf = new StringBuffer(50);
        FieldPosition position = new FieldPosition(0);
        this.format(number, sbuf, position);
        return sbuf.toString();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.maximumFractionDigits = this.maxFractionDigits;
            this.maximumIntegerDigits = this.maxIntegerDigits;
            this.minimumFractionDigits = this.minFractionDigits;
            this.minimumIntegerDigits = this.minIntegerDigits;
            this.serialVersionOnStream = 1;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.maxFractionDigits = (byte)(this.maximumFractionDigits < 127 ? (int)this.maximumFractionDigits : 127);
        this.maxIntegerDigits = (byte)(this.maximumIntegerDigits < 127 ? (int)this.maximumIntegerDigits : 127);
        this.minFractionDigits = (byte)(this.minimumFractionDigits < 127 ? (int)this.minimumFractionDigits : 127);
        this.minIntegerDigits = (byte)(this.minimumIntegerDigits < 127 ? (int)this.minimumIntegerDigits : 127);
        this.serialVersionOnStream = 1;
        stream.defaultWriteObject();
    }

    public Currency getCurrency() {
        throw new UnsupportedOperationException();
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            throw new NullPointerException("currency may not be null");
        }
        throw new UnsupportedOperationException();
    }

    public static class Field
    extends Format.Field {
        static final long serialVersionUID = 7494728892700160890L;
        public static final Field INTEGER = new Field("integer");
        public static final Field FRACTION = new Field("fraction");
        public static final Field EXPONENT = new Field("exponent");
        public static final Field DECIMAL_SEPARATOR = new Field("decimal separator");
        public static final Field SIGN = new Field("sign");
        public static final Field GROUPING_SEPARATOR = new Field("grouping separator");
        public static final Field EXPONENT_SYMBOL = new Field("exponent symbol");
        public static final Field PERCENT = new Field("percent");
        public static final Field PERMILLE = new Field("permille");
        public static final Field CURRENCY = new Field("currency");
        public static final Field EXPONENT_SIGN = new Field("exponent sign");
        private static final Field[] allFields = new Field[]{INTEGER, FRACTION, EXPONENT, DECIMAL_SEPARATOR, SIGN, GROUPING_SEPARATOR, EXPONENT_SYMBOL, PERCENT, PERMILLE, CURRENCY, EXPONENT_SIGN};

        private Field() {
            super("");
        }

        protected Field(String field_name) {
            super(field_name);
        }

        protected Object readResolve() throws InvalidObjectException {
            String s = this.getName();
            int i = 0;
            while (i < allFields.length) {
                if (s.equals(allFields[i].getName())) {
                    return allFields[i];
                }
                ++i;
            }
            throw new InvalidObjectException("no such NumberFormat field called " + s);
        }
    }
}

