/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollection<E>
implements Collection<E>,
Iterable<E> {
    protected AbstractCollection() {
    }

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public abstract int size();

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Iterator<E> itr = c.iterator();
        boolean modified = false;
        int pos = c.size();
        while (--pos >= 0) {
            modified |= this.add(itr.next());
        }
        return modified;
    }

    @Override
    public void clear() {
        Iterator<E> itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            itr.next();
            itr.remove();
        }
    }

    @Override
    public boolean contains(Object o) {
        Iterator<E> itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractCollection.equals(o, itr.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> itr = c.iterator();
        int pos = c.size();
        while (--pos >= 0) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean remove(Object o) {
        Iterator<E> itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractCollection.equals(o, itr.next())) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeAllInternal(c);
    }

    boolean removeAllInternal(Collection<?> c) {
        Iterator<E> itr = this.iterator();
        boolean modified = false;
        int pos = this.size();
        while (--pos >= 0) {
            if (!c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.retainAllInternal(c);
    }

    boolean retainAllInternal(Collection<?> c) {
        Iterator<E> itr = this.iterator();
        boolean modified = false;
        int pos = this.size();
        while (--pos >= 0) {
            if (c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public Object[] toArray() {
        Iterator<E> itr = this.iterator();
        int size = this.size();
        Object[] a = new Object[size];
        int pos = 0;
        while (pos < size) {
            a[pos] = itr.next();
            ++pos;
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        } else if (a.length > size) {
            a[size] = null;
        }
        Iterator<E> itr = this.iterator();
        int pos = 0;
        while (pos < size) {
            a[pos] = itr.next();
            ++pos;
        }
        return a;
    }

    public String toString() {
        Iterator<E> itr = this.iterator();
        StringBuffer r = new StringBuffer("[");
        boolean hasNext = itr.hasNext();
        while (hasNext) {
            E o = itr.next();
            if (o == this) {
                r.append("<this>");
            } else {
                r.append(o);
            }
            hasNext = itr.hasNext();
            if (!hasNext) continue;
            r.append(", ");
        }
        r.append("]");
        return r.toString();
    }

    static final boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static final int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }
}

