/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.classpath.VMStackWalker;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceBundle {
    private static final int CACHE_SIZE = 100;
    protected ResourceBundle parent;
    private Locale locale;
    private static Map bundleCache = new LinkedHashMap(101, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 100;
        }
    };
    private static BundleKey lookupKey = new BundleKey();
    private static Object nullEntry = new Object();

    public final String getString(String key) {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    public final Object getObject(String key) {
        ResourceBundle bundle = this;
        while (bundle != null) {
            Object o = bundle.handleGetObject(key);
            if (o != null) {
                return o;
            }
            bundle = bundle.parent;
        }
        String className = this.getClass().getName();
        throw new MissingResourceException("Key '" + key + "'not found in Bundle: " + className, className, key);
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setParent(ResourceBundle parent) {
        this.parent = parent;
    }

    public static ResourceBundle getBundle(String baseName) {
        ClassLoader cl = VMStackWalker.getCallingClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundle(baseName, Locale.getDefault(), cl);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale) {
        ClassLoader cl = VMStackWalker.getCallingClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundle(baseName, locale, cl);
    }

    public static synchronized ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader) {
        Locale defaultLocale = Locale.getDefault();
        lookupKey.set(defaultLocale, baseName, locale, classLoader);
        Object obj = bundleCache.get(lookupKey);
        if (obj instanceof ResourceBundle) {
            return (ResourceBundle)obj;
        }
        if (obj == nullEntry) {
            throw new MissingResourceException("Bundle " + baseName + " not found for locale " + locale + " by classloader " + classLoader, baseName, "");
        }
        boolean wantBase = locale.equals(defaultLocale);
        ResourceBundle bundle = ResourceBundle.tryBundle(baseName, locale, classLoader, wantBase);
        if (bundle == null && !wantBase) {
            bundle = ResourceBundle.tryBundle(baseName, defaultLocale, classLoader, true);
        }
        BundleKey key = new BundleKey(defaultLocale, baseName, locale, classLoader);
        if (bundle == null) {
            bundleCache.put(key, nullEntry);
            throw new MissingResourceException("Bundle " + baseName + " not found for locale " + locale + " by classloader " + classLoader, baseName, "");
        }
        bundleCache.put(key, bundle);
        return bundle;
    }

    protected abstract Object handleGetObject(String var1);

    public abstract Enumeration<String> getKeys();

    private static ResourceBundle tryBundle(String localizedName, ClassLoader classloader) {
        ResourceBundle bundle = null;
        try {
            Class<?> rbClass = classloader == null ? Class.forName(localizedName) : classloader.loadClass(localizedName);
            if (ResourceBundle.class.isAssignableFrom(rbClass)) {
                bundle = (ResourceBundle)rbClass.newInstance();
            }
        }
        catch (Exception exception) {}
        if (bundle == null) {
            try {
                String resourceName = String.valueOf(localizedName.replace('.', '/')) + ".properties";
                InputStream is = classloader == null ? ClassLoader.getSystemResourceAsStream(resourceName) : classloader.getResourceAsStream(resourceName);
                if (is != null) {
                    bundle = new PropertyResourceBundle(is);
                }
            }
            catch (IOException ex) {
                MissingResourceException mre = new MissingResourceException("Failed to load bundle: " + localizedName, localizedName, "");
                mre.initCause(ex);
                throw mre;
            }
        }
        return bundle;
    }

    private static ResourceBundle tryBundle(String baseName, Locale locale, ClassLoader classLoader, boolean wantBase) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        int baseLen = baseName.length();
        StringBuffer sb = new StringBuffer(baseLen + variant.length() + 7);
        sb.append(baseName);
        if (language.length() > 0) {
            sb.append('_');
            sb.append(language);
            if (country.length() > 0) {
                sb.append('_');
                sb.append(country);
                if (variant.length() > 0) {
                    sb.append('_');
                    sb.append(variant);
                }
            }
        }
        String bundleName = sb.toString();
        ResourceBundle first = null;
        ResourceBundle last = null;
        while (true) {
            int idx;
            ResourceBundle foundBundle;
            if ((foundBundle = ResourceBundle.tryBundle(bundleName, classLoader)) != null) {
                if (first == null) {
                    first = foundBundle;
                }
                if (last != null) {
                    last.parent = foundBundle;
                }
                foundBundle.locale = locale;
                last = foundBundle;
            }
            if ((idx = bundleName.lastIndexOf(95)) <= baseLen && (idx != baseLen || first == null && !wantBase)) break;
            bundleName = bundleName.substring(0, idx);
        }
        return first;
    }

    private static class BundleKey {
        Locale defaultLocale;
        String baseName;
        Locale locale;
        ClassLoader classLoader;
        int hashcode;

        BundleKey() {
        }

        BundleKey(Locale dl, String s, Locale l, ClassLoader cl) {
            this.set(dl, s, l, cl);
        }

        void set(Locale dl, String s, Locale l, ClassLoader cl) {
            this.defaultLocale = dl;
            this.baseName = s;
            this.locale = l;
            this.classLoader = cl;
            this.hashcode = this.defaultLocale.hashCode() ^ this.baseName.hashCode() ^ this.locale.hashCode() ^ this.classLoader.hashCode();
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BundleKey)) {
                return false;
            }
            BundleKey key = (BundleKey)o;
            return this.hashcode == key.hashcode && this.defaultLocale.equals(key.defaultLocale) && this.baseName.equals(key.baseName) && this.locale.equals(key.locale) && this.classLoader.equals(key.classLoader);
        }
    }
}

