/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class MBeanServerPermission
extends BasicPermission {
    private static final long serialVersionUID = -5661980843569388590L;

    public MBeanServerPermission(String name) {
        this(name, null);
    }

    public MBeanServerPermission(String name, String actions) {
        super(MBeanServerPermission.checkName(name), actions);
        if (actions != null && actions.length() > 0) {
            throw new IllegalArgumentException("The supplied action list was not equal to null or the empty string.");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof MBeanServerPermission) {
            MBeanServerPermission o = (MBeanServerPermission)obj;
            return o.getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean implies(Permission p) {
        if (p instanceof MBeanServerPermission) {
            if (this.getName().equals("*")) {
                return true;
            }
            MBeanServerPermission msp = (MBeanServerPermission)p;
            String[] thisCaps = this.getName().split(",");
            String[] mspCaps = msp.getName().split(",");
            int a = 0;
            while (a < mspCaps.length) {
                boolean found = false;
                String mc = mspCaps[a].trim();
                int b = 0;
                while (b < thisCaps.length) {
                    String tc = thisCaps[b].trim();
                    if (tc.equals(mc)) {
                        found = true;
                    }
                    if (tc.equals("createMBeanServer") && mc.equals("newMBeanServer")) {
                        found = true;
                    }
                    ++b;
                }
                if (!found) {
                    return false;
                }
                ++a;
            }
            return true;
        }
        return false;
    }

    public PermissionCollection newPermissionCollection() {
        return new MBeanServerPermissionCollection();
    }

    private static String checkName(String name) {
        if (!name.equals("*")) {
            String[] constraints = name.split(",");
            name = "";
            boolean seenCreate = false;
            boolean seenNew = false;
            boolean start = true;
            int a = 0;
            while (a < constraints.length) {
                String next = constraints[a].trim();
                if (!(next.equals("createMBeanServer") || next.equals("findMBeanServer") || next.equals("newMBeanServer") || next.equals("releaseMBeanServer"))) {
                    throw new IllegalArgumentException("An invalid constraint, " + next + ", was specified.");
                }
                if (next.equals("newMBeanServer")) {
                    seenNew = true;
                } else if (next.equals("createMBeanServer")) {
                    seenCreate = true;
                } else {
                    if (!start) {
                        name = String.valueOf(name) + ",";
                    }
                    name = String.valueOf(name) + next;
                    start = false;
                }
                ++a;
            }
            if (seenNew && !seenCreate) {
                name = String.valueOf(name) + (start ? "" : ",") + "newMBeanServer";
            } else if (seenCreate) {
                name = String.valueOf(name) + (start ? "" : ",") + "createMBeanServer";
            }
        }
        return name;
    }

    private class MBeanServerPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = -5661980843569388590L;
        private MBeanServerPermission collectionPermission;

        private MBeanServerPermissionCollection() {
        }

        public void add(Permission p) {
            if (this.isReadOnly()) {
                throw new SecurityException("This collection is read only.");
            }
            if (p instanceof MBeanServerPermission) {
                MBeanServerPermission msp = (MBeanServerPermission)p;
                if (this.collectionPermission == null) {
                    this.collectionPermission = msp;
                } else {
                    String finalString = this.collectionPermission.getName();
                    String[] cp = finalString.split(",");
                    String[] np = msp.getName().split(",");
                    int createms = finalString.indexOf("createMBeanServer");
                    int newms = finalString.indexOf("newMBeanServer");
                    int a = 0;
                    while (a < np.length) {
                        boolean found = false;
                        String nps = np[a].trim();
                        int b = 0;
                        while (b < cp.length) {
                            String cps = cp[b].trim();
                            if (cps.equals(nps)) {
                                found = true;
                            }
                            if (np.equals("newMBeanServer") && createms != -1) {
                                found = true;
                            }
                            if (np.equals("createMBeanServer") && newms != -1) {
                                finalString.replace("newMBeanServer", "createMBeanServer");
                            }
                            ++b;
                        }
                        if (!found) {
                            finalString = String.valueOf(finalString) + "," + nps;
                        }
                        ++a;
                    }
                    this.collectionPermission = new MBeanServerPermission(finalString);
                }
            }
        }

        public Enumeration elements() {
            return new MBeanServerPermissionEnumeration(this.collectionPermission);
        }

        public boolean implies(Permission p) {
            return this.collectionPermission.implies(p);
        }

        private class MBeanServerPermissionEnumeration
        implements Enumeration {
            private MBeanServerPermission p;
            private boolean done;

            public MBeanServerPermissionEnumeration(MBeanServerPermission p) {
                this.p = p;
                this.done = false;
            }

            public boolean hasMoreElements() {
                return !this.done;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    this.done = true;
                    return this.p;
                }
                throw new NoSuchElementException("No more elements are available.");
            }
        }
    }
}

