/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import gnu.classpath.ServiceFactory;
import gnu.javax.print.CupsPrintServiceLookup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.StreamPrintService;
import javax.print.attribute.AttributeSet;

public abstract class PrintServiceLookup {
    private static final CupsPrintServiceLookup systemProvider = new CupsPrintServiceLookup();
    private static final HashSet printServices = new HashSet();
    private static final HashSet printServiceLookups = new HashSet();

    static {
        Iterator it = ServiceFactory.lookupProviders(PrintServiceLookup.class);
        while (it.hasNext()) {
            printServiceLookups.add(it.next());
        }
    }

    public static boolean registerServiceProvider(PrintServiceLookup sp) {
        return printServiceLookups.add(sp);
    }

    public static boolean registerService(PrintService service) {
        if (service instanceof StreamPrintService) {
            return false;
        }
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPrintJobAccess();
            }
            return printServices.add(service);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static final PrintService[] lookupPrintServices(DocFlavor flavor, AttributeSet attributes) {
        ArrayList<PrintService> result = new ArrayList<PrintService>();
        PrintService[] services = systemProvider.getPrintServices(flavor, attributes);
        result.addAll((Collection)Arrays.asList(services));
        for (PrintServiceLookup lookup : printServiceLookups) {
            services = lookup.getPrintServices(flavor, attributes);
            result.addAll((Collection)Arrays.asList(services));
        }
        for (PrintService service : printServices) {
            if (!systemProvider.checkPrintService(flavor, attributes, service)) continue;
            result.add(service);
        }
        return result.toArray(new PrintService[result.size()]);
    }

    public static final MultiDocPrintService[] lookupMultiDocPrintServices(DocFlavor[] flavors, AttributeSet attributes) {
        ArrayList<PrintService> result = new ArrayList<PrintService>();
        MultiDocPrintService[] services = systemProvider.getMultiDocPrintServices(flavors, attributes);
        result.addAll((Collection)Arrays.asList(services));
        for (PrintServiceLookup lookup : printServiceLookups) {
            services = lookup.getMultiDocPrintServices(flavors, attributes);
            result.addAll((Collection)Arrays.asList(services));
        }
        for (PrintService service : printServices) {
            if (!systemProvider.checkMultiDocPrintService(flavors, attributes, service)) continue;
            result.add(service);
        }
        return result.toArray(new MultiDocPrintService[result.size()]);
    }

    public static final PrintService lookupDefaultPrintService() {
        PrintService service = systemProvider.getDefaultPrintService();
        if (service != null) {
            return service;
        }
        Iterator it = printServiceLookups.iterator();
        while (it.hasNext()) {
            service = ((PrintServiceLookup)it.next()).getDefaultPrintService();
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public abstract PrintService getDefaultPrintService();

    public abstract MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] var1, AttributeSet var2);

    public abstract PrintService[] getPrintServices();

    public abstract PrintService[] getPrintServices(DocFlavor var1, AttributeSet var2);
}

