/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.MenuContainer;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.UIResource;

public class JSlider
extends JComponent
implements SwingConstants,
Accessible,
ImageObserver,
MenuContainer,
Serializable {
    private static final long serialVersionUID = -1441275936141218479L;
    private transient boolean paintTicks;
    private transient boolean paintTrack = true;
    private transient boolean paintLabels;
    private transient Dictionary labelTable;
    protected BoundedRangeModel sliderModel;
    protected int majorTickSpacing;
    protected int minorTickSpacing;
    protected boolean snapToTicks;
    protected int orientation = 0;
    private transient boolean isInverted;
    protected ChangeListener changeListener;
    protected transient ChangeEvent changeEvent;

    public JSlider() {
        this(0, 0, 100, 50);
    }

    public JSlider(int orientation) {
        this(orientation, 0, 100, 50);
    }

    public JSlider(int minimum, int maximum) {
        this(0, minimum, maximum, (maximum + minimum) / 2);
    }

    public JSlider(int minimum, int maximum, int value) {
        this(0, minimum, maximum, value);
    }

    public JSlider(int orientation, int minimum, int maximum, int value) {
        this.sliderModel = new DefaultBoundedRangeModel(value, 0, minimum, maximum);
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException(String.valueOf(orientation) + " is not a legal orientation");
        }
        this.orientation = orientation;
        this.changeListener = this.createChangeListener();
        this.sliderModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public JSlider(BoundedRangeModel model) {
        this.sliderModel = model;
        this.changeListener = this.createChangeListener();
        this.sliderModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public int getValue() {
        return this.sliderModel.getValue();
    }

    public void setValue(int value) {
        this.sliderModel.setValue(value);
    }

    public SliderUI getUI() {
        return (SliderUI)this.ui;
    }

    public void setUI(SliderUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.updateLabelUIs();
        this.setUI((SliderUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "SliderUI";
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                JSlider.this.fireStateChanged();
            }
        };
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    protected void fireStateChanged() {
        Object[] changeListeners = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        int i = changeListeners.length - 2;
        while (i >= 0) {
            if (changeListeners[i] == ChangeListener.class) {
                ((ChangeListener)changeListeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    public BoundedRangeModel getModel() {
        return this.sliderModel;
    }

    public void setModel(BoundedRangeModel model) {
        if (model != this.sliderModel) {
            BoundedRangeModel oldModel = this.sliderModel;
            this.sliderModel = model;
            oldModel.removeChangeListener(this.changeListener);
            this.sliderModel.addChangeListener(this.changeListener);
            this.firePropertyChange("model", oldModel, this.sliderModel);
        }
    }

    public int getMinimum() {
        return this.sliderModel.getMinimum();
    }

    public void setMinimum(int minimum) {
        int old = this.sliderModel.getMinimum();
        this.sliderModel.setMinimum(minimum);
        if (minimum != old) {
            this.firePropertyChange("minimum", old, minimum);
        }
    }

    public int getMaximum() {
        return this.sliderModel.getMaximum();
    }

    public void setMaximum(int maximum) {
        int old = this.sliderModel.getMaximum();
        this.sliderModel.setMaximum(maximum);
        if (maximum != old) {
            this.firePropertyChange("maximum", old, maximum);
        }
    }

    public boolean getValueIsAdjusting() {
        return this.sliderModel.getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean adjusting) {
        this.sliderModel.setValueIsAdjusting(adjusting);
    }

    public int getExtent() {
        return this.sliderModel.getExtent();
    }

    public void setExtent(int extent) {
        this.sliderModel.setExtent(extent);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
        }
        if (orientation != this.orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange("orientation", oldOrientation, this.orientation);
            this.revalidate();
        }
    }

    public Dictionary getLabelTable() {
        return this.labelTable;
    }

    public void setLabelTable(Dictionary table) {
        if (table != this.labelTable) {
            Dictionary oldTable = this.labelTable;
            this.labelTable = table;
            this.updateLabelUIs();
            this.firePropertyChange("labelTable", oldTable, this.labelTable);
            this.revalidate();
            this.repaint();
        }
    }

    protected void updateLabelUIs() {
        if (this.labelTable != null) {
            Enumeration list2 = this.labelTable.elements();
            while (list2.hasMoreElements()) {
                Object o = list2.nextElement();
                if (!(o instanceof JComponent)) continue;
                JComponent jc = (JComponent)o;
                jc.updateUI();
                jc.setSize(jc.getPreferredSize());
            }
        }
    }

    public Hashtable createStandardLabels(int increment) {
        return this.createStandardLabels(increment, this.sliderModel.getMinimum());
    }

    public Hashtable createStandardLabels(int increment, int start) {
        if (increment <= 0) {
            throw new IllegalArgumentException("Requires 'increment' > 0.");
        }
        if (start < this.getMinimum() || start > this.getMaximum()) {
            throw new IllegalArgumentException("The 'start' value is out of range.");
        }
        Hashtable<Integer, LabelUIResource> table = new Hashtable<Integer, LabelUIResource>();
        int max = this.getMaximum();
        int i = start;
        while (i <= max) {
            LabelUIResource label = new LabelUIResource(String.valueOf(i), 0);
            table.put(new Integer(i), label);
            i += increment;
        }
        return table;
    }

    public boolean getInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean inverted) {
        if (this.isInverted != inverted) {
            boolean oldInverted = this.isInverted;
            this.isInverted = inverted;
            this.firePropertyChange("inverted", oldInverted, this.isInverted);
            this.repaint();
        }
    }

    public int getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public void setMajorTickSpacing(int spacing) {
        if (this.majorTickSpacing != spacing) {
            int oldSpacing = this.majorTickSpacing;
            this.majorTickSpacing = spacing;
            if (this.labelTable == null && this.majorTickSpacing > 0 && this.getPaintLabels()) {
                this.setLabelTable(this.createStandardLabels(this.majorTickSpacing));
            }
            this.firePropertyChange("majorTickSpacing", oldSpacing, this.majorTickSpacing);
            if (this.getPaintTicks()) {
                this.repaint();
            }
        }
    }

    public int getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setMinorTickSpacing(int spacing) {
        if (this.minorTickSpacing != spacing) {
            int oldSpacing = this.minorTickSpacing;
            this.minorTickSpacing = spacing;
            this.firePropertyChange("minorTickSpacing", oldSpacing, this.minorTickSpacing);
            if (this.getPaintTicks()) {
                this.repaint();
            }
        }
    }

    public boolean getSnapToTicks() {
        return this.snapToTicks;
    }

    public void setSnapToTicks(boolean snap) {
        if (snap != this.snapToTicks) {
            this.snapToTicks = snap;
            this.firePropertyChange("snapToTicks", !snap, snap);
        }
    }

    public boolean getPaintTicks() {
        return this.paintTicks;
    }

    public void setPaintTicks(boolean paint) {
        if (paint != this.paintTicks) {
            boolean oldPaintTicks = this.paintTicks;
            this.paintTicks = paint;
            this.firePropertyChange("paintTicks", oldPaintTicks, this.paintTicks);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean getPaintTrack() {
        return this.paintTrack;
    }

    public void setPaintTrack(boolean paint) {
        if (this.paintTrack != paint) {
            this.paintTrack = paint;
            this.firePropertyChange("paintTrack", !paint, paint);
            this.repaint();
        }
    }

    public boolean getPaintLabels() {
        return this.paintLabels;
    }

    public void setPaintLabels(boolean paint) {
        if (paint != this.paintLabels) {
            this.paintLabels = paint;
            if (paint && this.majorTickSpacing > 0 && this.labelTable == null) {
                this.setLabelTable(this.createStandardLabels(this.majorTickSpacing));
            }
            this.firePropertyChange("paintLabels", !paint, paint);
            this.revalidate();
            this.repaint();
        }
    }

    protected String paramString() {
        String superParamStr = super.paramString();
        StringBuffer sb = new StringBuffer();
        sb.append(",isInverted=").append(this.getInverted());
        sb.append(",majorTickSpacing=").append(this.getMajorTickSpacing());
        sb.append(",minorTickSpacing=").append(this.getMinorTickSpacing());
        sb.append(",orientation=");
        if (this.orientation == 0) {
            sb.append("HORIZONTAL");
        } else {
            sb.append("VERTICAL");
        }
        sb.append(",paintLabels=").append(this.getPaintLabels());
        sb.append(",paintTicks=").append(this.getPaintTicks());
        sb.append(",paintTrack=").append(this.getPaintTrack());
        sb.append(",snapToTicks=").append(this.getSnapToTicks());
        sb.append(",snapToValue=true");
        return String.valueOf(superParamStr) + sb.toString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSlider();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJSlider
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -6301740148041106789L;

        protected AccessibleJSlider() {
            super(JSlider.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet result = super.getAccessibleStateSet();
            if (JSlider.this.orientation == 0) {
                result.add(AccessibleState.HORIZONTAL);
            } else if (JSlider.this.orientation == 1) {
                result.add(AccessibleState.VERTICAL);
            }
            return result;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SLIDER;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JSlider.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number value) {
            if (value == null) {
                return false;
            }
            Number oldValue = this.getCurrentAccessibleValue();
            JSlider.this.setValue(value.intValue());
            this.firePropertyChange("AccessibleValue", oldValue, new Integer(JSlider.this.getValue()));
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JSlider.this.getMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JSlider.this.getMaximum());
        }
    }

    private class LabelUIResource
    extends JLabel
    implements UIResource {
        LabelUIResource(String text, int align) {
            super(text, align);
            this.setName("Slider.label");
        }
    }
}

