/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_HANDLE_FACTORY_H
#define QTTAPIOCA_HANDLE_FACTORY_H

#include <QtCore/QList>
#include <QtCore/QObject>
#include <QtCore/QString>
#include <qglobal.h>

/** Namespace for Tapioca classes. */
namespace QtTapioca {

class HandleFactoryPrivate;
class Handle;
class ConnectionPrivate;

/**
 * This class is responsible for creating all handles used throughout Tapioca.
 */
class Q_DECL_EXPORT HandleFactory : QObject {
    Q_OBJECT
    Q_DECLARE_PRIVATE(HandleFactory)

public:
    /**
     * Destructor
     */
    ~HandleFactory();

    /**
     * Creates a new handle, given its name.
     *
     * @param handleType Type of the handle to be created.
     * @param name Name of the handle to be created.
     * @return The handle with the specified type and name or NULL.
     */
    Handle *createHandle(uint handleType, const QString &name);

    /**
     * Creates a new handle, given its ID.
     *
     * @param handleType Type of the handle to be created.
     * @param handleId ID of the handle to be created.
     * @return The handle with the specified type and ID or NULL.
     */
    Handle *createHandle(uint handleType, uint handleId);

private:
    friend class ConnectionPrivate;
    HandleFactory(QObject *connDBusProxy, QObject *parent = 0);

    HandleFactoryPrivate *d;
};

} // namespace

#endif

