/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.DBMetaData;
import com.sun.star.wizards.db.FieldColumn;
import java.util.HashMap;
import java.util.Vector;

public class QueryMetaData
extends CommandMetaData {
    FieldColumn CurFieldColumn;
    public String Command;
    private PropertyValue[][] m_aFilterConditions;
    public PropertyValue[][] GroupByFilterConditions = new PropertyValue[0][];
    public String[] UniqueAggregateFieldNames = new String[0];
    public int Type = 1;

    public QueryMetaData(XMultiServiceFactory xMultiServiceFactory, Locale locale, NumberFormatter numberFormatter) {
        super(xMultiServiceFactory, locale, numberFormatter);
    }

    public QueryMetaData(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
    }

    public void setFilterConditions(PropertyValue[][] propertyValueArray) {
        this.m_aFilterConditions = propertyValueArray;
    }

    public PropertyValue[][] getFilterConditions() {
        if (this.m_aFilterConditions == null) {
            this.m_aFilterConditions = new PropertyValue[0][];
        }
        return this.m_aFilterConditions;
    }

    public void setGroupByFilterConditions(PropertyValue[][] propertyValueArray) {
        this.GroupByFilterConditions = propertyValueArray;
    }

    public PropertyValue[][] getGroupByFilterConditions() {
        return this.GroupByFilterConditions;
    }

    public void addSeveralFieldColumns(String[] stringArray, String string) {
        FieldColumn[] fieldColumnArray;
        int n;
        Vector<FieldColumn> vector = new Vector<FieldColumn>();
        for (n = 0; n < stringArray.length; ++n) {
            fieldColumnArray = this.getFieldColumn(stringArray[n], string);
            if (fieldColumnArray != null) continue;
            vector.add(new FieldColumn(this, stringArray[n], string, false));
        }
        if (vector.size() > 0) {
            n = this.FieldColumns.length;
            fieldColumnArray = new FieldColumn[n + vector.size()];
            System.arraycopy(this.FieldColumns, 0, fieldColumnArray, 0, n);
            for (int i = 0; i < vector.size(); ++i) {
                fieldColumnArray[n + i] = (FieldColumn)vector.elementAt(i);
            }
            this.FieldColumns = fieldColumnArray;
        }
    }

    public void reorderFieldColumns(String[] stringArray) {
        FieldColumn[] fieldColumnArray = new FieldColumn[this.FieldColumns.length];
        for (int i = 0; i < stringArray.length; ++i) {
            FieldColumn fieldColumn;
            fieldColumnArray[i] = fieldColumn = this.getFieldColumnByDisplayName(stringArray[i]);
        }
        System.arraycopy(fieldColumnArray, 0, this.FieldColumns, 0, fieldColumnArray.length);
    }

    public void removeSeveralFieldColumnsByDisplayFieldName(String[] stringArray) {
        Vector<FieldColumn> vector = new Vector<FieldColumn>();
        boolean bl = false;
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            String string = this.FieldColumns[i].getDisplayFieldName();
            if (JavaTools.FieldInList(stringArray, string) > -1) continue;
            vector.add(this.FieldColumns[i]);
        }
        this.FieldColumns = new FieldColumn[vector.size()];
        vector.toArray(this.FieldColumns);
    }

    public void removeFieldColumn(String string, String string2) {
        FieldColumn fieldColumn = this.getFieldColumn(string, string2);
        int n = 0;
        if (fieldColumn != null) {
            FieldColumn[] fieldColumnArray = new FieldColumn[this.FieldColumns.length - 1];
            for (int i = 0; i < this.FieldColumns.length; ++i) {
                if (this.FieldColumns[i].m_sFieldName.equals(string) || this.FieldColumns[i].getCommandName().equals(string2)) continue;
                fieldColumnArray[n] = this.FieldColumns[i];
                ++n;
            }
            this.FieldColumns = fieldColumnArray;
        }
    }

    public String[] getIncludedCommandNames() {
        Vector<String> vector = new Vector<String>(1);
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            FieldColumn fieldColumn = this.FieldColumns[i];
            String string = fieldColumn.getCommandName();
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    public static String[] getIncludedCommandNames(String[] stringArray) {
        Vector<String> vector = new Vector<String>(1);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "";
            String[] stringArray2 = JavaTools.ArrayoutofString(stringArray[i], ".");
            if (stringArray2.length <= 1) continue;
            for (int j = 0; j < stringArray2.length - 1; ++j) {
                string = string + stringArray2[j];
            }
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
        String[] stringArray3 = new String[vector.size()];
        vector.toArray(stringArray3);
        return stringArray3;
    }

    public String[] getFieldNamesOfCommand(String string) {
        DBMetaData.CommandObject commandObject = this.getTableByName(string);
        return commandObject.xColumns.getElementNames();
    }

    public void initializeFieldTitleSet(boolean bl) {
        try {
            if (this.FieldTitleSet == null) {
                this.FieldTitleSet = new HashMap();
            }
            String[] stringArray = this.getIncludedCommandNames();
            for (int i = 0; i < stringArray.length; ++i) {
                DBMetaData.CommandObject commandObject = this.getTableByName(stringArray[i]);
                String string = commandObject.Name;
                String[] stringArray2 = commandObject.xColumns.getElementNames();
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string2 = FieldColumn.composeDisplayFieldName(string, stringArray2[j]);
                    if (this.FieldTitleSet.containsKey(string2)) continue;
                    this.FieldTitleSet.put(string2, stringArray2[j]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public String[] getUniqueAggregateFieldNames() {
        Vector<String> vector = new Vector<String>(0);
        for (int i = 0; i < this.AggregateFieldNames.length; ++i) {
            if (vector.contains(this.AggregateFieldNames[i][0])) continue;
            vector.add(this.AggregateFieldNames[i][0]);
        }
        this.UniqueAggregateFieldNames = new String[vector.size()];
        vector.toArray(this.UniqueAggregateFieldNames);
        return this.UniqueAggregateFieldNames;
    }

    public boolean hasNumericalFields() {
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            if (!this.FieldColumns[i].bIsNumberFormat) continue;
            return true;
        }
        return false;
    }

    public int getAggregateIndex(String string) {
        int n = -1;
        if (this.Type == 0) {
            n = JavaTools.FieldInTable(this.AggregateFieldNames, string);
        }
        return n;
    }

    public static interface QueryType {
        public static final int SOSUMMARYQUERY = 0;
        public static final int SODETAILQUERY = 1;
    }
}

