/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import gnu.java.awt.java2d.ImagePaint;
import gnu.java.awt.java2d.Pixelizer;
import gnu.java.awt.java2d.ScanlineConverter;
import gnu.java.awt.java2d.ScanlineCoverage;
import gnu.java.awt.java2d.ShapeCache;
import java.awt.AWTError;
import java.awt.AWTPermission;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractGraphics2D
extends Graphics2D
implements Cloneable,
Pixelizer {
    private static final Font FONT = new Font("SansSerif", 0, 12);
    private static final ThreadLocal<ShapeCache> shapeCache = new ThreadLocal();
    private static final ThreadLocal<ScanlineConverter> scanlineConverters = new ThreadLocal();
    protected AffineTransform transform = new AffineTransform();
    private Paint paint;
    private PaintContext paintContext;
    private Color background = Color.WHITE;
    private Font font;
    private Composite composite = AlphaComposite.SrcOver;
    private Stroke stroke = STANDARD_STROKE;
    private Shape clip;
    private RenderingHints renderingHints = new RenderingHints(STANDARD_HINTS);
    private WritableRaster destinationRaster;
    private boolean isOptimized = true;
    private static final BasicStroke STANDARD_STROKE = new BasicStroke();
    private static final HashMap STANDARD_HINTS;

    static {
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        STANDARD_HINTS = hints;
    }

    protected AbstractGraphics2D() {
    }

    public void draw(Shape shape) {
        Shape strokedShape = this.stroke.createStrokedShape(shape);
        this.fillShape(strokedShape, false);
    }

    public boolean drawImage(Image image, AffineTransform xform, ImageObserver obs) {
        Rectangle areaOfInterest = new Rectangle(0, 0, image.getWidth(obs), image.getHeight(obs));
        return this.drawImageImpl(image, xform, obs, areaOfInterest);
    }

    private boolean drawImageImpl(Image image, AffineTransform xform, ImageObserver obs, Rectangle areaOfInterest) {
        boolean ret;
        if (image == null) {
            ret = true;
        } else if (image instanceof RenderedImage) {
            this.drawRenderedImageImpl((RenderedImage)((Object)image), xform, areaOfInterest);
            ret = true;
        } else if (image instanceof RenderableImage) {
            this.drawRenderableImageImpl((RenderableImage)((Object)image), xform, areaOfInterest);
            ret = true;
        } else {
            ret = false;
        }
        return ret;
    }

    public void drawImage(BufferedImage image, BufferedImageOp op, int x, int y) {
        BufferedImage filtered = op.createCompatibleDestImage(image, image.getColorModel());
        AffineTransform t = new AffineTransform();
        t.translate(x, y);
        this.drawRenderedImage(filtered, t);
    }

    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        Rectangle areaOfInterest = new Rectangle(image.getMinX(), image.getHeight(), image.getWidth(), image.getHeight());
        this.drawRenderedImageImpl(image, xform, areaOfInterest);
    }

    private void drawRenderedImageImpl(RenderedImage image, AffineTransform xform, Rectangle areaOfInterest) {
        AffineTransform t = new AffineTransform();
        t.translate(-areaOfInterest.x - image.getMinX(), -areaOfInterest.y - image.getMinY());
        t.concatenate(xform);
        t.concatenate(this.transform);
        AffineTransform it = null;
        try {
            it = t.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
        if (it != null) {
            GeneralPath aoi = new GeneralPath(areaOfInterest);
            aoi.transform(xform);
            ImagePaint p = new ImagePaint(image, it);
            Paint savedPaint = this.paint;
            try {
                this.paint = p;
                this.fillShape(aoi, false);
            }
            finally {
                this.paint = savedPaint;
            }
        }
    }

    public void drawRenderableImage(RenderableImage image, AffineTransform xform) {
        Rectangle areaOfInterest = new Rectangle((int)image.getMinX(), (int)image.getHeight(), (int)image.getWidth(), (int)image.getHeight());
        this.drawRenderableImageImpl(image, xform, areaOfInterest);
    }

    private void drawRenderableImageImpl(RenderableImage image, AffineTransform xform, Rectangle areaOfInterest) {
        RenderedImage rendered = image.createDefaultRendering();
        this.drawRenderedImageImpl(rendered, xform, areaOfInterest);
    }

    public void drawString(String text, int x, int y) {
        if (this.isOptimized) {
            this.rawDrawString(text, x, y);
        } else {
            FontRenderContext ctx = this.getFontRenderContext();
            GlyphVector gv = this.font.createGlyphVector(ctx, text.toCharArray());
            this.drawGlyphVector(gv, x, y);
        }
    }

    public void drawString(String text, float x, float y) {
        FontRenderContext ctx = this.getFontRenderContext();
        GlyphVector gv = this.font.createGlyphVector(ctx, text.toCharArray());
        this.drawGlyphVector(gv, x, y);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        FontRenderContext ctx = this.getFontRenderContext();
        GlyphVector gv = this.font.createGlyphVector(ctx, iterator);
        this.drawGlyphVector(gv, x, y);
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        FontRenderContext ctx = this.getFontRenderContext();
        GlyphVector gv = this.font.createGlyphVector(ctx, iterator);
        this.drawGlyphVector(gv, x, y);
    }

    public void fill(Shape shape) {
        this.fillShape(shape, false);
    }

    public boolean hit(Rectangle rect, Shape text, boolean onStroke) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setComposite(Composite comp) {
        SecurityManager sm;
        if (!(comp instanceof AlphaComposite) && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new AWTPermission("readDisplayPixels"));
        }
        this.composite = comp;
        if (!comp.equals(AlphaComposite.SrcOver)) {
            this.isOptimized = false;
        } else {
            this.updateOptimization();
        }
    }

    public void setPaint(Paint p) {
        if (p != null) {
            this.paint = p;
            if (!(this.paint instanceof Color)) {
                this.isOptimized = false;
            } else {
                this.updateOptimization();
            }
        }
    }

    public void setStroke(Stroke s) {
        this.stroke = s;
        if (!this.stroke.equals(new BasicStroke())) {
            this.isOptimized = false;
        } else {
            this.updateOptimization();
        }
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.renderingHints.put(hintKey, hintValue);
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.renderingHints.get(hintKey);
    }

    public void setRenderingHints(Map hints) {
        this.renderingHints.clear();
        this.renderingHints.putAll((Map<?, ?>)hints);
    }

    public void addRenderingHints(Map hints) {
        this.renderingHints.putAll((Map<?, ?>)hints);
    }

    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.renderingHints.clone();
    }

    public void translate(int x, int y) {
        this.transform.translate(x, y);
        if (this.clip != null) {
            if (this.clip instanceof Rectangle) {
                Rectangle r = (Rectangle)this.clip;
                r.x -= x;
                r.y -= y;
                this.setClip(r);
            } else {
                AffineTransform clipTransform = new AffineTransform();
                clipTransform.translate(-x, -y);
                this.updateClip(clipTransform);
            }
        }
    }

    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
        if (this.clip != null) {
            if (this.clip instanceof Rectangle) {
                Rectangle r = (Rectangle)this.clip;
                r.x = (int)((double)r.x - tx);
                r.y = (int)((double)r.y - ty);
            } else {
                AffineTransform clipTransform = new AffineTransform();
                clipTransform.translate(-tx, -ty);
                this.updateClip(clipTransform);
            }
        }
    }

    public void rotate(double theta) {
        this.transform.rotate(theta);
        if (this.clip != null) {
            AffineTransform clipTransform = new AffineTransform();
            clipTransform.rotate(-theta);
            this.updateClip(clipTransform);
        }
        this.updateOptimization();
    }

    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
        if (this.clip != null) {
            AffineTransform clipTransform = new AffineTransform();
            clipTransform.rotate(-theta, x, y);
            this.updateClip(clipTransform);
        }
        this.updateOptimization();
    }

    public void scale(double scaleX, double scaleY) {
        this.transform.scale(scaleX, scaleY);
        if (this.clip != null) {
            AffineTransform clipTransform = new AffineTransform();
            clipTransform.scale(1.0 / scaleX, 1.0 / scaleY);
            this.updateClip(clipTransform);
        }
        this.updateOptimization();
    }

    public void shear(double shearX, double shearY) {
        this.transform.shear(shearX, shearY);
        if (this.clip != null) {
            AffineTransform clipTransform = new AffineTransform();
            clipTransform.shear(-shearX, -shearY);
            this.updateClip(clipTransform);
        }
        this.updateOptimization();
    }

    public void transform(AffineTransform t) {
        this.transform.concatenate(t);
        try {
            AffineTransform clipTransform = t.createInverse();
            this.updateClip(clipTransform);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        this.updateOptimization();
    }

    public void setTransform(AffineTransform t) {
        this.updateClip(this.transform);
        this.transform.setTransform(t);
        try {
            this.updateClip(this.transform.createInverse());
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        this.updateOptimization();
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void clip(Shape s) {
        if (this.clip == null) {
            this.setClip(s);
        } else if (this.clip instanceof Rectangle && s instanceof Rectangle) {
            Rectangle clipRect = (Rectangle)this.clip;
            Rectangle r = (Rectangle)s;
            AbstractGraphics2D.computeIntersection(r.x, r.y, r.width, r.height, clipRect);
            this.setClip(clipRect);
        } else {
            Area current = this.clip instanceof Area ? (Area)this.clip : new Area(this.clip);
            Area intersect = s instanceof Area ? (Area)s : new Area(s);
            current.intersect(intersect);
            this.clip = current;
            this.isOptimized = false;
            this.setClip(this.clip);
        }
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.transform, false, true);
    }

    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        this.translate(x, y);
        this.fillShape(gv.getOutline(), true);
        this.translate(-x, -y);
    }

    public Graphics create() {
        AbstractGraphics2D copy = (AbstractGraphics2D)this.clone();
        return copy;
    }

    protected Object clone() {
        try {
            AbstractGraphics2D copy = (AbstractGraphics2D)super.clone();
            copy.clip = this.clip instanceof Rectangle ? new Rectangle((Rectangle)this.clip) : new GeneralPath(this.clip);
            copy.renderingHints = new RenderingHints(null);
            copy.renderingHints.putAll((Map<?, ?>)this.renderingHints);
            copy.transform = new AffineTransform(this.transform);
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            AWTError err = new AWTError("Unexpected exception while cloning");
            err.initCause(ex);
            throw err;
        }
    }

    public Color getColor() {
        Color c = null;
        if (this.paint instanceof Color) {
            c = (Color)this.paint;
        }
        return c;
    }

    public void setColor(Color color) {
        this.setPaint(color);
    }

    public void setPaintMode() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setXORMode(Color color) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        if (f != null) {
            this.font = f;
        }
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        Rectangle b = null;
        if (this.clip != null) {
            b = this.clip.getBounds();
        }
        return b;
    }

    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    public Shape getClip() {
        return this.clip;
    }

    public void setClip(Shape c) {
        this.clip = c;
        if (!(this.clip instanceof Rectangle)) {
            this.isOptimized = false;
        } else {
            this.updateOptimization();
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        if (this.isOptimized) {
            this.rawCopyArea(x, y, width, height, dx, dy);
        } else {
            this.copyAreaImpl(x, y, width, height, dx, dy);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.isOptimized) {
            int tx = (int)this.transform.getTranslateX();
            int ty = (int)this.transform.getTranslateY();
            this.rawDrawLine(x1 + tx, y1 + ty, x2 + tx, y2 + ty);
        } else {
            ShapeCache sc = this.getShapeCache();
            if (sc.line == null) {
                sc.line = new Line2D.Float();
            }
            sc.line.setLine(x1, y1, x2, y2);
            this.draw(sc.line);
        }
    }

    public void drawRect(int x, int y, int w, int h) {
        if (this.isOptimized) {
            this.rawDrawRect(x, y, w, h);
        } else {
            ShapeCache sc = this.getShapeCache();
            if (sc.rect == null) {
                sc.rect = new Rectangle();
            }
            sc.rect.setBounds(x, y, w, h);
            this.draw(sc.rect);
        }
    }

    public void fillRect(int x, int y, int width, int height) {
        if (this.isOptimized) {
            this.rawFillRect(x + (int)this.transform.getTranslateX(), y + (int)this.transform.getTranslateY(), width, height);
        } else {
            ShapeCache sc = this.getShapeCache();
            if (sc.rect == null) {
                sc.rect = new Rectangle();
            }
            sc.rect.setBounds(x, y, width, height);
            this.fill(sc.rect);
        }
    }

    public void clearRect(int x, int y, int width, int height) {
        if (this.isOptimized) {
            this.rawClearRect(x, y, width, height);
        } else {
            Paint savedForeground = this.getPaint();
            this.setPaint(this.getBackground());
            this.fillRect(x, y, width, height);
            this.setPaint(savedForeground);
        }
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        ShapeCache sc = this.getShapeCache();
        if (sc.roundRect == null) {
            sc.roundRect = new RoundRectangle2D.Float();
        }
        sc.roundRect.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.draw(sc.roundRect);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        ShapeCache sc = this.getShapeCache();
        if (sc.roundRect == null) {
            sc.roundRect = new RoundRectangle2D.Float();
        }
        sc.roundRect.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.fill(sc.roundRect);
    }

    public void drawOval(int x, int y, int width, int height) {
        ShapeCache sc = this.getShapeCache();
        if (sc.ellipse == null) {
            sc.ellipse = new Ellipse2D.Float();
        }
        sc.ellipse.setFrame(x, y, width, height);
        this.draw(sc.ellipse);
    }

    public void fillOval(int x, int y, int width, int height) {
        ShapeCache sc = this.getShapeCache();
        if (sc.ellipse == null) {
            sc.ellipse = new Ellipse2D.Float();
        }
        sc.ellipse.setFrame(x, y, width, height);
        this.fill(sc.ellipse);
    }

    public void drawArc(int x, int y, int width, int height, int arcStart, int arcAngle) {
        ShapeCache sc = this.getShapeCache();
        if (sc.arc == null) {
            sc.arc = new Arc2D.Float();
        }
        sc.arc.setArc(x, y, width, height, arcStart, arcAngle, 0);
        this.draw(sc.arc);
    }

    public void fillArc(int x, int y, int width, int height, int arcStart, int arcAngle) {
        ShapeCache sc = this.getShapeCache();
        if (sc.arc == null) {
            sc.arc = new Arc2D.Float();
        }
        sc.arc.setArc(x, y, width, height, arcStart, arcAngle, 2);
        this.draw(sc.arc);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int npoints) {
        ShapeCache sc = this.getShapeCache();
        if (sc.polyline == null) {
            sc.polyline = new GeneralPath();
        }
        GeneralPath p = sc.polyline;
        p.reset();
        if (npoints > 0) {
            p.moveTo(xPoints[0], yPoints[0]);
        }
        int i = 1;
        while (i < npoints) {
            p.lineTo(xPoints[i], yPoints[i]);
            ++i;
        }
        this.fill(p);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int npoints) {
        ShapeCache sc = this.getShapeCache();
        if (sc.polygon == null) {
            sc.polygon = new Polygon();
        }
        sc.polygon.reset();
        sc.polygon.xpoints = xPoints;
        sc.polygon.ypoints = yPoints;
        sc.polygon.npoints = npoints;
        this.draw(sc.polygon);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int npoints) {
        ShapeCache sc = this.getShapeCache();
        if (sc.polygon == null) {
            sc.polygon = new Polygon();
        }
        sc.polygon.reset();
        sc.polygon.xpoints = xPoints;
        sc.polygon.ypoints = yPoints;
        sc.polygon.npoints = npoints;
        this.fill(sc.polygon);
    }

    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        boolean ret;
        if (this.isOptimized) {
            ret = this.rawDrawImage(image, x + (int)this.transform.getTranslateX(), y + (int)this.transform.getTranslateY(), observer);
        } else {
            AffineTransform t = new AffineTransform();
            t.translate(x, y);
            ret = this.drawImage(image, t, observer);
        }
        return ret;
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        AffineTransform t = new AffineTransform();
        t.translate(x, y);
        double scaleX = (double)width / (double)image.getWidth(observer);
        double scaleY = (double)height / (double)image.getHeight(observer);
        t.scale(scaleX, scaleY);
        return this.drawImage(image, t, observer);
    }

    public boolean drawImage(Image image, int x, int y, Color bgcolor, ImageObserver observer) {
        AffineTransform t = new AffineTransform();
        t.translate(x, y);
        return this.drawImage(image, t, observer);
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        AffineTransform t = new AffineTransform();
        t.translate(x, y);
        double scaleX = (double)image.getWidth(observer) / (double)width;
        double scaleY = (double)image.getHeight(observer) / (double)height;
        t.scale(scaleX, scaleY);
        return this.drawImage(image, t, observer);
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        int sx = Math.min(sx1, sx1);
        int sy = Math.min(sy1, sy2);
        int sw = Math.abs(sx1 - sx2);
        int sh = Math.abs(sy1 - sy2);
        int dx = Math.min(dx1, dx1);
        int dy = Math.min(dy1, dy2);
        int dw = Math.abs(dx1 - dx2);
        int dh = Math.abs(dy1 - dy2);
        AffineTransform t = new AffineTransform();
        t.translate(sx - dx, sy - dy);
        double scaleX = (double)sw / (double)dw;
        double scaleY = (double)sh / (double)dh;
        t.scale(scaleX, scaleY);
        Rectangle areaOfInterest = new Rectangle(sx, sy, sw, sh);
        return this.drawImageImpl(image, t, observer, areaOfInterest);
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    public void dispose() {
    }

    protected void fillShape(Shape s, boolean isFont) {
        Object v;
        boolean antialias = false;
        antialias = isFont ? (v = this.renderingHints.get(RenderingHints.KEY_TEXT_ANTIALIASING)) == RenderingHints.VALUE_TEXT_ANTIALIAS_ON || v == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT : (v = this.renderingHints.get(RenderingHints.KEY_ANTIALIASING)) == RenderingHints.VALUE_ANTIALIAS_ON;
        ScanlineConverter sc = this.getScanlineConverter();
        int resolution = 0;
        if (antialias) {
            resolution = 2;
        }
        sc.renderShape(this, s, this.clip, this.transform, resolution, this.renderingHints);
    }

    protected abstract ColorModel getColorModel();

    protected Rectangle getDeviceBounds() {
        return this.destinationRaster.getBounds();
    }

    protected void rawDrawLine(int x0, int y0, int x1, int y1) {
        ShapeCache sc = this.getShapeCache();
        if (sc.line == null) {
            sc.line = new Line2D.Float();
        }
        sc.line.setLine(x0, y0, x1, y1);
        this.draw(sc.line);
    }

    protected void rawDrawRect(int x, int y, int w, int h) {
        ShapeCache sc = this.getShapeCache();
        if (sc.rect == null) {
            sc.rect = new Rectangle();
        }
        sc.rect.setBounds(x, y, w, h);
        this.draw(sc.rect);
    }

    protected void rawDrawString(String text, int x, int y) {
        FontRenderContext ctx = this.getFontRenderContext();
        GlyphVector gv = this.font.createGlyphVector(ctx, text.toCharArray());
        this.drawGlyphVector(gv, x, y);
    }

    protected void rawClearRect(int x, int y, int w, int h) {
        Paint savedForeground = this.getPaint();
        this.setPaint(this.getBackground());
        this.rawFillRect(x, y, w, h);
        this.setPaint(savedForeground);
    }

    protected void rawFillRect(int x, int y, int w, int h) {
        ShapeCache sc = this.getShapeCache();
        if (sc.rect == null) {
            sc.rect = new Rectangle();
        }
        sc.rect.setBounds(x, y, w, h);
        this.fill(sc.rect);
    }

    protected boolean rawDrawImage(Image image, int x, int y, ImageObserver obs) {
        AffineTransform t = new AffineTransform();
        t.translate(x, y);
        return this.drawImage(image, t, obs);
    }

    protected void rawCopyArea(int x, int y, int w, int h, int dx, int dy) {
        this.copyAreaImpl(x, y, w, h, dx, dy);
    }

    private void copyAreaImpl(int x, int y, int w, int h, int dx, int dy) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void renderScanline(int y, ScanlineCoverage c) {
        PaintContext pCtx = this.paintContext;
        int x0 = c.getMinX();
        int x1 = c.getMaxX();
        Raster paintRaster = pCtx.getRaster(x0, y, x1 - x0, 1);
        float coverageAlpha = 0.0f;
        float maxCoverage = c.getMaxCoverage();
        ColorModel cm = pCtx.getColorModel();
        DataBuffer db = paintRaster.getDataBuffer();
        Point loc = new Point(paintRaster.getMinX(), paintRaster.getMinY());
        SampleModel sm = paintRaster.getSampleModel();
        WritableRaster writeRaster = Raster.createWritableRaster(sm, db, loc);
        WritableRaster alphaRaster = cm.getAlphaRaster(writeRaster);
        ScanlineCoverage.Iterator iter = c.iterate();
        while (iter.hasNext()) {
            ScanlineCoverage.Range range = iter.next();
            coverageAlpha = (float)range.getCoverage() / maxCoverage;
            if (!((double)coverageAlpha < 1.0)) continue;
            int x = range.getXPos();
            while (x < range.getXPosEnd()) {
                int pixel = alphaRaster.getSample(x, y, 0);
                pixel = (int)((float)pixel * coverageAlpha);
                alphaRaster.setSample(x, y, 0, pixel);
                ++x;
            }
        }
        ColorModel paintColorModel = pCtx.getColorModel();
        CompositeContext cCtx = this.composite.createContext(paintColorModel, this.getColorModel(), this.renderingHints);
        WritableRaster targetChild = this.destinationRaster.createWritableTranslatedChild(-x0, -y);
        cCtx.compose(paintRaster, targetChild, targetChild);
        this.updateRaster(this.destinationRaster, x0, y, x1 - x0, 1);
        cCtx.dispose();
    }

    protected void init() {
        this.setPaint(Color.BLACK);
        this.setFont(FONT);
        this.isOptimized = true;
    }

    protected WritableRaster getDestinationRaster() {
        Rectangle db = this.getDeviceBounds();
        if (this.destinationRaster == null) {
            int[] bandMasks = new int[]{0xFF0000, 65280, 255};
            this.destinationRaster = Raster.createPackedRaster(3, db.width, db.height, bandMasks, null);
            int x0 = this.destinationRaster.getMinX();
            int x1 = this.destinationRaster.getWidth() + x0;
            int y0 = this.destinationRaster.getMinY();
            int y1 = this.destinationRaster.getHeight() + y0;
            int numBands = this.destinationRaster.getNumBands();
            int y = y0;
            while (y < y1) {
                int x = x0;
                while (x < x1) {
                    int b = 0;
                    while (b < numBands) {
                        this.destinationRaster.setSample(x, y, b, 255);
                        ++b;
                    }
                    ++x;
                }
                ++y;
            }
        }
        return this.destinationRaster;
    }

    protected void updateRaster(Raster raster, int x, int y, int w, int h) {
    }

    private void updateOptimization() {
        int transformType = this.transform.getType();
        boolean optimizedTransform = false;
        if (transformType == 0 || transformType == 1) {
            optimizedTransform = true;
        }
        boolean optimizedClip = this.clip == null || this.clip instanceof Rectangle;
        this.isOptimized = optimizedClip && optimizedTransform && this.paint instanceof Color && this.composite == AlphaComposite.SrcOver && this.stroke.equals(new BasicStroke());
    }

    private static Rectangle computeIntersection(int x, int y, int w, int h, Rectangle rect) {
        int dh;
        int x2 = rect.x;
        int y2 = rect.y;
        int w2 = rect.width;
        int h2 = rect.height;
        int dx = x > x2 ? x : x2;
        int dy = y > y2 ? y : y2;
        int dw = x + w < x2 + w2 ? x + w - dx : x2 + w2 - dx;
        int n = dh = y + h < y2 + h2 ? y + h - dy : y2 + h2 - dy;
        if (dw >= 0 && dh >= 0) {
            rect.setBounds(dx, dy, dw, dh);
        } else {
            rect.setBounds(0, 0, 0, 0);
        }
        return rect;
    }

    private void updateClip(AffineTransform t) {
        if (!(this.clip instanceof GeneralPath)) {
            this.clip = new GeneralPath(this.clip);
        }
        GeneralPath p = (GeneralPath)this.clip;
        p.transform(t);
    }

    private ShapeCache getShapeCache() {
        ShapeCache sc = shapeCache.get();
        if (sc == null) {
            sc = new ShapeCache();
            shapeCache.set(sc);
        }
        return sc;
    }

    private ScanlineConverter getScanlineConverter() {
        ScanlineConverter sc = scanlineConverters.get();
        if (sc == null) {
            sc = new ScanlineConverter();
            scanlineConverters.set(sc);
        }
        return sc;
    }
}

