/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.ComponentGraphics;
import gnu.java.awt.peer.gtk.GtkVolatileImage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class VolatileImageGraphics
extends ComponentGraphics {
    private GtkVolatileImage owner;
    private BufferedImage buffer;

    public VolatileImageGraphics(GtkVolatileImage img) {
        this.owner = img;
        this.cairo_t = this.initFromVolatile(this.owner.nativePointer, img.width, img.height);
        this.setup(this.cairo_t);
    }

    private VolatileImageGraphics(VolatileImageGraphics copy) {
        this.owner = copy.owner;
        this.cairo_t = this.initFromVolatile(this.owner.nativePointer, this.owner.width, this.owner.height);
        this.copy(copy, this.cairo_t);
    }

    public void copyAreaImpl(int x, int y, int width, int height, int dx, int dy) {
        this.owner.copyArea(x, y, width, height, dx, dy);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        if (this.owner.component == null) {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        GraphicsConfiguration conf = this.owner.component.getGraphicsConfiguration();
        return conf;
    }

    public Graphics create() {
        return new VolatileImageGraphics(this);
    }

    public void draw(Shape s) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.draw(s);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setColor(this.getColor());
            g2d.setStroke(this.getStroke());
            g2d.draw(s);
            this.drawComposite(s.getBounds2D(), null);
        }
    }

    public void fill(Shape s) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.fill(s);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setPaint(this.getPaint());
            g2d.setColor(this.getColor());
            g2d.fill(s);
            this.drawComposite(s.getBounds2D(), null);
        }
    }

    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawGlyphVector(gv, x, y);
        } else {
            this.createBuffer();
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setPaint(this.getPaint());
            g2d.setColor(this.getColor());
            g2d.drawGlyphVector(gv, x, y);
            Rectangle2D bounds = gv.getLogicalBounds();
            bounds = new Rectangle2D.Double((double)x + bounds.getX(), (double)y + bounds.getY(), bounds.getWidth(), bounds.getHeight());
            this.drawComposite(bounds, null);
        }
    }

    protected boolean drawImage(Image img, AffineTransform xform, Color bgcolor, ImageObserver obs) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            return super.drawImage(img, xform, bgcolor, obs);
        }
        if (!(img instanceof BufferedImage)) {
            ImageProducer source = img.getSource();
            if (source == null) {
                return false;
            }
            img = Toolkit.getDefaultToolkit().createImage(source);
        }
        BufferedImage bImg = (BufferedImage)img;
        Point2D origin = new Point2D.Double(bImg.getMinX(), bImg.getMinY());
        Point2D pt = new Point2D.Double(bImg.getWidth(), bImg.getHeight());
        if (xform != null) {
            origin = xform.transform(origin, origin);
            pt = xform.transform(pt, pt);
        }
        this.createBuffer();
        Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
        g2d.setRenderingHints(this.getRenderingHints());
        g2d.drawImage(img, xform, obs);
        return this.drawComposite(new Rectangle2D.Double((int)origin.getX(), (int)origin.getY(), (int)pt.getX(), (int)pt.getY()), obs);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (img instanceof GtkVolatileImage && (this.comp == null || this.comp instanceof AlphaComposite)) {
            this.owner.drawVolatile(((GtkVolatileImage)img).nativePointer, x, y, ((GtkVolatileImage)img).width, ((GtkVolatileImage)img).height);
            return true;
        }
        return super.drawImage(img, x, y, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        if (img instanceof GtkVolatileImage && (this.comp == null || this.comp instanceof AlphaComposite)) {
            this.owner.drawVolatile(((GtkVolatileImage)img).nativePointer, x, y, width, height);
            return true;
        }
        return super.drawImage(img, x, y, width, height, observer);
    }

    protected Rectangle2D getRealBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.owner.width, this.owner.height);
    }

    private boolean drawComposite(Rectangle2D bounds, ImageObserver observer) {
        Rectangle clip = this.getClipBounds();
        Rectangle2D.intersect(bounds, clip, bounds);
        BufferedImage buffer2 = this.buffer;
        if (!bounds.equals(buffer2.getRaster().getBounds())) {
            buffer2 = buffer2.getSubimage((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        }
        BufferedImage current = this.owner.getSnapshot();
        double[] points = new double[]{bounds.getX(), bounds.getY(), bounds.getMaxX(), bounds.getMaxY()};
        this.transform.transform(points, 0, points, 0, 2);
        Rectangle2D.Double deviceBounds = new Rectangle2D.Double(points[0], points[1], points[2] - points[0], points[3] - points[1]);
        Rectangle2D.intersect(deviceBounds, this.getClipInDevSpace(), deviceBounds);
        current = current.getSubimage((int)((RectangularShape)deviceBounds).getX(), (int)((RectangularShape)deviceBounds).getY(), (int)((RectangularShape)deviceBounds).getWidth(), (int)((RectangularShape)deviceBounds).getHeight());
        this.compCtx.compose(buffer2.getRaster(), current.getRaster(), buffer2.getRaster());
        Composite oldComp = this.comp;
        this.comp = null;
        boolean rv = super.drawImage((Image)buffer2, AffineTransform.getTranslateInstance(bounds.getX(), bounds.getY()), null, null);
        this.comp = oldComp;
        return rv;
    }

    private void createBuffer() {
        if (this.buffer == null) {
            WritableRaster rst = Raster.createWritableRaster(GtkVolatileImage.createGdkSampleModel(this.owner.width, this.owner.height), new Point(0, 0));
            this.buffer = new BufferedImage(GtkVolatileImage.gdkColorModel, rst, GtkVolatileImage.gdkColorModel.isAlphaPremultiplied(), new Hashtable());
        } else {
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            g2d.setBackground(new Color(0, 0, 0, 0));
            g2d.clearRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        }
    }

    protected ColorModel getNativeCM() {
        return CairoSurface.cairoCM_pre;
    }
}

