/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Enumeration;

public final class Engine {
    private static final String ALG_ALIAS = "Alg.Alias.";
    private static final int MAX_ALIASES = 5;
    private static final Object[] NO_ARGS = new Object[0];

    private Engine() {
    }

    public static Object getInstance(String service, String algorithm, Provider provider) throws InvocationTargetException, NoSuchAlgorithmException {
        return Engine.getInstance(service, algorithm, provider, NO_ARGS);
    }

    public static Object getInstance(String service, String algorithm, Provider provider, Object[] initArgs) throws InvocationTargetException, NoSuchAlgorithmException {
        if (service == null) {
            throw new IllegalArgumentException("service MUST NOT be null");
        }
        if ((service = service.trim()).length() == 0) {
            throw new IllegalArgumentException("service MUST NOT be empty");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm MUST NOT be null");
        }
        if ((algorithm = algorithm.trim()).length() == 0) {
            throw new IllegalArgumentException("algorithm MUST NOT be empty");
        }
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        if (initArgs == null) {
            throw new IllegalArgumentException("Constructor's parameters MUST NOT be null");
        }
        Enumeration<?> enumer = provider.propertyNames();
        String key = null;
        int count = 0;
        boolean algorithmFound = false;
        StringBuilder sb = new StringBuilder();
        while (enumer.hasMoreElements()) {
            String alias;
            key = (String)enumer.nextElement();
            if (key.equalsIgnoreCase(String.valueOf(service) + "." + algorithm)) {
                algorithm = key.substring(service.length() + 1);
                algorithmFound = true;
                break;
            }
            if (!key.equalsIgnoreCase(ALG_ALIAS + service + "." + algorithm) || algorithm.equalsIgnoreCase(alias = provider.getProperty(key))) continue;
            algorithm = alias;
            if (count++ > 5) {
                sb.append("Algorithm [").append(algorithm).append("] of type [").append(service).append("] from provider [").append(provider).append("] has too many aliases");
                throw new NoSuchAlgorithmException(sb.toString());
            }
            enumer = provider.propertyNames();
        }
        if (!algorithmFound) {
            sb.append("Algorithm [").append(algorithm).append("] of type [").append(service).append("] from provider [").append(provider).append("] is not found");
            throw new NoSuchAlgorithmException(sb.toString());
        }
        Class<?> clazz = null;
        ClassLoader loader = provider.getClass().getClassLoader();
        Constructor constructor = null;
        String className = provider.getProperty(key);
        sb.append("Class [").append(className).append("] for algorithm [").append(algorithm).append("] of type [").append(service).append("] from provider [").append(provider).append("] ");
        Throwable cause = null;
        try {
            clazz = loader != null ? loader.loadClass(className) : Class.forName(className);
            constructor = Engine.getCompatibleConstructor(clazz, initArgs);
            return constructor.newInstance(initArgs);
        }
        catch (ClassNotFoundException x) {
            sb.append("cannot not be found");
            cause = x;
        }
        catch (IllegalAccessException x) {
            sb.append("cannot be accessed");
            cause = x;
        }
        catch (InstantiationException x) {
            sb.append("cannot be instantiated");
            cause = x;
        }
        catch (ExceptionInInitializerError x) {
            sb.append("cannot be initialized");
            cause = x;
        }
        catch (SecurityException x) {
            sb.append("caused a security violation");
            cause = x;
        }
        catch (NoSuchMethodException x) {
            sb.append("does not have/expose an appropriate constructor");
            cause = x;
        }
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    private static Constructor getCompatibleConstructor(Class clazz, Object[] initArgs) throws NoSuchMethodException {
        Constructor<?>[] c = clazz.getConstructors();
        int i = 0;
        while (i < c.length) {
            block4: {
                Class<?>[] argTypes = c[i].getParameterTypes();
                if (argTypes.length == initArgs.length) {
                    int j = 0;
                    while (j < argTypes.length) {
                        if (initArgs[j] == null || argTypes[j].isAssignableFrom(initArgs[j].getClass())) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return c[i];
                }
            }
            ++i;
        }
        throw new NoSuchMethodException();
    }
}

