/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.Registry;
import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.key.dss.DSSKey;
import gnu.java.security.key.dss.DSSKeyPairRawCodec;
import gnu.java.security.key.dss.DSSKeyPairX509Codec;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;

public class DSSPublicKey
extends DSSKey
implements PublicKey,
DSAPublicKey {
    private final BigInteger y;
    private transient String str;

    public DSSPublicKey(BigInteger p, BigInteger q, BigInteger g, BigInteger y) {
        this(1, p, q, g, y);
    }

    public DSSPublicKey(int preferredFormat, BigInteger p, BigInteger q, BigInteger g, BigInteger y) {
        super(preferredFormat == 4 ? 2 : preferredFormat, p, q, g);
        this.y = y;
    }

    public static DSSPublicKey valueOf(byte[] k) {
        if (k[0] == Registry.MAGIC_RAW_DSS_PUBLIC_KEY[0]) {
            try {
                return (DSSPublicKey)new DSSKeyPairRawCodec().decodePublicKey(k);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (DSSPublicKey)new DSSKeyPairX509Codec().decodePublicKey(k);
    }

    public BigInteger getY() {
        return this.y;
    }

    public byte[] getEncoded(int format) {
        byte[] result;
        switch (format) {
            case 1: {
                result = new DSSKeyPairRawCodec().encodePublicKey(this);
                break;
            }
            case 2: {
                result = new DSSKeyPairX509Codec().encodePublicKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding format: " + format);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DSAPublicKey)) {
            return false;
        }
        DSAPublicKey that = (DSAPublicKey)obj;
        return super.equals(that) && this.y.equals(that.getY());
    }

    public String toString() {
        if (this.str == null) {
            String ls = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            this.str = this.getClass().getName() + "(" + super.toString() + "," + ls + "y=0x" + this.y.toString(16) + ls + ")";
        }
        return this.str;
    }
}

