/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.security.Registry;
import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.key.rsa.GnuRSAKey;
import gnu.java.security.key.rsa.RSAKeyPairRawCodec;
import gnu.java.security.key.rsa.RSAKeyPairX509Codec;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;

public class GnuRSAPublicKey
extends GnuRSAKey
implements PublicKey,
RSAPublicKey {
    private transient String str;

    public GnuRSAPublicKey(BigInteger n, BigInteger e) {
        this(1, n, e);
    }

    public GnuRSAPublicKey(int preferredFormat, BigInteger n, BigInteger e) {
        super(preferredFormat == 4 ? 2 : preferredFormat, n, e);
    }

    public static GnuRSAPublicKey valueOf(byte[] k) {
        if (k[0] == Registry.MAGIC_RAW_RSA_PUBLIC_KEY[0]) {
            try {
                return (GnuRSAPublicKey)new RSAKeyPairRawCodec().decodePublicKey(k);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (GnuRSAPublicKey)new RSAKeyPairX509Codec().decodePublicKey(k);
    }

    public byte[] getEncoded(int format) {
        byte[] result;
        switch (format) {
            case 1: {
                result = new RSAKeyPairRawCodec().encodePublicKey(this);
                break;
            }
            case 2: {
                result = new RSAKeyPairX509Codec().encodePublicKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding format: " + format);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RSAPublicKey)) {
            return false;
        }
        RSAPublicKey that = (RSAPublicKey)obj;
        return super.equals(that) && this.getPublicExponent().equals(that.getPublicExponent());
    }

    public String toString() {
        if (this.str == null) {
            String ls = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            this.str = this.getClass().getName() + "(" + super.toString() + "," + ls + ")";
        }
        return this.str;
    }
}

