/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.text;

import gnu.java.text.FormatBuffer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;

public class AttributedFormatBuffer
implements FormatBuffer {
    private StringBuffer buffer;
    private ArrayList ranges;
    private ArrayList attributes;
    private int[] a_ranges;
    private HashMap[] a_attributes;
    private int startingRange;
    AttributedCharacterIterator.Attribute defaultAttr;

    public AttributedFormatBuffer(StringBuffer buffer) {
        this.buffer = buffer;
        this.ranges = new ArrayList();
        this.attributes = new ArrayList();
        this.defaultAttr = null;
        if (buffer.length() != 0) {
            this.startingRange = buffer.length();
            this.addAttribute(buffer.length(), null);
        } else {
            this.startingRange = -1;
        }
    }

    public AttributedFormatBuffer(int prebuffer) {
        this(new StringBuffer(prebuffer));
    }

    public AttributedFormatBuffer() {
        this(10);
    }

    private final void addAttribute(int new_range, AttributedCharacterIterator.Attribute attr) {
        if (attr != null) {
            HashMap<AttributedCharacterIterator.Attribute, AttributedCharacterIterator.Attribute> map = new HashMap<AttributedCharacterIterator.Attribute, AttributedCharacterIterator.Attribute>();
            map.put(attr, attr);
            this.attributes.add(map);
        } else {
            this.attributes.add(null);
        }
        this.ranges.add(new Integer(new_range));
    }

    public void append(String s) {
        if (this.startingRange < 0) {
            this.startingRange = 0;
        }
        this.buffer.append(s);
    }

    public void append(String s, AttributedCharacterIterator.Attribute attr) {
        this.setDefaultAttribute(attr);
        this.startingRange = this.buffer.length();
        this.append(s);
        this.setDefaultAttribute(null);
    }

    public void append(String s, int[] ranges, HashMap[] attrs) {
        int curPos = this.buffer.length();
        this.setDefaultAttribute(null);
        if (ranges != null) {
            int i = 0;
            while (i < ranges.length) {
                this.ranges.add(new Integer(ranges[i] + curPos));
                this.attributes.add(attrs[i]);
                ++i;
            }
        }
        this.startingRange = this.buffer.length();
        this.buffer.append(s);
    }

    public void append(char c) {
        if (this.startingRange < 0) {
            this.startingRange = this.buffer.length();
        }
        this.buffer.append(c);
    }

    public void append(char c, AttributedCharacterIterator.Attribute attr) {
        this.setDefaultAttribute(attr);
        this.buffer.append(c);
        this.setDefaultAttribute(null);
    }

    public void setDefaultAttribute(AttributedCharacterIterator.Attribute attr) {
        if (attr == this.defaultAttr) {
            return;
        }
        int currentPos = this.buffer.length();
        if (this.startingRange != currentPos && this.startingRange >= 0) {
            this.addAttribute(currentPos, this.defaultAttr);
        }
        this.defaultAttr = attr;
        this.startingRange = currentPos;
    }

    public AttributedCharacterIterator.Attribute getDefaultAttribute() {
        return this.defaultAttr;
    }

    public void cutTail(int length) {
        this.buffer.setLength(this.buffer.length() - length);
    }

    public int length() {
        return this.buffer.length();
    }

    public void clear() {
        this.buffer.setLength(0);
        this.ranges.clear();
        this.attributes.clear();
        this.defaultAttr = null;
        this.startingRange = -1;
    }

    public void sync() {
        if (this.startingRange < 0 || this.startingRange == this.buffer.length()) {
            return;
        }
        this.addAttribute(this.buffer.length(), this.defaultAttr);
        this.a_ranges = new int[this.ranges.size()];
        int i = 0;
        while (i < this.a_ranges.length) {
            this.a_ranges[i] = (Integer)this.ranges.get(i);
            ++i;
        }
        this.a_attributes = new HashMap[this.attributes.size()];
        System.arraycopy(this.attributes.toArray(), 0, this.a_attributes, 0, this.a_attributes.length);
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public int[] getRanges() {
        return this.a_ranges;
    }

    public HashMap[] getAttributes() {
        return this.a_attributes;
    }
}

