/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.prefs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;

public class NodeReader {
    private final BufferedReader br;
    private String line = "";
    private final PreferencesFactory factory;

    public NodeReader(Reader r, PreferencesFactory factory) {
        this.br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        this.factory = factory;
    }

    public NodeReader(InputStream is, PreferencesFactory factory) {
        this(new InputStreamReader(is), factory);
    }

    public void importPreferences() throws InvalidPreferencesFormatException, IOException {
        this.readPreferences();
    }

    private void readPreferences() throws InvalidPreferencesFormatException, IOException {
        this.skipTill("<preferences");
        this.readRoot();
        this.skipTill("</preferences>");
    }

    private void readRoot() throws InvalidPreferencesFormatException, IOException {
        Preferences root;
        this.skipTill("<root");
        this.skipTill("type=\"");
        String type = this.readTill("\"");
        if ("user".equals(type)) {
            root = this.factory.userRoot();
        } else if ("system".equals(type)) {
            root = this.factory.systemRoot();
        } else {
            throw new InvalidPreferencesFormatException("Unknown type: " + type);
        }
        this.readMap(root);
        this.readNodes(root);
        this.skipTill("</root>");
    }

    private void readNodes(Preferences node2) throws InvalidPreferencesFormatException, IOException {
        while ("node".equals(this.nextTag())) {
            this.skipTill("<node");
            this.skipTill("name=\"");
            String name = this.readTill("\"");
            Preferences subnode = node2.node(name);
            this.readMap(subnode);
            this.readNodes(subnode);
            this.skipTill("</node>");
        }
    }

    private void readMap(Preferences node2) throws InvalidPreferencesFormatException, IOException {
        this.skipTill("<map");
        if (this.line.startsWith("/>")) {
            this.line = this.line.substring(2);
            return;
        }
        this.readEntries(node2);
        this.skipTill("</map>");
    }

    private void readEntries(Preferences node2) throws InvalidPreferencesFormatException, IOException {
        while ("entry".equals(this.nextTag())) {
            this.skipTill("<entry");
            this.skipTill("key=\"");
            String key = this.readTill("\"");
            this.skipTill("value=\"");
            String value = this.readTill("\"");
            node2.put(key, value);
        }
    }

    private void skipTill(String s) throws InvalidPreferencesFormatException, IOException {
        int index;
        while (true) {
            if (this.line == null) {
                throw new InvalidPreferencesFormatException(String.valueOf(s) + " not found");
            }
            index = this.line.indexOf(s);
            if (index != -1) break;
            this.line = this.br.readLine();
        }
        this.line = this.line.substring(index + s.length());
    }

    private String readTill(String s) throws InvalidPreferencesFormatException {
        int index = this.line.indexOf(s);
        if (index == -1) {
            throw new InvalidPreferencesFormatException(String.valueOf(s) + " not found");
        }
        String read = this.line.substring(0, index);
        this.line = this.line.substring(index + s.length());
        return read;
    }

    private String nextTag() throws InvalidPreferencesFormatException, IOException {
        int start;
        while (true) {
            if (this.line == null) {
                throw new InvalidPreferencesFormatException("unexpected EOF");
            }
            start = this.line.indexOf("<");
            if (start != -1) break;
            this.line = this.br.readLine();
        }
        int end = start + 1;
        while (end != this.line.length() && " \t\r\n".indexOf(this.line.charAt(end)) == -1) {
            ++end;
        }
        String tag = this.line.substring(start + 1, end);
        this.line = this.line.substring(start);
        return tag;
    }
}

