/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.AuthenticatedEntry;
import gnu.javax.crypto.keyring.BinaryDataEntry;
import gnu.javax.crypto.keyring.CertPathEntry;
import gnu.javax.crypto.keyring.CertificateEntry;
import gnu.javax.crypto.keyring.CompressedEntry;
import gnu.javax.crypto.keyring.EncryptedEntry;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.MaskableEnvelopeEntry;
import gnu.javax.crypto.keyring.PasswordAuthenticatedEntry;
import gnu.javax.crypto.keyring.PasswordEncryptedEntry;
import gnu.javax.crypto.keyring.PrimitiveEntry;
import gnu.javax.crypto.keyring.PrivateKeyEntry;
import gnu.javax.crypto.keyring.Properties;
import gnu.javax.crypto.keyring.PublicKeyEntry;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public abstract class EnvelopeEntry
extends Entry {
    private static final Logger log = Logger.getLogger(EnvelopeEntry.class.getName());
    protected EnvelopeEntry containingEnvelope;
    protected List entries = new LinkedList();

    public EnvelopeEntry(int type, Properties properties) {
        super(type, properties);
        if (this.properties.get("alias-list") != null) {
            this.properties.remove("alias-list");
        }
    }

    protected EnvelopeEntry(int type) {
        super(type);
    }

    public void add(Entry entry) {
        if (!this.containsEntry(entry)) {
            if (entry instanceof EnvelopeEntry) {
                ((EnvelopeEntry)entry).setContainingEnvelope(this);
            }
            this.entries.add(entry);
            this.makeAliasList();
        }
    }

    public boolean containsAlias(String alias) {
        String aliases = this.getAliasList();
        boolean result = false;
        if (aliases != null) {
            StringTokenizer tok = new StringTokenizer(aliases, ";");
            while (tok.hasMoreTokens()) {
                if (!tok.nextToken().equals(alias)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean containsEntry(Entry entry) {
        if (entry instanceof EnvelopeEntry) {
            return this.entries.contains(entry);
        }
        if (entry instanceof PrimitiveEntry) {
            for (Entry e : this.entries) {
                if (e.equals(entry)) {
                    return true;
                }
                if (!(e instanceof EnvelopeEntry) || !((EnvelopeEntry)e).containsEntry(entry)) continue;
                return true;
            }
        }
        return false;
    }

    public List getEntries() {
        return new ArrayList(this.entries);
    }

    public List get(String alias) {
        LinkedList result = new LinkedList();
        for (Entry e : this.entries) {
            PrimitiveEntry pe;
            if (e instanceof EnvelopeEntry) {
                MaskableEnvelopeEntry mee;
                EnvelopeEntry ee = (EnvelopeEntry)e;
                if (!ee.containsAlias(alias)) continue;
                if (ee instanceof MaskableEnvelopeEntry && (mee = (MaskableEnvelopeEntry)ee).isMasked()) {
                    result.add(mee);
                    continue;
                }
                result.addAll(ee.get(alias));
                continue;
            }
            if (!(e instanceof PrimitiveEntry) || !(pe = (PrimitiveEntry)e).getAlias().equals(alias)) continue;
            result.add(e);
        }
        return result;
    }

    public String getAliasList() {
        String list2 = this.properties.get("alias-list");
        if (list2 == null) {
            return "";
        }
        return list2;
    }

    public boolean remove(Entry entry) {
        boolean ret = false;
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            Entry e = (Entry)it.next();
            if (e instanceof EnvelopeEntry) {
                if (e == entry) {
                    it.remove();
                    ret = true;
                    break;
                }
                if (!((EnvelopeEntry)e).remove(entry)) continue;
                ret = true;
                break;
            }
            if (!(e instanceof PrimitiveEntry) || !((PrimitiveEntry)e).equals(entry)) continue;
            it.remove();
            ret = true;
            break;
        }
        if (ret) {
            this.payload = null;
            this.makeAliasList();
        }
        return ret;
    }

    public boolean remove(String alias) {
        boolean result = false;
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            PrimitiveEntry pe;
            Entry e = (Entry)it.next();
            if (e instanceof EnvelopeEntry) {
                EnvelopeEntry ee = (EnvelopeEntry)e;
                result = ee.remove(alias) || result;
                continue;
            }
            if (!(e instanceof PrimitiveEntry) || !(pe = (PrimitiveEntry)e).getAlias().equals(alias)) continue;
            it.remove();
            result = true;
        }
        if (result) {
            this.payload = null;
            this.makeAliasList();
        }
        return result;
    }

    public String toString() {
        return "Envelope{" + super.toString() + ", entries=" + this.entries + "}";
    }

    protected void encodePayload() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        DataOutputStream out = new DataOutputStream(bout);
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            ((Entry)it.next()).encode(out);
        }
    }

    protected void setContainingEnvelope(EnvelopeEntry e) {
        if (this.containingEnvelope != null) {
            throw new IllegalArgumentException("envelopes may not be shared");
        }
        this.containingEnvelope = e;
    }

    protected void decodeEnvelope(DataInputStream in) throws IOException {
        int type;
        this.entries.clear();
        block13: while (true) {
            type = in.read();
            switch (type) {
                case 0: {
                    this.add(EncryptedEntry.decode(in));
                    continue block13;
                }
                case 1: {
                    this.add(PasswordEncryptedEntry.decode(in));
                    continue block13;
                }
                case 3: {
                    this.add(PasswordAuthenticatedEntry.decode(in));
                    continue block13;
                }
                case 2: {
                    this.add(AuthenticatedEntry.decode(in));
                    continue block13;
                }
                case 4: {
                    this.add(CompressedEntry.decode(in));
                    continue block13;
                }
                case 5: {
                    this.add(CertificateEntry.decode(in));
                    continue block13;
                }
                case 6: {
                    this.add(PublicKeyEntry.decode(in));
                    continue block13;
                }
                case 7: {
                    this.add(PrivateKeyEntry.decode(in));
                    continue block13;
                }
                case 8: {
                    this.add(CertPathEntry.decode(in));
                    continue block13;
                }
                case 9: {
                    this.add(BinaryDataEntry.decode(in));
                    continue block13;
                }
                case -1: {
                    return;
                }
            }
            break;
        }
        throw new MalformedKeyringException("unknown type " + type);
    }

    private void makeAliasList() {
        if (!this.entries.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            Iterator it = this.entries.iterator();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                String aliasOrList = null;
                if (entry instanceof EnvelopeEntry) {
                    aliasOrList = ((EnvelopeEntry)entry).getAliasList();
                } else if (entry instanceof PrimitiveEntry) {
                    aliasOrList = ((PrimitiveEntry)entry).getAlias();
                }
                if (aliasOrList == null || (aliasOrList = aliasOrList.trim()).trim().length() <= 0) continue;
                buf.append(aliasOrList);
                if (!it.hasNext()) continue;
                buf.append(';');
            }
            String aliasList = buf.toString();
            this.properties.put("alias-list", aliasList);
            if (this.containingEnvelope != null) {
                this.containingEnvelope.makeAliasList();
            }
        }
    }
}

