/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.java.security.hash.MD5;
import gnu.java.security.util.PRNG;
import gnu.java.security.util.Util;
import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.key.IKeyAgreementParty;
import gnu.javax.crypto.key.IncomingMessage;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.KeyAgreementFactory;
import gnu.javax.crypto.key.OutgoingMessage;
import gnu.javax.crypto.sasl.ClientMechanism;
import gnu.javax.crypto.sasl.IllegalMechanismStateException;
import gnu.javax.crypto.sasl.InputBuffer;
import gnu.javax.crypto.sasl.IntegrityException;
import gnu.javax.crypto.sasl.OutputBuffer;
import gnu.javax.crypto.sasl.srp.CALG;
import gnu.javax.crypto.sasl.srp.ClientStore;
import gnu.javax.crypto.sasl.srp.IALG;
import gnu.javax.crypto.sasl.srp.KDF;
import gnu.javax.crypto.sasl.srp.SRP;
import gnu.javax.crypto.sasl.srp.SRPRegistry;
import gnu.javax.crypto.sasl.srp.SecurityContext;
import gnu.javax.security.auth.Password;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class SRPClient
extends ClientMechanism
implements SaslClient {
    private static final Logger log = Logger.getLogger(SRPClient.class.getName());
    private String uid;
    private String U;
    BigInteger N;
    BigInteger g;
    BigInteger A;
    BigInteger B;
    private Password password;
    private byte[] s;
    private byte[] cIV;
    private byte[] sIV;
    private byte[] M1;
    private byte[] M2;
    private byte[] cn;
    private byte[] sn;
    private SRP srp;
    private byte[] sid;
    private int ttl;
    private byte[] sCB;
    private String L;
    private String o;
    private String chosenIntegrityAlgorithm;
    private String chosenConfidentialityAlgorithm;
    private int rawSendSize = 0x7FFFFFFB;
    private byte[] K;
    private boolean replayDetection = true;
    private int inCounter = 0;
    private int outCounter = 0;
    private IALG inMac;
    private IALG outMac;
    private CALG inCipher;
    private CALG outCipher;
    private IKeyAgreementParty clientHandler = KeyAgreementFactory.getPartyAInstance("srp-sasl");
    private PRNG prng = null;

    public SRPClient() {
        super("SRP");
    }

    protected void initMechanism() throws SaslException {
        MD5 md = new MD5();
        byte[] b = this.authorizationID.getBytes();
        md.update(b, 0, b.length);
        b = this.serverName.getBytes();
        md.update(b, 0, b.length);
        b = this.protocol.getBytes();
        md.update(b, 0, b.length);
        if (this.channelBinding.length > 0) {
            md.update(this.channelBinding, 0, this.channelBinding.length);
        }
        this.uid = Util.toBase64(md.digest());
        if (ClientStore.instance().isAlive(this.uid)) {
            SecurityContext ctx = ClientStore.instance().restoreSession(this.uid);
            this.srp = SRP.instance(ctx.getMdName());
            this.sid = ctx.getSID();
            this.K = ctx.getK();
            this.cIV = ctx.getClientIV();
            this.sIV = ctx.getServerIV();
            this.replayDetection = ctx.hasReplayDetection();
            this.inCounter = ctx.getInCounter();
            this.outCounter = ctx.getOutCounter();
            this.inMac = ctx.getInMac();
            this.outMac = ctx.getOutMac();
            this.inCipher = ctx.getInCipher();
            this.outCipher = ctx.getOutCipher();
        } else {
            this.sid = new byte[0];
            this.ttl = 0;
            this.K = null;
            this.cIV = null;
            this.sIV = null;
            this.cn = null;
            this.sn = null;
        }
    }

    protected void resetMechanism() throws SaslException {
        try {
            this.password.destroy();
        }
        catch (DestroyFailedException dfe) {
            SaslException se = new SaslException("resetMechanism()");
            se.initCause(dfe);
            throw se;
        }
        this.password = null;
        this.M1 = null;
        this.K = null;
        this.cIV = null;
        this.sIV = null;
        this.outMac = null;
        this.inMac = null;
        this.outCipher = null;
        this.inCipher = null;
        this.sid = null;
        this.ttl = 0;
        this.cn = null;
        this.sn = null;
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        switch (this.state) {
            case 0: {
                ++this.state;
                return this.sendIdentities();
            }
            case 1: {
                ++this.state;
                byte[] result = this.sendPublicKey(challenge);
                try {
                    this.password.destroy();
                }
                catch (DestroyFailedException destroyFailedException) {
                    SaslException se = new SaslException("sendPublicKey()");
                    se.initCause(se);
                    throw se;
                }
                return result;
            }
            case 2: {
                if (this.complete) break;
                ++this.state;
                return this.receiveEvidence(challenge);
            }
        }
        throw new IllegalMechanismStateException("evaluateChallenge()");
    }

    protected byte[] engineUnwrap(byte[] incoming, int offset, int len) throws SaslException {
        byte[] result;
        if (this.inMac == null && this.inCipher == null) {
            throw new IllegalStateException("connection is not protected");
        }
        try {
            if (this.inMac != null) {
                byte[] computed_mac;
                int macBytesCount = this.inMac.length();
                int payloadLength = len - macBytesCount;
                byte[] received_mac = new byte[macBytesCount];
                System.arraycopy(incoming, offset + payloadLength, received_mac, 0, macBytesCount);
                this.inMac.update(incoming, offset, payloadLength);
                if (this.replayDetection) {
                    ++this.inCounter;
                    this.inMac.update(new byte[]{(byte)(this.inCounter >>> 24), (byte)(this.inCounter >>> 16), (byte)(this.inCounter >>> 8), (byte)this.inCounter});
                }
                if (!Arrays.equals(received_mac, computed_mac = this.inMac.doFinal())) {
                    throw new IntegrityException("engineUnwrap()");
                }
                if (this.inCipher != null) {
                    result = this.inCipher.doFinal(incoming, offset, payloadLength);
                } else {
                    result = new byte[len - macBytesCount];
                    System.arraycopy(incoming, offset, result, 0, result.length);
                }
            } else {
                result = this.inCipher.doFinal(incoming, offset, len);
            }
        }
        catch (IOException x) {
            if (x instanceof SaslException) {
                throw (SaslException)x;
            }
            throw new SaslException("engineUnwrap()", x);
        }
        return result;
    }

    protected byte[] engineWrap(byte[] outgoing, int offset, int len) throws SaslException {
        byte[] result;
        if (this.outMac == null && this.outCipher == null) {
            throw new IllegalStateException("connection is not protected");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (this.outCipher != null) {
                result = this.outCipher.doFinal(outgoing, offset, len);
                out.write(result);
                if (this.outMac != null) {
                    this.outMac.update(result);
                    if (this.replayDetection) {
                        ++this.outCounter;
                        this.outMac.update(new byte[]{(byte)(this.outCounter >>> 24), (byte)(this.outCounter >>> 16), (byte)(this.outCounter >>> 8), (byte)this.outCounter});
                    }
                    byte[] C = this.outMac.doFinal();
                    out.write(C);
                }
            } else {
                out.write(outgoing, offset, len);
                this.outMac.update(outgoing, offset, len);
                if (this.replayDetection) {
                    ++this.outCounter;
                    this.outMac.update(new byte[]{(byte)(this.outCounter >>> 24), (byte)(this.outCounter >>> 16), (byte)(this.outCounter >>> 8), (byte)this.outCounter});
                }
                byte[] C = this.outMac.doFinal();
                out.write(C);
            }
            result = out.toByteArray();
        }
        catch (IOException x) {
            if (x instanceof SaslException) {
                throw (SaslException)x;
            }
            throw new SaslException("engineWrap()", x);
        }
        return result;
    }

    protected String getNegotiatedQOP() {
        if (this.inMac != null) {
            if (this.inCipher != null) {
                return "auth-conf";
            }
            return "auth-int";
        }
        return "auth";
    }

    protected String getNegotiatedStrength() {
        if (this.inMac != null) {
            if (this.inCipher != null) {
                return "high";
            }
            return "medium";
        }
        return "low";
    }

    protected String getNegotiatedRawSendSize() {
        return String.valueOf(this.rawSendSize);
    }

    protected String getReuse() {
        return "true";
    }

    private byte[] sendIdentities() throws SaslException {
        this.getUsernameAndPassword();
        if (this.sid.length != 0) {
            this.cn = new byte[16];
            this.getDefaultPRNG().nextBytes(this.cn);
        } else {
            this.cn = new byte[0];
        }
        OutputBuffer frameOut = new OutputBuffer();
        try {
            frameOut.setText(this.U);
            frameOut.setText(this.authorizationID);
            frameOut.setEOS(this.sid);
            frameOut.setOS(this.cn);
            frameOut.setEOS(this.channelBinding);
        }
        catch (IOException x) {
            if (x instanceof SaslException) {
                throw (SaslException)x;
            }
            throw new AuthenticationException("sendIdentities()", x);
        }
        byte[] result = frameOut.encode();
        return result;
    }

    private byte[] sendPublicKey(byte[] input) throws SaslException {
        int ack;
        block15: {
            InputBuffer frameIn = new InputBuffer(input);
            try {
                ack = (int)frameIn.getScalar(1);
                if (ack == 0) {
                    this.N = frameIn.getMPI();
                    this.g = frameIn.getMPI();
                    this.s = frameIn.getOS();
                    this.B = frameIn.getMPI();
                    this.L = frameIn.getText();
                    break block15;
                }
                if (ack == 255) {
                    this.sn = frameIn.getOS();
                    this.sCB = frameIn.getEOS();
                    break block15;
                }
                throw new SaslException("sendPublicKey(): Invalid scalar (" + ack + ") in server's request");
            }
            catch (IOException x) {
                if (x instanceof SaslException) {
                    throw (SaslException)x;
                }
                throw new SaslException("sendPublicKey()", x);
            }
        }
        if (ack == 0) {
            this.o = this.createO(this.L.toLowerCase());
            byte[] pBytes = this.password.getBytes();
            HashMap<String, Object> mapA = new HashMap<String, Object>();
            mapA.put("gnu.crypto.srp6.ka.H", this.srp.getAlgorithm());
            mapA.put("gnu.crypto.srp6.ka.I", this.U);
            mapA.put("gnu.crypto.srp6.ka.p", pBytes);
            try {
                this.clientHandler.init(mapA);
                this.clientHandler.processMessage(null);
            }
            catch (KeyAgreementException x) {
                throw new SaslException("sendPublicKey()", x);
            }
            try {
                OutgoingMessage out = new OutgoingMessage();
                out.writeMPI(this.N);
                out.writeMPI(this.g);
                out.writeMPI(new BigInteger(1, this.s));
                out.writeMPI(this.B);
                IncomingMessage in = new IncomingMessage(out.toByteArray());
                out = this.clientHandler.processMessage(in);
                in = new IncomingMessage(out.toByteArray());
                this.A = in.readMPI();
                this.K = this.clientHandler.getSharedSecret();
            }
            catch (KeyAgreementException x) {
                throw new SaslException("sendPublicKey()", x);
            }
            try {
                this.M1 = this.srp.generateM1(this.N, this.g, this.U, this.s, this.A, this.B, this.K, this.authorizationID, this.L, this.cn, this.channelBinding);
            }
            catch (UnsupportedEncodingException x) {
                throw new AuthenticationException("sendPublicKey()", x);
            }
            OutputBuffer frameOut = new OutputBuffer();
            try {
                frameOut.setMPI(this.A);
                frameOut.setOS(this.M1);
                frameOut.setText(this.o);
                frameOut.setOS(this.cIV);
            }
            catch (IOException x) {
                if (x instanceof SaslException) {
                    throw (SaslException)x;
                }
                throw new AuthenticationException("sendPublicKey()", x);
            }
            byte[] result = frameOut.encode();
            return result;
        }
        this.setupSecurityServices(true);
        return null;
    }

    private byte[] receiveEvidence(byte[] input) throws SaslException {
        byte[] expected;
        InputBuffer frameIn = new InputBuffer(input);
        try {
            this.M2 = frameIn.getOS();
            this.sIV = frameIn.getOS();
            this.sid = frameIn.getEOS();
            this.ttl = (int)frameIn.getScalar(4);
            this.sCB = frameIn.getEOS();
        }
        catch (IOException x) {
            if (x instanceof SaslException) {
                throw (SaslException)x;
            }
            throw new AuthenticationException("receiveEvidence()", x);
        }
        try {
            expected = this.srp.generateM2(this.A, this.M1, this.K, this.U, this.authorizationID, this.o, this.sid, this.ttl, this.cIV, this.sIV, this.sCB);
        }
        catch (UnsupportedEncodingException x) {
            throw new AuthenticationException("receiveEvidence()", x);
        }
        if (!Arrays.equals(this.M2, expected)) {
            throw new AuthenticationException("M2 mismatch");
        }
        this.setupSecurityServices(false);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getUsernameAndPassword() throws AuthenticationException {
        try {
            if (!this.properties.containsKey("gnu.crypto.sasl.username") && !this.properties.containsKey("gnu.crypto.sasl.password")) {
                String defaultName = System.getProperty("user.name");
                NameCallback nameCB = defaultName == null ? new NameCallback("username: ") : new NameCallback("username: ", defaultName);
                PasswordCallback pwdCB = new PasswordCallback("password: ", false);
                this.handler.handle(new Callback[]{nameCB, pwdCB});
                this.U = nameCB.getName();
                this.password = new Password(pwdCB.getPassword());
            } else {
                if (this.properties.containsKey("gnu.crypto.sasl.username")) {
                    this.U = (String)this.properties.get("gnu.crypto.sasl.username");
                } else {
                    String defaultName = System.getProperty("user.name");
                    NameCallback nameCB = defaultName == null ? new NameCallback("username: ") : new NameCallback("username: ", defaultName);
                    this.handler.handle(new Callback[]{nameCB});
                    this.U = nameCB.getName();
                }
                if (this.properties.containsKey("gnu.crypto.sasl.password")) {
                    Object pw = this.properties.get("gnu.crypto.sasl.password");
                    if (pw instanceof char[]) {
                        this.password = new Password((char[])pw);
                    } else if (pw instanceof Password) {
                        this.password = (Password)pw;
                    } else {
                        if (!(pw instanceof String)) throw new IllegalArgumentException(String.valueOf(pw.getClass().getName()) + "is not a valid password class");
                        this.password = new Password(((String)pw).toCharArray());
                    }
                } else {
                    PasswordCallback pwdCB = new PasswordCallback("password: ", false);
                    this.handler.handle(new Callback[]{pwdCB});
                    this.password = new Password(pwdCB.getPassword());
                }
            }
            if (this.U == null) {
                throw new AuthenticationException("null username supplied");
            }
            if (this.password != null) return;
            throw new AuthenticationException("null password supplied");
        }
        catch (UnsupportedCallbackException x) {
            throw new AuthenticationException("getUsernameAndPassword()", x);
        }
        catch (IOException x) {
            throw new AuthenticationException("getUsernameAndPassword()", x);
        }
    }

    private String createO(String aol) throws AuthenticationException {
        boolean confidentiality;
        boolean replaydetectionAvailable = false;
        boolean integrityAvailable = false;
        boolean confidentialityAvailable = false;
        String mandatory = "replay_detection";
        String mdName = SRPRegistry.SRP_DEFAULT_DIGEST_NAME;
        StringTokenizer st = new StringTokenizer(aol, ",");
        block2: while (st.hasMoreTokens()) {
            int i;
            String option = st.nextToken();
            if (option.startsWith("mda=")) {
                option = option.substring(option.indexOf(61) + 1);
                i = 0;
                while (i < SRPRegistry.INTEGRITY_ALGORITHMS.length) {
                    if (SRPRegistry.SRP_ALGORITHMS[i].equals(option)) {
                        mdName = option;
                        continue block2;
                    }
                    ++i;
                }
                continue;
            }
            if (option.equals("replay_detection")) {
                replaydetectionAvailable = true;
                continue;
            }
            if (option.startsWith("integrity=")) {
                option = option.substring(option.indexOf(61) + 1);
                i = 0;
                while (i < SRPRegistry.INTEGRITY_ALGORITHMS.length) {
                    if (SRPRegistry.INTEGRITY_ALGORITHMS[i].equals(option)) {
                        this.chosenIntegrityAlgorithm = option;
                        integrityAvailable = true;
                        continue block2;
                    }
                    ++i;
                }
                continue;
            }
            if (option.startsWith("confidentiality=")) {
                option = option.substring(option.indexOf(61) + 1);
                i = 0;
                while (i < SRPRegistry.CONFIDENTIALITY_ALGORITHMS.length) {
                    if (SRPRegistry.CONFIDENTIALITY_ALGORITHMS[i].equals(option)) {
                        this.chosenConfidentialityAlgorithm = option;
                        confidentialityAvailable = true;
                        continue block2;
                    }
                    ++i;
                }
                continue;
            }
            if (option.startsWith("mandatory=")) {
                mandatory = option.substring(option.indexOf(61) + 1);
                continue;
            }
            if (!option.startsWith("maxbuffersize=")) continue;
            String maxBufferSize = option.substring(option.indexOf(61) + 1);
            try {
                this.rawSendSize = Integer.parseInt(maxBufferSize);
                if (this.rawSendSize <= 0x7FFFFFFB && this.rawSendSize >= 1) continue;
                throw new AuthenticationException("Illegal value for 'maxbuffersize' option");
            }
            catch (NumberFormatException x) {
                throw new AuthenticationException("maxbuffersize=" + maxBufferSize, x);
            }
        }
        String s = (String)this.properties.get("gnu.crypto.sasl.srp.replay.detection");
        Boolean flag = Boolean.valueOf(s);
        this.replayDetection = replaydetectionAvailable && flag != false;
        s = (String)this.properties.get("gnu.crypto.sasl.srp.integrity");
        flag = Boolean.valueOf(s);
        boolean integrity = integrityAvailable && flag != false;
        s = (String)this.properties.get("gnu.crypto.sasl.srp.confidentiality");
        flag = Boolean.valueOf(s);
        boolean bl = confidentiality = confidentialityAvailable && flag != false;
        if ("replay_detection".equals(mandatory)) {
            this.replayDetection = true;
            integrity = true;
        } else if ("integrity".equals(mandatory)) {
            integrity = true;
        } else if ("confidentiality".equals(mandatory)) {
            confidentiality = true;
        }
        if (this.replayDetection && this.chosenIntegrityAlgorithm == null) {
            throw new AuthenticationException("Replay detection is required but no integrity protection algorithm was chosen");
        }
        if (integrity && this.chosenIntegrityAlgorithm == null) {
            throw new AuthenticationException("Integrity protection is required but no algorithm was chosen");
        }
        if (confidentiality && this.chosenConfidentialityAlgorithm == null) {
            throw new AuthenticationException("Confidentiality protection is required but no algorithm was chosen");
        }
        if (this.chosenConfidentialityAlgorithm == null) {
            this.cIV = new byte[0];
        } else {
            IBlockCipher cipher = CipherFactory.getInstance(this.chosenConfidentialityAlgorithm);
            if (cipher == null) {
                throw new AuthenticationException("createO()", new NoSuchAlgorithmException());
            }
            int blockSize = cipher.defaultBlockSize();
            this.cIV = new byte[blockSize];
            this.getDefaultPRNG().nextBytes(this.cIV);
        }
        this.srp = SRP.instance(mdName);
        StringBuffer sb = new StringBuffer();
        sb.append("mda").append("=").append(mdName).append(",");
        if (this.replayDetection) {
            sb.append("replay_detection").append(",");
        }
        if (integrity) {
            sb.append("integrity").append("=").append(this.chosenIntegrityAlgorithm).append(",");
        }
        if (confidentiality) {
            sb.append("confidentiality").append("=").append(this.chosenConfidentialityAlgorithm).append(",");
        }
        String result = sb.append("maxbuffersize").append("=").append(0x7FFFFFFB).toString();
        return result;
    }

    private void setupSecurityServices(boolean sessionReUse) throws SaslException {
        this.complete = true;
        if (!sessionReUse) {
            this.inCounter = 0;
            this.outCounter = 0;
            if (this.chosenConfidentialityAlgorithm != null) {
                this.inCipher = CALG.getInstance(this.chosenConfidentialityAlgorithm);
                this.outCipher = CALG.getInstance(this.chosenConfidentialityAlgorithm);
            }
            if (this.chosenIntegrityAlgorithm != null) {
                this.inMac = IALG.getInstance(this.chosenIntegrityAlgorithm);
                this.outMac = IALG.getInstance(this.chosenIntegrityAlgorithm);
            }
        } else {
            this.K = this.srp.generateKn(this.K, this.cn, this.sn);
        }
        KDF kdf = KDF.getInstance(this.K);
        if (this.inCipher != null) {
            this.inCipher.init(kdf, this.sIV, Direction.REVERSED);
            this.outCipher.init(kdf, this.cIV, Direction.FORWARD);
        }
        if (this.inMac != null) {
            this.inMac.init(kdf);
            this.outMac.init(kdf);
        }
        if (this.sid != null && this.sid.length != 0) {
            ClientStore.instance().cacheSession(this.uid, this.ttl, new SecurityContext(this.srp.getAlgorithm(), this.sid, this.K, this.cIV, this.sIV, this.replayDetection, this.inCounter, this.outCounter, this.inMac, this.outMac, this.inCipher, this.outCipher));
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

