/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.action.GetSecurityPropertyAction;
import gnu.javax.net.ssl.provider.CipherAlgorithm;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.MacAlgorithm;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.SignatureAlgorithm;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.NullCipher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CipherSuite
implements Constructed {
    private static final List<String> tlsSuiteNames = new LinkedList<String>();
    private static final HashMap<String, CipherSuite> namesToSuites = new HashMap();
    public static final CipherSuite TLS_NULL_WITH_NULL_NULL = new CipherSuite(CipherAlgorithm.NULL, KeyExchangeAlgorithm.NONE, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.NULL, 0, 0, 0, "TLS_NULL_WITH_NULL_NULL");
    public static final CipherSuite TLS_RSA_WITH_NULL_MD5 = new CipherSuite(CipherAlgorithm.NULL, KeyExchangeAlgorithm.RSA, SignatureAlgorithm.RSA, MacAlgorithm.MD5, 0, 0, 1, "TLS_RSA_WITH_NULL_MD5");
    public static final CipherSuite TLS_RSA_WITH_NULL_SHA = new CipherSuite(CipherAlgorithm.NULL, KeyExchangeAlgorithm.RSA, SignatureAlgorithm.RSA, MacAlgorithm.SHA, 0, 0, 2, "TLS_RSA_WITH_NULL_SHA");
    public static final CipherSuite TLS_RSA_EXPORT_WITH_RC4_40_MD5 = new CipherSuite(CipherAlgorithm.RC4, KeyExchangeAlgorithm.RSA, SignatureAlgorithm.RSA, MacAlgorithm.MD5, 5, 0, 3, "TLS_RSA_EXPORT_WITH_RC4_40_MD5");
    public static final CipherSuite TLS_RSA_WITH_RC4_128_MD5 = new CipherSuite(CipherAlgorithm.RC4, KeyExchangeAlgorithm.RSA, SignatureAlgorithm.RSA, MacAlgorithm.MD5, 16, 0, 4, "TLS_RSA_WITH_RC4_128_MD5");
    public static final CipherSuite TLS_RSA_WITH_RC4_128_SHA = new CipherSuite(CipherAlgorithm.RC4, KeyExchangeAlgorithm.RSA, SignatureAlgorithm.RSA, MacAlgorithm.SHA, 16, 0, 5, "TLS_RSA_WITH_RC4_128_SHA");
    public static final CipherSuite TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite(CipherAlgorithm.DES, KeyExchangeAlgorithm.RSA, SignatureAlgorithm.RSA, MacAlgorithm.SHA, 5, 0, 8, "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA");
    public static final CipherSuite TLS_RSA_WITH_DES_CBC_SHA = new CipherSuite(CipherAlgorithm.DES, KeyExchangeAlgorithm.RSA, SignatureAlgorithm.RSA, MacAlgorithm.SHA, 8, 0, 9, "TLS_RSA_WITH_DES_CBC_SHA");
    public static final CipherSuite TLS_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite(CipherAlgorithm.DESede, KeyExchangeAlgorithm.RSA, SignatureAlgorithm.RSA, MacAlgorithm.SHA, 24, 0, 10, "TLS_RSA_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite(CipherAlgorithm.DES, KeyExchangeAlgorithm.DH_DSS, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 5, 0, 11, "TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA");
    public static final CipherSuite TLS_DH_DSS_WITH_DES_CBC_SHA = new CipherSuite(CipherAlgorithm.DES, KeyExchangeAlgorithm.DH_DSS, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 8, 0, 12, "TLS_DH_DSS_WITH_DES_CBC_SHA");
    public static final CipherSuite TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA = new CipherSuite(CipherAlgorithm.DESede, KeyExchangeAlgorithm.DH_DSS, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 24, 0, 13, "TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite(CipherAlgorithm.DES, KeyExchangeAlgorithm.DH_RSA, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 5, 0, 14, "TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA");
    public static final CipherSuite TLS_DH_RSA_WITH_DES_CBC_SHA = new CipherSuite(CipherAlgorithm.DES, KeyExchangeAlgorithm.DH_RSA, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 8, 0, 15, "TLS_DH_RSA_WITH_DES_CBC_SHA");
    public static final CipherSuite TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite(CipherAlgorithm.DESede, KeyExchangeAlgorithm.DH_RSA, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 24, 0, 16, "TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite(CipherAlgorithm.DES, KeyExchangeAlgorithm.DHE_DSS, true, SignatureAlgorithm.DSA, MacAlgorithm.SHA, 5, 0, 17, "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
    public static final CipherSuite TLS_DHE_DSS_WITH_DES_CBC_SHA = new CipherSuite(CipherAlgorithm.DES, KeyExchangeAlgorithm.DHE_DSS, true, SignatureAlgorithm.DSA, MacAlgorithm.SHA, 8, 0, 18, "TLS_DHE_DSS_WITH_DES_CBC_SHA");
    public static final CipherSuite TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = new CipherSuite(CipherAlgorithm.DESede, KeyExchangeAlgorithm.DHE_DSS, true, SignatureAlgorithm.DSA, MacAlgorithm.SHA, 24, 0, 19, "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite(CipherAlgorithm.DES, KeyExchangeAlgorithm.DHE_RSA, true, SignatureAlgorithm.RSA, MacAlgorithm.SHA, 5, 0, 20, "TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA");
    public static final CipherSuite TLS_DHE_RSA_WITH_DES_CBC_SHA = new CipherSuite(CipherAlgorithm.DES, KeyExchangeAlgorithm.DHE_RSA, true, SignatureAlgorithm.RSA, MacAlgorithm.SHA, 8, 0, 21, "TLS_DHE_RSA_WITH_DES_CBC_SHA");
    public static final CipherSuite TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite(CipherAlgorithm.DESede, KeyExchangeAlgorithm.DHE_RSA, true, SignatureAlgorithm.RSA, MacAlgorithm.SHA, 24, 0, 22, "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_RSA_WITH_AES_128_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.RSA, SignatureAlgorithm.RSA, MacAlgorithm.SHA, 16, 0, 47, "TLS_RSA_WITH_AES_128_CBC_SHA");
    public static final CipherSuite TLS_DH_DSS_WITH_AES_128_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.DH_DSS, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 16, 0, 48, "TLS_DH_DSS_WITH_AES_128_CBC_SHA");
    public static final CipherSuite TLS_DH_RSA_WITH_AES_128_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.DH_RSA, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 16, 0, 49, "TLS_DH_RSA_WITH_AES_128_CBC_SHA");
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_128_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.DHE_DSS, true, SignatureAlgorithm.DSA, MacAlgorithm.SHA, 16, 0, 50, "TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_128_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.DHE_RSA, true, SignatureAlgorithm.RSA, MacAlgorithm.SHA, 16, 0, 51, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA");
    public static final CipherSuite TLS_RSA_WITH_AES_256_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.RSA, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 32, 0, 53, "TLS_RSA_WITH_AES_256_CBC_SHA");
    public static final CipherSuite TLS_DH_DSS_WITH_AES_256_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.DH_DSS, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 32, 0, 54, "TLS_DH_DSS_WITH_AES_256_CBC_SHA");
    public static final CipherSuite TLS_DH_RSA_WITH_AES_256_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.DH_RSA, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 32, 0, 55, "TLS_DH_RSA_WITH_AES_256_CBC_SHA");
    public static final CipherSuite TLS_DHE_DSS_WITH_AES_256_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.DHE_DSS, true, SignatureAlgorithm.DSA, MacAlgorithm.SHA, 32, 0, 56, "TLS_DHE_DSS_WITH_AES_256_CBC_SHA");
    public static final CipherSuite TLS_DHE_RSA_WITH_AES_256_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.DHE_RSA, true, SignatureAlgorithm.RSA, MacAlgorithm.SHA, 32, 0, 57, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA");
    public static final CipherSuite TLS_PSK_WITH_RC4_128_SHA = new CipherSuite(CipherAlgorithm.RC4, KeyExchangeAlgorithm.PSK, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 16, 0, 138, "TLS_PSK_WITH_RC4_128_SHA");
    public static final CipherSuite TLS_PSK_WITH_3DES_EDE_CBC_SHA = new CipherSuite(CipherAlgorithm.DESede, KeyExchangeAlgorithm.PSK, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 24, 0, 139, "TLS_PSK_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_PSK_WITH_AES_128_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.PSK, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 16, 0, 140, "TLS_PSK_WITH_AES_128_CBC_SHA");
    public static final CipherSuite TLS_PSK_WITH_AES_256_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.PSK, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 32, 0, 141, "TLS_PSK_WITH_AES_256_CBC_SHA");
    public static final CipherSuite TLS_DHE_PSK_WITH_RC4_128_SHA = new CipherSuite(CipherAlgorithm.RC4, KeyExchangeAlgorithm.DHE_PSK, true, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 16, 0, 142, "TLS_DHE_PSK_WITH_RC4_128_SHA");
    public static final CipherSuite TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA = new CipherSuite(CipherAlgorithm.DESede, KeyExchangeAlgorithm.DHE_PSK, true, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 24, 0, 143, "TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_DHE_PSK_WITH_AES_128_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.DHE_PSK, true, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 16, 0, 144, "TLS_DHE_PSK_WITH_AES_128_CBC_SHA");
    public static final CipherSuite TLS_DHE_PSK_WITH_AES_256_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.DHE_PSK, true, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 32, 0, 145, "TLS_DHE_PSK_WITH_AES_256_CBC_SHA");
    public static final CipherSuite TLS_RSA_PSK_WITH_RC4_128_SHA = new CipherSuite(CipherAlgorithm.RC4, KeyExchangeAlgorithm.RSA_PSK, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 16, 0, 146, "TLS_RSA_PSK_WITH_RC4_128_SHA");
    public static final CipherSuite TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA = new CipherSuite(CipherAlgorithm.DESede, KeyExchangeAlgorithm.RSA_PSK, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 24, 0, 147, "TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA");
    public static final CipherSuite TLS_RSA_PSK_WITH_AES_128_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.RSA_PSK, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 16, 0, 148, "TLS_RSA_PSK_WITH_AES_128_CBC_SHA");
    public static final CipherSuite TLS_RSA_PSK_WITH_AES_256_CBC_SHA = new CipherSuite(CipherAlgorithm.AES, KeyExchangeAlgorithm.RSA_PSK, SignatureAlgorithm.ANONYMOUS, MacAlgorithm.SHA, 32, 0, 149, "TLS_RSA_PSK_WITH_AES_256_CBC_SHA");
    private final CipherAlgorithm cipherAlgorithm;
    private final KeyExchangeAlgorithm keyExchangeAlgorithm;
    private final SignatureAlgorithm signatureAlgorithm;
    private final MacAlgorithm macAlgorithm;
    private final boolean ephemeralDH;
    private final boolean exportable;
    private final boolean isStream;
    private final int keyLength;
    private final byte[] id;
    private final String name;
    private final boolean isResolved;

    private CipherSuite(CipherAlgorithm cipherAlgorithm, KeyExchangeAlgorithm keyExchangeAlgorithm, SignatureAlgorithm signatureAlgorithm, MacAlgorithm macAlgorithm, int keyLength, int id1, int id2, String name) {
        this(cipherAlgorithm, keyExchangeAlgorithm, false, signatureAlgorithm, macAlgorithm, keyLength, id1, id2, name);
    }

    private CipherSuite(CipherAlgorithm cipherAlgorithm, KeyExchangeAlgorithm keyExchangeAlgorithm, boolean ephemeralDH, SignatureAlgorithm signatureAlgorithm, MacAlgorithm macAlgorithm, int keyLength, int id1, int id2, String name) {
        this.cipherAlgorithm = cipherAlgorithm;
        this.keyExchangeAlgorithm = keyExchangeAlgorithm;
        this.ephemeralDH = ephemeralDH;
        this.signatureAlgorithm = signatureAlgorithm;
        this.macAlgorithm = macAlgorithm;
        this.exportable = keyLength <= 5;
        this.isStream = cipherAlgorithm == CipherAlgorithm.NULL || cipherAlgorithm == CipherAlgorithm.RC4;
        this.keyLength = keyLength;
        this.id = new byte[]{(byte)id1, (byte)id2};
        this.name = name.intern();
        namesToSuites.put(name, this);
        if (name.startsWith("TLS")) {
            tlsSuiteNames.add(name);
        }
        this.isResolved = true;
    }

    private CipherSuite(byte[] id) {
        this.cipherAlgorithm = null;
        this.keyExchangeAlgorithm = null;
        this.signatureAlgorithm = null;
        this.macAlgorithm = null;
        this.ephemeralDH = false;
        this.exportable = false;
        this.isStream = false;
        this.keyLength = 0;
        this.id = id;
        this.name = null;
        this.isResolved = false;
    }

    public static CipherSuite forName(String name) {
        if (name.startsWith("SSL_")) {
            name = "TLS_" + name.substring(4);
        }
        return namesToSuites.get(name);
    }

    public static CipherSuite forValue(short raw_value) {
        byte[] b = new byte[]{(byte)(raw_value >>> 8), (byte)raw_value};
        return new CipherSuite(b).resolve();
    }

    public static List<String> availableSuiteNames() {
        return tlsSuiteNames;
    }

    public CipherAlgorithm cipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public Cipher cipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (this.cipherAlgorithm == null) {
            throw new NoSuchAlgorithmException(String.valueOf(this.toString()) + ": unresolved cipher suite");
        }
        if (this.cipherAlgorithm == CipherAlgorithm.NULL) {
            return new NullCipher();
        }
        String alg = null;
        alg = this.cipherAlgorithm == CipherAlgorithm.RC4 ? "RC4" : (Object)((Object)this.cipherAlgorithm) + "/CBC/NoPadding";
        GetSecurityPropertyAction gspa = new GetSecurityPropertyAction("jessie.jce.provider");
        String provider = AccessController.doPrivileged(gspa);
        if (provider != null) {
            try {
                return Cipher.getInstance(alg, provider);
            }
            catch (NoSuchProviderException noSuchProviderException) {}
        }
        return Cipher.getInstance(alg);
    }

    public MacAlgorithm macAlgorithm() {
        return this.macAlgorithm;
    }

    public Mac mac(ProtocolVersion version) throws NoSuchAlgorithmException {
        if (this.macAlgorithm == null) {
            throw new NoSuchAlgorithmException(String.valueOf(this.toString()) + ": unresolved cipher suite");
        }
        if (this.macAlgorithm == MacAlgorithm.NULL) {
            return null;
        }
        String macAlg = null;
        if (version == ProtocolVersion.SSL_3) {
            macAlg = "SSLv3HMac-" + (Object)((Object)this.macAlgorithm);
        } else {
            if (this.macAlgorithm == MacAlgorithm.MD5) {
                macAlg = "HMac-MD5";
            }
            if (this.macAlgorithm == MacAlgorithm.SHA) {
                macAlg = "HMac-SHA1";
            }
        }
        GetSecurityPropertyAction gspa = new GetSecurityPropertyAction("jessie.jce.provider");
        String provider = AccessController.doPrivileged(gspa);
        if (provider != null) {
            try {
                return Mac.getInstance(macAlg, provider);
            }
            catch (NoSuchProviderException noSuchProviderException) {}
        }
        return Mac.getInstance(macAlg);
    }

    public SignatureAlgorithm signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public KeyExchangeAlgorithm keyExchangeAlgorithm() {
        return this.keyExchangeAlgorithm;
    }

    public boolean isEphemeralDH() {
        return this.ephemeralDH;
    }

    @Override
    public int length() {
        return 2;
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.id);
    }

    public void put(ByteBuffer buf) {
        buf.put(this.id);
    }

    public CipherSuite resolve() {
        if (this.id[0] == 0) {
            switch (this.id[1] & 0xFF) {
                case 0: {
                    return TLS_NULL_WITH_NULL_NULL;
                }
                case 1: {
                    return TLS_RSA_WITH_NULL_MD5;
                }
                case 2: {
                    return TLS_RSA_WITH_NULL_SHA;
                }
                case 3: {
                    return TLS_RSA_EXPORT_WITH_RC4_40_MD5;
                }
                case 4: {
                    return TLS_RSA_WITH_RC4_128_MD5;
                }
                case 5: {
                    return TLS_RSA_WITH_RC4_128_SHA;
                }
                case 8: {
                    return TLS_RSA_EXPORT_WITH_DES40_CBC_SHA;
                }
                case 9: {
                    return TLS_RSA_WITH_DES_CBC_SHA;
                }
                case 10: {
                    return TLS_RSA_WITH_3DES_EDE_CBC_SHA;
                }
                case 11: {
                    return TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA;
                }
                case 12: {
                    return TLS_DH_DSS_WITH_DES_CBC_SHA;
                }
                case 13: {
                    return TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA;
                }
                case 14: {
                    return TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA;
                }
                case 15: {
                    return TLS_DH_RSA_WITH_DES_CBC_SHA;
                }
                case 16: {
                    return TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA;
                }
                case 17: {
                    return TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA;
                }
                case 18: {
                    return TLS_DHE_DSS_WITH_DES_CBC_SHA;
                }
                case 19: {
                    return TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA;
                }
                case 20: {
                    return TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA;
                }
                case 21: {
                    return TLS_DHE_RSA_WITH_DES_CBC_SHA;
                }
                case 22: {
                    return TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA;
                }
                case 47: {
                    return TLS_RSA_WITH_AES_128_CBC_SHA;
                }
                case 48: {
                    return TLS_DH_DSS_WITH_AES_128_CBC_SHA;
                }
                case 49: {
                    return TLS_DH_RSA_WITH_AES_128_CBC_SHA;
                }
                case 50: {
                    return TLS_DHE_DSS_WITH_AES_128_CBC_SHA;
                }
                case 51: {
                    return TLS_DHE_RSA_WITH_AES_128_CBC_SHA;
                }
                case 53: {
                    return TLS_RSA_WITH_AES_256_CBC_SHA;
                }
                case 54: {
                    return TLS_DH_DSS_WITH_AES_256_CBC_SHA;
                }
                case 55: {
                    return TLS_DH_RSA_WITH_AES_256_CBC_SHA;
                }
                case 56: {
                    return TLS_DHE_DSS_WITH_AES_256_CBC_SHA;
                }
                case 57: {
                    return TLS_DHE_RSA_WITH_AES_256_CBC_SHA;
                }
                case 138: {
                    return TLS_PSK_WITH_RC4_128_SHA;
                }
                case 139: {
                    return TLS_PSK_WITH_3DES_EDE_CBC_SHA;
                }
                case 140: {
                    return TLS_PSK_WITH_AES_128_CBC_SHA;
                }
                case 141: {
                    return TLS_PSK_WITH_AES_256_CBC_SHA;
                }
                case 142: {
                    return TLS_DHE_PSK_WITH_RC4_128_SHA;
                }
                case 143: {
                    return TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA;
                }
                case 144: {
                    return TLS_DHE_PSK_WITH_AES_128_CBC_SHA;
                }
                case 145: {
                    return TLS_DHE_PSK_WITH_AES_256_CBC_SHA;
                }
                case 146: {
                    return TLS_RSA_PSK_WITH_RC4_128_SHA;
                }
                case 147: {
                    return TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA;
                }
                case 148: {
                    return TLS_RSA_PSK_WITH_AES_128_CBC_SHA;
                }
                case 149: {
                    return TLS_RSA_PSK_WITH_AES_256_CBC_SHA;
                }
            }
        }
        return this;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public int keyLength() {
        return this.keyLength;
    }

    public boolean isExportable() {
        return this.exportable;
    }

    public boolean isStreamCipher() {
        return this.isStream;
    }

    public byte[] id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CipherSuite)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        byte[] id = ((CipherSuite)o).id();
        return id[0] == this.id[0] && id[1] == this.id[1];
    }

    public int hashCode() {
        return 0xFFFF0000 | (this.id[0] & 0xFF) << 8 | this.id[1] & 0xFF;
    }

    @Override
    public String toString(String prefix) {
        return this.toString();
    }

    public String toString() {
        if (this.name == null) {
            return "{ " + (this.id[0] & 0xFF) + ", " + (this.id[1] & 0xFF) + " }";
        }
        return this.name;
    }
}

