/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.sampled.gstreamer.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javax.sound.sampled.AudioFormat;

final class GstAudioFileReaderNativePeer {
    private static final String GST_ENCODING = "GStreamer Generic Audio Reader";

    static {
        System.loadLibrary("gstreamerpeer");
    }

    GstAudioFileReaderNativePeer() {
    }

    public static AudioFormat getAudioFormat(File file) throws Exception {
        GstHeader header = new GstHeader();
        header.file = file.getAbsolutePath();
        if (!GstAudioFileReaderNativePeer.gstreamer_get_audio_format_file(header)) {
            return null;
        }
        return GstAudioFileReaderNativePeer.getAudioFormat(header);
    }

    public static AudioFormat getAudioFormat(InputStream is) throws Exception {
        GstHeader header = new GstHeader();
        BufferedInputStream stream = new BufferedInputStream(is);
        if (!stream.markSupported()) {
            throw new IOException("Stream must support marking.");
        }
        stream.mark(0);
        if (!GstAudioFileReaderNativePeer.gstreamer_get_audio_format_stream(header, stream)) {
            return null;
        }
        return GstAudioFileReaderNativePeer.getAudioFormat(header);
    }

    public static AudioFormat getAudioFormat(URL url) throws Exception {
        GstHeader header = new GstHeader();
        header.file = url.toExternalForm();
        BufferedInputStream stream = new BufferedInputStream(url.openStream());
        if (!stream.markSupported()) {
            throw new IOException("Stream must support marking.");
        }
        stream.mark(0);
        if (!GstAudioFileReaderNativePeer.gstreamer_get_audio_format_stream(header, stream)) {
            return null;
        }
        return GstAudioFileReaderNativePeer.getAudioFormat(header);
    }

    private static AudioFormat.Encoding getEncoding(GstHeader header) {
        StringBuilder buffer = new StringBuilder();
        if (header.name == null) {
            buffer.append(GST_ENCODING);
            if (header.mimetype != null) {
                buffer.append(" ");
                buffer.append(header.mimetype);
            }
            header.name = buffer.toString();
        } else {
            String lowerCase = header.name.toLowerCase();
            int index = lowerCase.indexOf("decoder");
            if (index == -1) {
                index = lowerCase.indexOf("demuxer");
            }
            if (index == -1) {
                index = lowerCase.length();
            }
            buffer.append(header.name.substring(0, index));
        }
        return new AudioFormat.Encoding(buffer.toString().trim());
    }

    private static AudioFormat getAudioFormat(GstHeader header) throws Exception {
        int na = -1;
        AudioFormat.Encoding encoding = GstAudioFileReaderNativePeer.getEncoding(header);
        float sampleRate = header.rate != null ? new Float(header.rate).floatValue() : (float)na;
        int sampleSizeInBits = header.depth != null ? new Integer(header.depth) : na;
        int channels = header.channels != null ? new Integer(header.channels) : na;
        boolean bigEndian = false;
        if (header.endianness != null && header.endianness.compareTo("4321") == 0) {
            bigEndian = true;
        }
        int frameSize = na;
        float frameRate = na;
        String lowerCase = header.name.toLowerCase();
        if (lowerCase.contains("law") || lowerCase.contains("au") || lowerCase.contains("x-au")) {
            frameSize = (sampleSizeInBits >> 3) * channels;
            frameRate = sampleRate;
        } else if (lowerCase.contains("wav")) {
            frameSize = (sampleSizeInBits + 7) / 8 * channels;
            frameRate = sampleRate;
        } else if (lowerCase.contains("iff")) {
            frameSize = sampleSizeInBits * channels / 8;
            frameRate = sampleRate;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("Classpath GStreamer Sound Audio Engine", true);
        properties.put("decoder", header.name);
        if (header.type != null) {
            properties.put("type", header.type);
        }
        if (header.framed != null) {
            properties.put("framed", header.framed);
        }
        if (header.bitrate != null) {
            properties.put("bitrate", header.bitrate);
        }
        if (header.isSigned != null) {
            properties.put("isSigned", header.isSigned);
        }
        if (header.depth != null) {
            properties.put("depth", header.depth);
        }
        if (header.mimetype != null) {
            properties.put("mimetype", header.mimetype);
        }
        AudioFormat format = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian, properties);
        return format;
    }

    protected static final native boolean gstreamer_get_audio_format_stream(GstHeader var0, BufferedInputStream var1);

    protected static final native boolean gstreamer_get_audio_format_file(GstHeader var0);

    private static class GstHeader {
        public String file = null;
        public String suffix = null;
        public String name = null;
        public String mimetype = null;
        public String endianness = null;
        public String channels = null;
        public String rate = null;
        public String width = null;
        public String depth = null;
        public String isSigned = null;
        public String layer = null;
        public String bitrate = null;
        public String framed = null;
        public String type = null;

        private GstHeader() {
        }
    }
}

